
<?php $__env->startSection('content'); ?>
<div class="page-wrapper">
    <div class="content">

        <div class="page-header">
            <div class="row">
                <div class="col-sm-12">
                    <ul class="breadcrumb">
                        <li class="breadcrumb-item"><a href="<?php echo e(route('admin.dashboard')); ?>">Home</a></li>
                        <li class="breadcrumb-item"><i class="feather-chevron-right"></i></li>
                        <li class="breadcrumb-item"><a href="<?php echo e(route('admin.therapist')); ?>">Therapists </a></li>
                        <li class="breadcrumb-item"><i class="feather-chevron-right"></i></li>
                        <li class="breadcrumb-item active">Add Therapist</li>
                    </ul>
                </div>
            </div>
        </div>

        <div class="row">
            <div class="col-sm-12">
                <div class="card">
                    <div class="card-body">
                        <!-- <form method="POST" action=" <?php echo e(route('admin.save-therapist')); ?>"> -->
                        <form id="addTherapist" action=" <?php echo e(route('admin.save-therapist')); ?>">
                            <?php echo csrf_field(); ?>
                            <div class="row">
                                <div class="col-12">
                                    <div class="form-heading">
                                        <h4>Therapist Details</h4>
                                    </div>
                                </div>
                                <div class="col-12 col-md-6 col-xl-6">
                                    <div class="row">
                                        <div class="col-3 col-md-3 col-xl-3">
                                            <div class="form-group local-forms">
                                                <label>Full Name <span class="login-danger">*</span></label>

                                                <select class="form-control select" name="prefix">
                                                    <option value="Mr.">Mr.</option>
                                                    <option value="Mrs.">Mrs.</option>
                                                    <option value="Miss.">Miss.</option>
                                                    <option value="Ms.">Ms.</option>
                                                </select>
                                            </div>
                                        </div>
                                        <div class="col-9 col-md-9 col-xl-9">
                                            <div class="form-group local-forms">
                                                <input class="form-control" name="full_name" type="text" placeholder>
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                <div class="col-12 col-md-6 col-xl-6">
                                    <div class="form-group local-forms">
                                        <label>Professional Credentials <span class="login-danger">*</span></label>
                                        <input class="form-control" name="professional_credentials" type="text" placeholder>
                                    </div>
                                </div>

                                <div class="col-12 col-md-6 col-xl-6">
                                    <div class="form-group local-forms">
                                        <label>Provider Category <span class="login-danger">*</span></label>

                                        <select class="form-control select" name="provider_category">
                                            <option>--Select Category ---</option>
                                            <?php $__currentLoopData = App\Models\ProviderCategory::get(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($item->id); ?>"><?php echo e($item->name); ?></option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-12 col-md-6 col-xl-6">
                                    <div class="form-group local-forms">
                                        <label>Service <span class="login-danger">*</span></label>

                                        <select class="form-control select chosen-select" multiple name="services[]">

                                        </select>
                                    </div>
                                </div>

                                <div class="col-12 col-md-6 col-xl-6">
                                    <div class="form-group local-forms">
                                        <label>Qualification <span class="login-danger">*</span></label>
                                        <input class="form-control" name="qualification" type="text" placeholder>
                                    </div>
                                </div>
                                <div class="col-12 col-md-6 col-xl-2">
                                    <div class="form-group local-forms">
                                        <label> Experience<span class="login-danger">*</span></label>
                                        <input class="form-control" name="experience" type="number" placeholder>
                                    </div>
                                </div>
                                <div class="col-12 col-md-6 col-xl-4">
                                    <div class="form-group local-forms">
                                        <label>Employee ID <span class="login-danger">*</span></label>
                                        <input class="form-control" name="employee_id" type="text" placeholder>
                                    </div>
                                </div>
                                <div class="col-12 col-md-6 col-xl-6">
                                    <div class="form-group local-forms">
                                        <label>Mobile <span class="login-danger">*</span></label>
                                        <input class="form-control" name="mobile" id="mobile" type="text" placeholder>
                                    </div>
                                </div>
                                <div class="col-12 col-md-6 col-xl-6">
                                    <div class="form-group local-forms">
                                        <label>Email <span class="login-danger">*</span></label>
                                        <input class="form-control" name="email" id="email" type="email" placeholder>
                                    </div>
                                </div>


                                <div class="col-12 col-md-6 col-xl-6">
                                    <div class="form-group local-forms">
                                        <label>Designation <span class="login-danger">*</span></label>
                                        <input class="form-control" name="designation_in_yc" type="text" placeholder>
                                    </div>
                                </div>

                                <div class="col-12 col-md-6 col-xl-6">
                                    <div class="form-group local-forms">
                                        <label>Languages Known<small>(separated with a comma)</small> <span class="login-danger">*</span></label>
                                        <input type="text" name="language_known" value="English, Malayalam" data-role="tagsinput" class="form-control">
                                    </div>
                                </div>
                                <div class="col-12 col-md-6 col-xl-6">
                                    <div class="form-group local-forms cal-icon">
                                        <label>Date Of Birth <span class="login-danger"></span></label>
                                        <input class="form-control datetimepicker" name="dob" type="text" placeholder>
                                    </div>
                                </div>

                                <div class="col-12 col-md-6 col-xl-4">
                                    <div class="form-group local-top-form">
                                        <label class="local-top">Profile Image <span class="login-danger">*</span></label>
                                        <input type="file" accept="image/*" onchange="readURL(this);" name="image" id="file" class="form-control">
                                    </div>
                                </div>
                                <div class="col-12 col-md-6 col-xl-2">
                                    <div class="form-group local-top-form">
                                        <img width="80" height="80" src="<?php echo e(asset('assets/img/no-image-available.jpg')); ?>" class="preview" alt="">
                                    </div>
                                </div>
                                <div class="col-12 col-md-6 col-xl-3">
                                    <div class="form-group select-gender">
                                        <label class="gen-label">Slot Managment permission<span class="login-danger">*</span></label>
                                        <div class="form-check-inline">
                                            <label class="form-check-label">
                                                <input type="radio" name="slot_managment" aria-selected="" value="on" class="form-check-input">On
                                            </label>
                                        </div>
                                        <div class="form-check-inline">
                                            <label class="form-check-label">
                                                <input type="radio" name="slot_managment" value="off" checked="form-check-input"> Off
                                            </label>
                                        </div>
                                    </div>
                                </div>

                                <div class="col-12 col-md-6 col-xl-3">
                                    <div class="form-group select-gender">
                                        <label class="gen-label">Gender<span class="login-danger">*</span></label>
                                        <div class="form-check-inline">
                                            <label class="form-check-label">
                                                <input type="radio" name="gender" aria-selected="" value="MALE" class="form-check-input">Male
                                            </label>
                                        </div>
                                        <div class="form-check-inline">
                                            <label class="form-check-label">
                                                <input type="radio" name="gender" value="FEMALE" class="form-check-input">Female
                                            </label>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-12 col-md-6 col-xl-6">
                                    <div class="form-group local-forms cal-icon">
                                        <label>Joining Date <span class="login-danger">*</span></label>
                                        <input class="form-control datetimepicker" name="joining_date" type="text" placeholder>
                                    </div>
                                </div>
                                <div class="col-12 col-sm-12">
                                    <div class="form-group local-forms">
                                        <label>Specialization and Expertise<small>(separated with a comma)</small> <span class="login-danger"></span></label>
                                        <!-- <input type="text" name="specialization_and_expertise" data-role="tagsinput" class="form-control"> -->
                                        <select class="form-control expertise" name="specialization_and_expertise[]" multiple="multiple">
                                            <?php $__currentLoopData = App\Models\Specialization::get(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($item->id); ?>"><?php echo e($item->tag); ?></option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-12 col-sm-12">
                                    <div class="form-group local-forms">
                                        <label>Client Focus and Population<small>(separated with a comma)</small> <span class="login-danger"></span></label>
                                        <input type="text" name="client_focus_and_population" data-role="tagsinput" class="form-control">
                                    </div>
                                </div>
                                <div class="col-12 col-sm-12">
                                    <div class="form-group local-forms">
                                        <label>Address <span class="login-danger">*</span></label>
                                        <textarea class="form-control" name="address" rows="3" cols="30"></textarea>
                                    </div>
                                </div>
                                <div class="col-12 col-md-6 col-xl-3">
                                    <div class="form-group local-forms">
                                        <label>City <span class="login-danger">*</span></label>
                                        <input class="form-control" type="text" name="city" placeholder>
                                    </div>
                                </div>
                                <div class="col-12 col-md-6 col-xl-3">
                                    <div class="form-group local-forms">
                                        <label>State/Province <span class="login-danger">*</span></label>
                                        <input class="form-control" type="text" name="state" placeholder>
                                    </div>
                                </div>
                                <div class="col-12 col-md-6 col-xl-3">
                                    <div class="form-group local-forms">
                                        <label>Country <span class="login-danger">*</span></label>
                                        <input class="form-control" type="text" name="country" placeholder>
                                    </div>
                                </div>

                                <div class="col-12 col-md-6 col-xl-3">
                                    <div class="form-group local-forms">
                                        <label>Postal Code <span class="login-danger">*</span></label>
                                        <input class="form-control" type="text" name="postal_code" placeholder>
                                    </div>
                                </div>
                                <div class="col-12 col-sm-12">
                                    <div class="form-group local-forms">
                                        <label>Profile Summary <span class="login-danger"></span></label>
                                        <textarea class="form-control" rows="3" name="biography" cols="30"></textarea>
                                    </div>
                                </div>
                                <div class="col-12 col-sm-12">
                                    <div class="form-group local-forms">
                                        <label>Personal Background <span class="login-danger"></span></label>
                                        <textarea class="form-control" rows="3" name="personal_background" cols="30"></textarea>
                                    </div>
                                </div>
                                <div class="col-12 col-sm-12">
                                    <div class="form-group local-forms">
                                        <label>Research and Publications <span class="login-danger"></span></label>
                                        <textarea class="form-control" rows="3" name="research_and_publications" cols="30"></textarea>
                                    </div>
                                </div>
                                <div class="col-12 col-sm-12">
                                    <div class="form-group local-forms">
                                        <label>Approach and Treatment Modalities <span class="login-danger"></span></label>
                                        <textarea class="form-control" rows="3" name="approach_and_treatment" cols="30"></textarea>
                                    </div>
                                </div>
                                <div class="col-12 col-sm-12">
                                    <div class="form-group local-forms">
                                        <label>Philosophy and Approach<span class="login-danger"></span></label>
                                        <textarea class="form-control" rows="3" name="philosophy_and_approach" cols="30"></textarea>
                                    </div>
                                </div>
                                <div class="col-12 col-sm-12">
                                    <div class="form-group local-forms">
                                        <label>Awards <span class="login-danger"></span></label>
                                        <textarea class="form-control" rows="3" name="awards" cols="30"></textarea>
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-sm-12">
                                    <div class="card card-table show-entire">
                                        <div class="card-body">

                                            <div class="page-table-header mb-2">
                                                <div class="row align-items-center">
                                                    <div class="col">
                                                        <div class="doctor-table-blk">
                                                            <h3>Work Experience</h3>

                                                        </div>
                                                    </div>
                                                    <div class="col-auto text-end float-end ms-auto download-grp add-group">
                                                        <a href="javascript:void(0);" title="Add More Work Details" class="btn btn-primary add_work ms-2"><img src="<?php echo e(asset('assets/img/icons/plus.svg')); ?>" alt></a>
                                                    </div>
                                                </div>
                                            </div>


                                        </div>
                                    </div>
                                </div>

                                <div class="row" id="remove-work-row">
                                    <div class="col-12 col-md-6 col-xl-3">
                                        <div class="form-group local-forms">
                                            <label>Designation <span class="login-danger"></span></label>
                                            <input class="form-control" name="designation[]" type="text" placeholder>
                                        </div>
                                    </div>
                                    <div class="col-12 col-md-6 col-xl-4">
                                        <div class="form-group local-forms">
                                            <label>Hospital<span class="login-danger"></span></label>
                                            <input class="form-control" name="hospital[]" type="text" placeholder>
                                        </div>
                                    </div>
                                    <div class="col-12 col-md-6 col-xl-4">
                                        <div class="form-group local-forms">
                                            <label>Place <span class="login-danger"></span></label>
                                            <input class="form-control" name="place[]" type="text" placeholder>
                                        </div>
                                    </div>
                                    <div class="col-12 col-md-6 col-xl-1">
                                        <div class="add-group">
                                            <a href=" javascript:void(0);" id="remove_work" class=" btn btn-primary ms-2"> <img src="<?php echo e(asset('assets/img/icons/trash.svg')); ?>" alt> </a>
                                        </div>
                                    </div>
                                </div>
                                <div id="more-experience"></div>

                            </div>

                            <div class="row">
                                <div class="col-sm-12">
                                    <div class="card card-table show-entire">
                                        <div class="card-body">

                                            <div class="page-table-header mb-2">
                                                <div class="row align-items-center">
                                                    <div class="col">
                                                        <div class="doctor-table-blk">
                                                            <h3>Education and Qualifications</h3>

                                                        </div>
                                                    </div>
                                                    <div class="col-auto text-end float-end ms-auto download-grp add-group">
                                                        <a href="javascript:void(0);" title="Add More Academic Details" class="btn btn-primary add_academics ms-2"><img src="<?php echo e(asset('assets/img/icons/plus.svg')); ?>" alt></a>
                                                    </div>
                                                </div>
                                            </div>


                                        </div>
                                    </div>
                                </div>


                                <div class="row" id="remove-academics-row">
                                    <div class="col-12 col-md-6 col-xl-3">
                                        <div class="form-group local-forms">
                                            <label>Education <span class="login-danger"></span></label>
                                            <input class="form-control" name="education[]" type="text" placeholder>
                                        </div>
                                    </div>
                                    <div class="col-12 col-md-6 col-xl-4">
                                        <div class="form-group local-forms">
                                            <label>College/University<span class="login-danger"></span></label>
                                            <input class="form-control" name="college[]" type="text" placeholder>
                                        </div>
                                    </div>
                                    <div class="col-12 col-md-6 col-xl-4">
                                        <div class="form-group local-forms">
                                            <label>Year <span class="login-danger"></span></label>
                                            <input class="form-control" name="year[]" type="text">
                                        </div>
                                    </div>
                                    <div class="col-12 col-md-6 col-xl-1">
                                        <div class="add-group">
                                            <a href=" javascript:void(0);" id="remove_academics" class=" btn btn-primary ms-2"> <img src="<?php echo e(asset('assets/img/icons/trash.svg')); ?>" alt> </a>
                                        </div>
                                    </div>
                                </div>
                                <div id="more-academics"></div>

                            </div>

                            <div class="row">
                                <div class="col-sm-12">
                                    <div class="card card-table show-entire">
                                        <div class="card-body">

                                            <div class="page-table-header mb-2">
                                                <div class="row align-items-center">
                                                    <div class="col">
                                                        <div class="doctor-table-blk">
                                                            <h3> Licensing and Certifications</h3>
                                                        </div>
                                                    </div>
                                                    <div class="col-auto text-end float-end ms-auto download-grp add-group">
                                                        <a href="javascript:void(0);" title="Add More  Licensing and Certifications Details" class="btn btn-primary add_licensing ms-2"><img src="<?php echo e(asset('assets/img/icons/plus.svg')); ?>" alt></a>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>


                                <div class="row" id="remove_licensing-row">
                                    <div class="col-12 col-md-6 col-xl-6">
                                        <div class="form-group local-forms">
                                            <label> Licensing and Certifications Name <span class="login-danger"></span></label>
                                            <input class="form-control" name="licensing_and_certifications_name[]" type="text" placeholder>
                                        </div>
                                    </div>
                                    <div class="col-12 col-md-6 col-xl-5">
                                        <div class="form-group local-forms">
                                            <label>Expiry Date<span class="login-danger"></span></label>
                                            <input class="form-control datetimepicker" name="expiry_date[]" type="text" placeholder>
                                        </div>
                                    </div>

                                    <div class="col-12 col-md-6 col-xl-1">
                                        <div class="add-group">
                                            <a href="javascript:void(0);" id="remove_licensing" class=" btn btn-primary ms-2"> <img src="<?php echo e(asset('assets/img/icons/trash.svg')); ?>" alt> </a>
                                        </div>
                                    </div>
                                </div>
                                <div id="more-licensing"></div>
                            </div>


                            <div class="row">
                                <div class="col-sm-12">
                                    <div class="card card-table show-entire">
                                        <div class="card-body">

                                            <div class="page-table-header mb-2">
                                                <div class="row align-items-center">
                                                    <div class="col">
                                                        <div class="doctor-table-blk">
                                                            <h3>Additional Training</h3>
                                                        </div>
                                                    </div>
                                                    <div class="col-auto text-end float-end ms-auto download-grp add-group">
                                                        <a href="javascript:void(0);" title="Add More Academic Details" class="btn btn-primary add_training ms-2"><img src="<?php echo e(asset('assets/img/icons/plus.svg')); ?>" alt></a>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>


                                <div class="row" id="remove-training-row">
                                    <div class="col-12 col-md-6 col-xl-3">
                                        <div class="form-group local-forms">
                                            <label>Training Name <span class="login-danger"></span></label>
                                            <input class="form-control" name="training_education[]" type="text" placeholder>
                                        </div>
                                    </div>
                                    <div class="col-12 col-md-6 col-xl-4">
                                        <div class="form-group local-forms">
                                            <label>College/University<span class="login-danger"></span></label>
                                            <input class="form-control" name="training_college[]" type="text" placeholder>
                                        </div>
                                    </div>
                                    <div class="col-12 col-md-6 col-xl-4">
                                        <div class="form-group local-forms">
                                            <label>Year <span class="login-danger"></span></label>
                                            <input class="form-control" name="training_year[]" type="text">
                                        </div>
                                    </div>
                                    <div class="col-12 col-md-6 col-xl-1">
                                        <div class="add-group">
                                            <a href=" javascript:void(0);" id="remove_training" class=" btn btn-primary ms-2"> <img src="<?php echo e(asset('assets/img/icons/trash.svg')); ?>" alt> </a>
                                        </div>
                                    </div>
                                </div>
                                <div id="more-trainings"></div>
                                <div class="col-12">
                                    <div class="doctor-submit text-end">
                                        <button type="submit" class="btn btn-primary submit-form me-2">Submit</button>
                                        <button type="submit" class="btn btn-primary cancel-form">Cancel</button>
                                    </div>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

</div>
<script>
    $(".expertise").select2({
        multiple: true
    });
    $('#email').on("keyup", function(e) {
        e.preventDefault();
        $("#js-loader").fadeIn();
        var email = $('#email').val();
        $.ajax({
            url: "<?php echo e(route('admin.email-exist')); ?>",
            method: "GET",
            data: {
                'email': email
            },
            success: function(data) {
                $("#js-loader").fadeOut();
                if (data == 1) {
                    toastr.error('Email already Exist');
                }
            }
        });
    });

    $('#mobile').on("keyup", function(e) {
        e.preventDefault();
        $("#js-loader").fadeIn();
        var mobile = $('#mobile').val();
        $.ajax({
            url: "<?php echo e(route('admin.mobile-exist')); ?>",
            method: "GET",
            data: {
                'mobile': mobile
            },
            success: function(data) {
                $("#js-loader").fadeOut();
                if (data == 1) {
                    toastr.error('Mobile already Exist');
                }
            }
        });
    });



    $('select[name="provider_category"]').on('change', function() {
        var catId = $(this).val();
        if (catId) {
            $.ajax({
                url: "<?php echo e(route('admin.load-service')); ?>",
                data: {

                    'id': catId
                },
                type: "GET",
                //  dataType: "json",
                success: function(data) {
                    $('select[name="services[]"]').empty();
                    if (data != '') {
                        $('select[name="services[]"]').append('<option  value=""> --select service-- </option>');
                        $.each(data, function(key, value) {
                            $('select[name="services[]"]').append('<option value=" ' + value.id + '">' + value.service_name + '</option>');
                        })
                    } else {
                        $('select[name="services[]"]').empty();
                    }
                }

            })
        }
    });
    $(".chosen-select").select2({
        multiple: true
    });
    $('body').on('click', '.add_work', function(e) {
        e.preventDefault();
        $("#js-loader").fadeIn();
        $.ajax({
            url: "<?php echo e(route('admin.work-html')); ?>",
            method: "GET",
            success: function(result) {
                $("#js-loader").fadeOut();
                $('#more-experience').append(result);
            }
        });
    });

    $('body').on('click', '#remove_work', function(e) {
        $(this).closest("#remove-work-row").remove();
    });

    $('body').on('click', '.add_academics', function(e) {
        e.preventDefault();
        $("#js-loader").fadeIn();
        $.ajax({
            url: "<?php echo e(route('admin.academics-html')); ?>",
            method: "GET",
            success: function(result) {
                $("#js-loader").fadeOut();
                $('#more-academics').append(result);
            }
        });
    });

    $('body').on('click', '.add_training', function(e) {
        e.preventDefault();
        $("#js-loader").fadeIn();
        $.ajax({
            url: "<?php echo e(route('admin.training-html')); ?>",
            method: "GET",
            success: function(result) {
                $("#js-loader").fadeOut();
                $('#more-trainings').append(result);
            }
        });
    });


    $('body').on('click', '#remove_academics', function(e) {
        $(this).closest("#remove-academics-row").remove();
    });

    $('body').on('click', '#remove_licensing', function(e) {
        $(this).closest("#remove_licensing-row").remove();
    });

    $('body').on('click', '#remove_training', function(e) {
        $(this).closest("#remove-training-row").remove();
    });
    $('#addTherapist').submit(function(e) {
        e.preventDefault();
        var url = $(this).attr("action");
        $("#js-loader").fadeIn();
        let formData = new FormData(this);
        var email = $("input[name=email]").val();
        $.ajax({
            type: 'POST',
            url: url,
            data: formData,
            contentType: false,
            processData: false,
            success: function(data) {
                $("#js-loader").fadeOut();
                if (data == true) {
                    toastr.success('Therapist Details Added Successfully and login details send to ' + email);
                    location.reload();

                } else {
                    toastr.error('Something went Wrong');
                }
            },
            error: function(err) {
                // Your Error Message
                toastr.error(err);
            }
        });
    });

    $('body').on('click', '.add_licensing', function(e) {
        e.preventDefault();
        $("#js-loader").fadeIn();
        $.ajax({
            url: "<?php echo e(route('admin.licensing-html')); ?>",
            method: "GET",
            success: function(result) {
                $("#js-loader").fadeOut();
                $('#more-licensing').append(result);
            }
        });
    });
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('admin.layout.dashboard-template', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/yellowcl/public_html/resources/views/admin/therapist/add.blade.php ENDPATH**/ ?>