
<?php $__env->startSection('content'); ?>
<style>
    .btn-n-active {
        background: #55ce63;
    }

    .slot-btn {
        margin-bottom: 10px;
    }

    .slot-btn:hover {
        background: #fbd500;
    }

    .invoice-fields {
        margin-bottom: 15px;
    }

    .tab-content {
        padding-top: 11px;
    }

    .card-box {
        padding: 0px;
    }

    /* defines the animation */
    @-webkit-keyframes fadeInUp {
        from {
            opacity: 0;
            transform: translate3d(0, 100%, 0);
        }

        to {
            opacity: 1;
            transform: none;
        }
    }

    @keyframes fadeInUp {
        from {
            opacity: 0;
            transform: translate3d(0, 100%, 0);
        }

        to {
            opacity: 1;
            transform: none;
        }
    }

    .main {
        opacity: 0;
        -webkit-animation: fadeInUp 1s ease-in-out 0s forwards;
        animation: fadeInUp 1s ease-in-out 0s forwards;
    }

    .main>div {
        -webkit-animation-delay: 1s;
        animation-delay: 1s;
    }

    .card-middle-avatar a {
        display: contents;
    }


    .main-limit h4 {
        font-size: 15px;
    }

    .doctor-table-blk {
        margin-bottom: 40px;
    }

    .provider {
        height: 550px;
        overflow: auto;
    }

    .provider::-webkit-scrollbar-track {
        /* border: 1px solid black; */
        background-color: #F5F5F5;
    }

    .provider::-webkit-scrollbar {
        width: 10px;
        background-color: #091269;
    }

    .provider::-webkit-scrollbar-thumb {
        background-color: #091269;
    }

    @import url('https://fonts.googleapis.com/css2?family=Poppins:wght@200&display=swap');

    * {
        padding: 0;
        margin: 0;
    }

    .container {
        min-height: 100vh;
        display: flex;
        justify-content: center;
        align-items: center;
        /* background-color: #eee; */
    }

    .container .cardbox {
        height: 650px;
        /* width: 800px; */
        background-color: #fff;
        position: relative;
        box-shadow: 0 15px 30px rgba(0, 0, 0, 0.1);
        font-family: 'Poppins', sans-serif;
        border-radius: 20px;
    }

    .container .cardbox .form {
        width: 100%;
        height: 100%;

        display: flex;
    }

    .container .cardbox .left-side {
        width: 35%;
        background-color: #091269;
        height: 100%;
        border-top-left-radius: 20px;
        border-bottom-left-radius: 20px;
        padding: 20px 30px;
        box-sizing: border-box;

    }

    /*left-side-start*/
    .left-heading {
        color: #fff;

    }

    .steps-content {
        margin-top: 30px;
        color: #fff;
    }

    .steps-content p {
        font-size: 12px;
        margin-top: 15px;
    }

    .progress-bar {
        list-style: none;
        /*color:#fff;*/
        /* margin-top: 30px; */
        font-size: 13px;
        font-weight: 700;
        counter-reset: container 0;
    }

    .progress-bar li {
        position: relative;
        margin-left: 40px;
        margin-top: 50px;
        counter-increment: container 1;
        color: #4f6581;
    }

    .progress-bar li::before {
        content: counter(container);
        line-height: 25px;
        text-align: center;
        position: absolute;
        height: 25px;
        width: 25px;
        border: 1px solid #4f6581;
        border-radius: 50%;
        left: -40px;
        top: -5px;
        z-index: 10;
        background-color: #304767;


    }


    .progress-bar li::after {
        content: '';
        position: absolute;
        height: 90px;
        width: 2px;
        background-color: #4f6581;
        z-index: 1;
        left: -27px;
        top: -70px;
    }


    .progress-bar li.active::after {
        background-color: #fff;

    }

    .progress-bar li:first-child:after {
        display: none;
    }

    /*.progress-bar li:last-child:after{*/
    /*  display:none;  */
    /*}*/
    .progress-bar li.active::before {
        color: #fbd500;
        border: 1px solid #fbd500;
    }

    .progress-bar li.active {
        color: #fff;
    }

    .d-none {
        display: none;
    }

    /*left-side-end*/
    .container .cardbox .right-side {
        width: 65%;
        background-color: #fff;
        height: 100%;
        border-radius: 20px;
    }

    /*right-side-start*/
    .main {
        display: none;
    }

    .active {
        display: block;
    }

    .main {
        padding: 40px;
    }

    .main small {
        display: flex;
        justify-content: center;
        align-items: center;
        margin-top: 2px;
        height: 30px;
        width: 30px;
        background-color: #ccc;
        border-radius: 50%;
        color: yellow;
        font-size: 19px;
    }

    .text {
        margin-top: 20px;
    }

    .congrats {
        text-align: center;
    }

    .text p {
        margin-top: 10px;
        font-size: 13px;
        font-weight: 700;
        color: #cbced4;
    }

    .input-text {
        margin: 30px 0;
        display: flex;
        gap: 20px;
    }

    .input-text .input-div {
        width: 100%;
        position: relative;

    }



    input[type="text"] {
        width: 100%;
        height: 40px;
        border: none;
        outline: 0;
        border-radius: 5px;
        border: 1px solid #cbced4;
        gap: 20px;
        box-sizing: border-box;
        padding: 0px 10px;
    }

    select {
        width: 100%;
        height: 40px;
        border: none;
        outline: 0;
        border-radius: 5px;
        border: 1px solid #cbced4;
        gap: 20px;
        box-sizing: border-box;
        padding: 0px 10px;
    }

    .input-text .input-div span {
        position: absolute;
        top: 10px;
        left: 10px;
        font-size: 14px;
        transition: all 0.5s;
    }

    .input-div input:focus~span,
    .input-div input:valid~span {
        top: -15px;
        left: 6px;
        font-size: 10px;
        font-weight: 600;
    }

    .input-div span {
        top: -15px;
        left: 6px;
        font-size: 10px;
    }

    .buttons button {
        height: 40px;
        width: 100px;
        border: none;
        border-radius: 5px;
        background-color: #0075ff;
        font-size: 12px;
        color: #fff;
        cursor: pointer;
        float: right;
    }

    .button_space {
        /* display: flex; */
        gap: 20px;

    }

    .button_space button:nth-child(2) {
        background-color: #fff;
        color: #000;
        border: 1px solid#000;
    }

    .user_cardbox {
        margin-top: 20px;
        margin-bottom: 40px;
        height: 200px;
        width: 100%;
        border: 1px solid #c7d3d9;
        border-radius: 10px;
        display: flex;
        overflow: hidden;
        position: relative;
        box-sizing: border-box;
    }

    .user_cardbox span {
        height: 80px;
        width: 100%;
        background-color: #dfeeff;
    }

    .circle {
        position: absolute;
        top: 40px;
        left: 60px;
    }

    .circle span {
        height: 70px;
        width: 70px;
        background-color: #fff;
        display: flex;
        justify-content: center;
        align-items: center;
        border: 2px solid #fff;
        border-radius: 50%;
    }

    .circle span img {
        width: 100%;
        height: 100%;
        border-radius: 50%;
        object-fit: cover;
    }

    .social {
        display: flex;
        position: absolute;
        top: 100px;
        right: 10px;
    }

    .social span {
        height: 30px;
        width: 30px;
        border-radius: 7px;
        background-color: #fff;
        border: 1px solid #cbd6dc;
        display: flex;
        justify-content: center;
        align-items: center;
        margin-left: 10px;
        color: #cbd6dc;

    }

    .social span i {
        cursor: pointer;
    }

    .heart {
        color: red !important;
    }

    .share {
        color: red !important;
    }

    .user_name {
        position: absolute;
        top: 110px;
        margin: 10px;
        padding: 0 30px;
        display: flex;
        flex-direction: column;
        width: 100%;

    }

    .user_name h3 {
        color: #4c5b68;
    }

    .detail {
        /*margin-top:10px;*/
        display: flex;
        justify-content: space-between;
        margin-right: 50px;
    }

    .detail p {
        font-size: 12px;
        font-weight: 700;

    }

    .detail p a {
        text-decoration: none;
        color: blue;
    }

    .checkmark__circle {
        stroke-dasharray: 166;
        stroke-dashoffset: 166;
        stroke-width: 2;
        stroke-miterlimit: 10;
        stroke: #7ac142;
        fill: none;
        animation: stroke 0.6s cubic-bezier(0.65, 0, 0.45, 1) forwards;
    }

    .checkmark {
        width: 56px;
        height: 56px;
        border-radius: 50%;
        display: block;
        stroke-width: 2;
        stroke: #fff;
        stroke-miterlimit: 10;
        margin: 10% auto;
        box-shadow: inset 0px 0px 0px #7ac142;
        animation: fill .4s ease-in-out .4s forwards, scale .3s ease-in-out .9s both;
    }

    .checkmark__check {
        transform-origin: 50% 50%;
        stroke-dasharray: 48;
        stroke-dashoffset: 48;
        animation: stroke 0.3s cubic-bezier(0.65, 0, 0.45, 1) 0.8s forwards;
    }

    @keyframes stroke {
        100% {
            stroke-dashoffset: 0;
        }
    }

    @keyframes scale {

        0%,
        100% {
            transform: none;
        }

        50% {
            transform: scale3d(1.1, 1.1, 1);
        }
    }

    @keyframes fill {
        100% {
            box-shadow: inset 0px 0px 0px 30px #7ac142;
        }
    }










    .warning {
        border: 1px solid red !important;
    }


    /*right-side-end*/
    @media (max-width:750px) {
        .container {
            height: scroll;


        }

        .container .cardbox {
            max-width: 350px;
            height: auto !important;
            margin: 30px 0;
        }

        .container .cardbox .right-side {
            width: 100%;

        }

        .input-text {
            display: block;
        }

        .input-text .input-div {
            margin-top: 20px;

        }

        .container .cardbox .left-side {

            display: none;
        }
    }
</style>

<div class="page-wrapper">
    <div class="content">

        <form id="appointment" method="post" action="<?php echo e(route('admin.save-appointment')); ?>">
            <?php echo csrf_field(); ?>
            <input type="hidden" name="therapist">
            <input type="hidden" name="service">
            <input type="hidden" name="call_type">
            <input type="hidden" name="slot_id">
            <input type="hidden" name="slot">
            <input type="hidden" value="<?php echo e($user_id); ?>" name="user">
            <input type="hidden" name="fee">
            <div class="page-header">


                <div class="row">
                    <div class="col-sm-12">
                        <ul class="breadcrumb">
                            <li class="breadcrumb-item"><a href="<?php echo e(route('admin.dashboard')); ?>">Home</a></li>
                            <li class="breadcrumb-item"><i class="feather-chevron-right"></i></li>
                            <li class="breadcrumb-item"><a href="<?php echo e(route('admin.users')); ?>">Appoinments</a></li>
                            <li class="breadcrumb-item"><i class="feather-chevron-right"></i></li>
                            <li class="breadcrumb-item active">Book Appoinments</li>
                        </ul>
                    </div>
                </div>
            </div>


            <div class="container">
                <div class="cardbox">
                    <div class="form">
                        <div class="left-side">
                            <!-- <div class="left-heading">
                            <h3>indeed</h3>
                        </div> -->
                            <div class="steps-content">
                                <h3>Step <span class="step-number">1</span></h3>
                                <p class="step-number-content active">Pick a specific doctor to perform your service </p>
                                <p class="step-number-content d-none">Please select a service from below options</p>
                                <p class="step-number-content d-none">Please select a consulation method</p>
                                <p class="step-number-content d-none"> Select date to see a timeline of available slots </p>
                                <!-- <p class="step-number-content d-none"> Please provide you contact details </p> -->
                                <p class="step-number-content d-none"> Please slect payment option</p>
                                <p class="step-number-content d-none">Confirm your booking</p>
                            </div>
                            <ul class="progress-bar">
                                <li class="active" id="provider-li">Choose your Doctor</li>
                                <li id="service-li">Therapist Services</li>
                                <li id="consulation-li">Consulation Type</li>
                                <li id="slot-li">Select Date and Slot</li>
                                <!-- <li id="user-li"> User Detail Information </li> -->
                                <li id="payment-li"> Payment Selection</li>
                                <li id="confirmation-li"> Confirmation</li>
                            </ul>

                        </div>
                        <div class="right-side">
                            <div class="main active" id="provider">
                                <div class="row provider">
                                    <div class="doctor-table-blk">
                                        <h3>Select Therapist</h3>
                                        <div class="doctor-search-blk">
                                            <div class="top-nav-search table-search-blk">
                                                <form>
                                                    <input type="text" class="form-control" placeholder="Search here" id="search">
                                                    <!-- <a class="btn"><img src="<?php echo e(asset('assets/img/icons/search-normal.svg')); ?>" alt=""></a> -->
                                                </form>
                                            </div>
                                            <div class="add-group">
                                                <select class="form-control" id="provider_category" style="background: rgba(46,55,164,.05);margin-left: 9px;border: none;color: #56608b;">
                                                    <option value="">All</option>
                                                    <?php $__currentLoopData = App\Models\ProviderCategory::get(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <option value=" <?php echo e($item->id); ?>"><?php echo e($item->name); ?></option>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                </select>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="row text-center" id="search-div">
                                    </div>
                                    <!-- <div class="buttons">
                                        <button class="next_button">Next Step</button>
                                    </div> -->

                                </div>

                            </div>
                            <div class="main" id="service">
                                <div class="row provider">
                                    <div class="doctor-table-blk">
                                        <h3>Select Service</h3>

                                    </div>
                                    <div class="row text-center" id="service-div">

                                    </div>

                                    <div class="buttons button_space ">
                                        <!-- <button class="next_button">Next Step</button> -->
                                        <button class="back_button" data-id="service" data-value="provider">Back</button>
                                    </div>


                                </div>
                            </div>
                            <div class="main" id="consulation">
                                <div class="row provider">
                                    <div class="doctor-table-blk">
                                        <h3>Select Consulation Method</h3>
                                    </div>
                                    <div class="row text-center" id="consulation-div">
                                    </div>
                                    <div class="buttons button_space">
                                        <!-- <button class="next_button">Next Step</button> -->
                                        <button class="back_button" data-id="consulation" data-value="service">Back</button>
                                    </div>
                                </div>

                            </div>

                            <div class="main" id="slot">
                                <div class="row provider">
                                    <div class="doctor-table-blk">
                                        <h5>Select Date and Time</h5>
                                    </div>

                                    <div class="col-12 col-md-6 col-xl-6">
                                        <div class="form-group local-forms row">
                                            <label>Select Booking date <span class="login-danger"></span></label>
                                            <input class="form-control datetimepicker" name="booking_date" value="<?php echo e(date('d/m/Y',strtotime(now()))); ?>" type="text" placeholder>
                                        </div>
                                        <div class="form-group local-forms row">
                                            <button class="btn btn-info search_slot">Search Slots</button>
                                        </div>
                                    </div>

                                    <div class="col-sm-6 col-lg-6 col-xl-6 d-flex">
                                        <div class="row text-center" id="slot-div">

                                        </div>
                                    </div>
                                    <div class="buttons button_space ">
                                        <!-- <button class="next_button">Next Step</button> -->
                                        <button class="back_button" data-id="slot" data-value="consulation">Back</button>
                                    </div>


                                </div>
                            </div>
                            <div class="main" id="user">
                                <div class="card-box">
                                    <ul class="nav nav-tabs nav-tabs-solid nav-justified">
                                        <li class="nav-item"><a class="nav-link active" href="#solid-justified-tab1" data-bs-toggle="tab">New User</a></li>
                                        <li class="nav-item"><a class="nav-link" href="#solid-justified-tab2" data-bs-toggle="tab">Registered User</a></li>
                                    </ul>
                                    <div class="tab-content">
                                        <div class="tab-pane show active" id="solid-justified-tab1">
                                            <div class="col-12">
                                                <div class="text">
                                                    <h4 style="margin-bottom:40px;">Enter personal information of new user</h4>
                                                    <p></p>
                                                </div>
                                            </div>
                                            <div class="row">
                                                <div class="col-12 col-md-6 col-xl-6">
                                                    <div class="form-group local-forms">
                                                        <label>First Name <span class="login-danger">*</span></label>
                                                        <input class="form-control" name="first_name" type="text" placeholder>
                                                    </div>
                                                </div>
                                                <div class="col-12 col-md-6 col-xl-6">
                                                    <div class="form-group local-forms">
                                                        <label>Last Name <span class="login-danger">*</span></label>
                                                        <input class="form-control" name="last_name" type="text" placeholder>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="row">
                                                <div class="col-12 col-md-6 col-xl-6">
                                                    <div class="form-group local-forms">
                                                        <label>Email <span class="login-danger">*</span></label>
                                                        <input class="form-control" name="email" type="email" placeholder>
                                                    </div>
                                                </div>

                                                <div class="col-12 col-md-6 col-xl-6 ">
                                                    <div class="form-group local-forms">
                                                        <label>Phone <span class="login-danger">*</span></label>
                                                        <div class="row">
                                                            <div class="col-3 col-md-3 col-xl-3">
                                                                <input class="form-control" name="code" type="text" placeholder="+91">
                                                            </div>
                                                            <div class="col-9 col-md-9 col-xl-9">
                                                                <input class="form-control" name="phone" type="text" max="10">
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="row">
                                                <div class="col-12 col-md-6 col-xl-6">
                                                    <div class="form-group select-gender">
                                                        <label class="gen-label">Gender<span class="login-danger">*</span></label>
                                                        <div class="form-check-inline">
                                                            <label class="form-check-label">
                                                                <input type="radio" name="gender" aria-selected="" value="MALE" class="form-check-input">Male
                                                            </label>
                                                        </div>
                                                        <div class="form-check-inline">
                                                            <label class="form-check-label">
                                                                <input type="radio" name="gender" value="FEMALE" class="form-check-input">Female
                                                            </label>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="buttons button_space ">
                                                <button class="next_button user_next">Next Step</button>
                                                <button class="back_button" data-id="user" data-value="slot">Back</button>
                                            </div>
                                        </div>
                                        <div class="tab-pane" id="solid-justified-tab2">
                                            <div class="row provider">
                                                <div class="doctor-table-blk">
                                                    <h3>Select User</h3>
                                                    <div class="doctor-search-blk">
                                                        <div class="top-nav-search table-search-blk">
                                                            <form>
                                                                <input type="text" class="form-control" placeholder="Search here" id="search_user">
                                                                <!-- <a class="btn"><img src="<?php echo e(asset('assets/img/icons/search-normal.svg')); ?>" alt=""></a> -->
                                                            </form>
                                                        </div>

                                                    </div>
                                                </div>
                                                <div class="row text-center" id="search-user-div">


                                                </div>
                                                <div class="buttons button_space ">
                                                    <!-- <button class="next_button ">Next Step</button> -->
                                                    <button class="back_button" data-id="user" data-value="slot">Back</button>
                                                </div>
                                            </div>
                                        </div>
                                    </div>

                                </div>
                            </div>
                            <div class="main" id="payment">
                                <div class="row provider">
                                    <div class="doctor-table-blk">
                                        <h3>Payment Selection</h3>

                                    </div>


                                    <div class="col-sm-5 col-lg-12 col-xl-5 d-flex">
                                        <div class="card flex-fill mb-2">
                                            <div class="card-header">
                                                <h4> PAYMENT METHOD
                                                </h4>
                                            </div>
                                            <div class="card-body">
                                                <div class="invoice-fields">
                                                    <div class="payment-details">
                                                        <p>Offline Payment</p>
                                                    </div>
                                                </div>
                                                <!-- <div class="invoice-payment-box">
                                                    <div class="payment-details">
                                                        <p>Online Payment</p>
                                                    </div>
                                                </div> -->

                                            </div>
                                        </div>
                                    </div>

                                    <div class="col-sm-7 col-lg-12 col-xl-7 d-flex">
                                        <div class="card flex-fill mb-2">
                                            <div class="card-header">
                                                <h4>APPOINMENT SUMMARY
                                                </h4>
                                            </div>
                                            <div class="card-body history">

                                            </div>
                                        </div>
                                    </div>
                                    <div class="buttons button_space">
                                        <button type="submit" class="next_button">Next Step</button>
                                        <button class="back_button" data-value="slot" data-id="payment">Back</button>
                                    </div>


                                </div>
                            </div>
                            <div class="main" id="confirmation">
                                <svg class="checkmark" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 52 52">
                                    <circle class="checkmark__circle" cx="26" cy="26" r="25" fill="none" />
                                    <path class="checkmark__check" fill="none" d="M14.1 27.2l7.1 7.2 16.7-16.8" />
                                </svg>

                                <div class="text congrats">
                                    <h2>Your Appointment is Booked Sucessfully!</h2>
                                    <!-- <p></p> -->
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </form>
    </div>
    <script>
        $(document).ready(function() {
            // $("#js-loader").fadeIn(300);
            $.ajax({
                url: "<?php echo e(route('admin.search-therapist')); ?>",
                method: "GET",
                success: function(result) {
                    //    $("#js-loader").fadeOut(300);
                    $('#search-div').append(result);
                }
            });
            $.ajax({
                url: "<?php echo e(route('admin.search-user')); ?>",
                method: "GET",
                success: function(result) {
                    //    $("#js-loader").fadeOut(300);
                    $('#search-user-div').append(result);
                }
            });

            // booking();
        });


        $(document).on('keyup', '#search', function(e) {
            e.preventDefault();
            search = $(this).val();
            provider_category = $('#provider_category').val();
            // $("#js-loader").fadeIn(300);
            $.ajax({
                url: "<?php echo e(route('admin.search-therapist')); ?>",
                method: "GET",
                data: {
                    'search': search,
                    'provider_category': provider_category
                },
                success: function(result) {
                    //      $("#js-loader").fadeOut(300);
                    $('#search-div').html(result);
                }
            });
        });
        $(document).on('keyup', '#search_user', function(e) {
            e.preventDefault();
            search = $(this).val();
            // $("#js-loader").fadeIn(300);
            $.ajax({
                url: "<?php echo e(route('admin.search-user')); ?>",
                method: "GET",
                data: {
                    'search': search
                },
                success: function(result) {
                    //      $("#js-loader").fadeOut(300);
                    $('#search-user-div').html(result);
                }
            });
        });
        $(document).on('change', '#provider_category', function(e) {
            e.preventDefault();
            search = $('#search').val();
            provider_category = $(this).val();
            $("#js-loader").fadeIn(300);
            $.ajax({
                url: "<?php echo e(route('admin.search-therapist')); ?>",
                method: "GET",
                data: {
                    'search': search,
                    'provider_category': provider_category
                },
                success: function(result) {
                    $("#js-loader").fadeOut(300);
                    $('#search-div').html(result);
                }
            });
        });

        $(document).on('click', '.therapist', function(e) {
            e.preventDefault();
            id = $(this).data('id');
            $("#js-loader").fadeIn(300);
            $.ajax({
                url: "<?php echo e(route('admin.search-therapist-service')); ?>",
                method: "GET",
                data: {
                    'id': id
                },
                success: function(result) {
                    $("#js-loader").fadeOut(300);
                    $("input[name=therapist]").val(id);
                    $('#service-div').html(result);
                    $('#service-li').addClass('active');
                    $('#service').addClass('active');
                    $('#provider').removeClass('active');
                }
            });
        });
        $(document).on('click', '.service', function(e) {
            e.preventDefault();
            id = $(this).data('id');
            therapist = $("input[name=therapist]").val();
            $("#js-loader").fadeIn(300);
            $.ajax({
                url: "<?php echo e(route('admin.search-service-methods')); ?>",
                method: "GET",
                data: {
                    'id': id,
                    'therapist': therapist
                },
                success: function(result) {
                    $("#js-loader").fadeOut(300);
                    $("input[name=service]").val(id);
                    $('#consulation-div').html(result);
                    $('#consulation-li').addClass('active');
                    $('#consulation').addClass('active');
                    $('#service').removeClass('active');
                    // booking();
                }
            });
        });

        $(document).on('click', '.callmethod', function(e) {
            e.preventDefault();
            bookingDate = $("input[name=booking_date]").val();
            callmethod = $(this).data('id');
            service = $("input[name=service]").val();
            therapist = $("input[name=therapist]").val();
            fee = $(this).data('value');
            $("input[name=fee]").val(fee);
            slots(bookingDate, callmethod, service, therapist);
        });

        $(document).on('click', ".search_slot", function(e) {
            e.preventDefault();
            bookingDate = $("input[name=booking_date]").val();
            callmethod = $("input[name=call_type]").val();
            service = $("input[name=service]").val();
            therapist = $("input[name=therapist]").val();
            slots(bookingDate, callmethod, service, therapist);

        });
        $(document).on('click', ".slot-btn", function(e) {
            e.preventDefault();
            slot_id = $(this).data('id');
            slot = $(this).data('value');

            $("input[name=slot_id]").val(slot_id);
            $("input[name=slot]").val(slot);
            // $('#user-li').addClass('active');
            // $('#user').addClass('active');

            bookingDate = $("input[name=booking_date]").val();
            callmethod = $("input[name=call_type]").val();
            service = $("input[name=service]").val();
            therapist = $("input[name=therapist]").val();
            slot = $("input[name=slot]").val();
            fee = $("input[name=fee]").val();
            $("#js-loader").fadeIn(300);
            $.ajax({
                url: "<?php echo e(route('admin.payment-and-summary')); ?>",
                method: "GET",
                data: {
                    bookingDate: bookingDate,
                    callmethod: callmethod,
                    service: service,
                    therapist: therapist,
                    slot: slot,
                    fee: fee
                },
                success: function(result) {
                    $("#js-loader").fadeOut(300);
                    $(".slot-btn").removeClass("btn-n-active");
                    $(this).addClass("btn-n-active");
                    $('#slot').removeClass('active');
                    // $("input[name=service]").val(id);
                    $('.history').html(result);
                    $('#payment-li').addClass('active');
                    $('#payment').addClass('active');
                    $('#user').removeClass('active');
                }
            });
        });

        function slots(bookingDate, callmethod, service, therapist) {
            $("#js-loader").fadeIn(300);
            $.ajax({
                url: "<?php echo e(route('admin.search-slots')); ?>",
                method: "GET",
                data: {
                    'bookingDate': bookingDate,
                    'therapist': therapist,
                    'service': service,
                    'callmethod': callmethod
                },
                success: function(result) {
                    $("#js-loader").fadeOut(300);
                    $("input[name=call_type]").val(callmethod);
                    $('#slot-div').html(result);
                    $('#slot-li').addClass('active');
                    $('#slot').addClass('active');
                    $('#consulation').removeClass('active');
                    // booking();
                }
            });
        }

        $(document).on('click', '.back_button', function(e) {
            e.preventDefault();
            hidetab = $(this).data('id');
            showtab = $(this).data('value');
            $('#' + hidetab + '- li ').removeClass('active');
            $('#' + hidetab).removeClass('active');
            $('#' + showtab).addClass('active');
        });

        $(document).on('click', '.user_div', function(e) {
            e.preventDefault();
            user = $(this).data('id');
            $("input[name=user]").val(user);
            bookingDate = $("input[name=booking_date]").val();
            callmethod = $("input[name=call_type]").val();
            service = $("input[name=service]").val();
            therapist = $("input[name=therapist]").val();
            slot = $("input[name=slot]").val();
            fee = $("input[name=fee]").val();
            $("#js-loader").fadeIn(300);
            $.ajax({
                url: "<?php echo e(route('admin.payment-and-summary')); ?>",
                method: "GET",
                data: {
                    bookingDate: bookingDate,
                    callmethod: callmethod,
                    service: service,
                    therapist: therapist,
                    slot: slot,
                    fee: fee
                },
                success: function(result) {
                    $("#js-loader").fadeOut(300);
                    // $("input[name=service]").val(id);
                    $('.history').html(result);
                    $('#payment-li').addClass('active');
                    $('#payment').addClass('active');
                    $('#user').removeClass('active');
                }
            });
        });



        $(document).on('click', '.user_next', function(e) {
            e.preventDefault();
            $("#js-loader").fadeIn(300);
            bookingDate = $("input[name=booking_date]").val();
            callmethod = $("input[name=call_type]").val();
            service = $("input[name=service]").val();
            therapist = $("input[name=therapist]").val();
            slot = $("input[name=slot]").val();
            fee = $("input[name=fee]").val();
            $.ajax({
                type: 'GET',
                url: "<?php echo e(route('admin.payment-and-summary')); ?>",
                data: {
                    bookingDate: bookingDate,
                    callmethod: callmethod,
                    service: service,
                    therapist: therapist,
                    slot: slot,
                    fee: fee
                },
                success: function(result) {
                    $("#js-loader").fadeOut(300);
                    $('.history').html(result);
                    $('#payment-li').addClass('active');
                    $('#payment').addClass('active');
                    $('#user').removeClass('active');

                },
                error: function(err) {
                    // Your Error Message
                    toastr.error(err);
                }
            });

        });

        $('#appointment').submit(function(e) {
            e.preventDefault();
            var url = $(this).attr("action");
            let formData = new FormData(this);

            $("#js-loader").fadeIn();
            $.ajax({
                type: 'POST',
                url: url,
                data: formData,
                contentType: false,
                processData: false,
                success: function(result) {
                    $("#js-loader").fadeOut(300);
                    $('#confirmation-li').addClass('active');
                    $('#confirmation').addClass('active');
                    $('#payment').removeClass('active');
                    if (result.status == true) {
                        toastr.success(result.data);
                    } else {
                        toastr.error(result.data);
                    }
                },
                error: function(err) {
                    // Your Error Message
                    toastr.error(err);
                }
            });
        });

        // function booking() {
        //     var next_click = document.querySelectorAll(".next_button");
        //     var main_form = document.querySelectorAll(".main");
        //     var step_list = document.querySelectorAll(".progress-bar li");
        //     var num = document.querySelector(".step-number");

        //     let formnumber = 0;
        //     next_click.forEach(function(next_click_form) {
        //         next_click_form.addEventListener('click', function() {
        //             if (!validateform()) {
        //                 return false
        //             }
        //             formnumber++;
        //             updateform();
        //             progress_forward();
        //             contentchange();
        //         });
        //     });

        //     var back_click = document.querySelectorAll(".back_button");
        //     back_click.forEach(function(back_click_form) {
        //         back_click_form.addEventListener('click', function() {
        //             formnumber--;
        //             updateform();
        //             progress_backward();
        //             contentchange();
        //         });
        //     });

        //     var username = document.querySelector("#user_name");
        //     var shownname = document.querySelector(".shown_name");


        //     var submit_click = document.querySelectorAll(".submit_button");
        //     submit_click.forEach(function(submit_click_form) {
        //         submit_click_form.addEventListener('click', function() {
        //             shownname.innerHTML = username.value;
        //             formnumber++;
        //             updateform();
        //         });
        //     });

        //     var heart = document.querySelector(".fa-heart");
        //     heart.addEventListener('click', function() {
        //         heart.classList.toggle('heart');
        //     });


        //     var share = document.querySelector(".fa-share-alt");
        //     share.addEventListener('click', function() {
        //         share.classList.toggle('share');
        //     });



        //     function updateform() {
        //         main_form.forEach(function(mainform_number) {
        //             mainform_number.classList.remove('active');
        //         })
        //         main_form[formnumber].classList.add('active');
        //     }

        //     function progress_forward() {
        //         // step_list.forEach(list => {

        //         //     list.classList.remove('active');

        //         // }); 


        //         num.innerHTML = formnumber + 1;
        //         step_list[formnumber].classList.add('active');
        //     }

        //     function progress_backward() {
        //         var form_num = formnumber + 1;
        //         step_list[form_num].classList.remove('active');
        //         num.innerHTML = form_num;
        //     }

        //     var step_num_content = document.querySelectorAll(".step-number-content");

        //     function contentchange() {
        //         step_num_content.forEach(function(content) {
        //             content.classList.remove('active');
        //             content.classList.add('d-none');
        //         });
        //         step_num_content[formnumber].classList.add('active');
        //     }


        //     function validateform() {
        //         validate = true;
        //         var validate_inputs = document.querySelectorAll(".main.active input");
        //         validate_inputs.forEach(function(vaildate_input) {
        //             vaildate_input.classList.remove('warning');
        //             if (vaildate_input.hasAttribute('require')) {
        //                 if (vaildate_input.value.length == 0) {
        //                     validate = false;
        //                     vaildate_input.classList.add('warning');
        //                 }
        //             }
        //         });
        //         return validate;

        //     }
        // }
    </script>
    <?php $__env->stopSection(); ?>
<?php echo $__env->make('admin.layout.dashboard-template', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/yellowcl/public_html/resources/views/admin/appoinment/book-user-appointment.blade.php ENDPATH**/ ?>