
<?php $__env->startSection('content'); ?>
<style>
    .card-table .card-body {
        padding: 3px 15px;
    }

    .page-table-header {
        text-transform: uppercase;
        padding: 15px 0px 21px;
    }
</style>
<div class="page-wrapper">
    <div class="content">

        <div class="row">
            <div class="col-sm-7 col-6">
                <ul class="breadcrumb">
                    <li class="breadcrumb-item"><a href="<?php echo e(route('admin.dashboard')); ?>">Home</a></li>
                    <li class="breadcrumb-item"><i class="feather-chevron-right"></i></li>
                    <li class="breadcrumb-item"><a href="<?php echo e(route('admin.users')); ?>">Users</a></li>
                    <li class="breadcrumb-item"><i class="feather-chevron-right"></i></li>
                    <li class="breadcrumb-item active">User Details</li>
                </ul>
            </div>
            <div class="col-sm-5 col-6 text-end m-b-30 featureddiv">
                <a class="btn btn-secondary follow-btns" href="<?php echo e(route('admin.book-user-appoinment',['id'=>$user->id])); ?>">Book Appoinment</a>
                <a href="javascript:void(0);" data-bs-toggle="modal" data-bs-target="#resetpassword" class="btn btn-success btn-rounded"><i class="fa fa-wallet"></i> Wallet Refil</a>
                <a href="<?php echo e(route('admin.edit-user', ['slug' => $user->id])); ?>" class="btn btn-primary btn-rounded"><i class="fa fa-plus"></i> Edit Profile</a>
            </div>
        </div>
        <div class="card-box profile-header">
            <div class="row">
                <div class="col-md-12">

                    <div class="profile-view">
                        <div class="profile-img-wrap">
                            <div class="profile-img">
                                <?php
                                if ($user->image != NULL) {
                                $img = asset('assets/uploads/user/' . $user->image);
                                } else {
                                if ($user->Gender == 'MALE' || $user->Gender == 'M') {
                                $img = asset('assets/img/male.png');
                                } elseif ($user->Gender == 'FEMALE' || $user->Gender == 'F') {
                                $img = asset('assets/img/female.png');
                                } else {
                                $img = asset('assets/img/other.png');
                                }
                                }

                                ?>

                                <a href="#"><img class="avatar" src="<?php echo e($img); ?>" alt></a>
                            </div>
                        </div>
                        <div class="profile-basic">
                            <div class="row">
                                <div class="col-md-5">
                                    <div class="profile-info-left">
                                        <?php if($user->First_Name): ?>
                                        <h3 class="user-name m-t-0 mb-0"><?php echo e($user->First_Name); ?> <?php echo e(ucfirst($user->Last_Name)); ?></h3>
                                        <small class="text-muted">PID : <?php echo e($user->Patient_Identification_Number); ?></small>
                                        <?php endif; ?>
                                        <br>
                                        <?php if($user->UserId): ?>
                                        <small class="text-muted">USERID : <?php echo e($user->UserId); ?></small>
                                        <?php endif; ?>
                                        <br>
                                        <?php if($user-> Reg_Date): ?>
                                        <small class="text-muted">REGISTRATION DATE : <?php echo e(date("d M Y H:m:s",strtotime($user->Reg_Date))); ?></small>
                                        <?php endif; ?>
                                        <?php if($user->walletBalance): ?>
                                        <p> <button class="custom-badge status-pink">
                                                <img src="<?php echo e(asset('assets/img/icons/menu-icon-09.svg')); ?>"> <?php echo e($user->walletBalance->balance); ?> Coins</button></p>
                                        <?php else: ?>
                                        <p> <button class="custom-badge status-pink">
                                                <img src="<?php echo e(asset('assets/img/icons/menu-icon-09.svg')); ?>"> 0 Coins</button></p>
                                        <?php endif; ?>
                                    </div>
                                </div>
                                <div class="col-md-7">
                                    <ul class="personal-info" style="display: grid;">
                                        <li>
                                            <span class=" title">Phone:</span>
                                            <span class="text"><a href><?php if($user->SMS): ?>
                                                    <?php echo e($user->SMS); ?>

                                                    <?php else: ?>
                                                    <?php echo e($user->phone); ?>

                                                    <?php endif; ?>
                                                </a></span>
                                        </li>
                                        <?php if($user->alternative_phone!=NULL): ?>
                                        <li>
                                            <span class="title">Alternative Phone:</span>
                                            <span class="text"><?php echo e($user->alternative_phone); ?></span>
                                        </li>
                                        <?php endif; ?>
                                        <li>
                                            <span class="title">Email:</span>
                                            <?php if($user->Email): ?>
                                            <span class="text"><a href><span class="__cf_email__" data-cfemail="<?php echo e($user->Email); ?>"><?php echo e($user->Email); ?></span></a></span>
                                            <?php endif; ?>
                                        </li>
                                        <?php if($user->alternative_email!=NULL): ?>
                                        <li>
                                            <span class="title">Alternative Email:</span>
                                            <span class="text"><a href><span class="__cf_email__" data-cfemail="<?php echo e($user->alternative_email); ?>"><?php echo e($user->alternative_email); ?></span></a></span>
                                        </li>
                                        <?php endif; ?>
                                        <li>
                                            <span class="title">Birthday:</span>
                                            <?php if($user->DOB): ?>
                                            <span class="text"><?php echo e(date("d M Y ",strtotime($user->DOB))); ?></span>
                                            <?php endif; ?>
                                        </li>


                                        <li>
                                            <span class="title">Gender:</span>
                                            <?php if($user->Gender): ?>
                                            <span class="text"><?php echo e($user->Gender); ?></span>
                                            <?php endif; ?>
                                        </li>
                                        <li>
                                            <span class="title">Country:</span>
                                            <?php if($user->country): ?>
                                            <span class="text"><?php echo e($user->country); ?></span>
                                            <?php endif; ?>
                                        </li>
                                        <li>
                                            <span class="title">Patient Status:</span>
                                            <?php if($user->country): ?>
                                            <span class="text"><?php echo e($user->Patient_Status); ?></span>
                                            <?php endif; ?>
                                        </li>
                                    </ul>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="profile-tabs">
            <ul class="nav nav-tabs nav-tabs-bottom">
                <li class="nav-item"><a class="nav-link active" href="#upcoming-appoinment" data-value="upcoming" data-bs-toggle="tab">Upcoming Appoinments</a></li>
                <li class="nav-item"><a class="nav-link" href="#prev-appoinment" data-value="previous" data-bs-toggle="tab">Previous Appointments</a></li>
                <li class="nav-item"><a class="nav-link" href="#wallet" data-value="wallet" data-bs-toggle="tab">Wallet Transactions</a></li>
                <li class="nav-item"><a class="nav-link" href="#reviews" data-value="review" data-bs-toggle="tab">Reviews</a></li>
                <li class="nav-item"><a class="nav-link" href="#assessment" data-value="assessment" data-bs-toggle="tab">Assessment</a></li>
            </ul>
            <div class="tab-content">
                <div class="tab-pane show active" id="upcoming-appoinment">
                    <div class="card card-table show-entire">
                        <div class="card-body">

                            <div class="page-table-header mb-2">
                                <div class="row align-items-center">
                                    <div class="col">
                                        <div class="doctor-table-blk">
                                            <h3>Upcoming Appointment</h3>

                                        </div>
                                    </div>

                                </div>
                            </div>


                            <div class="table-responsive text-center">

                                <table class="table border-0 custom-table comman-table  mb-0 " id="upcoming-table">
                                    <thead>
                                        <tr>
                                            <th>
                                                SL.NO
                                            </th>
                                            <th>Action</th>
                                            <th>Provider</th>
                                            <th>Status</th>
                                            <th>Start Date</th>
                                            <th>End Date</th>
                                            <th>Time</th>
                                            <th>Call Type</th>
                                            <th>Charge</th>
                                        </tr>
                                    </thead>
                                    <tbody>

                                    </tbody>
                                </table>

                            </div>
                        </div>
                    </div>
                </div>
                <div class=" tab-pane" id="prev-appoinment">
                    <div class="card card-table show-entire">
                        <div class="card-body">

                            <div class="page-table-header mb-2">
                                <div class="row align-items-center">
                                    <div class="col">
                                        <div class="doctor-table-blk">
                                            <h3>Previous Appointment</h3>
                                        </div>
                                    </div>

                                </div>
                            </div>

                            <div class="table-responsive">
                                <table class="table border-0 custom-table comman-table  mb-0" id="previous-table">
                                    <thead>
                                        <tr>
                                            <th>
                                                SL.NO
                                            </th>
                                            <th>Action</th>
                                            <th>Provider</th>
                                            <th>Status</th>
                                            <th>Appoinment Date</th>
                                            <th>Start Time</th>
                                            <th>End Time</th>
                                            <th>Call Type</th>
                                            <th>Charge</th>
                                        </tr>
                                    </thead>
                                    <tbody>


                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>

                </div>

                <div class="tab-pane" id="wallet">
                    <div class="card card-table show-entire">
                        <div class="card-body">

                            <div class="page-table-header mb-2">
                                <div class="row align-items-center">
                                    <div class="col">
                                        <div class="doctor-table-blk">
                                            <h3>Wallet Transactions</h3>
                                        </div>
                                    </div>

                                </div>
                            </div>

                            <div class="table-responsive">
                                <table class="table border-0 custom-table comman-table  mb-0" id="wallet-table">
                                    <thead>
                                        <tr>
                                            <th>
                                                SL.NO
                                            </th>
                                            <th>Amount</th>
                                            <th>Point</th>
                                            <th>Date</th>
                                            <th>Wallet Type</th>
                                            <th>Transaction Type</th>
                                            <th>Balance</th>
                                        </tr>
                                    </thead>
                                    <tbody>

                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="tab-pane" id="reviews">
                    <div class="card card-table show-entire">
                        <div class="card-body">

                            <div class="page-table-header mb-2">
                                <div class="row align-items-center">
                                    <div class="col">
                                        <div class="doctor-table-blk">
                                            <h3>Reviews</h3>
                                        </div>
                                    </div>

                                </div>
                            </div>

                            <div class="table-responsive">
                                <table class="table border-0 custom-table comman-table  mb-0" id="review-table">
                                    <thead>
                                        <tr>
                                            <th>
                                                SL.NO
                                            </th>
                                            <th>Therapist</th>
                                            <th>Comment</th>
                                            <th>Star</th>
                                            <th>Date</th>
                                            <th>View<br> Appoinment<br> Deatils</th>

                                        </tr>
                                    </thead>
                                    <tbody>

                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="tab-pane" id="assessment">
                    <div class="card card-table show-entire">
                        <div class="card-body">

                            <div class="page-table-header mb-2">
                                <div class="row align-items-center">
                                    <div class="col">
                                        <div class="doctor-table-blk">
                                            <h3>Assessment</h3>
                                        </div>
                                    </div>

                                </div>
                            </div>

                            <div class="table-responsive">
                                <table class="table border-0 custom-table comman-table  mb-0" id="assessment-table">
                                    <thead>
                                        <tr>
                                            <th>
                                                SL.NO
                                            </th>
                                            <th>Title</th>
                                            <th>Score</th>
                                            <th>Status</th>
                                            <th>Date</th>
                                            <th>View</th>

                                        </tr>
                                    </thead>
                                    <tbody>

                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div id="resetpassword" class="modal fade" role="dialog">
            <div class="modal-dialog modal-dialog-centered ">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title">Reset Password</h5>
                    </div>

                    <div class="modal-body text-center">
                        <form id="add-wallet" action="<?php echo e(route('admin.addWalletAmount')); ?>">
                            <?php echo csrf_field(); ?>
                            <div class="row m-t-20">

                                <div class=" col-12 col-md-12 col-xl-12">
                                    <div class="form-group local-forms">
                                        <div class="form-group local-forms">
                                            <label>Wallet Amount<span class="login-danger">*</span></label>
                                            <input class="form-control" required name="user_id" value="<?php echo e($user->id); ?>" type="hidden">
                                            <input class="form-control" required name="amount" type="text">
                                        </div>
                                    </div>
                                </div>

                                <div class=" col-12 col-md-12 col-xl-12">
                                    <div class="form-group local-forms">
                                        <div class="form-group local-forms">
                                            <label>Wallet type / Purpose<span class="login-danger">*</span></label>
                                            <select class="form-control" required name="type">
                                                <?php $__currentLoopData = App\Models\TypesOfWallet::get(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option value="<?php echo e($item->id); ?>"><?php echo e($item->name); ?></option>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </select>
                                        </div>
                                    </div>
                                </div>


                                <div class="m-t-20"> <a href="#" class="btn btn-white" data-bs-dismiss="modal">Close</a>
                                    <button type="submit" class="btn btn-success ">ADD</button>
                                </div>
                            </div>

                        </form>
                    </div>
                </div>
            </div>

        </div>
        <script type="text/javascript">
            $(document).ready(function() {
                var tab = jQuery('.nav-tabs').find('li a.active').data('value');

                if (tab == 'upcoming') {
                    var url = "<?php echo e(route('admin.upcoming-appoinments', ['slug' => $user->id])); ?>";
                    listTable(tab, url);
                }
            });
            $('body').on('click', '.nav-link', function(e) {
                e.preventDefault();
                var tab = jQuery('.nav-tabs').find('li a.active').data('value');
                if (tab == 'upcoming') {
                    var url = "<?php echo e(route('admin.upcoming-appoinments', ['slug' => $user->id])); ?>";
                    listTable(tab, url);
                }
                if (tab == 'previous') {
                    var url = "<?php echo e(route('admin.previuos-appoinments', ['slug' => $user->id])); ?>";
                    listTable(tab, url);
                }
                if (tab == 'wallet') {
                    var url = "<?php echo e(route('admin.wallet-transactions', ['slug' => $user->id])); ?>";
                    listTable(tab, url);
                }
                if (tab == 'review') {
                    var url = "<?php echo e(route('admin.get-reviews', ['slug' => $user->id])); ?>";
                    listTable(tab, url);

                }
                if (tab == 'assessment') {

                    var url = "<?php echo e(route('admin.get-user-assessment', ['slug' => $user->id])); ?>";
                    listTable(tab, url);

                }
            });

            function listTable(tab, url) {
                var tableid = '#' + tab + '-table';
                if ($.fn.DataTable.isDataTable(tableid)) {
                    $(tableid).DataTable().clear().destroy();
                }
                if (tab == 'wallet') {
                    $(tableid).DataTable({
                        processing: true,
                        serverSide: true,
                        ajax: url,
                        columns: [{
                            data: 'DT_RowIndex',
                            name: 'DT_RowIndex'
                        }, {
                            data: 'amount',
                            name: 'amount'
                        }, {
                            data: 'point',
                            name: 'point'
                        }, {
                            data: 'date',
                            name: 'date'
                        }, {
                            data: 'wallet_type',
                            name: 'wallet_type'
                        }, {
                            data: 'transaction_type',
                            name: 'transaction_type'
                        }, {
                            data: 'balance',
                            name: 'balance'
                        }, ],
                        "select": {
                            'style': 'multi',
                            'selector': 'td:first-child' //only checkbox can select row 
                        },
                        dom: 'Bfrtip',
                        buttons: [{
                                extend: 'csv',
                                exportOptions: {
                                    columns: [0, 1, 2, 3, 4, 5, 6, 7]
                                }
                            }, {
                                extend: 'copy',
                                exportOptions: {
                                    columns: [0, 1, 2, 3, 4, 5, 6, 7]
                                }
                            },
                            {
                                extend: 'pdfHtml5',
                                exportOptions: {
                                    columns: [0, 1, 2, 3, 4, 5, 6, 7]
                                }
                            },
                        ]
                    });
                } else if (tab == 'review') {
                    $(tableid).DataTable({
                        processing: true,
                        serverSide: true,
                        ajax: url,
                        columns: [{
                            data: 'DT_RowIndex',
                            name: 'DT_RowIndex'
                        }, {
                            data: 'therapist',
                            name: 'therapist'
                        }, {
                            data: 'comment',
                            name: 'comment'
                        }, {
                            data: 'star',
                            name: 'star'
                        }, {
                            data: 'postdate',
                            name: 'postdate'
                        }, {
                            data: 'action',
                            name: 'action'
                        }],
                        "select": {
                            'style': 'multi',
                            'selector': 'td:first-child' //only checkbox can select row 
                        },
                        dom: 'Bfrtip',
                        buttons: [{
                                extend: 'csv',
                                exportOptions: {
                                    columns: [0, 1, 2, 3, 4]
                                }
                            }, {
                                extend: 'copy',
                                exportOptions: {
                                    columns: [0, 1, 2, 3, 4]
                                }
                            },
                            {
                                extend: 'pdfHtml5',
                                exportOptions: {
                                    columns: [0, 1, 2, 3, 4]
                                }
                            },
                        ]
                    });
                } else if (tab == 'assessment') {
                    $(tableid).DataTable({
                        processing: true,
                        serverSide: true,
                        ajax: url,
                        columns: [{
                            data: 'DT_RowIndex',
                            name: 'DT_RowIndex'
                        }, {
                            data: 'title',
                            name: 'title'
                        }, {
                            data: 'rate',
                            name: 'rate'
                        }, {
                            data: 'date',
                            name: 'date'
                        }, {
                            data: 'status',
                            name: 'status'
                        }, {
                            data: 'action',
                            name: 'action'
                        }],
                        "select": {
                            'style': 'multi',
                            'selector': 'td:first-child' //only checkbox can select row 
                        },
                        dom: 'Bfrtip',
                        buttons: [{
                                extend: 'csv',
                                exportOptions: {
                                    columns: [0, 1, 2, 3, 4]
                                }
                            }, {
                                extend: 'copy',
                                exportOptions: {
                                    columns: [0, 1, 2, 3, 4]
                                }
                            },
                            {
                                extend: 'pdfHtml5',
                                exportOptions: {
                                    columns: [0, 1, 2, 3, 4]
                                }
                            },
                        ]
                    });
                } else {
                    $(tableid).DataTable({
                        processing: true,
                        serverSide: true,
                        ajax: url,
                        columns: [{
                            data: 'DT_RowIndex',
                            name: 'DT_RowIndex'
                        }, {
                            data: 'action',
                            name: 'action',
                            orderable: false,
                            searchable: false
                        }, {
                            data: 'provider',
                            name: 'provider'
                        }, {
                            data: 'status',
                            name: 'status'
                        }, {
                            data: 'date',
                            name: 'date'
                        }, {
                            data: 'start_time',
                            name: 'start_time'
                        }, {
                            data: 'end_time',
                            name: 'end_time'
                        }, {
                            data: 'call_type',
                            name: 'call_type'
                        }, {
                            data: 'charge',
                            name: 'charge'
                        }, ],
                        "select": {
                            'style': 'multi',
                            'selector': 'td:first-child' //only checkbox can select row 
                        },
                        dom: 'Bfrtip',
                        buttons: [{
                            extend: 'csv',
                            exportOptions: {
                                columns: [0, 2, 3, 4, 5, 6, 7, 8]
                            }
                        }, {
                            extend: 'copy',
                            exportOptions: {
                                columns: [0, 2, 3, 4, 5, 6, 7, 8]
                            }
                        }, {
                            extend: 'pdfHtml5',
                            exportOptions: {
                                columns: [0, 2, 3, 4, 5, 6, 7, 8]
                            }
                        }, ]
                    });
                }
            }

            $('#add-wallet').submit(function(e) {
                e.preventDefault();
                var url = $(this).attr("action");
                let formData = new FormData(this);
                $("#js-loader").fadeIn();
                $.ajax({
                    type: 'POST',
                    url: url,
                    data: formData,
                    contentType: false,
                    processData: false,
                    success: function(result) {
                        $("#js-loader").fadeOut();
                        if (result.status == true) {
                            toastr.success(result.data);
                        } else if (result.status == false) {
                            toastr.error(result.data);
                        }
                        location.reload();
                    },
                    error: function(err) {
                        // Your Error Message
                        toastr.error(err.data);
                    }
                });
            });
        </script>
        <?php $__env->stopSection(); ?>
<?php echo $__env->make('admin.layout.dashboard-template', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\yc\resources\views/admin/user/view.blade.php ENDPATH**/ ?>