
<?php $__env->startSection('content'); ?>

<div class="page-wrapper">
    <div class="content">

        <div class="page-header">
            <div class="row">
                <div class="col-sm-12">
                    <ul class="breadcrumb">
                        <li class="breadcrumb-item"><a href="<?php echo e(route('admin.dashboard')); ?>">Home</a></li>
                        <li class="breadcrumb-item"><i class="feather-chevron-right"></i></li>
                        <li class="breadcrumb-item"><a href="<?php echo e(route('admin.services')); ?>">Service</a></li>
                        <li class="breadcrumb-item"><i class="feather-chevron-right"></i></li>
                        <li class="breadcrumb-item active">Edit Services</li>
                    </ul>
                </div>
            </div>
        </div>

        <div class="row">
            <div class="col-sm-12">
                <div class="card">
                    <div class="card-body">
                        <!-- <form method="POST" action="<?php echo e(route('admin.update-service')); ?>"> -->
                        <form id="updateService" action="<?php echo e(route('admin.update-service')); ?>">
                            <?php echo csrf_field(); ?>
                            <div class="row">
                                <div class="col-12">
                                    <div class="form-heading">
                                        <h4>Edit Service Details</h4>
                                    </div>
                                </div>
                                <div class="col-12 col-md-6 col-xl-6">
                                    <div class="form-group local-forms">
                                        <label>Service Title <span class="login-danger">*</span></label>
                                        <input type="hidden" name="id" value="<?php echo e($data->id); ?>">
                                        <input class="form-control" name="title" value="<?php echo e($data->service_name); ?>" type="text" placeholder>
                                    </div>
                                </div>
                                <!-- <div class="col-12 col-md-6 col-xl-6">
                                    <div class="form-group local-forms">
                                        <label>Duration <span class="login-danger">*</span></label>
                                        <input class="form-control" name="sessions" value="<?php echo e($data->duration); ?>" type="time" placeholder>
                                    </div>
                                </div> -->

                                <div class="col-12 col-md-6 col-xl-4">
                                    <div class="form-group local-top-form">
                                        <label class="local-top">Service Image <span class="login-danger">*</span></label>
                                        <input type="file" accept="image/*" name="image" id="file" class="form-control" onchange="readURL(this);">
                                    </div>
                                </div>
                                <div class="col-12 col-md-6 col-xl-2">
                                    <div class="form-group local-top-form">
                                        <img width="60" height="60" src="<?php echo e(asset('assets/uploads/service/' . $data->image)); ?>" class="img-fluid call-imgs preview" alt="">
                                    </div>
                                </div>
                                <div class="col-12 col-md-6 col-xl-12">
                                    <div class="form-group summer-mail">
                                        <label>Description <span class="login-danger">*</span></label>
                                        <textarea rows="4" name="description" cols="5" class="form-control summernote" placeholder="Enter your message here"><?php echo e($data->description); ?></textarea>
                                    </div>
                                </div>


                            </div>

                            <div class="row">
                                <div class="col-sm-12">
                                    <div class="card card-table show-entire">
                                        <div class="card-body">

                                            <div class="page-table-header mb-2">
                                                <div class="row align-items-center">
                                                    <div class="col">
                                                        <div class="doctor-table-blk">
                                                            <h3>Set Fee for Service</h3>

                                                        </div>
                                                    </div>
                                                    <div class="col-auto text-end float-end ms-auto download-grp add-group">
                                                        <a href="javascript:void(0);" title="Add more fee details" class="btn btn-primary add ms-2"><img src="<?php echo e(asset('assets/img/icons/plus.svg')); ?>" alt></a>
                                                    </div>
                                                </div>
                                            </div>


                                        </div>
                                    </div>
                                </div>
                                <?php $__currentLoopData = $data->serviceFeeStructure; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=>$item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div class="row" id="remove-row">
                                    <div class="col-12 col-md-6 col-xl-3">
                                        <div class="form-group local-forms">
                                            <label>Provider Category <span class="login-danger">*</span></label>
                                            <input type="hidden" name="feeid[]" value="<?php echo e($item->id); ?>">

                                            <select class="form-control select" name="provider_category[]">
                                                <?php $__currentLoopData = App\Models\ProviderCategory::get(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $pc): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option value="<?php echo e($pc->id); ?>" <?php echo e($pc->id == $item->provider_category_id ? 'selected' : ''); ?>><?php echo e($pc->name); ?></option>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </select>
                                        </div>
                                    </div>

                                    <div class="col-12 col-md-6 col-xl-3">
                                        <div class="form-group local-forms">
                                            <label>Call Method<span class="login-danger">*</span></label>
                                            <select class="form-control select" name="call_method[]">
                                                <?php $__currentLoopData = App\Models\CallMethods::orderBy('id','DESC')->get(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $cm): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option value="<?php echo e($cm->id); ?>" <?php echo e($cm->id == $item->call_method_id ? 'selected' : ''); ?>><?php echo e($cm->name); ?></option>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </select>
                                        </div>
                                    </div>
                                    <div class="col-12 col-md-6 col-xl-3">
                                        <div class="form-group local-forms">
                                            <label>Duration (in mins)<span class="login-danger">*</span></label>
                                            <input class="form-control" name="duration[]" value="<?php echo e($item->duration); ?>" type="number" placeholder>
                                        </div>
                                    </div>
                                    <div class="col-12 col-md-6 col-xl-2">
                                        <div class="form-group local-forms">
                                            <label>Rate<span class="login-danger">*</span></label>
                                            <input class="form-control" name="rate[]" value="<?php echo e($item->rate); ?>" type="text" placeholder>
                                        </div>
                                    </div>
                                    <div class="col-12 col-md-6 col-xl-1">
                                        <div class="add-group">
                                            <a href=" javascript:void(0);" id="remove" data-id="<?php echo e($item->id); ?>" class=" btn btn-primary ms-2"> <img src="<?php echo e(asset('assets/img/icons/trash.svg')); ?>" alt> </a>
                                        </div>
                                    </div>
                                </div>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>


                                <div id="more-fee"></div>

                            </div>


                            <div class="row">
                                <div class="col-12">
                                    <div class="doctor-submit text-end">
                                        <button type="submit" class="btn btn-primary submit-form me-2">Save</button>
                                        <button type="submit" class="btn btn-primary cancel-form">Cancel</button>
                                    </div>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <script>
        $('body').on('click', '.add', function(e) {
            e.preventDefault();
            $("#js-loader").fadeIn();
            $.ajax({
                url: "<?php echo e(route('admin.fee-html')); ?>",
                method: "GET",
                success: function(result) {
                    $("#js-loader").fadeOut();
                    $('#more-fee').append(result);
                }
            });
        });


        $('body').on('click', '#remove', function(e) {
            var id = $(this).data('id');
            e.preventDefault();
            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });
            $.ajax({
                url: "<?php echo e(route('admin.delete-service-fee')); ?>",
                method: "GET",
                data: {
                    'id': id
                },
                success: function(result) {

                    if (result == 1) {
                        toastr.success("Row Deleted Successfully.");
                    } else {
                        toastr.error("Something went wrong.");
                    }


                }
            });
            $(this).closest("#remove-row").remove();
            // $('#remove-row').hide('slow');
        });



        $('#updateService').submit(function(e) {
            e.preventDefault();
            var url = $(this).attr("action");
            $("#js-loader").fadeIn();
            let formData = new FormData(this);
            $.ajax({
                type: 'POST',
                url: url,
                data: formData,
                contentType: false,
                processData: false,
                success: function(data) {
                    $("#js-loader").fadeOut();
                    if (data == true) {
                        toastr.success('Service Edited Successfully');
                    } else {
                        toastr.error(data);
                    }
                },
                error: function(err) {
                    // Your Error Message
                    toastr.error(err);
                }
            });
        });
    </script>
    <?php $__env->stopSection(); ?>
<?php echo $__env->make('admin.layout.dashboard-template', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/yellowcl/public_html/resources/views/admin/service/edit.blade.php ENDPATH**/ ?>