<?php

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\User\TherapistController;
use App\Http\Controllers\User\ServiceController;
use App\Http\Controllers\User\BlogController;
use App\Http\Controllers\User\HomePageController;
use App\Http\Controllers\User\UserController;
use App\Http\Controllers\User\BookingController;
use App\Http\Controllers\User\WalletController;
use App\Http\Controllers\User\AssessmentController;
use App\Http\Controllers\CallController;
use App\Http\Controllers\ChatController;
/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "api" middleware group. Make something great!
|
*/



Route::post('/login', [UserController::class, 'login']);
Route::post('/register', [UserController::class, 'register']);
// Route::middleware('auth:sanctum')->get('/user', function (Request $request) {
//     return $request->user();
// });


Route::get('/privacy/policy', [HomePageController::class, 'privacy']);
Route::get('/all/currency', [UserController::class, 'allCurrency']);
Route::get('/terms/conditions', [HomePageController::class, 'terms']);
Route::get('/contacts', [HomePageController::class, 'contacts']);
Route::post('/search/slot', [BookingController::class, 'searchSlot']);
Route::post('/send/whatsapp/message', [HomePageController::class, 'sendWhatsappMessage']);
Route::middleware('auth:api')->group(function () {
    Route::post('/booking/from/package', [HomePageController::class, 'packageBookingFromPackage']);
    Route::post('/therapist', [TherapistController::class, 'therapist']);
    Route::get('/therapist', [TherapistController::class, 'therapistDetails']);
    Route::get('/provider/categories', [TherapistController::class, 'providerCategory']);
    Route::get('/specialization', [TherapistController::class, 'specialization']);
    Route::get('/all/service', [ServiceController::class, 'serviceList']);
    Route::get('/service', [ServiceController::class, 'serviceDetails']);
    Route::post('/fetch/therapist/basedOn/Service', [ServiceController::class, 'fetchTherapistBasedOnService']);
    Route::post('/all/blog', [BlogController::class, 'blog']);
    Route::post('/blog', [BlogController::class, 'blogDetails']);
    Route::get('/all/podcast', [BlogController::class, 'podcast']);
    Route::post('/podcast', [BlogController::class, 'podcastDetails']);
    Route::get('/blog/categories', [BlogController::class, 'blogCategory']);

    Route::get('/thought-of-the-day', [HomePageController::class, 'thoughts']);
    Route::get('/banners', [HomePageController::class, 'banners']);
    Route::get('/video/banners', [HomePageController::class, 'videobanners']);
    Route::get('/featured/Therapist', [HomePageController::class, 'featuredTherapist']);
    Route::get('/packages', [HomePageController::class, 'packages']);
    Route::get('/package/details', [HomePageController::class, 'packageDetails']);
    Route::get('/offers', [HomePageController::class, 'offers']);
    Route::get('/offer/details', [HomePageController::class, 'offerDetails']);


    Route::get('/profile', [UserController::class, 'profile']);
    Route::post('/update/profile', [UserController::class, 'updateProfile']);
    Route::post('/update/gst/number', [UserController::class, 'updateGstNumber']);
    Route::post('/update/address', [UserController::class, 'updateAddress']);
    Route::post('/save/token', [UserController::class, 'saveToken'])->name('save-token');
    Route::post('/verify/email', [UserController::class, 'verifyEmail'])->name('verify-email');
    Route::get('/check/email/verified', [UserController::class, 'checkEmailVerfied'])->name('check-email-verified');
    Route::get('/user/packages', [UserController::class, 'packages']);
    Route::post('/change/currency', [UserController::class, 'changeCurrency']);
    Route::get('/user/package/details', [UserController::class, 'packageDetails']);

    Route::post('/logout', [UserController::class, 'logout'])->name('logout');
    Route::post('/get/packages', [BookingController::class, 'getPackages']);

    Route::post('/price/listing', [BookingController::class, 'priceListing']);
    Route::post('/package/booking', [BookingController::class, 'packageBooking']);

    Route::get('/get/coupons', [BookingController::class, 'getCoupons']);
    Route::post('/add/coupons', [BookingController::class, 'addCoupons']);
    Route::post('/book/appoinment', [BookingController::class, 'bookAppoinment']);
    Route::post('/create/order', [BookingController::class, 'creatOrder']);
    Route::post('/verifyPayment', [BookingController::class, 'verifyPayment']);
    Route::post('/report/an/issue', [UserController::class, 'reportAnIssue']);
    Route::get('/notification', [UserController::class, 'notification']);

    //********************************** wallet start *********************************/
    Route::post('/add/wallet/amount', [WalletController::class, 'addWalletAmount']);
    Route::get('/wallet/balance', [WalletController::class, 'walletBalance']);
    Route::get('/wallet/transactions', [WalletController::class, 'walletTransactions']);

    //********************************** wallet end *********************************/

    //********************************** appoiment details *********************************/
    Route::get('/previous/appoinments', [BookingController::class, 'previousAppoinments']);
    Route::get('/upcoming/appoinments', [BookingController::class, 'upcomingAppoinments']);
    Route::get('/canceled/appoinments', [BookingController::class, 'canceledAppoinments']);
    Route::get('/upcoming/appoinments/homepage', [BookingController::class, 'upcomingAppoinmentsHomePage']);
    Route::post('/appoinment/review', [BookingController::class, 'reviewAppoinment']);
    Route::post('/add/review', [BookingController::class, 'addReview']);
    Route::post('/get/review', [BookingController::class, 'getReview']);
    Route::post('/change/appoinment/status', [BookingController::class, 'changeAppoinmentStatus']);
    Route::post('/reshedule/appoinment', [BookingController::class, 'resheduleAppoinment']);
    Route::get('/download/prescription', [BookingController::class, 'downloadPrescription']);
    Route::get('/consulation', [BookingController::class, 'consulation']);
    Route::get('/cancel/reason', [BookingController::class, 'cancelReason']);
    //********************************** appoiment details end *********************************/

    //********************************** assessment  *********************************/
    Route::get('/assessments', [AssessmentController::class, 'assessments']);
    Route::post('/assessments/QandA', [AssessmentController::class, 'assessmentsQandA']);
    Route::post('/save/assessments/QandA', [AssessmentController::class, 'saveAssessmentsQandA']);
    Route::post('/save/mood/tracking', [AssessmentController::class, 'saveMoodTracker']);
    Route::get('/mood/listing', [AssessmentController::class, 'moodListing']);
    Route::get('/get/mood', [AssessmentController::class, 'getMood']);
    //********************************** assessment end *********************************/

    //********************************** call handle functions  *********************************/

    Route::post('/save/patient/call/logintime', [CallController::class, 'savePatientCallLoginTime']);
    Route::post('/save/patient/call/logouttime', [CallController::class, 'savePatientCallLogoutTime']);

    //********************************** call handle functions end *********************************/
    //********************************** chat functions  *********************************/

    Route::post('/save/user/chat', [ChatController::class, 'saveUserChat']);
    Route::get('/get/user/chat', [ChatController::class, 'getUserChat']);
    //********************************** chat functions end *********************************/


});
