@extends('admin.layout.dashboard-template')
@section('content')
<div class="page-wrapper">
    <div class="content">

        <div class="page-header">
            <div class="row">
                <div class="col-sm-12">
                    <ul class="breadcrumb">
                        <li class="breadcrumb-item"><a href="{{route('admin.dashboard')}}">Home</a></li>
                        <li class="breadcrumb-item"><i class="feather-chevron-right"></i></li>
                        <li class="breadcrumb-item"><a href="{{route('admin.users')}}">Patient</a></li>
                        <li class="breadcrumb-item"><i class="feather-chevron-right"></i></li>
                        <li class="breadcrumb-item active">Edit Patient</li>
                    </ul>
                </div>
            </div>
        </div>

        <div class="row">
            <div class="col-sm-12">
                <div class="card">
                    <div class="card-body">
                        <!-- <form method="post" action="{{ route('admin.update-user') }}" enctype="multipart/form-data"> -->
                        <form id="add_user" action="{{ route('admin.update-user') }}" enctype="multipart/form-data">
                            @csrf
                            <div class="row">
                                <div class="col-12">
                                    <div class="form-heading">
                                        <h4>Patient Details</h4>
                                    </div>
                                </div>
                                <div class="col-12 col-md-6 col-xl-6">
                                    <div class="form-group local-forms">
                                        <label>First Name <span class="login-danger">*</span></label>
                                        <input type="hidden" name="id" value="{{$data->id}}">
                                        <input class="form-control" name="first_name" value="{{$data->First_Name}}" type="text" placeholder>
                                    </div>
                                </div>
                                <div class="col-12 col-md-6 col-xl-6">
                                    <div class="form-group local-forms">
                                        <label>Last Name <span class="login-danger">*</span></label>
                                        <input class="form-control" name="last_name" type="text" value="{{$data->Last_Name}}" placeholder>
                                    </div>
                                </div>
                                <div class="col-12 col-md-6 col-xl-6">
                                    <div class="form-group local-forms">
                                        <label>Email <span class="login-danger">*</span></label>
                                        <input class="form-control" name="email" type="email" value="{{$data->Email}}" placeholder>
                                    </div>
                                </div>
                                <div class="col-12 col-md-6 col-xl-6">
                                    <div class="form-group local-forms">
                                        <label>Alternative Email <span class="login-danger">*</span></label>
                                        <input class="form-control" name="alternative_email" type="email" value="{{$data->alternative_email}}" placeholder>
                                    </div>
                                </div>
                                <div class="col-12 col-md-6 col-xl-6">
                                    <div class="form-group local-forms row">
                                        <label>Phone <span class="login-danger">*</span></label>
                                        <div class="col-3 col-md-3 col-xl-3">
                                            <div class="form-group local-forms">
                                                <input class="form-control" name="code" value="{{$data->Phone_Code}}" type="text" placeholder="+91">
                                            </div>
                                        </div>
                                        <div class="col-9 col-md-9 col-xl-9">
                                            <div class="form-group local-forms">
                                                <input class="form-control" name="phone" value="{{$data->phone}}" type="text" max="10">
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                <div class="col-12 col-md-6 col-xl-6">
                                    <div class="form-group local-forms">
                                        <label>Alternative Phone <span class="login-danger">*</span></label>
                                        <input class="form-control" name="alternative_phone" type="text" value="{{$data->alternative_phone}}" placeholder>
                                    </div>
                                </div>
                                @php


                                if ($data->Gender == 'Male' || $data->Gender == 'MALE' || $data->Gender == 'M') {
                                $gender='M';
                                $img = asset('assets/img/male.png');
                                } elseif ($data->Gender == 'Female' || $data->Gender == 'FEMALE' || $data->Gender == 'F') {
                                $gender='F';
                                $img = asset('assets/img/female.png');
                                } else {
                                $gender='O';
                                $img = asset('assets/img/other.png');
                                }
                                if ($data->image != NULL) {
                                $img = asset('assets/uploads/user/' . $data->image);
                                }

                                @endphp
                                <div class="col-12 col-md-6 col-xl-6">
                                    <div class="form-group select-gender">
                                        <label class="gen-label">Gender<span class="login-danger">*</span></label>
                                        <div class="form-check-inline">
                                            <label class="form-check-label">
                                                <input type="radio" name="gender" {{ $gender == 'M' ? 'checked' : ''}} value="MALE" class="form-check-input">Male
                                            </label>
                                        </div>
                                        <div class="form-check-inline">
                                            <label class="form-check-label">
                                                <input type="radio" name="gender" value="FEMALE" {{ $gender == 'F' ? 'checked' : ''}} class="form-check-input">Female
                                            </label>
                                        </div>
                                        <div class="form-check-inline">
                                            <label class="form-check-label">
                                                <input type="radio" name="gender" value="OTHERS" {{ $gender == 'O' ? 'checked' : ''}} class="form-check-input">Others
                                            </label>
                                        </div>
                                    </div>
                                </div>



                                <div class="col-12 col-md-6 col-xl-6">
                                    <div class="form-group local-forms cal-icon">
                                        <label>Date Of Birth <span class="login-danger"></span></label>
                                        <input class="form-control datetimepicker" name="dob" value="{{date('d/m/Y',strtotime($data->DOB))}}" type="text" placeholder>
                                    </div>
                                </div>

                                <div class="col-12 col-md-6 col-xl-4">
                                    <div class="form-group local-top-form">
                                        <label class="local-top">Image <span class="login-danger">*</span></label>
                                        <input type="file" accept="image/*" name="image" id="file" class="form-control" onchange="readURL(this);">
                                    </div>
                                </div>
                                <div class="col-12 col-md-6 col-xl-2">
                                    <div class="form-group local-top-form">
                                        <img width="60" height="60" src="{{$img}}" class="img-fluid call-imgs preview" alt="">
                                    </div>
                                </div>
                                <div class="col-12">
                                    <div class="doctor-submit text-end">
                                        <button type="submit" class="btn btn-primary submit-form me-2">UPDATE</button>
                                        <button type="submit" class="btn btn-primary cancel-form">Cancel</button>
                                    </div>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <script>
        $('#add_user').submit(function(e) {
            e.preventDefault();
            var url = $(this).attr("action");
            let formData = new FormData(this);
            $("#js-loader").fadeIn();
            $.ajax({
                type: 'POST',
                url: url,
                data: formData,
                contentType: false,
                processData: false,
                success: function(result) {
                    $("#js-loader").fadeOut();
                    
       window.location.href = "{{ route('admin.users')}}";
                    if (result.status == true) {
                        toastr.success(result.data);
                    } else if (result.status == false) {
                        toastr.error(result.data);
                    }
                },
                error: function(err) {
                    // Your Error Message
                    toastr.error(err.data);
                }
            });
        });
    </script>
    @endsection