@extends('admin.layout.dashboard-template')
@section('content')

<style>
    .text-muted {
        display: flow-root;
    }


    .table-wrapper>table {
        border-spacing: 0;
        overflow: hidden;
        width: 100%;
    }

    .table-wrapper>table th {
        border-bottom: 1px solid #FBD500;
        font-weight: 700;
        padding: 13px 20px;
        text-align: left;
        text-transform: uppercase;
    }

    .table-wrapper>table>thead {
        background: #efeff2;
    }

    .table-wrapper>table tr.default {
        cursor: pointer;
        transition: all 0.2s ease;
    }

    .table-wrapper>table tr.default td {
        border-bottom: 1px solid #eef9e2;
        padding: 10px 20px;
    }

    .table-wrapper>table tr.toggle-row td {
        padding: 20px 15px;
    }

    .table-wrapper>table tr.default:hover {
        background: #f0f9e5;
    }

    .table-wrapper>table tr.active {
        background: #edf8e1;
    }

    .serial-num {
        color: rgba(51, 51, 51, 0.4);
        font-size: 16px;
    }

    .arrow {
        border-bottom: 2px solid #333;
        border-right: 2px solid #333;
        cursor: pointer;
        float: right;
        height: 8px;
        margin: 0 auto;
        text-indent: -9999px;
        transform: rotate(45deg);
        -webkit-transform: rotate(45deg);
        width: 8px;
    }

    .active .arrow {
        transform: rotate(225deg);
    }

    .sub-table-wrap {
        display: none;
        background: #fff;
    }

    .full-sub-table {
        background: #f9fdf5;
        padding: 24px 14px;
    }

    .full-sub-table .info-wrapper {
        display: inline-block;
        margin: 0;
        width: 24%;
    }

    .full-sub-table .info-wrapper dt {
        color: rgba(51, 51, 51, 0.7);
    }

    .full-sub-table .info-wrapper dd {
        margin: 0;
    }

    .slot-btn {

        margin-bottom: 15px;

    }
</style>
<div class="page-wrapper">
    <div class="content">
        <div class="row">
            <div class="col-sm-7 col-6">
                <ul class="breadcrumb">
                    <li class="breadcrumb-item"><a href="{{route('admin.dashboard')}}">Dashboard </a></li>
                    <li class="breadcrumb-item"><i class="feather-chevron-right"></i></li>
                    <li class="breadcrumb-item"><a href="{{route('admin.therapist')}}">Therapist </a></li>
                    <li class="breadcrumb-item"><i class="feather-chevron-right"></i></li>
                    <li class="breadcrumb-item active">{{$data->full_name}}</li>
                </ul>
            </div>
            <div class="col-sm-5 col-6 text-end m-b-30 featureddiv">
                <!-- @if($data->featured==1)
                    <a href="javascript:void(0);" data-id="{{$data->id}}" data-value="0" class="btn btn-success btn-rounded featured" title="Make it as Unfeatured"><i class="fa fa-check-circle"></i> Verified</a>
                    @else
                    <a href="javascript:void(0);" data-id="{{$data->id}}" data-value="1" class="btn btn-danger btn-rounded featured" title="Make it as Featured"><i class="fa fa-times-circle"></i> Unverfied</a>
                    @endif -->
                <a href="javascript:void(0);" data-bs-toggle="modal" data-bs-target="#resetpassword" class="btn btn-warning btn-rounded"><i class="fa fa-lock"></i> Change Password</a>
                <a href="{{route('admin.edit-therapist', ['slug' => $data->slug])}}" class="btn btn-primary btn-rounded"><i class="fa fa-plus"></i> Edit Profile</a>
            </div>
        </div>
        <div class="card-box profile-header">
            <div class="row">
                <div class="col-md-12">
                    <div class="profile-view">
                        <div class="profile-img-wrap">
                            <div class="profile-img">
                                @php
                                if ($data->image != NULL) {
                                $img = asset('assets/uploads/therapist/' . $data->image);
                                } else {
                                if ($data->gender == 'MALE') {
                                $img = asset('assets/img/male-avatar.jpg');
                                } else {
                                $img = asset('assets/img/female-avatar.webp');
                                }
                                }
                                @endphp
                                <a href="#"><img class="avatar" src="{{$img}}" alt></a>
                            </div>
                        </div>

                        <div class="profile-basic">
                            <div class="row">
                                <div class="col-md-5">
                                    <div class="profile-info-left">
                                        <h3 class="user-name m-t-0 mb-0">{{$data->prefix}}{{ucfirst($data->full_name)}}</h3>
                                        <small class="text-muted">{{ucfirst($data->designation) }}</small>
                                        <p> <button class="custom-badge status-pink">{{$data->providerCategory->name}}</button></p>
                                        <div class="staff-id">Employee ID : {{$data->employee_id}}</div>
                                        <small class="text-muted"><i class="fas fa-calendar-alt"></i>&nbsp;{{$data->experience}}yrs Exp</small>
                                        <small class="text-muted"><i class="fas fa-video"></i>&nbsp;{{count(App\Models\Appointments::where('therapist_id', $data->id)->get())}} Sessions</small>
                                        <small class="text-muted"><i class="fas fa-comment"></i>&nbsp;{{$data->language_known}}</small>

                                    </div>
                                </div>
                                <div class="col-md-7">
                                    <ul class="personal-info">
                                        <li>
                                            <span class="title">Phone:</span>
                                            <span class="text"><a href>{{$data->mobile}}</a></span>
                                        </li>
                                        <li>
                                            <span class="title">Email:</span>
                                            <span class="text"><a href><span class="__cf_email__" data-cfemail="{{$data->email }}">{{$data->email }}</span></a></span>
                                        </li>
                                        <li>
                                            <span class="title">Birthday:</span>
                                            <span class="text">{{date("d M Y ",strtotime($data->dob)) }}</span>
                                        </li>
                                        <li>
                                            <span class="title">Address:</span>
                                            <span class="text">{{$data->address }}</span>
                                        </li>
                                        <li>
                                            <span class="title">Gender:</span>
                                            <span class="text">{{$data->gender }}</span>
                                        </li>
                                        <li>
                                            <span class="title">Qualification:</span>
                                            <span class="text">{{$data->qualification }}</span>
                                        </li>
                                        <li>
                                            <span class="title">Joining Date:</span>
                                            <span class="text">{{date("d M Y ",strtotime($data->joining_date)) }}</span>
                                        </li>
                                        <li>
                                            <span class="title">Slot Setting Permission:</span>
                                            <span class="text">{{Str::upper($data->slot_setting_permission) }}</span>
                                        </li>

                                    </ul>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>


        <div class="profile-tabs">
            <ul class="nav nav-tabs nav-tabs-bottom">
                <li class="nav-item"><a class="nav-link active" href="#profile" data-bs-toggle="tab">Profile</a></li>
                <li class="nav-item"><a class="nav-link" href="#slot" data-bs-toggle="tab">Slots</a></li>
                <li class="nav-item"><a class="nav-link" href="#upcoming-appoinment" data-value="upcoming" data-bs-toggle="tab">Upcoming Appointments</a></li>
                <li class="nav-item"><a class="nav-link" href="#prev-appoinment" data-value="previous" data-bs-toggle="tab">Previous Appointments</a></li>
                <li class="nav-item"><a class="nav-link" href="#reviews" data-value="review" data-bs-toggle="tab">Reviews</a></li>

            </ul>
            <div class="tab-content">
                <div class="tab-pane show active" id="profile">
                    <div class="row">
                        <div class="col-md-12">
                            @if($data->services)
                            <div class="card-box">
                                <h4>Services</h4>
                                @foreach($data->services as $item)
                                @php
                                $s=App\Models\Service::where('id',$item)->pluck('service_name')->first();
                                @endphp
                                <!-- <button class="custom-badge status-gray re-shedule"> </button> -->
                                <a href="javascript:;" class="status-green">{{$s }}</a>
                                @endforeach
                            </div>
                            @endif

                            @if($data->specialization_and_expertise )
                            <div class="card-box">
                                <h4>Specialization and Expertise</h4>
                                @foreach($data->specialization_and_expertise as $item)
                                @php
                                $s=App\Models\Specialization::where('id',$item)->pluck('tag')->first();
                                @endphp
                                <!-- <button class="custom-badge status-gray re-shedule"> </button> -->
                                <a href="javascript:;" class="status-pink">{{$s }}</a>
                                @endforeach
                            </div>
                            @endif

                            <div class="card-box">
                                <h4>Address</h4>
                                <div class="about-me-list">
                                    <ul class="list-space">
                                        <li>
                                            <h4>Address</h4>
                                            <span>{{$data->address}}</span>
                                        </li>
                                        <li>
                                            <h4>City</h4>
                                            <span>{{$data->city}}</span>
                                        </li>
                                        <li>
                                            <h4>State</h4>
                                            <span>{{$data->state}}</span>
                                        </li>
                                        <li>
                                            <h4>Country</h4>
                                            <span>{{$data->country}}</span>
                                        </li>
                                        <li>
                                            <h4>Postal Code</h4>
                                            <span>{{$data->postal_code}}</span>
                                        </li>
                                    </ul>
                                </div>
                            </div>

                            <div class="card-box">
                                <h4>Biography</h4>
                                {{$data->biography}}
                            </div>
                            @if($data->personal_background)
                            <div class="card-box">
                                <h4>Personal Background</h4>
                                {{$data->personal_background}}
                            </div>
                            @endif

                            @if($data->research_and_publications)
                            <div class="card-box">
                                <h4>Research and Publications</h4>
                                {{$data->research_and_publications}}
                            </div>
                            @endif
                            @if($data->approach_and_treatment)
                            <div class="card-box">
                                <h4>Approach and Treatment</h4>
                                {{$data->approach_and_treatment}}
                            </div>
                            @endif

                            @if($data->philosophy_and_approach)
                            <div class="card-box">
                                <h4>Philosophy and Approach</h4>
                                {{$data->philosophy_and_approach}}
                            </div>
                            @endif


                            @if($data->client_focus_and_population)
                            <div class="card-box">
                                <h4>Client Focus and Population</h4>
                                {{$data->client_focus_and_population}}
                            </div>
                            @endif

                            @if($data->skills)
                            <div class="card-box">
                                <h4>Skills</h4>
                                {{$data->skills}}
                            </div>
                            @endif

                            @if($data->skills)
                            <div class="card-box">
                                <h4>Skills</h4>
                                {{$data->skills}}
                            </div>
                            @endif
                            @if($data->awards)
                            <div class="card-box">
                                <h4>Awards</h4>
                                {{$data->awards}}
                            </div>
                            @endif
                            <div class="card-box">
                                <h3 class="card-title">Experience</h3>
                                <div class="experience-box">
                                    <ul class="experience-list">
                                        @foreach($data->work as $item)
                                        <li>
                                            <div class="experience-user">
                                                <div class="before-circle"></div>
                                            </div>
                                            <div class="experience-content">
                                                <div class="timeline-content">
                                                    <a href="#/" class="name">{{$item->designation}}</a>
                                                    <div>{{$item->hospital}}</div>
                                                    <span class="time">{{$item->place}}</span>

                                                </div>
                                            </div>
                                        </li>
                                        @endforeach

                                    </ul>
                                </div>
                            </div>

                            <div class="card-box ">
                                <h3 class="card-title">Education Informations</h3>
                                <div class="experience-box">
                                    <ul class="experience-list">
                                        @foreach($data->academics as $item)
                                        <li>
                                            <div class="experience-user">
                                                <div class="before-circle"></div>
                                            </div>
                                            <div class="experience-content">
                                                <div class="timeline-content">
                                                    <a href="#" class="name">{{$item->education}}</a>
                                                    <div>{{$item->college}}</div>
                                                    <span class="time">{{$item->year}}</span>
                                                </div>
                                            </div>
                                        </li>
                                        @endforeach

                                    </ul>
                                </div>
                            </div>

                            <div class="card-box ">
                                <h3 class="card-title">Additional Training</h3>
                                <div class="experience-box">
                                    <ul class="experience-list">
                                        @foreach($data->training as $item)
                                        <li>
                                            <div class="experience-user">
                                                <div class="before-circle"></div>
                                            </div>
                                            <div class="experience-content">
                                                <div class="timeline-content">
                                                    <a href="#" class="name">{{$item->education}}</a>
                                                    <div>{{$item->college}}</div>
                                                    <span class="time">{{$item->year}}</span>
                                                </div>
                                            </div>
                                        </li>
                                        @endforeach

                                    </ul>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="tab-pane" id="upcoming-appoinment">
                    <div class="card card-table show-entire">
                        <div class="card-body">

                            <div class="page-table-header mb-2">
                                <div class="row align-items-center">
                                    <div class="col">
                                        <div class="doctor-table-blk">
                                            <h3>Upcoming Appointment</h3>

                                        </div>
                                    </div>
                                    <div class="col-auto text-end float-end ms-auto download-grp">
                                        <a href="javascript:;" class=" me-2"><img src="assets/img/icons/pdf-icon-01.svg" alt></a>
                                        <a href="javascript:;" class=" me-2"><img src="assets/img/icons/pdf-icon-02.svg" alt></a>
                                        <a href="javascript:;" class=" me-2"><img src="assets/img/icons/pdf-icon-03.svg" alt></a>
                                        <a href="javascript:;"><img src="assets/img/icons/pdf-icon-04.svg" alt></a>
                                    </div>
                                </div>
                            </div>

                            <div class="table-responsive text-center">

                                <table class="table border-0 custom-table comman-table  mb-0 " id="upcoming-table">
                                    <thead>
                                        <tr>
                                            <th>
                                                SL.NO
                                            </th>
                                            <th>Action</th>
                                            <th>User</th>
                                            <th>Status</th>
                                            <th>Date</th>
                                            <th>Start Time</th>
                                            <th>End Time</th>
                                            <th>Call Type</th>
                                            <th>Charge</th>
                                        </tr>
                                    </thead>
                                    <tbody>

                                    </tbody>
                                </table>

                            </div>
                        </div>
                    </div>


                    <div id="delete_patient" class="modal fade delete-modal" role="dialog">
                        <div class="modal-dialog modal-dialog-centered">
                            <div class="modal-content">
                                <div class="modal-body text-center">
                                    <img src="assets/img/sent.png" alt width="50" height="46">
                                    <h3>Are you sure want to delete this ?</h3>
                                    <div class="m-t-20"> <a href="#" class="btn btn-white" data-bs-dismiss="modal">Close</a>
                                        <button type="submit" class="btn btn-danger">Delete</button>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                </div>

                <div class="tab-pane" id="prev-appoinment">
                    <div class=" card card-table show-entire">
                        <div class="card-body">

                            <div class="page-table-header mb-2">
                                <div class="row align-items-center">
                                    <div class="col">
                                        <div class="doctor-table-blk">
                                            <h3>Previous Appointment</h3>

                                        </div>
                                    </div>
                                    <div class="col-auto text-end float-end ms-auto download-grp">
                                        <a href="javascript:;" class=" me-2"><img src="assets/img/icons/pdf-icon-01.svg" alt></a>
                                        <a href="javascript:;" class=" me-2"><img src="assets/img/icons/pdf-icon-02.svg" alt></a>
                                        <a href="javascript:;" class=" me-2"><img src="assets/img/icons/pdf-icon-03.svg" alt></a>
                                        <a href="javascript:;"><img src="assets/img/icons/pdf-icon-04.svg" alt></a>
                                    </div>
                                </div>
                            </div>

                            <div class="table-responsive text-center">

                                <table class="table border-0 custom-table comman-table  mb-0 " id="previous-table">
                                    <thead>
                                        <tr>
                                            <th>
                                                SL.NO
                                            </th>
                                            <th>Action</th>
                                            <th>User</th>
                                            <th>Status</th>
                                            <th>Date</th>
                                            <th>Start Time</th>
                                            <th>End Time</th>
                                            <th>Call Type</th>
                                            <th>Charge</th>
                                        </tr>
                                    </thead>
                                    <tbody>

                                    </tbody>
                                </table>

                            </div>
                        </div>
                    </div>
                    <div id="delete_patient" class="modal fade delete-modal" role="dialog">
                        <div class="modal-dialog modal-dialog-centered">
                            <div class="modal-content">
                                <div class="modal-body text-center">
                                    <img src="assets/img/sent.png" alt width="50" height="46">
                                    <h3>Are you sure want to delete this ?</h3>
                                    <div class="m-t-20"> <a href="#" class="btn btn-white" data-bs-dismiss="modal">Close</a>
                                        <button type="submit" class="btn btn-danger">Delete</button>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                </div>


                <div class="tab-pane" id="slot">
                    <div class="card">
                        @if($slot)
                        <div class="card-header text-center">
                            <h4 class="card-title mb-0">Slots</h4>
                            <p>Break Time: {{$slot->break_duration}}</p>
                        </div>
                        <div class="card-body">
                            <div class="table-responsive">
                                <div class="table-wrapper">
                                    <table>
                                        <tbody>
                                            @foreach(days() as $day)
                                            <tr class="default text-center">
                                                <th style=" background: #dee0f0;">{{$day}}</th>
                                            </tr>

                                            @php
                                            $flag=0;
                                            foreach($slot->workingHours as $key=>$item){
                                            if($day==$item->day){
                                            $flag++;
                                            }
                                            }

                                            @endphp

                                            @if($flag==0)
                                            <tr class="text-center">
                                                <td>Unavailable</td>
                                            </tr>
                                            @else
                                            <tr>
                                                <td>
                                                    <table class="table">
                                                        <thead>
                                                            <tr>

                                                                <th>Start Time</th>
                                                                <th>End Time</th>
                                                                <th>Slots</th>
                                                            </tr>
                                                        </thead>
                                                        <tbody>

                                                            @foreach($slot->workingHours as $key=>$item)
                                                            @if($day==$item->day)
                                                            <tr class="default">

                                                                <td>
                                                                    <span>{{$item->start_time}}</span>
                                                                </td>
                                                                <td>
                                                                    <span>{{ $item->end_time}}</span>
                                                                </td>
                                                                <td>View Slots<span class="arrow">View Slots</span></td>
                                                            </tr>

                                                            <tr class="toggle-row">
                                                                <td colspan="6">
                                                                    <div class="sub-table-wrap">
                                                                        <div class="full-sub-table">
                                                                            <table class="table">
                                                                                <thead>
                                                                                    <tr>
                                                                                        <th>CALL METHOD</th>
                                                                                        <th>SLOTS</th>
                                                                                    </tr>
                                                                                </thead>
                                                                                <tbody>
                                                                                    @foreach($item->slotShedule as $s)
                                                                                    <tr>
                                                                                        <td>{{$s->callMethod->name}}</td>
                                                                                        <td>
                                                                                            @php
                                                                                            $i=0;
                                                                                            @endphp
                                                                                            @foreach(json_decode($s->slots) as $x)

                                                                                            <button class="custom-badge status-green slot-btn">{{$x}}</button>

                                                                                            @endforeach
                                                                                        </td>
                                                                                    </tr>
                                                                                    @endforeach
                                                                                </tbody>
                                                                            </table>

                                                                        </div>
                                                                    </div>
                                                                </td>
                                                            </tr>
                                                            @else
                                                            @continue
                                                            @endif
                                                            @endforeach
                                                        </tbody>
                                                    </table>
                                                </td>
                                            </tr>

                                            @endif
                                            @endforeach

                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                        @else
                        <div class="card chat-box  mb-0">
                            <div class="voice-call-blk text-center">
                                <div class="voice-call-user">
                                    <p>Slots Not set for {{$data->full_name}}</p>
                                </div>

                                <div class="end-call-voice">
                                    <a href="{{route('admin.add-slot')}}" class="btn btn-primary">Add slot</a>
                                </div>
                            </div>
                        </div>
                        @endif
                    </div>
                </div>


                <div class="tab-pane" id="reviews">
                    <div class="card card-table show-entire">
                        <div class="card-body">

                            <div class="page-table-header mb-2">
                                <div class="row align-items-center">
                                    <div class="col">
                                        <div class="doctor-table-blk">
                                            <h3>Reviews</h3>
                                        </div>
                                    </div>

                                </div>
                            </div>

                            <div class="table-responsive">
                                <table class="table border-0 custom-table comman-table  mb-0" id="review-table">
                                    <thead>
                                        <tr>
                                            <th>
                                                SL.NO
                                            </th>
                                            <th>User</th>
                                            <th>Comment</th>
                                            <th>Star</th>
                                            <th>Date</th>
                                            <th>View<br> Appoinment<br> Deatils</th>

                                        </tr>
                                    </thead>
                                    <tbody>

                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div id="resetpassword" class="modal fade" role="dialog">
        <div class="modal-dialog modal-dialog-centered ">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Reset Password</h5>
                </div>
                <div class="modal-body text-center">
                    <form id="password_form" action="{{ route('admin.reset-therapist-password') }}">
                        @csrf
                        <div class="row m-t-20">
                            <div class=" col-12 col-md-12 col-xl-12">
                                <div class="form-group local-forms">
                                    <label>New Password<span class="login-danger">*</span></label>
                                    <input class="form-control" required name="id" value="{{$data->id}}" type="hidden">
                                    <input class="form-control" required name="full_name" value="{{$data->full_name}}" type="hidden">
                                    <input class="form-control" required name="mobile" value="{{$data->mobile}}" type="hidden">
                                    <input class="form-control" required name="email" value="{{$data->email}}" type="hidden">
                                    <input class="form-control" required name="password" minlength="6" type="text">
                                </div>
                            </div>
                            <div class=" col-12 col-md-12 col-xl-12" <div class="form-group local-forms">
                                <div class="form-group local-forms">
                                    <label>Confirm Password<span class="login-danger">*</span></label>
                                    <input class="form-control" required name="confirm_password" minlength="6" type="text">
                                </div>

                            </div>
                        </div>
                        <div class="m-t-20"> <a href="#" class="btn btn-white" data-bs-dismiss="modal">Close</a>
                            <button type="submit" class="btn btn-success ">ADD</button>
                        </div>
                </div>

                </form>
            </div>
        </div>
    </div>
</div>

</div>
</div>

<script>
    $('#password_form').submit(function(e) {
        e.preventDefault();
        var url = $(this).attr("action");
        let formData = new FormData(this);
        $("#js-loader").fadeIn();
        $.ajax({
            type: 'POST',
            url: url,
            data: formData,
            contentType: false,
            processData: false,
            success: function(result) {

                $("#js-loader").fadeOut();
                if (result == true) {
                    toastr.success("Password Updated Successfully");
                } else if (result == false) {
                    toastr.error("Something went wrong");
                }
            },
            error: function(err) {
                // Your Error Message
                toastr.error(err);
            }
        });
    });
    $(document).on('click', '.featured', function(e) {
        var id = $(this).data('id');
        var status = $(this).data('value');
        e.preventDefault();
        $.ajaxSetup({
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            }
        });
        $.ajax({
            url: "{{ route('admin.featured-therapist-status') }}",
            method: "GET",
            data: {
                'id': id,
                'status': status
            },
            success: function(result) {
                $('.featureddiv').load('.featureddiv');
                if (result == 1) {
                    toastr.success("Featured Status Changed Successfully.");
                } else {
                    toastr.error("Something went wrong.");
                }

            }
        });

    });

    $(document).ready(function($) {
        $('.default').click(function() {
            $('.default').not($(this)).removeClass('active');
            $(this).toggleClass('active').next().find('.sub-table-wrap').slideToggle();
            $(".toggle-row").not($(this).next()).find('.sub-table-wrap').slideUp('fast');
        });
    });

    $('body').on('click', '.nav-link', function(e) {
        e.preventDefault();
        var tab = jQuery('.nav-tabs').find('li a.active').data('value');

        if (tab == 'upcoming') {
            var url = "{{ route('admin.upcoming-appoinments-therapist', ['id' => $data->id]) }}";

            listTable(tab, url);
        }
        if (tab == 'previous') {
            var url = "{{ route('admin.previous-appoinments-therapist', ['id' => $data->id]) }}";
            listTable(tab, url);
        }
        if (tab == 'review') {
            var url = "{{ route('admin.get-reviews-therapist', ['id' => $data->id]) }}";
            listTable(tab, url);

        }
    });

    function listTable(tab, url) {
        var tableid = '#' + tab + '-table';
        if ($.fn.DataTable.isDataTable(tableid)) {
            $(tableid).DataTable().clear().destroy();
        }
        if (tab == 'review') {
            $(tableid).DataTable({
                processing: true,
                serverSide: true,
                ajax: url,
                columns: [{
                    data: 'DT_RowIndex',
                    name: 'DT_RowIndex'
                }, {
                    data: 'user',
                    name: 'user'
                }, {
                    data: 'comment',
                    name: 'comment'
                }, {
                    data: 'star',
                    name: 'star'
                }, {
                    data: 'postdate',
                    name: 'postdate'
                }, {
                    data: 'action',
                    name: 'action'
                }],
                "select": {
                    'style': 'multi',
                    'selector': 'td:first-child' //only checkbox can select row 
                },
                dom: 'Bfrtip',
                buttons: [{
                        extend: 'csv',
                        exportOptions: {
                            columns: [0, 1, 2, 3, 4]
                        }
                    }, {
                        extend: 'copy',
                        exportOptions: {
                            columns: [0, 1, 2, 3, 4]
                        }
                    },
                    {
                        extend: 'pdfHtml5',
                        exportOptions: {
                            columns: [0, 1, 2, 3, 4]
                        }
                    },
                ]
            });
        } else {
            $(tableid).DataTable({
                processing: true,
                serverSide: true,
                ajax: url,
                columns: [{
                    data: 'DT_RowIndex',
                    name: 'DT_RowIndex'
                }, {
                    data: 'action',
                    name: 'action',
                    orderable: false,
                    searchable: false
                }, {
                    data: 'provider',
                    name: 'provider'
                }, {
                    data: 'status',
                    name: 'status'
                }, {
                    data: 'date',
                    name: 'date'
                }, {
                    data: 'start_time',
                    name: 'start_time'
                }, {
                    data: 'end_time',
                    name: 'end_time'
                }, {
                    data: 'call_type',
                    name: 'call_type'
                }, {
                    data: 'charge',
                    name: 'charge'
                }, ],
                "select": {
                    'style': 'multi',
                    'selector': 'td:first-child' //only checkbox can select row 
                },
                dom: 'Bfrtip',
                buttons: [{
                    extend: 'csv',
                    exportOptions: {
                        columns: [0, 2, 3, 4, 5, 6, 7, 8]
                    }
                }, {
                    extend: 'copy',
                    exportOptions: {
                        columns: [0, 2, 3, 4, 5, 6, 7, 8]
                    }
                }, {
                    extend: 'pdfHtml5',
                    exportOptions: {
                        columns: [0, 2, 3, 4, 5, 6, 7, 8]
                    }
                }, ]
            });
        }
    }
</script>
@endsection