@extends('admin.layout.dashboard-template')
@section('content')
<style>
    @media (min-width: 730px) {
        .daterangepicker.ltr .ranges {
            float: right !important;
        }
    }
</style>
<div class="page-wrapper">
    <div class="content">

        <div class="page-header">
            <div class="row">
                <div class="col-sm-12">
                    <ul class="breadcrumb">
                        <!-- <li class="breadcrumb-item"><a href="admin-users.php">Service </a></li>
                        <li class="breadcrumb-item"><i class="feather-chevron-right"></i></li> -->
                        <li class="breadcrumb-item active">Therapist settlements

                        </li>
                    </ul>
                </div>
            </div>
        </div>

        <div class="row">
            <div class="col-sm-12">
                <div class="card card-table show-entire">
                    <div class="card-body">
                        <div class="page-table-header mb-5">
                            <div class="row align-items-center">
                                <div class="col">
                                    <div class="doctor-table-blk">
                                        <h3>Therapist Settlements</h3>
                                        <div class="col-auto text-end float-end ms-auto download-grp">

                                            <a href="{{route('admin.add-settlement')}}" class="btn btn-primary add-pluss ms-2"><i class="far fa-plus"></i></a>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="row align-items-center">

                            <div>
                                <div class=" row mb-5 p-2">

                                    <div class="col-12 col-md-6 col-xl-4">
                                        <div class="form-group local-forms">
                                            <label>Payment From </label>
                                            <input class="form-control" type="date" required name="from" placeholder>
                                        </div>
                                    </div>
                                    <div class="col-12 col-md-6 col-xl-4">
                                        <div class="form-group local-forms">
                                            <label>Payment To</label>
                                            <input class="form-control" type="date" required name="to" placeholder>
                                        </div>
                                    </div>
                                    <div class="col-12 col-md-6 col-xl-4">
                                        <div class="form-group local-forms">
                                            <label>Provider </label>
                                            <select class="form-control therapist" name="therapist">
                                                <option value="">--Select Therapist--</option>
                                                @foreach(App\Models\Therapist::get() as $item)
                                                <option value="{{$item->id}}">{{$item->prefix}}.{{$item->full_name}}</option>
                                                @endforeach
                                            </select>
                                        </div>
                                    </div>


                                    <div class="col-12 col-md-6 col-xl-2">
                                        <div class="form-group local-forms">
                                            <!-- <button class="btn btn-success submit-form ">Filter</button> -->
                                            <button class="btn btn-success filter" style="width:100%;">Filter</button>
                                        </div>
                                    </div>

                                </div>


                                <div class="table-responsive">
                                    <table class="table border-0 custom-table comman-table mb-0" id="therapist_table">
                                        <thead>
                                            <tr>
                                                <th>payment_id</th>
                                                <th>Therapist</th>
                                                <th>Amount</th>
                                                <th>payment_date</th>
                                                <th>Payment Of</th>
                                                <th>Action</th>
                                            </tr>
                                        </thead>
                                        <tbody>

                                        </tbody>
                                        <tfoot>
                                            <tr>
                                                <th></th>
                                                <th></th>
                                                <th></th>
                                                <th></th>
                                                <th></th>
                                                <th></th>
                                            </tr>
                                        </tfoot>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div id="delete_settlement" class="modal fade delete-modal" role="dialog">
                <div class="modal-dialog modal-dialog-centered">
                    <div class="modal-content">
                        <div class="modal-body text-center">
                            <img src="assets/img/sent.png" alt width="50" height="46">
                            <h3>Are you sure want to delete this ?</h3>
                            <div class="m-t-20"> <a href="#" class="btn btn-white" data-bs-dismiss="modal">Close</a>
                                <button type="submit" class="btn btn-danger" id="delete_item">Delete</button>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <script type="text/javascript" src="//cdn.jsdelivr.net/jquery/1/jquery.min.js"></script>
            <script type="text/javascript" src="//cdn.jsdelivr.net/momentjs/latest/moment.min.js"></script>
            <!-- <link rel="stylesheet" type="text/css" href="//cdn.jsdelivr.net/bootstrap/3/css/bootstrap.css" /> -->

            <script type="text/javascript" src="//cdn.jsdelivr.net/bootstrap.daterangepicker/2/daterangepicker.js"></script>
            <link rel="stylesheet" type="text/css" href="//cdn.jsdelivr.net/bootstrap.daterangepicker/2/daterangepicker.css" />
            <script type="text/javascript" src="https://www.gstatic.com/charts/loader.js"></script>
            <script type="text/javascript">
                $(function() {
                    var table = $('#therapist_table').DataTable({
                        "footerCallback": function(row, data, start, end, display) {
                            var api = this.api(),
                                data;

                            // converting to interger to find total
                            var intVal = function(i) {
                                return typeof i === 'string' ?
                                    i.replace(/[\$,]/g, '') * 1 :
                                    typeof i === 'number' ?
                                    i : 0;
                            };

                            var thuTotal = api
                                .column(2)
                                .data()
                                .reduce(function(a, b) {
                                    return intVal(a) + intVal(b);
                                }, 0);


                            // Update footer by showing the total with the reference of the column index 

                            $(api.column(1).footer()).html('Total');
                            $(api.column(2).footer()).html(thuTotal);

                        },
                        processing: true,
                        serverSide: true,
                        dom: "<'row'<'col-sm-4'l><'col-sm-4'f><'col-sm-4'B>>" +
                            "<'row'<'col-sm-12'tr>>" +
                            "<'row'<'col-sm-5'i><'col-sm-7'p>>",

                        //    ajax: "{{ route('admin.get-consulation-report') }}",
                        ajax: {
                            url: "{{ route('admin.get-settlements') }}",
                            data: function(d) {
                                d.from = $('input[name="from"]').val();
                                d.to = $('input[name="to"]').val();
                                d.therapist = $('select[name="therapist"]').val();
                            }
                        },
                        columns: [{
                                data: 'settlement_id',
                                name: 'settlement_id'
                            },
                            {
                                data: 'therapist',
                                name: 'therapist'
                            },
                            {
                                data: 'amount',
                                name: 'amount'
                            },
                            {
                                data: 'payment_date',
                                name: 'payment_date'
                            },

                            {
                                data: 'Payment Of',
                                name: 'Payment Of'
                            },
                            {
                                data: 'action',
                                name: 'action',
                                orderable: false,
                                searchable: false
                            },
                        ],
                        "select": {
                            'style': 'multi',
                            'selector': 'td:first-child' //only checkbox can select row
                        },
                        buttons: [{
                                extend: 'copyHtml5',
                                footer: true
                            },
                            {
                                extend: 'excelHtml5',
                                footer: true
                            },
                            {
                                extend: 'csvHtml5',
                                footer: true
                            },
                            {
                                extend: 'pdfHtml5',
                                footer: true
                            },
                            {
                                extend: 'print',
                                footer: true
                            }
                        ]
                    });
                    $(".filter").click(function() {

                        table.draw();
                    });
                });


                var deleteID;
                $('body').on('click', '#getDeleteId', function() {
                    deleteID = $(this).data('id');
                })
                $(document).on('click', '#delete_item', function(e) {
                    var id = deleteID;
                    e.preventDefault();
                    $.ajaxSetup({
                        headers: {
                            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                        }
                    });
                    $.ajax({
                        url: "{{ route('admin.delete-settlement') }}",
                        method: "GET",
                        data: {
                            'id': id
                        },
                        success: function(result) {
                            $('#delete_settlement').modal('hide');
                            $('.table').DataTable().ajax.reload();
                            if (result == 1) {
                                toastr.success("Data Deleted Successfully.");
                            } else {
                                toastr.error("Something went wrong.");
                            }

                            $('.data-table').DataTable().ajax.reload();

                        }
                    });

                });
            </script>
            @endsection