@extends('admin.layout.dashboard-template')
@section('content')
<div class="page-wrapper">
    <div class="content">

        <div class="page-header">
            <div class="row">
                <div class="col-sm-12">
                    <ul class="breadcrumb">
                        <li class="breadcrumb-item"><a href="{{route('admin.dashboard')}}">Home</a></li>
                        <li class="breadcrumb-item"><i class="feather-chevron-right"></i></li>
                        <li class="breadcrumb-item"><a href="{{route('admin.leave')}}">Leave</a></li>
                        <li class="breadcrumb-item"><i class="feather-chevron-right"></i></li>
                        <li class="breadcrumb-item active">Edit Leave</li>
                    </ul>
                </div>
            </div>
        </div>

        <div class="row">
            <div class="col-sm-12">
                <div class="card">
                    <div class="card-body">
                        <!-- <form method="post" action="{{ route('admin.save-user') }}"> -->
                        <form id="add_user" action="{{ route('admin.update-leave') }}">
                            @csrf
                            <div class="row">
                                <div class="col-12">
                                    <div class="form-heading">
                                        <h4>Edit Leave</h4>
                                    </div>
                                </div>
                                <div class="col-12 col-md-6 col-xl-12">
                                    <div class="form-group local-forms">
                                        <label>Provider </label>
                                        <select class="form-control therapist" name="therapist_id" required>
                                            <option value="">--Select Therapist--</option>
                                            @foreach(App\Models\Therapist::get() as $item)
                                            <option value="{{$item->id}}" {{ $item->id == $data->therapist_id ? "selected" : "" }}>{{$item->prefix}}.{{$item->full_name}}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                </div>

                                <div class="col-12 col-md-6 col-xl-6">
                                    <div class="form-group local-forms">
                                        <label>Leave from </label>
                                        <input type="hidden" name="id" value="{{$data->id}}">
                                        <input class="form-control" value="{{$data->leave_from}}" name="leave_from" required type="date">
                                    </div>
                                </div>
                                <div class="col-12 col-md-6 col-xl-6">
                                    <div class="form-group local-forms">
                                        <label>Leave to </label>
                                        <input class="form-control" name="leave_to" value="{{$data->leave_to}}" required type="date">
                                    </div>
                                </div>




                                <div class="col-12 col-md-12 col-xl-12">
                                    <div class="form-group local-forms">
                                        <label>Reason <span class="login-danger"></span></label>
                                        <textarea class="form-control" name="reason">{{$data->reason}}</textarea>
                                    </div>
                                </div>

                                <div class="col-12">
                                    <div class="doctor-submit text-end">
                                        <button type="submit" class="btn btn-primary submit-form me-2">Submit</button>
                                        <button type="submit" class="btn btn-primary cancel-form">Cancel</button>
                                    </div>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <script>
        $('#add_user').submit(function(e) {
            e.preventDefault();
            var url = $(this).attr("action");
            let formData = new FormData(this);
            $("#js-loader").fadeIn();
            $.ajax({
                type: 'POST',
                url: url,
                data: formData,
                contentType: false,
                processData: false,
                success: function(result) {
                    $("#js-loader").fadeOut();
                    if (result.status == true) {
                        toastr.success(result.data);
                    } else if (result.status == false) {
                        toastr.error(result.data);
                    }
                },
                error: function(err) {
                    // Your Error Message
                    toastr.error(err.data);
                }
            });
        });
    </script>
    @endsection