@extends('admin.layout.dashboard-template')
@section('content')

<style>
    .table-wrapper {
        /* background: #fff;
        box-shadow: 0 0 50px rgba(62, 105, 9, 0.75);
        left: 50%;
        position: absolute;
        top: 50%;
        transform: translate(-50%, -50%); */
    }

    .table-wrapper>table {
        border-spacing: 0;
        overflow: hidden;
        width: 100%;
    }

    .table-wrapper>table th {
        border-bottom: 1px solid #FBD500;
        font-weight: 700;
        padding: 13px 20px;
        text-align: left;
        text-transform: uppercase;
    }

    .table-wrapper>table>thead {
        background: #efeff2;
    }

    .table-wrapper>table tr.default {
        cursor: pointer;
        transition: all 0.2s ease;
    }

    .table-wrapper>table tr.default td {
        border-bottom: 1px solid #eef9e2;
        padding: 10px 20px;
    }

    .table-wrapper>table tr.toggle-row td {
        padding: 20px 15px;
    }

    .table-wrapper>table tr.default:hover {
        background: #f0f9e5;
    }

    .table-wrapper>table tr.active {
        background: #edf8e1;
    }

    .serial-num {
        color: rgba(51, 51, 51, 0.4);
        font-size: 16px;
    }

    .arrow {
        border-bottom: 2px solid #333;
        border-right: 2px solid #333;
        cursor: pointer;
        float: right;
        height: 8px;
        margin: 0 auto;
        text-indent: -9999px;
        transform: rotate(45deg);
        -webkit-transform: rotate(45deg);
        width: 8px;
    }

    .active .arrow {
        transform: rotate(225deg);
    }

    .sub-table-wrap {
        display: none;
        background: #fff;
    }

    .full-sub-table {
        background: #f9fdf5;
        padding: 24px 14px;
    }

    .full-sub-table .info-wrapper {
        display: inline-block;
        margin: 0;
        width: 24%;
    }

    .full-sub-table .info-wrapper dt {
        color: rgba(51, 51, 51, 0.7);
    }

    .full-sub-table .info-wrapper dd {
        margin: 0;
    }

    .slot-btn {

        margin-bottom: 15px;

    }
</style>
<div class="page-wrapper">
    <div class="content">

        <div class="page-header">
            <div class="row">
                <div class="col-sm-12">
                    <ul class="breadcrumb">
                        <li class="breadcrumb-item"><a href="{{route('admin.dashboard')}}">Home</a></li>
                        <li class="breadcrumb-item"><i class="feather-chevron-right"></i></li>
                        <li class="breadcrumb-item"><a href="{{route('admin.slots')}}">Slot</a></li>
                    </ul>
                </div>
            </div>
        </div>

        <div class="row">
            <div class="col-sm-12">
                <div class="card">
                    <div class="card-header text-center">
                        <h3 class="card-title mb-0">Slot</h3>
                    </div>
                    <div class="card-body">
                        <div class="row">
                            <div class="col-12 col-md-12 col-lg-12 col-xl-12">
                                <div class="card">
                                    <div class="card-body" style="position: relative;">
                                        <div class="about-me-list">
                                            <ul class="list-space">
                                                <li>

                                                    <h4>Provider Category</h4>
                                                    <span>:</span>
                                                    <span>{{$data->therapist->full_name}}</span>
                                                </li>
                                                <li>
                                                    <h4>Break Time</h4>
                                                    <span>:</span>
                                                    <span>{{$data->break_duration}} Minutes</span>
                                                </li>
                                                <li>
                                                    <h4>Call duration</h4>
                                                    <span>:</span>
                                                    <span>{{$data->call_duration}} Minutes</span>
                                                </li>
                                            </ul>

                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-12">
                                <div class="card">
                                    <div class="card-header text-center">
                                        <h4 class="card-title mb-0">Slot Managment</h4>
                                    </div>
                                    <div class="card-body">
                                        <div class="table-responsive">
                                            <div class="table-wrapper">
                                                <table>
                                                    <tbody>

                                                        @foreach(days() as $day)
                                                        <tr class="default text-center">
                                                            <th style=" background: #dee0f0;">{{$day}}</th>
                                                        </tr>
                                                        @php
                                                        $flag=0;
                                                        foreach($data->workingHours as $key=>$item){
                                                        if($day==$item->day){
                                                        $flag++;
                                                        }
                                                        }

                                                        @endphp
                                                        @if($flag==0)
                                                        <tr class="text-center">
                                                            <td>Unavailable</td>
                                                        </tr>
                                                        @else
                                                        <tr>
                                                            <td>
                                                                <table class="table">
                                                                    <thead>
                                                                        <tr>

                                                                            <th>Start Time</th>
                                                                            <th>End Time</th>
                                                                            <th>Slots</th>
                                                                        </tr>
                                                                    </thead>
                                                                    <tbody>

                                                                        @foreach($data->workingHours as $key=>$item)
                                                                        @if($day==$item->day)
                                                                        <tr class="default">

                                                                            <td>
                                                                                <span>{{$item->start_time}}</span>
                                                                            </td>
                                                                            <td>
                                                                                <span>{{ $item->end_time}}</span>
                                                                            </td>
                                                                            <td>View Slots<span class="arrow">View Slots</span></td>
                                                                        </tr>

                                                                        <tr class="toggle-row">
                                                                            <td colspan="6">
                                                                                <div class="sub-table-wrap">
                                                                                    <div class="full-sub-table">
                                                                                        <table class="table">
                                                                                            <thead>
                                                                                                <tr>
                                                                                                    <th>CALL METHOD</th>
                                                                                                    <th>SLOTS</th>
                                                                                                </tr>
                                                                                            </thead>
                                                                                            <tbody>
                                                                                                @foreach($item->slotShedule as $s)
                                                                                                <tr>
                                                                                                    <td>{{$s->callMethod->name}}</td>
                                                                                                    <td>
                                                                                                        @php
                                                                                                        $i=0;
                                                                                                        @endphp
                                                                                                        @foreach(json_decode($s->slots) as $x)

                                                                                                        <button class="custom-badge status-green slot-btn">{{$x}}</button>

                                                                                                        @endforeach
                                                                                                    </td>
                                                                                                </tr>

                                                                                                @endforeach
                                                                                            </tbody>
                                                                                        </table>

                                                                                    </div>
                                                                                </div>
                                                                            </td>
                                                                        </tr>
                                                                        @else
                                                                        @continue
                                                                        @endif
                                                                        @endforeach
                                                                    </tbody>
                                                                </table>
                                                            </td>
                                                        </tr>

                                                        @endif
                                                        @endforeach
                                                    </tbody>
                                                </table>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>

                        </div>
                    </div>
                </div>

            </div>
        </div>

    </div>
</div>
</div>
</div>
</div>
<script>
    $(document).ready(function($) {
        $('.default').click(function() {
            $('.default').not($(this)).removeClass('active');
            $(this).toggleClass('active').next().find('.sub-table-wrap').slideToggle();
            $(".toggle-row").not($(this).next()).find('.sub-table-wrap').slideUp('fast');
        });
    });
</script>

@endsection