@extends('admin.layout.dashboard-template')
@section('content')
<style>
    .more {
        display: none;
    }

    .blog {
        border: 1px solid #eee;
        -webkit-box-shadow: 10px 13px 4px -4px rgba(230, 223, 230, 1);
        -moz-box-shadow: 10px 13px 4px -4px rgba(230, 223, 230, 1);
        box-shadow: 10px 13px 4px -4px rgba(230, 223, 230, 1);
    }
</style>
<div class="page-wrapper">
    <div class="content">

        <div class="page-header">
            <div class="row">
                <div class="col-sm-12">
                    <ul class="breadcrumb">
                        <li class="breadcrumb-item"><a href="{{route('admin.dashboard')}}">Home</a></li>
                        <li class="breadcrumb-item"><i class="feather-chevron-right"></i></li>
                        <li class="breadcrumb-item"><a href="{{route('admin.services')}}">Service</a></li>
                        <li class="breadcrumb-item"><i class="feather-chevron-right"></i></li>
                        <li class="breadcrumb-item active">{{$data->service_name}}</li>
                    </ul>
                </div>
            </div>
        </div>

        <div class="row">
            <div class="col-sm-12">
                <div class="card">
                    <div class="card-header text-center">
                        <h3 class="card-title mb-0">{{$data->service_name}}</h3>
                    </div>
                    <div class="card-body">
                        <div class="row">
                            <div class="col-12 col-md-12 col-lg-6 col-xl-8">
                                <div class="card">
                                    <div class="card-body" style="position: relative;">
                                        <div class="about-me-list">
                                            <ul class="list-space">
                                                <li>
                                                    <h4>Service Name</h4>
                                                    <span>:</span>
                                                    <span>{{$data->service_name}}</span>
                                                </li>
                                                <!-- <li>
                                                    <h4>Duration</h4>
                                                    <span>:</span>
                                                    <span>{{$data->duration}}</span>
                                                </li> -->

                                                <li>
                                                    <h4>Description</h4>
                                                    <span>:</span>
                                                </li>
                                            </ul>

                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-12 col-md-12 col-lg-6 col-xl-4 d-flex">
                                <div class="card">
                                    <div class="card-body" style="position: relative;">
                                        <img width="200" height="150" src="{{asset('assets/uploads/service/' . $data->image)}}" class="m-r-5" alt="">
                                    </div>
                                </div>
                            </div>
                            <div class="col-12">
                                <div class="card">
                                    <div class="card-body">
                                        <div class="less">
                                            <p class="text-justify">
                                                {{ Str::limit((strip_tags($data->description)), 200, '...') }}

                                                <button class="btn btn-primary btn-small myBtn" data-value="more">Read More</button>
                                            </p>
                                        </div>

                                        <div class="more">
                                            <p class=" text-justify">
                                                {!! $data->description !!}

                                                <button class="btn btn-primary btn-small myBtn" data-value="less">Read Less</button>
                                            </p>
                                        </div>

                                    </div>
                                </div>
                            </div>

                            <div class="col-12">
                                <div class="card">
                                    <div class="card-header text-center">
                                        <h4 class="card-title mb-0">Service Fee Structure</h4>
                                    </div>
                                    <div class="card-body">
                                        <div class="table-responsive">
                                            <table class="table table-hover border-0 custom-table invoice-table">
                                                <thead>
                                                    <tr>
                                                        <th>#</th>
                                                        <th>Provider Category</th>
                                                        <th>Call Method</th>
                                                        <th>Duration</th>
                                                        <th>Rate</th>
                                                        <th>Add Package</th>
                                                    </tr>
                                                </thead>
                                                <tbody>
                                                    @foreach($data->serviceFeeStructure as $key=>$item)
                                                    <tr>
                                                        <td>{{$key+1}}</td>
                                                        <td>{{$item->providerCategory->name}}</td>
                                                        <td>{{$item->callMethod->name}}</td>
                                                        <td>{{$item->duration}}</td>
                                                        <td>₹{{$item->rate}}</td>
                                                        <td> @if($item->call_method_id==1)
                                                            <a href=" javascript:void(0);" data-bs-toggle="modal" data-id="{{$item->id}}" data-bs-target="#add-package" class=" btn btn-primary ms-2 addpackage"> <i class="far fa-add"></i> </a>
                                                            @else
                                                            <a href=" javascript:void(0);" class=" btn">-- </a>
                                                            @endif
                                                        </td>
                                                    </tr>

                                                    <div id="add-package" class="modal fade delete-modal" role="dialog">
                                                        <div class="modal-dialog modal-dialog-centered modal-lg">
                                                            <div class="modal-content">
                                                                <div class="modal-body text-center">
                                                                    <div class="col-12">
                                                                        <div class="form-heading">
                                                                            <h4>ADD PACKAGE</h4>
                                                                        </div>
                                                                    </div>
                                                                    <!-- <form method="POST" action="{{ route('admin.save-package') }}"> -->
                                                                    <form id="add_package" action="{{ route('admin.save-package') }}">
                                                                        @csrf
                                                                        <div class="row">
                                                                            <div class="col-12 col-md-12 col-xl-6">
                                                                                <div class="form-group local-forms">
                                                                                    <label>Service <span class="login-danger">*</span></label>
                                                                                    <input class="form-control" name="service_fee_id" id="sf_id" type="hidden">
                                                                                    <input class="form-control" name="service" value="{{$data->id}}" type="hidden">
                                                                                    <input class="form-control" value="{{$data->service_name}}" type="text">
                                                                                </div>
                                                                            </div>
                                                                            <!-- <div class="col-12 col-md-12 col-xl-6">
                                                                                <div class="form-group local-forms">
                                                                                    <label>Provider Category <span class="login-danger">*</span></label>
                                                                                    <input class="form-control" value="{{$item->providerCategory->id}}" name="provider_category_id" type="hidden">
                                                                                    <input class="form-control" value="{{$item->providerCategory->name}}" type="text">
                                                                                </div>
                                                                            </div> -->
                                                                            <div class="col-12 col-md-12 col-xl-6">
                                                                                <div class="form-group local-forms">
                                                                                    <label>Package Name <span class="login-danger">*</span></label>
                                                                                    <input class="form-control" required name="title" type="text">
                                                                                </div>
                                                                            </div>
                                                                            <div class="col-12 col-md-12 col-xl-6">
                                                                                <div class="form-group local-forms">
                                                                                    <label>Number of Sessions <span class="login-danger">*</span></label>
                                                                                    <input class="form-control" required name="no_of_sessions" type="text">
                                                                                </div>
                                                                            </div>
                                                                            <div class="col-12 col-md-12 col-xl-6">
                                                                                <div class="form-group local-forms">
                                                                                    <label>Duration <span class="login-danger">*</span></label>
                                                                                    <input class="form-control" required name="duration" type="text">
                                                                                </div>
                                                                            </div>

                                                                            <div class="col-12 col-md-6 col-xl-6">
                                                                                <div class="form-group local-forms">
                                                                                    <label>Discount <span class="login-danger">*</span></label>
                                                                                    <input class="form-control" required name="discount" type="text" placeholder="">
                                                                                </div>
                                                                            </div>
                                                                            <div class="col-12 col-md-6 col-xl-6">
                                                                                <div class="form-group local-top-form">
                                                                                    <label class="local-top">Image <span class="login-danger">*</span></label>
                                                                                    <div class="settings-btn upload-files-avator">
                                                                                        <input type="file" accept="image/*" required name="image" id="file" onchange="loadFile(event)" class="hide-input">
                                                                                        <label for="file" class="upload">Choose File</label>
                                                                                    </div>
                                                                                </div>
                                                                            </div>

                                                                            <div class="col-12 col-md-6 col-xl-6">
                                                                                <div class="form-group local-forms cal-icon">
                                                                                    <label>Start Date <span class="login-danger">*</span></label>
                                                                                    <input class="form-control datetimepicker" required name="start_date" type="text">
                                                                                </div>
                                                                            </div>
                                                                            <div class="col-12 col-md-6 col-xl-6">
                                                                                <div class="form-group local-forms cal-icon">
                                                                                    <label>End Date <span class="login-danger">*</span></label>
                                                                                    <input class="form-control datetimepicker" required name="end_date" type="text">
                                                                                </div>
                                                                            </div>
                                                                            <div class="col-12 col-md-6 col-xl-6">
                                                                                <div class="form-group local-forms">
                                                                                    <label>Start Time <span class="login-danger">*</span></label>
                                                                                    <div class="time-icon">
                                                                                        <input type="text" class="form-control" name="start_time" id="datetimepicker3">
                                                                                    </div>
                                                                                </div>
                                                                            </div>
                                                                            <div class="col-12 col-md-6 col-xl-6">
                                                                                <div class="form-group local-forms">
                                                                                    <label>End Time <span class="login-danger">*</span></label>
                                                                                    <div class="time-icon">
                                                                                        <input type="text" class="form-control" name="end_time" id="datetimepicker4">
                                                                                    </div>
                                                                                </div>
                                                                            </div>
                                                                            <div class="col-12 col-sm-12">
                                                                                <div class="form-group local-forms">
                                                                                    <label>Notes <span class="login-danger">*</span></label>
                                                                                    <textarea class="form-control" name="note" rows="3" cols="30"></textarea>
                                                                                </div>
                                                                            </div>
                                                                        </div>
                                                                        <div class="m-t-20"> <a href="#" class="btn btn-white" data-bs-dismiss="modal">Close</a>
                                                                            <button type="submit" class="btn btn-success ">Add Package</button>
                                                                        </div>
                                                                    </form>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    @endforeach
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>

                        </div>
                    </div>
                </div>

                @if(count($data->package)>0)
                <div class="card card-table show-entire">
                    <div class="card-header">
                        <h3>Packages</h3>
                    </div>
                    <div class="card-body">
                        <div class="page-table-header mb-2">
                            <div class="row align-items-center">
                                <div class="col">

                                    <div class="row">

                                        @foreach($data->package as $item)

                                        <div class="col-sm-6 col-md-6 col-xl-4">
                                            <div class="blog grid-blog">
                                                <div class="blog-image">
                                                    <a href="#"><img class="img-fluid" src="{{asset('assets/uploads/package/'.$item->image)}}" alt=""></a>
                                                    <div class="blog-views">
                                                        <h5><i class="fa-solid fa-inr m-r-5"></i>{{$item->discount}}%</h5>
                                                    </div>
                                                    <ul class="nav view-blog-list blog-views">
                                                        <li> <a class="dropdown-item" href="#"><i class="fa-solid fa-pen-to-square m-r-5"></i>Edit</a></li>

                                                    </ul>
                                                </div>


                                                <div class="blog-content">
                                                    <div class="blog-grp-blk">
                                                        <div class="blog-img-blk">
                                                            <span><i class="feather-clock me-1"></i>{{$item->duration}}</span>
                                                        </div>

                                                        <span><i class="feather-video me-1"></i>{{$item->no_of_sessions}}</span>
                                                    </div>
                                                    <h3 class="blog-title"><a href="view-package.php">{{$item->title}}</a></h3>

                                                    <p>
                                                        {{ Str::limit((strip_tags($item->description)), 100, '...') }}
                                                    </p>
                                                    <div class="row">
                                                        <div class=" col-12 col-md-6 col-xl-6">
                                                            <a href="#" class="read-more d-flex"> Read more<i class="fa fa-long-arrow-right ms-2"></i></a>
                                                        </div>
                                                        <div class="col-12 col-md-6 col-xl-6 right-action">
                                                            <a href="javascript:;" class="status-gray "><i class="fa-solid fa-trash m-r-5"></i></a>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        @endforeach

                                    </div>
                                </div>
                            </div>

                        </div>
                    </div>
                </div>
                @endif
            </div>
        </div>
        <div class="card card-table show-entire">
            <div class="card-body">

                <div class="page-table-header mb-2">
                    <div class="row align-items-center">
                        <div class="col">
                            <div class="doctor-table-blk">
                                <h3>{{$data->service_name}} Appoinments</h3>
                                <div class="doctor-search-blk">
                                    <div class="top-nav-search table-search-blk">
                                        <form>
                                            <input type="text" class="form-control" placeholder="Search here">
                                            <a class="btn"><img src="assets/img/icons/search-normal.svg" alt></a>
                                        </form>
                                    </div>
                                    <div class="add-group">
                                        <a href="add-appointment.php" class="btn btn-primary add-pluss ms-2"><img src="assets/img/icons/plus.svg" alt></a>
                                        <a href="javascript:;" class="btn btn-primary doctor-refresh ms-2"><img src="assets/img/icons/re-fresh.svg" alt></a>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-auto text-end float-end ms-auto download-grp">
                            <a href="javascript:;" class=" me-2"><img src="assets/img/icons/pdf-icon-01.svg" alt></a>
                            <a href="javascript:;" class=" me-2"><img src="assets/img/icons/pdf-icon-02.svg" alt></a>
                            <a href="javascript:;" class=" me-2"><img src="assets/img/icons/pdf-icon-03.svg" alt></a>
                            <a href="javascript:;"><img src="assets/img/icons/pdf-icon-04.svg" alt></a>
                        </div>
                    </div>
                </div>


                <div class="table-responsive">
                    <table class="table border-0 custom-table comman-table datatable mb-0">
                        <thead>
                            <tr>
                                <th>
                                    <div class="form-check check-tables">
                                        <input class="form-check-input" type="checkbox" value="something">
                                    </div>
                                </th>
                                <th>Name</th>
                                <th>Consulting Doctor</th>
                                <th>Charge</th>
                                <th>Mobile</th>
                                <th>Status</th>
                                <th>Date</th>
                                <th>Time</th>
                                <th></th>
                            </tr>
                        </thead>
                        <tbody></tbody>
                    </table>
                </div>


            </div>
        </div>
    </div>
</div>
</div>
</div>
</div>

<script type="text/javascript">
    // $(window).on("load", function() {
    //     $(".more").css("display", "none");
    // });
    $('body').on('click', '.myBtn', function(e) {
        var value = $(this).data("value");

        if (value == 'more') {
            $(".more").css("display", "block");
            $(".less").css("display", "none");
            $('.more').show('slow');
            // $('.less').hide('slow');

        }
        if (value == 'less') {
            $('.more').hide('slow');
            $(".more").css("display", "none");
            $('.less').show('slow');
        }
    });

    $('body').on('click', '.addpackage', function(e) {
        var value = $(this).data("id");
        $("#sf_id").val(value);
    });

    $('#add_package').submit(function(e) {
        e.preventDefault();
        var url = $(this).attr("action");
        let formData = new FormData(this);
        $("#js-loader").fadeIn();
        $.ajax({
            type: 'POST',
            url: url,
            data: formData,
            contentType: false,
            processData: false,
            success: function(data) {
                $("#js-loader").fadeOut();
                if (data == true) {
                    toastr.success('Package Added Successfully');
                } else {
                    toastr.error(data);
                }
            },
            error: function(err) {
                // Your Error Message
                toastr.error(err);
            }
        });
    });
</script>
@endsection