@extends('admin.layout.dashboard-template')
@section('content')
<style>
    @media (min-width: 730px) {
        .daterangepicker.ltr .ranges {
            float: right !important;
        }
    }
</style>
<div class="page-wrapper">
    <div class="content">

        <div class="page-header">
            <div class="row">
                <div class="col-sm-12">
                    <ul class="breadcrumb">
                        <!-- <li class="breadcrumb-item"><a href="admin-users.php">Service </a></li>
                        <li class="breadcrumb-item"><i class="feather-chevron-right"></i></li> -->
                        <li class="breadcrumb-item active">Wallet Report</li>
                    </ul>
                </div>
            </div>
        </div>

        <div class="row">
            <div class="col-sm-12">
                <div class="card card-table show-entire">
                    <div class="card-body">
                        <div class="page-table-header mb-5">
                            <div class="row align-items-center">
                                <div class="col">
                                    <div class="doctor-table-blk">
                                        <h3>Wallet Report</h3><br>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="row align-items-center">

                            <div>

                                <div class="table-responsive">
                                    <table class="table border-0 custom-table comman-table mb-0" id="therapist_table">
                                        <thead>
                                            <tr>
                                                <th>User ID</th>
                                                <th>Wallet Current Balance</th>
                                                <th>Total Debit Amount(Inr)</th>
                                                <th>Total Credit Amount(Inr)</th>
                                        </thead>
                                        <tbody>

                                        </tbody>
                                        <tfoot>
                                            <tr>
                                                <th></th>
                                                <th></th>
                                                <th></th>
                                                <th></th>
                                            </tr>
                                        </tfoot>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>


            <script type="text/javascript" src="//cdn.jsdelivr.net/jquery/1/jquery.min.js"></script>
            <script type="text/javascript" src="//cdn.jsdelivr.net/momentjs/latest/moment.min.js"></script>
            <!-- <link rel="stylesheet" type="text/css" href="//cdn.jsdelivr.net/bootstrap/3/css/bootstrap.css" /> -->

            <script type="text/javascript" src="//cdn.jsdelivr.net/bootstrap.daterangepicker/2/daterangepicker.js"></script>
            <link rel="stylesheet" type="text/css" href="//cdn.jsdelivr.net/bootstrap.daterangepicker/2/daterangepicker.css" />
            <script type="text/javascript" src="https://www.gstatic.com/charts/loader.js"></script>
            <script type="text/javascript">
                $(function() {
                    var table = $('#therapist_table').DataTable({
                        "footerCallback": function(row, data, start, end, display) {
                            var api = this.api(),
                                data;

                            // converting to interger to find total
                            var intVal = function(i) {
                                return typeof i === 'string' ?
                                    i.replace(/[\$,]/g, '') * 1 :
                                    typeof i === 'number' ?
                                    i : 0;
                            };

                            var thuTotal = api
                                .column(1)
                                .data()
                                .reduce(function(a, b) {
                                    return intVal(a) + intVal(b);
                                }, 0);

                            var friTotal = api
                                .column(2)
                                .data()
                                .reduce(function(a, b) {
                                    return intVal(a) + intVal(b);
                                }, 0);

                            var sTotal = api
                                .column(3)
                                .data()
                                .reduce(function(a, b) {
                                    return intVal(a) + intVal(b);
                                }, 0);
                            // Update footer by showing the total with the reference of the column index 

                            $(api.column(0).footer()).html('Total');
                            $(api.column(1).footer()).html(thuTotal);
                            $(api.column(2).footer()).html(friTotal);
                            $(api.column(3).footer()).html(sTotal);
                        },
                        processing: true,
                        serverSide: true,
                        dom: "<'row'<'col-sm-4'l><'col-sm-4'f><'col-sm-4'B>>" +
                            "<'row'<'col-sm-12'tr>>" +
                            "<'row'<'col-sm-5'i><'col-sm-7'p>>",

                        //    ajax: "{{ route('admin.get-consulation-report') }}",
                        ajax: {
                            url: "{{ route('admin.get-wallet-report') }}",

                        },
                        columns: [{
                                data: 'user',
                                name: 'user'
                            },
                            {
                                data: 'wallet_balance',
                                name: 'wallet_balance'
                            },
                            {
                                data: 'total_debit_amount',
                                name: 'total_debit_amount'
                            },
                            {
                                data: 'total_credit_amount',
                                name: 'total_credit_amount'
                            },

                        ],
                        "select": {
                            'style': 'multi',
                            'selector': 'td:first-child' //only checkbox can select row
                        },
                        buttons: [{
                                extend: 'copyHtml5',
                                footer: true
                            },
                            {
                                extend: 'excelHtml5',
                                footer: true
                            },
                            {
                                extend: 'csvHtml5',
                                footer: true
                            },
                            {
                                extend: 'pdfHtml5',
                                footer: true
                            },
                            {
                                extend: 'print',
                                footer: true
                            }
                        ]
                    });
                    $(".filter").click(function() {

                        table.draw();
                    });
                });
            </script>
            @endsection