@extends('admin.layout.dashboard-template')
@section('content')
<style>
    @media (min-width: 730px) {
        .daterangepicker.ltr .ranges {
            float: right !important;
        }
    }
</style>
<div class="page-wrapper">
    <div class="content">

        <div class="page-header">
            <div class="row">
                <div class="col-sm-12">
                    <ul class="breadcrumb">
                        <!-- <li class="breadcrumb-item"><a href="admin-users.php">Service </a></li>
                        <li class="breadcrumb-item"><i class="feather-chevron-right"></i></li> -->
                        <li class="breadcrumb-item active">Patient Report</li>
                    </ul>
                </div>
            </div>
        </div>

        <div class="row">
            <div class="col-sm-12">
                <div class="card card-table show-entire">
                    <div class="card-body">
                        <!-- <div class="page-table-header mb-5">
                            <div class="row align-items-center">
                                <div class="col">
                                    <div class="doctor-table-blk">
                                        <h3>Patient Report</h3><br>
                                    </div>
                                   
                                    <div class="col-md-5 offset-md-6 form-group mb-0" style="float:right;margin-right: 24px;">
                                        <label>Filter Graph by Date</label>
                                        <input type="text" class="form-control" id="reportrange">
                                    </div>
                                    <div id="barchart_material" class=" row mb-5 p-4" style="width: 100%; height: 500px;"></div>
                                  
                                </div>

                            </div>
                        </div> -->
                        <div class="row align-items-center">

                            <div>
                                <div class=" row mb-5 p-2">
                                    <div class="col-12 col-md-6 col-xl-2">
                                        <div class="form-group local-forms">
                                            <label>From </label>
                                            <input class="form-control" value="{{ old('date', date('Y-m-01')) }}" type="date" required name="from" placeholder>
                                        </div>
                                    </div>
                                    <div class="col-12 col-md-6 col-xl-2">
                                        <div class="form-group local-forms">
                                            <label>To</label>
                                            <input class="form-control" type="date" required name="to" placeholder value="{{ old('date', date('Y-m-d')) }}">
                                        </div>
                                    </div>



                                    <div class="col-12 col-md-6 col-xl-4">
                                        <div class="form-group local-forms">
                                            <!-- <button class="btn btn-success submit-form ">Filter</button> -->
                                            <button class="btn btn-success filter" style="width:100%;">Filter</button>
                                        </div>
                                    </div>

                                </div>


                                <div class="table-responsive">
                                    <table class="table border-0 custom-table comman-table mb-0" id="therapist_table">
                                        <thead>
                                            <tr>
                                                <th>PID</th>
                                                <th>Patient<br> Name</th>
                                                <th>Phone</th>
                                                <th>Registration <br>Date</th>
                                                <th>Date of birth</th>
                                                <th>No:of Appointments</th>
                                                <th>Total Amount Paid</th>
                                            </tr>
                                        </thead>
                                        <tbody>

                                        </tbody>

                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div id="delete_patient" class="modal fade delete-modal" role="dialog">
                <div class="modal-dialog modal-dialog-centered">
                    <div class="modal-content">
                        <div class="modal-body text-center">
                            <img src="assets/img/sent.png" alt width="50" height="46">
                            <h3>Are you sure want to delete this ?</h3>
                            <div class="m-t-20"> <a href="#" class="btn btn-white" data-bs-dismiss="modal">Close</a>
                                <button type="submit" class="btn btn-danger" id="delete_item">Delete</button>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <script type="text/javascript" src="//cdn.jsdelivr.net/jquery/1/jquery.min.js"></script>
            <script type="text/javascript" src="//cdn.jsdelivr.net/momentjs/latest/moment.min.js"></script>
            <!-- <link rel="stylesheet" type="text/css" href="//cdn.jsdelivr.net/bootstrap/3/css/bootstrap.css" /> -->

            <script type="text/javascript" src="//cdn.jsdelivr.net/bootstrap.daterangepicker/2/daterangepicker.js"></script>
            <link rel="stylesheet" type="text/css" href="//cdn.jsdelivr.net/bootstrap.daterangepicker/2/daterangepicker.css" />
            <script type="text/javascript" src="https://www.gstatic.com/charts/loader.js"></script>
            <script type="text/javascript">
                $(function() {


                    var table = $('#therapist_table').DataTable({
                        processing: true,
                        serverSide: true,
                        dom: "<'row'<'col-sm-4'l><'col-sm-4'f><'col-sm-4'B>>" +
                            "<'row'<'col-sm-12'tr>>" +
                            "<'row'<'col-sm-5'i><'col-sm-7'p>>",

                        ajax: {
                            url: "{{ route('admin.get-patient-report') }}",
                            data: function(d) {
                                d.from = $('input[name="from"]').val();
                                d.to = $('input[name="to"]').val();

                            }
                        },
                        columns: [{
                                data: 'patient',
                                name: 'patient'
                            },
                            {
                                data: 'patient_name',
                                name: 'patient_name'
                            },
                            {
                                data: 'phone',
                                name: 'phone'
                            },
                            {
                                data: 'reg_date',
                                name: 'reg_date'
                            },
                            {
                                data: 'dob',
                                name: 'dob'
                            },
                            {
                                data: 'appointments',
                                name: 'appointments'
                            },
                            {
                                data: 'amount',
                                name: 'amount'
                            },
                        ],
                        "select": {
                            'style': 'multi',
                            'selector': 'td:first-child' //only checkbox can select row
                        },
                        buttons: [{
                                extend: 'copyHtml5',
                                footer: true
                            },
                            {
                                extend: 'excelHtml5',
                                footer: true
                            },
                            {
                                extend: 'csvHtml5',
                                footer: true
                            },
                            {
                                extend: 'pdfHtml5',
                                footer: true
                            },
                            {
                                extend: 'print',
                                footer: true
                            }
                        ]
                    });
                    $(".filter").click(function() {

                        table.draw();
                    });
                });
            </script>
            @endsection