@extends('admin.layout.dashboard-template')
@section('content')
<div class="page-wrapper">
    <div class="content">

        <div class="page-header">
            <div class="row">
                <div class="col-sm-12">
                    <ul class="breadcrumb">
                        <li class="breadcrumb-item"><a href="{{route('admin.dashboard')}}">Home</a></li>
                        <li class="breadcrumb-item"><i class="feather-chevron-right"></i></li>
                        <li class="breadcrumb-item"><a href="{{route('admin.podcasts')}}">Podcasts</a></li>
                        <li class="breadcrumb-item"><i class="feather-chevron-right"></i></li>
                        <li class="breadcrumb-item active">Edit Podcast</li>
                    </ul>
                </div>
            </div>
        </div>

        <div class="row">
            <div class="col-sm-12">
                <div class="card">
                    <div class="card-body">
                        <!-- <form method="post" action="{{ route('admin.update-podcast') }}"> -->
                        <form id="edit_podcast" action="{{ route('admin.update-podcast') }}">
                            @csrf


                            <div class="row">
                                <div class="col-12">
                                    <div class="form-heading">
                                        <h4>Podcast Details</h4>
                                    </div>
                                </div>
                                <div class="col-12 col-md-6 col-xl-6">
                                    <div class="form-group local-forms">
                                        <label>Podcast Title <span class="login-danger">*</span></label>
                                        <input class="form-control" name="title" value="{{$data->title}}" type="text" placeholder>
                                        <input type="hidden" name="id" value="{{$data->id}}">
                                    </div>
                                </div>
                                <div class="col-12 col-md-6 col-xl-3">
                                    <div class="form-group select-gender">
                                        <label class="gen-label">Select Author<span class="login-danger">*</span></label>
                                        <div class="form-check-inline">
                                            <label class="form-check-label">
                                                <input type="radio" name="author" checked value="F" class="form-check-input fenny_radio" {{ $data->author == 'F' ? 'checked' : ''}}>Fenny
                                            </label>
                                        </div>
                                        <div class="form-check-inline">
                                            <label class="form-check-label">
                                                <input type="radio" name="author" value="T" class="form-check-input therapist_radio" {{ $data->author == 'T' ? 'checked' : ''}}>Therapist
                                            </label>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-12 col-md-6 col-xl-3">
                                    <div class="form-group local-forms">
                                        <label>Select Therapist</label>
                                        <select class="form-control therapist" name="therapist" disabled>
                                            <option value="">--Select Therapist--</option>
                                            @foreach(App\Models\Therapist::get() as $item)
                                            <option value="{{$item->id}}" {{ $item->id == $data->therapist_id ? 'selected' : '' }}>{{$item->full_name}}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                </div>
                                <div class="col-12 col-md-12 col-xl-12">
                                    <div class="form-group local-forms">
                                        <label>Podcast Sub Title <span class="login-danger">*</span></label>
                                        <textarea class="form-control" name="subtitle">{{$data->sub_title}}</textarea>
                                    </div>
                                </div>
                                <div class="col-12 col-md-6 col-xl-6">
                                    <div class="form-group local-forms">
                                        <label>Audio Duration<span class="login-danger">*</span></label>
                                        <input class="form-control" name="audio_duration" value="{{$data->duration}}" type="text" placeholder>
                                    </div>
                                </div>
                                @php
                                $ids=json_decode($data->tags);

                                @endphp
                                <div class="col-12 col-md-6 col-xl-6">
                                    <div class="form-group local-forms">
                                        <label>Tags <small>(separated with a comma)</small> <span class="login-danger">*</span></label>
                                        <select class="form-control expertise" name="tags[]" multiple="multiple">
                                            @foreach(App\Models\Tags::get() as $item)
                                            @if(empty($ids))
                                            <option value="{{$item->tag}}">{{$item->tag}}</option>
                                            @else
                                            @if(in_array($item->tag, $ids))
                                            <option value="{{$item->tag}}" selected>{{$item->tag}}</option>
                                            @else
                                            <option value="{{$item->tag}}">{{$item->tag}}</option>
                                            @endif
                                            @endif
                                            @endforeach
                                        </select>
                                    </div>
                                </div>

                                <div class="col-12 col-md-6 col-xl-4">
                                    <div class="form-group local-top-form">
                                        <label class="local-top">Podcast Image<span class="login-danger">*</span></label>
                                        <!-- <div class="settings-btn upload-files-avator"> -->
                                        <input type="file" accept="image/*" name="image" id="file" onchange="readURL(this);" class="form-control">
                                        <!-- <label for="file" class="upload">Choose File</label>
                                        </div> -->
                                    </div>
                                </div>

                                <div class="col-12 col-md-6 col-xl-2">
                                    <div class="form-group local-top-form">

                                        @php
                                        if ($data->image != NULL) {
                                        $img = asset('assets/uploads/podcast/' . $data->image);
                                        } else {
                                        $img = asset('assets/img/no-image-available.jpg');
                                        }
                                        @endphp
                                        <img width="80" height="150" src="{{$img}}" class="form-control  preview" alt="">
                                    </div>
                                </div>

                                <div class="col-12 col-md-6 col-xl-3">
                                    <div class="form-group local-top-form">
                                        <label class="local-top">Podcast Audio<span class="login-danger">*</span></label>
                                        <input type="file" class="form-control" onchange="previewFile()" name="file" accept="audio/*"><br>
                                        <audio controls src=""></audio>
                                    </div>
                                </div>


                                <div class="col-12 col-md-6 col-xl-3">
                                    <div class="form-group local-top-form">
                                        <div id="result"></div>
                                    </div>
                                </div>




                                <div class="col-12 col-md-6 col-xl-6">
                                    <div class="form-group local-forms">
                                        <label>Podcast Color <span class="login-danger">*</span></label>
                                        <input class="form-control" name="color" value="{{$data->color}}" type="color" placeholder>
                                    </div>
                                </div>

                                <div class="col-12">
                                    <div class="doctor-submit text-end">
                                        <button type="submit" class="btn btn-primary submit-form me-2">Update Podcast</button>
                                        <button type="submit" class="btn btn-primary cancel-form">Cancel</button>
                                    </div>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <script>
        $(document).ready(function() {
            $(".expertise").select2({
                multiple: true
            });
        });

        $('#edit_podcast').submit(function(e) {
            e.preventDefault();
            var url = $(this).attr("action");
            let formData = new FormData(this);
            $("#js-loader").fadeIn();
            $.ajax({
                type: 'POST',
                url: url,
                data: formData,
                contentType: false,
                processData: false,
                success: function(data) {
                    $("#js-loader").fadeOut();
                    if (data == true) {
                        toastr.success('Podcast Updated Successfully');
                    } else {
                        toastr.error(data);
                    }
                },
                error: function(err) {
                    // Your Error Message
                    toastr.error(err);
                }
            });
        });
        $(document).ready(function() {
            $('.tags').tagsinput({
                maxTags: 2,
            });
        });
        $('body').on('click', '.therapist_radio', function() {
            $('.therapist').prop("disabled", false);
        });
        $('body').on('click', '.fenny_radio', function() {
            $('.therapist').prop("disabled", true);
        });
    </script>
    @endsection