@extends('admin.layout.dashboard-template')
@section('content')
<style>
    .about-me-list ul li h4 {
        min-width: 30%;
    }
</style>
<div class="page-wrapper">
    <div class="content">

        <div class="page-header">
            <div class="row">
                <div class="col-sm-12">
                    <ul class="breadcrumb">
                        <li class="breadcrumb-item"><a href="{{route('admin.dashboard')}}">Home</a></li>
                        <li class="breadcrumb-item"><i class="feather-chevron-right"></i></li>
                        <li class="breadcrumb-item"><a href="{{route('admin.services')}}">Packages</a></li>
                        <li class="breadcrumb-item"><i class="feather-chevron-right"></i></li>
                        <li class="breadcrumb-item active">{{$data->title}}</li>
                    </ul>
                </div>
            </div>
        </div>

        <div class="row">
            <div class="col-sm-12">
                <div class="card">
                    <div class="card-header text-center">
                        <h3 class="card-title mb-0">{{$data->title}}</h3>
                    </div>
                    <div class="card-body">
                        <div class="row">
                            <div class="col-12 col-md-12 col-lg-6 col-xl-8">
                                <div class="card">
                                    <div class="card-body" style="position: relative;">
                                        <div class="about-me-list">
                                            <ul class="list-space">
                                                <li>
                                                    <h4>Service</h4>
                                                    <span>:</span>
                                                    <span>{{$data->service->service_name}}</span>
                                                </li>
                                                <li>
                                                    <table class="table">
                                                        <thead>
                                                            <tr>
                                                                <th>Provider Category</th>
                                                                <th>Communication Methods</th>
                                                                <th>Duration</th>
                                                                <th>Rate</th>
                                                            </tr>
                                                        </thead>
                                                        <tbody>
                                                            @foreach ($fee as $item)
                                                            <tr>
                                                                <td>{{ $item->providerCategory->name }}</td>
                                                                <td>{{ $item->callMethod->name }}</td>
                                                                <td>{{ $item->duration }} Minutes</td>
                                                                <td>₹ {{ $item->rate }}</td>
                                                            </tr>
                                                            @endforeach
                                                        </tbody>
                                                    </table>
                                                </li>
                                                <li>
                                                    <h4>Number of Sessions </h4>
                                                    <span>:</span>
                                                    <span>{{$data->no_of_sessions}}</span>
                                                </li>

                                                <li>
                                                    <h4>Duration</h4>
                                                    <span>:</span>
                                                    <span>{{$data->duration}}</span>
                                                </li>
                                                <li>
                                                    <h4>Discount</h4>
                                                    <span>:</span>
                                                    <span>{{$data->discount}}%</span>
                                                </li>
                                                <li>
                                                    <h4>Start Date </h4>
                                                    <span>:</span>
                                                    <span>{{date("d l Y",strtotime($data->start_date))}}</span>
                                                </li>
                                                <li>
                                                    <h4>End Date </h4>
                                                    <span>:</span>
                                                    <span>{{date("d l Y",strtotime($data->end_date))}}</span>
                                                </li>
                                                <li>
                                                    <h4>Start Time</h4>
                                                    <span>:</span>
                                                    <span>{{$data->start_time}}</span>
                                                </li>
                                                <li>
                                                    <h4>End Time</h4>
                                                    <span>:</span>
                                                    <span>{{$data->end_time}}</span>
                                                </li>
                                                <li>
                                                    <h4>Description</h4>
                                                    <span>:</span>
                                                    <span style="text-align: justify;">{{$data->description}}</span>
                                                </li>
                                            </ul>

                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div class=" col-12 col-md-12 col-lg-6 col-xl-4 d-flex">
                                <div class="card">
                                    <div class="card-body" style="position: relative;">
                                        <img width="200" height="150" src="{{asset('assets/uploads/package/' . $data->image)}}" class="m-r-5" alt="">
                                    </div>
                                </div>
                            </div>



                        </div>
                    </div>
                </div>

            </div>
        </div>
        <div class="card card-table show-entire">
            <div class="card-body">

                <div class="page-table-header mb-2">
                    <div class="row align-items-center">
                        <div class="col">
                            <div class="doctor-table-blk">
                                <h3>{{$data->title}} Appoinments</h3>
                                <div class="doctor-search-blk">
                                    <div class="top-nav-search table-search-blk">
                                        <form>
                                            <input type="text" class="form-control" placeholder="Search here">
                                            <a class="btn"><img src="assets/img/icons/search-normal.svg" alt></a>
                                        </form>
                                    </div>
                                    <div class="add-group">
                                        <a href="add-appointment.php" class="btn btn-primary add-pluss ms-2"><img src="assets/img/icons/plus.svg" alt></a>
                                        <a href="javascript:;" class="btn btn-primary doctor-refresh ms-2"><img src="assets/img/icons/re-fresh.svg" alt></a>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-auto text-end float-end ms-auto download-grp">
                            <a href="javascript:;" class=" me-2"><img src="assets/img/icons/pdf-icon-01.svg" alt></a>
                            <a href="javascript:;" class=" me-2"><img src="assets/img/icons/pdf-icon-02.svg" alt></a>
                            <a href="javascript:;" class=" me-2"><img src="assets/img/icons/pdf-icon-03.svg" alt></a>
                            <a href="javascript:;"><img src="assets/img/icons/pdf-icon-04.svg" alt></a>
                        </div>
                    </div>
                </div>


                <div class="table-responsive">
                    <table class="table border-0 custom-table comman-table datatable mb-0">
                        <thead>
                            <tr>
                                <th>
                                    <div class="form-check check-tables">
                                        <input class="form-check-input" type="checkbox" value="something">
                                    </div>
                                </th>
                                <th>Name</th>
                                <th>Consulting Doctor</th>
                                <th>Charge</th>
                                <th>Mobile</th>
                                <th>Status</th>
                                <th>Date</th>
                                <th>Time</th>
                                <th></th>
                            </tr>
                        </thead>
                        <tbody></tbody>
                    </table>
                </div>


            </div>
        </div>
    </div>
</div>
</div>
</div>
</div>


@endsection