@extends('admin.layout.dashboard-template')
@section('content')
<div class="page-wrapper">
    <div class="content">

        <div class="page-header">
            <div class="row">
                <div class="col-sm-12">
                    <ul class="breadcrumb">
                        <li class="breadcrumb-item active">Thought of the Day</li>
                    </ul>
                </div>
            </div>
        </div>

        <div class="row">
            <div class="col-sm-12">
                <div class="card card-table show-entire">
                    <div class="card-body">

                        <div class="page-table-header mb-2">
                            <div class="row align-items-center">
                                <div class="col">
                                    <div class="doctor-table-blk">
                                        <h3>Thought of the Day</h3>
                                        <div class="doctor-search-blk">
                                            <div class="add-group">
                                                <a href="javascript:void(0);" data-bs-toggle="modal" data-bs-target="#add_blog_category" class="btn btn-primary add-pluss ms-2"><img src="{{asset('assets/img/icons/plus.svg')}}" alt></a>

                                            </div>
                                        </div>
                                    </div>
                                </div>

                            </div>
                        </div>

                        <div class="table-responsive">
                            <table class="table border-0 custom-table comman-table mb-0" id="thoughts_table">
                                <thead>
                                    <tr>
                                        <th>
                                            #
                                        </th>
                                        <th>Day</th>
                                        <th>Image</th>
                                        <th>ACTION</th>
                                    </tr>
                                </thead>
                                <tbody>

                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div id="add_blog_category" class="modal fade" role="dialog">
        <div class="modal-dialog modal-dialog-centered ">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Add Thought of the Day</h5>

                </div>
                <div class="modal-body text-center">
                    <form id="thoughts_form" action="{{ route('admin.save-thoughts') }}">
                        @csrf
                        <div class="row m-t-20">
                            <div class=" col-12 col-md-12 col-xl-12">
                                <div class="form-group local-forms">
                                    <label>Select day <span class="login-danger">*</span></label>
                                    <select class="form-control" required name="day">
                                        <option>--Select a day---</option>
                                        <option value="Sunday">Sunday</option>
                                        <option value="Monday">Monday</option>
                                        <option value="Tuesday">Tuesday</option>
                                        <option value="Wednesday">Wednesday</option>
                                        <option value="Thursday">Thursday</option>
                                        <option value="Friday">Friday</option>
                                        <option value="Saturday">Saturday</option>
                                    </select>
                                </div>
                            </div>
                            <div class=" col-12 col-md-12 col-xl-12">
                                <div class="panel">
                                    <div class="button_outer">
                                        <div class="btn_upload">
                                            <input type="file" class="upload_file" name="image">
                                            Upload Image
                                        </div>
                                        <div class="processing_bar"></div>
                                        <div class="success_box"></div>
                                    </div>
                                </div>
                                <div class="error_msg"></div>
                                <div class="uploaded_file_view uploaded_view">
                                    <span class="file_remove">X</span>
                                </div>
                            </div>
                        </div>
                        <div class="m-t-20"> <a href="#" class="btn btn-white" data-bs-dismiss="modal">Close</a>
                            <button type="submit" class="btn btn-success ">ADD</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
    <div id="edit_blog_category" class="modal fade" role="dialog">
        <div class="modal-dialog modal-dialog-centered ">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Edit Thought of the day</h5>

                </div>
                <div class="modal-body text-center">
                    <form id="edit_category" action="{{ route('admin.update-thoughts') }}">
                        @csrf
                        <div class="row m-t-20">
                            <div class=" col-12 col-md-12 col-xl-12">
                                <div class="form-group local-forms">
                                    <input type="hidden" name="id" id="thoughtID">
                                    <label>Select day <span class="login-danger">*</span></label>
                                    <select class="form-control" required name="day" id="day">
                                        <option>--Select a day---</option>
                                        <option value="Sunday">Sunday</option>
                                        <option value="Monday">Monday</option>
                                        <option value="Tuesday">Tuesday</option>
                                        <option value="Wednesday">Wednesday</option>
                                        <option value="Thursday">Thursday</option>
                                        <option value="Friday">Friday</option>
                                        <option value="Saturday">Saturday</option>
                                    </select>
                                </div>
                            </div>
                            <div class=" col-12 col-md-12 col-xl-12">
                                <div class="panel">
                                    <div class="button_outer">
                                        <div class="btn_upload">
                                            <input type="file" class="upload_file" onchange="readURL(this);" class="thoughtImage" name="image">
                                            Upload Image
                                        </div>

                                        <div class="processing_bar"></div>
                                        <div class="success_box"></div>
                                    </div>
                                    <img class="imgdiv preview" width="200" height="100">
                                </div>

                            </div>
                        </div>
                        <div class="m-t-20"> <a href="#" class="btn btn-white" data-bs-dismiss="modal">Close</a>
                            <button type="submit" class="btn btn-success ">ADD</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
    <div id="delete_thoughts" class="modal fade delete-modal" role="dialog">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-body text-center">
                    <img src="{{asset('assets/img/sent.png')}}" alt width="50" height="46">
                    <h3>Are you sure want to delete this ?</h3>
                    <div class="m-t-20"> <a href="#" class="btn btn-white" data-bs-dismiss="modal">Close</a>
                        <button type="submit" class="btn btn-danger" id="delete_item">Delete</button>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <script type="text/javascript">
        $(function() {
            $('#thoughts_table').DataTable({
                processing: true,
                serverSide: true,
                ajax: "{{ route('admin.get-thoughts') }}",
                columns: [{
                    data: 'DT_RowIndex',
                    name: 'DT_RowIndex'
                }, {
                    data: 'day',
                    name: 'day'
                }, {
                    data: 'image',
                    name: 'image'
                }, {
                    data: 'action',
                    name: 'action',
                    orderable: false,
                    searchable: false
                }, ],
                "select": {
                    'style': 'multi',
                    'selector': 'td:first-child' //only checkbox can select row 
                },
            });
        });
        var deleteID;
        $('body').on('click', '#getDeleteId', function() {
            deleteID = $(this).data('id');
        })
        $(document).on('click', '#delete_item', function(e) {
            var id = deleteID;
            e.preventDefault();
            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token" ]').attr('content')
                }
            });
            $.ajax({
                url: "{{ route('admin.delete-thoughts') }}",
                method: "GET",
                data: {
                    'id': id
                },
                success: function(result) {
                    $('#delete_thoughts').modal('hide');
                    $('.table').DataTable().ajax.reload();
                    if (result == 1) {
                        toastr.success("Data Deleted Successfully.");
                    } else {
                        toastr.error("Something went wrong.");
                    }
                    $('.table').DataTable().ajax.reload();
                }
            });
        });

        $('#thoughts_form').submit(function(e) {
            e.preventDefault();
            var url = $(this).attr("action");
            let formData = new FormData(this);
            $("#js-loader").fadeIn();
            $.ajax({
                type: 'POST',
                url: url,
                data: formData,
                contentType: false,
                processData: false,
                success: function(data) {
                    $('.table').DataTable().ajax.reload();
                    $("#js-loader").fadeOut();
                    if (data == true) {
                        toastr.success('Data Added Successfully');
                    } else {
                        toastr.error(data);
                    }
                },
                error: function(err) { // Your Error Message
                    toastr.error(err);
                }
            });
        });

        $(document).on('click', '#getEditId', function() {
            id = $(this).data('id');
            day = $(this).data('day');
            image = $(this).data('image');
            link = "{!! asset('assets/uploads/thoughts/')  !!}/" + image;
            $('.imgdiv').attr("src", link);
            $('#thoughtID').val(id);
            $('#day').val(day);

        })

        $('#edit_category').submit(function(e) {
            e.preventDefault();
            var url = $(this).attr("action");
            let formData = new FormData(this);
            $("#js-loader").fadeIn();
            $.ajax({
                type: 'POST',
                url: url,
                data: formData,
                contentType: false,
                processData: false,
                success: function(data) {
                    $('.table').DataTable().ajax.reload();
                    $("#js-loader").fadeOut();
                    if (data == true) {
                        toastr.success('Category Updated Successfully');
                    } else {
                        toastr.error(data);
                    }
                },
                error: function(err) { // Your Error Message
                    toastr.error(err);
                }
            });
        });
    </script>
    @endsection