@extends('admin.layout.dashboard-template')
@section('content')

@php
$current_wallet_point=0.0;
$rupee=0.0;
$current_wallet=App\Models\WalletPoint::orderBy('id','DESC')->first();
$settings=App\Models\Settings::first();
if($current_wallet != null){
$rupee=$current_wallet->rupee_amount;
$current_wallet_point=$current_wallet->point;
}

@endphp
<div class="page-wrapper">
    <div class="content">

        <div class="page-header">
            <div class="row">
                <div class="col-sm-12">
                    <ul class="breadcrumb">
                        <li class="breadcrumb-item active">Wallet Point</li>
                    </ul>
                </div>
            </div>
        </div>

        <div class="row">
            <div class="col-sm-12">

                <div class="card card-table show-entire">
                    <div class="card-body">

                        <div class="page-table-header mb-2">
                            <div class="row align-items-center">
                                <div class="col">
                                    <div class="card-box">
                                        <ul class="nav nav-tabs nav-tabs-solid nav-justified">
                                            <li class="nav-item"><a class="nav-link active" href="#solid-justified-tab1" data-bs-toggle="tab">Set Wallet Point</a></li>
                                            <li class="nav-item"><a class="nav-link" href="#solid-justified-tab2" data-bs-toggle="tab">Commission</a></li>
                                            <li class="nav-item"><a class="nav-link" href="#solid-justified-tab3" data-bs-toggle="tab">Contact Details</a></li>
                                            <li class="nav-item"><a class="nav-link" href="#solid-justified-tab4" data-bs-toggle="tab">Privacy & Policy</a></li>
                                            <li class="nav-item"><a class="nav-link" href="#solid-justified-tab5" data-bs-toggle="tab">Terms & Condition</a></li>
                                        </ul>

                                        <div class="tab-content">
                                            <div class="tab-pane show active" id="solid-justified-tab1">


                                                <br><Br>
                                                <div class="" style=" margin: auto;width: 80%;border: 1px solid #eee;padding: 20px;background:#fafafa;">
                                                    <form action="{{route('admin.update-wallet-type')}}" method="post" id="add_wallet_duration">
                                                        @csrf
                                                        <div class=" row">
                                                            <h4 class="page-title">Set Wallet Expiry Date</h4>
                                                            @foreach(App\Models\TypesOfWallet::get() as $k=>$item)
                                                            <div class="col-12 col-md-6 col-xl-4">
                                                                <div class="form-group local-forms">
                                                                    <!-- <label>Current Wallet Point <span class="login-danger">*</span></label> -->
                                                                    <input class="form-control" type="hidden" name="id[{{$k}}]" value="{{$item->id}}">
                                                                    <label>{{$item->name}}</label>
                                                                </div>
                                                            </div>
                                                            <div class="col-12 col-md-6 col-xl-4">
                                                                <div class="form-group local-forms">
                                                                    <div class="input-group">
                                                                        <input class="form-control" type="number" name="expiry_duration[{{$k}}]" value="{{$item->expiry_duration}}">
                                                                        <div class="input-group-prepend">
                                                                            <span class="input-group-text">In Month</span>
                                                                        </div>
                                                                    </div>

                                                                </div>
                                                            </div>


                                                            <div class="col-12 col-md-6 col-xl-3">
                                                                <div class="doctor-submit text-end">
                                                                    <button type="submit" class="btn btn-primary submit-form me-2">Submit</button>
                                                                </div>
                                                            </div>
                                                            @endforeach
                                                        </div>
                                                    </form>
                                                </div>
                                                <br><Br><Br>
                                                <!-- <div class="page-table-header mb-2">
                                                    <div class="row align-items-center">
                                                        <div class="col">
                                                            <div class="doctor-table-blk">
                                                                <h3>Wallet History</h3>

                                                            </div>
                                                        </div>

                                                    </div>
                                                </div>
                                                <div class="table-responsive">
                                                    <table class="table border-0 custom-table comman-table mb-0" id="wallet_table">
                                                        <thead>
                                                            <tr>
                                                                <th>
                                                                    #
                                                                </th>
                                                                <th>Rupee Amount</th>
                                                                <th>Wallet Point</th>
                                                                <th>Created Date</th>
                                                            </tr>
                                                        </thead>
                                                        <tbody>

                                                        </tbody>
                                                    </table>
                                                </div> -->
                                            </div>
                                            <div class="tab-pane" id="solid-justified-tab2">
                                                <form method="post" action="{{route('admin.save-wallet-commission')}}" id="wallet_commission">
                                                    @csrf
                                                    <h4 class="page-title">Commission</h4>


                                                    @foreach(App\Models\ProviderCategory::get() as $key=>$item)
                                                    @php
                                                    $wc=App\Models\WalletPointCommission::where('provider_category_id',$item->id)->first();
                                                    if($wc==null){
                                                    $commission=0;
                                                    }else{
                                                    $commission=$wc->commission;
                                                    }
                                                    @endphp
                                                    <div class="form-group row">
                                                        <label class="col-lg-3 col-form-label">{{$item->name}}</label>
                                                        <div class="col-md-9">
                                                            <div class="input-group">
                                                                <input class="form-control" type="hidden" value="{{$item->id}}" name="category[]">
                                                                <input class="form-control" type="text" name="commission[]" value="{{$commission}}">
                                                                <div class="input-group-prepend">
                                                                    <span class="input-group-text">%</span>
                                                                </div>

                                                            </div>
                                                        </div>
                                                    </div>

                                                    @endforeach

                                                    <div class="m-t-20 text-center">
                                                        <button type="submit" class="btn btn-primary submit-btn">Save</button>
                                                    </div>
                                                </form>
                                            </div>
                                            <div class="tab-pane" id="solid-justified-tab3">
                                                <form id="contactForm" action="{{route('admin.contact-details')}}">
                                                    @csrf
                                                    <div class="row">
                                                        <h4 class="page-title">Contact Details</h4>

                                                        <div class="col-12 col-md-6 col-xl-6">
                                                            <div class="form-group local-forms">
                                                                <label>Phone <span class="login-danger">*</span></label>
                                                                <input class="form-control" type="text" name="phone" placeholder="">
                                                            </div>
                                                        </div>
                                                        <div class="col-12 col-md-6 col-xl-6">
                                                            <div class="form-group local-forms">
                                                                <label>Email<span class="login-danger">*</span></label>
                                                                <input class="form-control" type="text" name="email" placeholder="">
                                                            </div>
                                                        </div>
                                                        <div class="col-12">
                                                            <div class="doctor-submit text-end">
                                                                <button type="submit" class="btn btn-primary submit-form me-2">Submit</button>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </form>
                                            </div>
                                            <div class="tab-pane" id="solid-justified-tab4">
                                                <form id="privacyForm" action="{{route('admin.privacy-policy')}}">
                                                    @csrf
                                                    <div class="row">
                                                        <h4 class="page-title">Privacy Policy</h4>
                                                        <div class="col-12 col-md-6 col-xl-12">
                                                            <div class="form-group local-forms">
                                                                <label>Privacy & Policy <span class="login-danger">*</span></label>
                                                                <textarea class="form-control summernote" rows="10" name="privacy_and_terms">{{$data->privacy_and_terms}}</textarea>
                                                            </div>
                                                        </div>
                                                        <div class="col-12">
                                                            <div class="doctor-submit text-end">
                                                                <button type="submit" class="btn btn-primary submit-form me-2">Submit</button>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </form>
                                            </div>
                                            <div class="tab-pane" id="solid-justified-tab5">
                                                <form id="termsForm" action="{{route('admin.terms-condition')}}">
                                                    @csrf
                                                    <div class="row">
                                                        <h4 class="page-title">Terms and Condition</h4>
                                                        <div class="col-12 col-md-6 col-xl-12">
                                                            <div class="form-group local-forms">
                                                                <label>Terms and Condition <span class="login-danger">*</span></label>
                                                                <textarea class="form-control summernote" rows="10" name="terms_and_conditions">{{$data->terms_and_conditions}}</textarea>
                                                            </div>
                                                        </div>
                                                        <div class="col-12">
                                                            <div class="doctor-submit text-end">
                                                                <button type="submit" class="btn btn-primary submit-form me-2">Submit</button>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </form>
                                            </div>
                                        </div>
                                    </div>
                                </div>

                            </div>
                        </div>


                    </div>
                </div>
            </div>
        </div>
    </div>


    <script type="text/javascript">
        $(function() {
            $('#wallet_table').DataTable({
                processing: true,
                serverSide: true,
                ajax: "{{ route('admin.get-wallet-log') }}",
                columns: [{
                        data: 'DT_RowIndex',
                        name: 'DT_RowIndex'
                    },
                    {
                        data: 'rupee',
                        name: 'rupee'
                    }, {
                        data: 'point',
                        name: 'point'
                    }, {
                        data: 'created_at',
                        name: 'created_at',
                    },
                ],
                "select": {
                    'style': 'multi',
                    'selector': 'td:first-child' //only checkbox can select row
                },
            });
        });

        $('#add_wallet_point').submit(function(e) {
            e.preventDefault();
            var url = $(this).attr("action");
            let formData = new FormData(this);
            $("#js-loader").fadeIn();
            $.ajax({
                type: 'POST',
                url: url,
                data: formData,
                contentType: false,
                processData: false,
                success: function(data) {
                    $("#js-loader").fadeOut();
                    if (data == true) {
                        toastr.success('Wallet Point added Successfully');
                    } else {
                        toastr.error('Something went Wrong');
                    }
                },
                error: function(err) {
                    // Your Error Message
                    toastr.error(err);
                }
            });
        });

        $('#add_wallet_duration').submit(function(e) {
            e.preventDefault();
            var url = $(this).attr("action");
            let formData = new FormData(this);
            $("#js-loader").fadeIn();
            $.ajax({
                type: 'POST',
                url: url,
                data: formData,
                contentType: false,
                processData: false,
                success: function(data) {
                    $("#js-loader").fadeOut();
                    if (data == true) {
                        toastr.success('Wallet Duration updated Successfully');
                    } else {
                        toastr.error('Something went Wrong');
                    }
                },
                error: function(err) {
                    // Your Error Message
                    toastr.error(err);
                }
            });
        });


        $('#wallet_commission').submit(function(e) {
            e.preventDefault();
            var url = $(this).attr("action");
            let formData = new FormData(this);
            $("#js-loader").fadeIn();
            $.ajax({
                type: 'POST',
                url: url,
                data: formData,
                contentType: false,
                processData: false,
                success: function(data) {
                    $("#js-loader").fadeOut();
                    if (data == true) {
                        toastr.success('Wallet Commission updated Successfully');
                    } else {
                        toastr.error('Something went Wrong');
                    }
                    location.reload();
                },
                error: function(err) {
                    // Your Error Message
                    toastr.error(err);
                }
            });
        });

        $('#privacyForm').submit(function(e) {
            e.preventDefault();
            var url = $(this).attr("action");
            let formData = new FormData(this);
            $("#js-loader").fadeIn();
            $.ajax({
                type: 'POST',
                url: url,
                data: formData,
                contentType: false,
                processData: false,
                success: function(data) {
                    $("#js-loader").fadeOut();
                    if (data == true) {
                        toastr.success('Privacy and policy updated Successfully');
                    } else {
                        toastr.error('Something went Wrong');
                    }
                },
                error: function(err) {
                    // Your Error Message
                    toastr.error(err);
                }
            });
        });

        $('#termsForm').submit(function(e) {
            e.preventDefault();
            var url = $(this).attr("action");
            let formData = new FormData(this);
            $("#js-loader").fadeIn();
            $.ajax({
                type: 'POST',
                url: url,
                data: formData,
                contentType: false,
                processData: false,
                success: function(data) {
                    $("#js-loader").fadeOut();
                    if (data == true) {
                        toastr.success('Terms and conditions updated Successfully');
                    } else {
                        toastr.error('Something went Wrong');
                    }
                },
                error: function(err) {
                    // Your Error Message
                    toastr.error(err);
                }
            });
        });

        $('#contactForm').submit(function(e) {
            e.preventDefault();
            var url = $(this).attr("action");
            let formData = new FormData(this);
            $("#js-loader").fadeIn();
            $.ajax({
                type: 'POST',
                url: url,
                data: formData,
                contentType: false,
                processData: false,
                success: function(data) {
                    $("#js-loader").fadeOut();
                    if (data == true) {
                        toastr.success('Contact details updated Successfully');
                    } else {
                        toastr.error('Something went Wrong');
                    }
                },
                error: function(err) {
                    // Your Error Message
                    toastr.error(err);
                }
            });
        });
    </script>
    @endsection