@extends('admin.layout.dashboard-template')
@section('content')

<div class="page-wrapper">
    <div class="content">

        <div class="page-header">
            <div class="row">
                <div class="col-sm-12">
                    <ul class="breadcrumb">
                        <li class="breadcrumb-item"><a href="{{route('admin.dashboard')}}">Home</a></li>
                        <li class="breadcrumb-item"><i class="feather-chevron-right"></i></li>
                        <li class="breadcrumb-item"><a href="{{route('admin.blogs')}}">Blogs</a></li>
                        <li class="breadcrumb-item"><i class="feather-chevron-right"></i></li>
                        <li class="breadcrumb-item active">{{$data->title}}</li>
                    </ul>
                    <div style="float:right;">
                        <a href="{{route('admin.add-blog')}}" class="btn btn-primary btn-rounded "><i class="fa fa-plus"></i>Add New Blog</a>
                        <a href="{{route('admin.edit-blog', ['slug' => $data->slug])}}" class="btn btn-warning btn-rounded "><i class="fa fa-plus"></i> Edit Blog</a>
                    </div>
                </div>
            </div>
        </div>

        <div class="row">
            <div class="col-md-8">
                <div class="blog-view">
                    <article class="blog blog-single-post">
                        <h3 class="blog-title">{{$data->title}}</h3>
                        <div class="blog-info clearfix">
                            <div class="post-right read-blks">
                                <a href="">
                                    @if ($data->author == 'T')
                                    <img width="28" height="28" class="rounded-circle" src="{{asset('assets/uploads/therapist/' . $data->therapist->image)}}" alt="">
                                    &nbsp;{{$data->therapist->full_name}}
                                    @else
                                    <img width="28" height="28" class="rounded-circle" src="{{asset('assets/img/fenni.jpg')}}" alt="">
                                    &nbsp;Fenni
                                    @endif
                                </a>
                            </div>

                            <div class="post-left date-blks">
                                <ul>
                                    <li><a href="#."><i class="feather-calendar"></i> <span>{{date("d l Y", strtotime($data->created_at))}}</span></a></li>
                                </ul>
                            </div>
                        </div>
                        <div class="blog-image">
                            <a href="javascript:void(0);"><img alt src="{{asset('assets/uploads/blog/' . $data->image)}}" class="img-fluid"></a>
                        </div>
                        <div class="blog-content">
                            <!-- <p> {{strip_tags($data->description)}}</p> -->
                            {!! $data->description !!}
                        </div>


                    </article>


                </div>
            </div>
            <aside class="col-md-4">


                @php
                $blog=App\Models\Blog::where('id','!=',$data->id)->get();
                @endphp
                @if(count($blog)>0)
                <div class="widget post-widget">
                    <div class="relat-head">
                        <h5>Related Posts</h5>
                        <a href="{{route('admin.blogs')}}">Show All</a>
                    </div>
                    <ul class="latest-posts">
                        @foreach($blog as $item)
                        <li>
                            <div class="post-thumb">
                                <a href="{{route('admin.view-blog', ['slug' => $item->slug]) }}">
                                    <img class="img-fluid" src="{{asset('assets/uploads/blog/' . $data->image)}}" alt=">{{$item->title}}">
                                </a>
                            </div>
                            <div class=" post-info">
                                <div class="date-posts">
                                    <h5>{{$item->title}}</h5>

                                </div>
                                <small class="ms-2">{{date('d l Y', strtotime($item->created_at)) }}</small>
                                <p>
                                    <a href="{{route('admin.view-blog', ['slug' => $item->slug]) }}">{{Str::limit((strip_tags($item->description)), 50, '...')}}</a>
                                </p>
                                <p> Read more <i class="fa fa-long-arrow-right ms-2"></i></p>
                            </div>
                        </li>
                        @endforeach

                    </ul>
                </div>
                @endif
                <div class="widget tags-widget">
                    <div class="relat-head">
                        <h5>Tags</h5>
                    </div>
                    <ul class="tags">
                        @foreach(explode(',',$data->tags) as $item)
                        <li><a href="#" class="tag">#{{$item}}</a></li>
                        @endforeach
                    </ul>
                </div>

                <div class="widget category-widget">
                    <div class="relat-head mb-0">
                        <h5> Categories</h5>
                    </div>
                    <ul class="categories">
                        @foreach(App\Models\Blog_category::get() as $item)
                        <li><a href="#"><img src="{{asset('assets/img/icons/tag.svg')}}" class="me-1" alt>{{$item->name}} ({{count($item->blog)}})</a>
                        </li>
                        @endforeach

                    </ul>
                </div>
            </aside>

        </div>
    </div>

    @endsection