@extends('admin.layout.dashboard-template')
@section('content')
<div class="page-wrapper">
    <div class="content">

        <div class="page-header">
            <div class="row">
                <div class="col-sm-12">
                    <ul class="breadcrumb">
                        <li class="breadcrumb-item"><a href="{{route('admin.dashboard')}}">Home</a></li>
                        <li class="breadcrumb-item"><i class="feather-chevron-right"></i></li>
                        <li class="breadcrumb-item"><a href="{{route('admin.blogs')}}">Blogs</a></li>
                        <li class="breadcrumb-item"><i class="feather-chevron-right"></i></li>
                        <li class="breadcrumb-item active">Add Blog</li>
                    </ul>
                </div>
            </div>
        </div>

        <div class="row">
            <div class="col-sm-12">
                <div class="card">
                    <div class="card-body">
                        <form id="add_blog" action="{{ route('admin.save-blog') }}" enctype="multipart/form-data">
                            @csrf
                            <div class="row">
                                <div class="col-12">
                                    <div class="form-heading">
                                        <h4>Blog Details</h4>
                                    </div>
                                </div>
                                <div class="col-12 col-md-6 col-xl-6">
                                    <div class="form-group local-forms">
                                        <label>Blog Title <span class="login-danger">*</span></label>
                                        <input class="form-control" name="title" type="text" placeholder>
                                    </div>
                                </div>
                                <div class="col-12 col-md-6 col-xl-3">
                                    <div class="form-group select-gender">
                                        <label class="gen-label">Select Author<span class="login-danger">*</span></label>
                                        <div class="form-check-inline">
                                            <label class="form-check-label">
                                                <input type="radio" name="author" checked value="F" class="form-check-input fenny_radio">Fenny
                                            </label>
                                        </div>
                                        <div class="form-check-inline">
                                            <label class="form-check-label">
                                                <input type="radio" name="author" value="T" class="form-check-input therapist_radio">Therapist
                                            </label>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-12 col-md-6 col-xl-3">
                                    <div class="form-group local-forms">
                                        <label>Select Therapist</label>
                                        <select class="form-control therapist" name="therapist" disabled>
                                            <option value="">--Select Therapist--</option>
                                            @foreach(App\Models\Therapist::get() as $item)
                                            <option value="{{$item->id}}">{{$item->full_name}}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                </div>
                                <div class="col-12 col-md-6 col-xl-6">
                                    <div class="form-group local-forms">
                                        <label>Blog Category <span class="login-danger">*</span></label>
                                        <select class="form-control select" name="blog_category">
                                            <option>Choose Blog Category</option>
                                            @foreach(App\Models\Blog_category::get() as $item)
                                            <option value="{{$item->id}}">{{$item->name}}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                </div>

                                <div class="col-12 col-md-6 col-xl-6">
                                    <div class="form-group local-forms">
                                        <label>Tags <small>(separated with a comma, Maximum 2 tags)</small> <span class="login-danger">*</span></label>
                                        <input type="text" name="tags" data-role="tagsinput" class="form-control tags">
                                    </div>
                                </div>

                                <div class="col-12 col-md-6 col-xl-12">
                                    <div class="form-group summer-mail">
                                        <textarea rows="4" cols="5" name="description" class="form-control summernote" placeholder="Enter your message here"></textarea>
                                    </div>
                                </div>
                                <div class="col-12 col-md-6 col-xl-4">
                                    <div class="form-group local-top-form">
                                        <label class="local-top">Blog Image<span class="login-danger">*</span></label>
                                        <!-- <div class="settings-btn upload-files-avator"> -->
                                        <input type="file" accept="image/*" name="image" id="file" onchange="readURL(this);" class="form-control">
                                        <!-- <label for="file" class="upload">Choose File</label>
                                        </div> -->
                                    </div>
                                </div>
                                <div class="col-12 col-md-6 col-xl-4">
                                    <div class="form-group local-top-form">
                                        <img width="80" height="200" src="{{asset('assets/img/no-image-available.jpg')}}" class="form-control  preview" alt="">
                                    </div>
                                </div>
                                <div class="col-12 col-md-6 col-xl-4">
                                    <div class="form-group local-forms">
                                        <label>Blog Color <span class="login-danger">*</span></label>
                                        <input class="form-control" name="color" type="color" placeholder>
                                    </div>
                                </div>


                                <div class="col-12">
                                    <div class="doctor-submit text-end">
                                        <button type="submit" class="btn btn-primary submit-form me-2">Publish Blog</button>
                                        <button type="submit" class="btn btn-primary cancel-form">Cancel</button>
                                    </div>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <script>
        $(document).ready(function() {
            $('.tags').tagsinput({
                maxTags: 2,
            });
        });
        $('#add_blog').submit(function(e) {
            e.preventDefault();
            var url = $(this).attr("action");
            let formData = new FormData(this);
            $("#js-loader").fadeIn();
            $.ajax({
                type: 'POST',
                url: url,
                data: formData,
                contentType: false,
                processData: false,
                success: function(data) {
                    $("#js-loader").fadeOut();
                    if (data == true) {
                        toastr.success('Blog Added Successfully');
                    } else {
                        toastr.error(data);
                    }
                },
                error: function(err) {
                    // Your Error Message
                    toastr.error(err);
                }
            });
        });
        $('body').on('click', '.therapist_radio', function() {
            $('.therapist').prop("disabled", false);
        });
        $('body').on('click', '.fenny_radio', function() {
            $('.therapist').prop("disabled", true);
        });
    </script>
    @endsection