@extends('admin.layout.dashboard-template')
@section('content')
<div class="page-wrapper">
    <div class="content">

        <div class="page-header">
            <div class="row">
                <div class="col-sm-12">
                    <ul class="breadcrumb">
                        <li class="breadcrumb-item"><a href="{{route('admin.dashboard')}}">Home</a></li>
                        <li class="breadcrumb-item"><i class="feather-chevron-right"></i></li>
                        <li class="breadcrumb-item active">Change Passwordr</li>
                    </ul>
                </div>
            </div>
        </div>

        <div class="row">
            <div class="col-sm-12">
                <div class="card">
                    <div class="card-body">
                        <!-- <form method="post" action="{{ route('admin.save-user') }}"> -->
                        <form id="reset-pswd" action="{{ route('admin.save-reset-password') }}">
                            @csrf
                            <div class="row">
                                <h4 class="page-title">Change Password</h4>

                                <div class="col-12 col-md-6 col-xl-6">
                                    <div class="form-group local-forms">
                                        <label>New password <span class="login-danger">*</span></label>

                                        <input class="form-control" name="password" type="password" placeholder="">
                                    </div>
                                </div>
                                <div class="col-12 col-md-6 col-xl-6">
                                    <div class="form-group local-forms">
                                        <label>Confirm password <span class="login-danger">*</span></label>
                                        <input class="form-control" name="confirm_password" type="password" placeholder="">
                                    </div>
                                </div>
                                <div class="col-12">
                                    <div class="doctor-submit text-end">
                                        <button type="submit" class="btn btn-primary submit-form me-2">Submit</button>
                                    </div>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <script>
        $('#reset-pswd').submit(function(e) {
            e.preventDefault();
            var url = $(this).attr("action");
            let formData = new FormData(this);
            $("#js-loader").fadeIn();
            $.ajax({
                type: 'POST',
                url: url,
                data: formData,
                contentType: false,
                processData: false,
                success: function(result) {
                    $("#js-loader").fadeOut();
                    if (result.status == true) {
                        toastr.success(result.data);
                    } else if (result.status == false) {
                        toastr.error(result.data);
                    }
                },
                error: function(err) {
                    // Your Error Message
                    toastr.error(err.data);
                }
            });
        });
    </script>
    @endsection