@extends('admin.layout.dashboard-template')
@section('content')
<div class="page-wrapper">
    <div class="content">

        <div class="page-header">
            <div class="row">
                <div class="col-sm-12">
                    <ul class="breadcrumb">
                        <li class="breadcrumb-item"><a href="{{route('admin.dashboard')}}">Home</a></li>
                        <li class="breadcrumb-item"><i class="feather-chevron-right"></i></li>
                        <li class="breadcrumb-item active">Assessment</li>
                    </ul>
                </div>
            </div>
        </div>

        <div class="row">
            <div class="col-sm-12">
                <div class="card card-table show-entire">
                    <div class="card-body">

                        <div class="page-table-header mb-2">
                            <div class="row align-items-center">
                                <div class="col">
                                    <div class="doctor-table-blk">
                                        <h3>Assessments</h3>
                                        <div class="doctor-search-blk">

                                            <div class="add-group">
                                                <a href="{{route('admin.add-assessment')}}" class="btn btn-primary add-pluss ms-2"><img src="{{asset('assets/img/icons/plus.svg')}}" alt></a>
                                                <button class="btn btn-danger" title="Delete selected rows" data-bs-toggle="modal" href="#deleteAll"><i class="far fa-trash-alt"></i></button>

                                            </div>
                                        </div>
                                    </div>
                                </div>

                            </div>
                        </div>

                        <div class="table-responsive">
                            <table class="table border-0 custom-table comman-table mb-0" id="service_table">
                                <thead>
                                    <tr>
                                        <th scope="col" style="width: 25px;">
                                            <div class="form-check">
                                                <input class="form-check-input" name="datatablecheckbox" type="checkbox" id="checkAll" value="option">
                                            </div>
                                        </th>
                                        <th>
                                            #
                                        </th>
                                        <th>Title</th>
                                        <th>Number of users<br> attend this <br>assessment</th>
                                        <th>Status</th>
                                        <th>ACTION</th>
                                    </tr>
                                </thead>
                                <tbody>

                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div id="deleteAll" class="modal fade delete-modal" role="dialog">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-body text-center">
                    <img src="{{asset('assets/img/sent.png')}}" alt width="50" height="46">
                    <h3>Are you sure want to delete this ?</h3>
                    <div class="m-t-20"> <a href="#" class="btn btn-white" data-bs-dismiss="modal">Close</a>
                        <button type="submit" class="btn btn-danger" id="deleteMultiple">Delete</button>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div id="delete_patient" class="modal fade delete-modal" role="dialog">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-body text-center">
                    <img src="assets/img/sent.png" alt width="50" height="46">
                    <h3>Are you sure want to delete this ?</h3>
                    <div class="m-t-20"> <a href="#" class="btn btn-white" data-bs-dismiss="modal">Close</a>
                        <button type="submit" class="btn btn-danger" id="delete_item">Delete</button>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <script type="text/javascript">
        $(function() {
            $('#service_table').DataTable({
                processing: true,
                serverSide: true,
                ajax: "{{ route('admin.get-assessment') }}",
                columns: [{

                        data: 'checkbox',
                        name: 'checkbox',
                        orderable: false,
                        searchable: false,
                        'targets': 0,
                        className: 'select-checkbox',
                        'checkboxes': {
                            'selectRow': true
                        }
                    },
                    {
                        data: 'DT_RowIndex',
                        name: 'DT_RowIndex'
                    },
                    {
                        data: 'title',
                        name: 'title'
                    },
                    {
                        data: 'users',
                        name: 'users'
                    },
                    {
                        data: 'status',
                        name: 'status'
                    },

                    {
                        data: 'action',
                        name: 'action',
                        orderable: false,
                        searchable: false
                    },
                ],
                "select": {
                    'style': 'multi',
                    'selector': 'td:first-child' //only checkbox can select row
                },

            });

        });
        $("#checkAll").click(function() {
            if ($(this).is(':checked')) {
                $('.datatablecheckbox').prop('checked', true);
                $("tr").addClass("selected");
            } else {
                $('.datatablecheckbox').prop('checked', false);
                $("tr").removeClass("selected");
            }
        });
        var deleteID;
        $('body').on('click', '#getDeleteId', function() {
            deleteID = $(this).data('id');
        })
        $(document).on('click', '#delete_item', function(e) {
            var id = deleteID;
            e.preventDefault();
            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });
            $.ajax({
                url: "{{ route('admin.delete-assesment') }}",
                method: "GET",
                data: {
                    'id': id
                },
                success: function(result) {
                    $('#delete_patient').modal('hide');
                    $('.table').DataTable().ajax.reload();
                    if (result == 1) {
                        toastr.success("Data Deleted Successfully.");
                    } else {
                        toastr.error("Something went wrong.");
                    }

                    $('.data-table').DataTable().ajax.reload();

                }
            });

        });

        $(document).on('click', '#status', function(e) {
            var id = $(this).data('id');
            var status = $(this).data('value');
            e.preventDefault();
            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });
            $.ajax({
                url: "{{ route('admin.change-service-status') }}",
                method: "GET",
                data: {
                    'id': id,
                    'status': status
                },
                success: function(result) {
                    $('#delete_patient').modal('hide');
                    $('.table').DataTable().ajax.reload();
                    if (result == 1) {
                        toastr.success("Status Changed Successfully.");
                    } else {
                        toastr.error("Something went wrong.");
                    }

                    $('.data-table').DataTable().ajax.reload();

                }
            });

        });

        $("#deleteMultiple").click(function() {
            arr = [];
            var arr = $("input[name='datatablecheckbox[]']:checked").map(function() {
                return this.value;
            }).get();
            $.ajax({
                type: 'GET',
                data: {
                    ids: arr
                },
                url: "{{ route('admin.delete-multiple-assesment') }}",
                success: function(result) {
                    alert(result);
                    $('#checkAll').prop('checked', false);

                    $('#deleteAll').modal('hide');
                    $('.table').DataTable().ajax.reload();
                    if (result == 1) {
                        toastr.success("Data Deleted Successfully.");
                    } else if (result == 0) {
                        toastr.error("Something went wrong.");
                    } else {
                        toastr.error(result);
                    }
                }
            });
        });
    </script>
    @endsection