@extends('admin.layout.dashboard-template')
@section('content')
<style>
    .fee-box {
        border: 1px solid #eee;
        margin-bottom: 30px;
        padding: 30px;
        border-radius: 21px;
        background: #f6f5f5;
    }
</style>
<div class="page-wrapper">
    <div class="content">

        <div class="page-header">
            <div class="row">
                <div class="col-sm-12">
                    <ul class="breadcrumb">
                        <li class="breadcrumb-item"><a href="{{route('admin.dashboard')}}">Home</a></li>
                        <li class="breadcrumb-item"><i class="feather-chevron-right"></i></li>
                        <li class="breadcrumb-item"><a href="{{route('admin.assessment')}}">Assessment</a></li>
                        <li class="breadcrumb-item"><i class="feather-chevron-right"></i></li>
                        <li class="breadcrumb-item active">Edit Assessment</li>
                    </ul>
                </div>
            </div>
        </div>

        <div class="row">
            <div class="col-sm-12">
                <div class="card">
                    <div class="card-body">
                        <!-- <form method="post" action="{{ route('admin.save-assessment') }}"> -->
                        <form class="addService" action="{{ route('admin.update-assessment') }}">
                            @csrf

                            <div class="row">
                                <div class="col-12">
                                    <div class="form-heading">
                                        <h4>Edit Assessment</h4>
                                    </div>
                                </div>
                                <div class="col-12 col-md-6 col-xl-6">
                                    <div class="form-group local-forms">
                                        <label>Title <span class="login-danger">*</span></label>
                                        <input type="hidden" name="id" value="{{$data->id}}">
                                        <input class="form-control" name="title" value="{{$data->title}}" type="text" required>
                                    </div>
                                </div>
                                <div class="col-12 col-md-6 col-xl-6">
                                    <div class="form-group local-forms">
                                        <label>Blog Color <span class="login-danger">*</span></label>
                                        <input class="form-control" name="color" value="{{$data->color}}" type="color" placeholder>
                                    </div>
                                </div>
                                <div class="col-12 col-md-6 col-xl-4">
                                    <div class="form-group local-top-form">
                                        <label class="local-top">Image <span class="login-danger">*</span></label>
                                        <!-- <div class="settings-btn upload-files-avator"> -->
                                        <input type="file" accept="image/*" name="image" id="file" onchange="readURL(this);" class="form-control">
                                        <!-- <label for="file" class="upload">Choose File</label> -->
                                        <!-- </div> -->
                                    </div>
                                </div>
                                <div class="col-12 col-md-6 col-xl-2">
                                    <div class="form-group local-top-form">
                                        @if($data->image)
                                        <img width="60" height="60" src="{{asset('assets/uploads/assessment/' . $data->image)}}" class="img-fluid call-imgs preview" alt="">
                                        @else
                                        <img width="100" height="80" src="{{asset('assets/img/no-image-available.jpg')}}" class="preview" alt="">
                                        @endif

                                    </div>
                                </div>
                                <div class="col-12 col-md-6 col-xl-6">
                                    <div class="form-group summer-mail">
                                        <label>Time <span class="login-danger">*</span></label>
                                        <input class="form-control" name="time" value="{{$data->time_duration}}" required type="text" placeholder="5-10 mins">
                                    </div>
                                </div>
                                @php
                                $ids=json_decode($data->recommended_therapist);
                                @endphp
                                <div class="col-12 col-md-12 col-xl-12">
                                    <div class="form-group local-forms">
                                        <label>Recommended therapist<span class="login-danger">*</span></label>
                                        <select class="form-control select chosen-select" name="provider[]" id="provider" required="select therapist">
                                            @foreach(App\Models\Therapist::select('id', 'full_name')->orderBy('full_name', 'ASC')->get() as $item)
                                            @if(empty($ids))

                                            <option value="{{$item->id}}">{{$item->full_name}}</option>
                                            @else

                                            @if(in_array($item->id, $ids))

                                            <option value="{{$item->id}}" selected>{{$item->full_name}} </option>
                                            @else
                                            <option value="{{$item->id}}">{{$item->full_name}} </option>
                                            @endif

                                            @endif
                                            @endforeach
                                        </select>
                                    </div>
                                </div>
                                @php
                                $ids=json_decode($data->recommended_blogs);
                                @endphp
                                <div class="col-12 col-md-12 col-xl-12">
                                    <div class="form-group local-forms">
                                        <label>Recommended Blogs<span class="login-danger">*</span></label>
                                        <select class="form-control select chosen-select" name="blogs[]" id="blogs" required placeholder="select blogs">
                                            @foreach(App\Models\Blog::select('id', 'title')->orderBy('title', 'ASC')->get() as $item)
                                            @if(empty($ids))

                                            <option value="{{$item->id}}">{{$item->title}}</option>
                                            @else

                                            @if(in_array($item->id, $ids))

                                            <option value="{{$item->id}}" selected>{{$item->title}} </option>
                                            @else
                                            <option value="{{$item->id}}">{{$item->title}} </option>
                                            @endif

                                            @endif
                                            @endforeach
                                        </select>
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-12">
                                    <div class="doctor-submit text-end">
                                        <button type="submit" class="btn btn-primary submit-form me-2">Save</button>
                                        <button type="submit" class="btn btn-primary cancel-form">Cancel</button>
                                    </div>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>

                <div class="card">
                    <div class="card-body">
                        <!-- <form method="post" action="{{ route('admin.save-assessment') }}"> -->
                        <form class="addService" action="{{ route('admin.update-assessment-qanda') }}">
                            @csrf
                            <div class="row">
                                <div class="col-sm-12">
                                    <div class="card card-table show-entire">
                                        <div class="card-body">

                                            <div class="page-table-header mb-2">
                                                <div class="row align-items-center">
                                                    <div class="col">
                                                        <div class="doctor-table-blk">
                                                            <h3>Assessment Questions an Answer</h3>
                                                            <input type="hidden" name="assessment_id" value="{{$data->id}}">
                                                        </div>
                                                    </div>
                                                    <div class="col-auto text-end float-end ms-auto download-grp add-group">
                                                        <a href="javascript:void(0);" title="Add more fee details" class="btn btn-primary add ms-2"><img src="{{asset('assets/img/icons/plus.svg')}}" alt></a>
                                                    </div>
                                                </div>
                                            </div>


                                        </div>
                                    </div>
                                </div>
                                @foreach($data->questions as $key=>$item)
                                <div class="fee-box " id="remove-row">
                                    <div class="row question" id="question{{$key}}">
                                        <div class="col-12 col-md-10 col-xl-11">
                                            <div class="form-group local-forms">
                                                <label>Question <span class="login-danger">*</span></label>
                                                <input type="hidden" name="question_id[{{$key}}]" value="{{$item->id}}">
                                                <input class="form-control" name="ex_question[{{$key}}]" value="{{$item->question}}" required type="text">
                                            </div>
                                        </div>

                                        <div class="col-12 col-md-2 col-xl-1">
                                            <div class="add-group">
                                                <a href=" javascript:void(0);" id="remove" data-id="{{$item->id}}" class=" btn btn-primary ms-2"> <img src="{{asset('assets/img/icons/trash.svg')}}" alt> </a>
                                            </div>
                                        </div>
                                    </div>


                                    <div class="page-table-header mb-5">
                                        <div class="row align-items-center">
                                            <div class="col">
                                                <div class="doctor-table-blk">
                                                    <h3> Answers</h3>

                                                </div>
                                            </div>
                                            <div class="col-auto text-end float-end ms-auto download-grp add-group">
                                                <a href="javascript:void(0);" title="Add more fee details" data-id="{{$key}}" class="btn btn-primary add-answer ms-2"><img src="{{asset('assets/img/icons/plus.svg')}}" alt></a>
                                            </div>
                                        </div>
                                    </div>

                                    @foreach($item->answer as $akey=>$answer)
                                    <div class="answer" id="remove-row-answer{{$key}}">
                                        <div class="row answer{{$key}}">
                                            <div class="col-12 col-md-8 col-xl-9">
                                                <div class="form-group local-forms">
                                                    <label>Answer <span class="login-danger">*</span></label>
                                                    <input class="form-control" name="ex_answer[{{$key}}][{{$akey}}]" value="{{$answer->answer}}" required type="text" placeholder="Enter answer">
                                                    <input type="hidden" name="answer_id[{{$key}}][{{$akey}}]" value="{{$answer->id}}">
                                                </div>
                                            </div>
                                            <div class="col-12 col-md-2 col-xl-2">
                                                <div class="form-group local-forms">
                                                    <label>Rate<span class="login-danger">*</span></label>
                                                    <input class="form-control" name="ex_rate[{{$key}}][{{$akey}}]" value="{{$answer->rate}}" required type="text" placeholder="Enter rate">
                                                </div>
                                            </div>
                                            <div class="col-12 col-md-2 col-xl-1">
                                                <div class="add-group">
                                                    <a href=" javascript:void(0);" data-id="{{$answer->id}}" class=" btn btn-primary ms-2 remove-answer"> <img src="{{asset('assets/img/icons/trash.svg')}}" alt> </a>
                                                </div>
                                            </div>

                                        </div>

                                    </div>
                                    @endforeach
                                    <div id="more-answer{{$key}}"></div>
                                </div>
                                @endforeach
                                <div id="more-fee"></div>

                            </div>
                            <div class="row">
                                <div class="col-12">
                                    <div class="doctor-submit text-end">
                                        <button type="submit" class="btn btn-primary submit-form me-2">Save</button>
                                        <button type="submit" class="btn btn-primary cancel-form">Cancel</button>
                                    </div>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>

                <div class="card">
                    <div class="card-body">
                        <!-- <form method="post" action="{{ route('admin.save-assessment') }}"> -->
                        <form class="addService" action="{{ route('admin.update-assessment-settings') }}">
                            @csrf
                            <div class="row">
                                <div class="col-sm-12">
                                    <div class="card card-table show-entire">
                                        <div class="card-body">

                                            <div class="page-table-header mb-2">
                                                <div class="row align-items-center">
                                                    <div class="col">
                                                        <div class="doctor-table-blk">
                                                            <h3>Assessment Rate Range settings</h3>

                                                        </div>
                                                    </div>
                                                    <div class="col-auto text-end float-end ms-auto download-grp add-group">
                                                        <a href="javascript:void(0);" title="Add more fee details" class="btn btn-primary add-settings ms-2"><img src="{{asset('assets/img/icons/plus.svg')}}" alt></a>
                                                    </div>
                                                </div>
                                            </div>


                                        </div>
                                    </div>
                                </div>

                                <div class="fee-box " id="remove-row-settings">
                                    <input type="hidden" name="assessment_id" value="{{$data->id}}">
                                    @foreach($data->settings as $item)
                                    <div class="row settings">
                                        <div class="col-12 col-md-2 col-xl-2">
                                            <div class="form-group local-forms">
                                                <label>start rate<span class="login-danger">*</span></label>
                                                <input type="hidden" name="settings_id[]" value="{{$item->id}}">
                                                <input class="form-control" value="{{$item->start_rate}}" name="ex_start_rate[]" type="text">
                                            </div>
                                        </div>
                                        <div class="col-12 col-md-2 col-xl-2">
                                            <div class="form-group local-forms">
                                                <label>End Rate<span class="login-danger">*</span></label>
                                                <input class="form-control" name="ex_end_rate[]" value="{{$item->end_rate}}" type="text">
                                            </div>
                                        </div>

                                        <div class="col-12 col-md-2 col-xl-2 ">
                                            <div class="form-group local-forms">
                                                <label>Comment/ Status<span class="login-danger">*</span></label>
                                                <input class="form-control" name="ex_comment[]" value="{{$item->status}}" type="text">
                                            </div>
                                        </div>
                                        <div class="col-12 col-md-5 col-xl-5 ">
                                            <div class="form-group local-forms">
                                                <label>Description<span class="login-danger">*</span></label>
                                                <textarea class="form-control" name="ex_status_description[]">{{$item->status_description}}</textarea>
                                            </div>
                                        </div>
                                        <div class="col-12 col-md-2 col-xl-1">
                                            <div class="add-group">
                                                <a href=" javascript:void(0);" id="remove-settings" data-id="{{$item->id}}" class=" btn btn-primary ms-2"> <img src="{{asset('assets/img/icons/trash.svg')}}" alt> </a>
                                            </div>
                                        </div>
                                    </div>
                                    @endforeach
                                </div>
                                <div id="more-settings"></div>

                            </div>

                            <div class="row">
                                <div class="col-12">
                                    <div class="doctor-submit text-end">
                                        <button type="submit" class="btn btn-primary submit-form me-2">Save</button>
                                        <button type="submit" class="btn btn-primary cancel-form">Cancel</button>
                                    </div>
                                </div>
                            </div>
                        </form>

                    </div>
                </div>
            </div>
        </div>
    </div>
    <script>
        $(".chosen-select").select2({
            multiple: true
        });
        $('body').on('click', '.add', function(e) {
            var count = $('.question').length;

            e.preventDefault();
            $("#js-loader").fadeIn();
            $.ajax({
                url: "{{ route('admin.questions-html') }}",
                data: {
                    count: count
                },
                method: "GET",
                success: function(result) {
                    $("#js-loader").fadeOut();
                    $('#more-fee').append(result);
                }
            });
        });

        $('body').on('click', '.add-answer', function(e) {
            var count = $(this).data('id');
            var answer_count = $('.answer' + count).length;

            e.preventDefault();
            $("#js-loader").fadeIn();
            $.ajax({
                url: "{{ route('admin.answer-html') }}",
                method: "GET",
                data: {
                    qcount: count,
                    count: answer_count
                },
                success: function(result) {
                    $("#js-loader").fadeOut();
                    $('#more-answer' + count).append(result);
                }
            });
        });

        $('body').on('click', '.add-settings', function(e) {
            e.preventDefault();
            $("#js-loader").fadeIn();
            $.ajax({
                url: "{{ route('admin.settings-html') }}",
                method: "GET",
                success: function(result) {
                    $("#js-loader").fadeOut();
                    $('#more-settings').append(result);
                }
            });
        });
        $('body').on('click', '#remove', function(e) {
            var id = $(this).data('id');
            if (id) {
                $.ajax({
                    url: "{{ route('admin.delete-question') }}",
                    method: "GET",
                    data: {
                        id: id
                    },
                    success: function(result) {
                        $("#js-loader").fadeOut();
                        $(this).closest("#remove-row").remove();
                        location.reload();
                    }
                });
            } else {
                $(this).closest("#remove-row").remove();
            }
        });

        $('body').on('click', '.remove-answer', function(e) {
            var count = $(this).data('id');
            var id = $(this).data('id');
            if (id) {
                $.ajax({
                    url: "{{ route('admin.delete-answer') }}",
                    method: "GET",
                    data: {
                        id: id
                    },
                    success: function(result) {
                        $("#js-loader").fadeOut();
                        $(this).closest("#remove-row-answer" + count).remove();
                        location.reload();
                    }
                });
            } else {
                $(this).closest("#remove-row-answer" + count).remove();
            }

        });
        $('body').on('click', '#remove-settings', function(e) {

            // $('#remove-row').hide('slow');
            var id = $(this).data('id');
            if (id) {
                $.ajax({
                    url: "{{ route('admin.delete-setting') }}",
                    method: "GET",
                    data: {
                        id: id
                    },
                    success: function(result) {
                        $("#js-loader").fadeOut();
                        $(this).closest("#remove-row-settings").remove();
                        location.reload();
                    }
                });
            } else {
                $(this).closest("#remove-row-settings").remove();
            }
        });
        $('.addService').submit(function(e) {
            e.preventDefault();
            var url = $(this).attr("action");
            $("#js-loader").fadeIn();
            let formData = new FormData(this);
            $.ajax({
                type: 'POST',
                url: url,
                data: formData,
                contentType: false,
                processData: false,
                success: function(data) {
                    $("#js-loader").fadeOut();
                    if (data == true) {
                        toastr.success('Assessment Updated Successfully');
                        location.reload();
                    } else {
                        toastr.error('Something went Wrong');
                    }
                },
                error: function(err) {
                    // Your Error Message
                    toastr.error(err);
                }
            });
        });
    </script>
    @endsection