@extends('admin.layout.dashboard-template')
    @section('content')
    <style>
        .slot-btn {
            margin-bottom: 10px;
        }

        .slot-btn:hover {
            background: #fbd500;
        }

        .follow-group {
            width: 92%;
        }

        .names-profiles h4 {
            color: #fff;
        }

        .names-profiles h5 {
            color: #caccda;
        }

        .btn-n-active {
            background: #55ce63;
        }
    </style>
    <div class="page-wrapper">
        <div class="content">

            <div class="page-header">
                <div class="row">
                    <div class="col-sm-4">
                        <ul class="breadcrumb">
                            <!-- <li class="breadcrumb-item"><a href="{{route('admin.dashboard')}}">Doctors </a></li>
                            <li class="breadcrumb-item"><i class="feather-chevron-right"></i></li> -->
                            <li class="breadcrumb-item"><a href="{{route('admin.appoinments')}}">Appoinments </a></li>
                            <li class="breadcrumb-item"><i class="feather-chevron-right"></i></li>
                            <li class="breadcrumb-item active">Appoinment Details</li>
                        </ul>
                    </div>

                    <div class="col-lg-8 col-md-8 d-flex align-items-center">
                        <div class="follow-btn-group">
                            @if($data->Appointment_Status!='Failed' && $data->invoice_number!=NULL)
                            <a href="{{route('admin.invoice',['id'=>$data->invoice_number])}}" target="_blank" class="btn btn-info " style="margin-right:8px;">Download Invoice</a>
                            @endif
                            @if($data->Appointment_Status=='Completed')
                            <a class="btn btn-secondary" style="margin-right:8px;cursor: not-allowed;
  pointer-events: all !important;">Transfer Appoinment</a>
                            <button type="submit" class="btn btn-secondary " style="cursor: not-allowed;
  pointer-events: all !important;">Reshedule Appoinment</button> &nbsp;&nbsp;
                            &nbsp;&nbsp;
                            <a href="javascript:void(0);" class="btn btn-secondary" style="cursor: not-allowed;
  pointer-events: all !important;">Delete Appoinment</a>
                            &nbsp;&nbsp;

                            @php
                            $color=statusColor($data->Appointment_Status);
                            @endphp
                            <button type="button" title="Change Status" class="btn " style="background:{{$color}};">{{$data->Appointment_Status}}<br>(Status)
                            </button>

                            @else
                            <div class="btn-group">
                                @php
                                $color=statusColor($data->Appointment_Status);
                                @endphp
                                <button type="button" title="Change Status" class="btn btn-danger dropdown-toggle" data-bs-toggle="dropdown" aria-haspopup="true" aria-expanded="false" style="background:{{$color}};">Change Status
                                    <br>({{$data->Appointment_Status}})
                                </button></button>
                                @php
                                $flag=0;
                                $array =['Resheduled', 'Failed','Missed', 'Awaiting', 'Confirm', 'Rejected', 'Cancel', 'Join', 'No Participants', 'Awaiting Participant', 'In Progress','Missed', 'Completed'];
                                $element = $data->Appointment_Status;
                                $position = array_search($element, $array);
                                @endphp
                                <div class="dropdown-menu">
                                    @foreach(status() as $k=>$item)

                                    @if(($position)>=$k)
                                    @continue;
                                    @endif
                                    <a class="dropdown-item changeStatus" data-value="{{$item}}" href="#">{{$item}}</a>

                                    @endforeach

                                </div>
                            </div>
                            <a class="btn btn-info follow-btns" href="{{route('admin.transfer-appoinment',['id'=>$data->id])}}" style=" margin-right:8px;">Transfer Appoinment</a>
                            <button type="submit" class="btn btn-success " data-bs-toggle="modal" data-bs-target="#reshedulemodal">Reshedule Appoinment</button> &nbsp;&nbsp;
                            &nbsp;&nbsp;
                            <a href="javascript:void(0);" data-bs-toggle="modal" data-bs-target="#delete_patient" class="btn btn-info message-btns">Delete Appoinment</a>
                            &nbsp;&nbsp;

                            @endif


                        </div>
                    </div>
                </div>
            </div>

            <div class="row">
                <div class="col-sm-12">
                    <div class="card">
                        <div class="card-body">
                            <div class="row">
                                <div class="col-md-12">
                                    <!-- <div class="about-info">
                                        <h4>Doctor Profile <span><a href="javascript:;"><i class="feather-more-vertical"></i></a></span></h4>
                                    </div> -->
                                    <div class="doctor-profile-head">
                                        <!-- <div class="profile-bg-img">
                                            <img src="assets/img/profile-bg.jpg" alt="Profile">
                                        </div> -->
                                        @php

                                        $type = App\Models\CallMethods::where('id', $data->Appointment_Type)->pluck('name')->first();
                                        if ($data->therapist->image != NULL) {
                                        $img = asset('assets/uploads/therapist/' . $data->therapist->image);
                                        } else {
                                        if ($data->therapist->gender == 'MALE') {
                                        $img = asset('assets/img/male-avatar.jpg');
                                        } else {
                                        $img = asset('assets/img/female-avatar.webp');
                                        }
                                        }

                                        @endphp

                                        <div class="row">
                                            <div class="col-lg-6 col-md-4" style="background:#081269;">
                                                <div class="profile-user-box">
                                                    <div class="profile-user-img">
                                                        <a href="{{route('admin.view-therapist', ['slug' => $data->therapist->slug]) }}">
                                                            <img src="{{$img}}" alt="Profile">
                                                            <div class="form-group doctor-up-files profile-edit-icon mb-0">
                                                                <div class="uplod d-flex">

                                                                    <!-- <label class="file-upload profile-upbtn mb-0">
                                                                    <img src="{{$img}}" alt="Profile"></i><input type="file">
                                                                </label> -->
                                                                </div>
                                                            </div>
                                                        </a>
                                                    </div>
                                                    <div class="names-profiles">
                                                        <h4>{{$data->therapist->prefix}} {{$data->therapist->full_name }}</h4>
                                                        <h5>{{$data->therapist->designation}}</h5>

                                                    </div>
                                                </div>
                                            </div>
                                            <div class="col-lg-6 col-md-4 d-flex align-items-center" style="background:#ffcf00;">
                                                <div class="follow-group">
                                                    <div class="doctor-follows">
                                                        <img src="{{asset('assets/img/icons/menu-icon-05.svg')}}" alt="calender">
                                                        <h4>{{date('d M Y', strtotime($data->Appointment_Date))}}</h4>
                                                    </div>
                                                    <div class="doctor-follows">
                                                        <img src="{{asset('assets/img/icons/menu-icon-14.svg')}}" alt="calender">
                                                        <h4>{{$data->Appointment_Time}}</h4>
                                                    </div>
                                                    <div class="doctor-follows">
                                                        <img src="{{asset('assets/img/icons/chat-icon-01.svg')}}" alt="calender">
                                                        <h4>{{$type}}</h4>
                                                    </div>
                                                </div>
                                            </div>

                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-lg-6">
                            <div class="doctor-personals-grp">
                                <div class="card">
                                    <div class="card-body">
                                        <div class="tab-content-set row">
                                            <div class="col-md-6">
                                                <ul class="nav">
                                                    <li>
                                                        <a class="active"><span class="set-about-icon me-2">
                                                                <img src="{{asset('assets/img/icons/menu-icon-05.svg')}}" alt></span>Appoinment Details</a>
                                                    </li>
                                                </ul>
                                            </div>
                                            @if($data->consultationNote!=null)
                                            <div class="col-md-6">
                                                <a href="{{ route('admin.download-consultation-note', ['id' => $data->consultationNote->id]) }}" style="float:right;" class="btn btn-info " target="_blank"><i class="fa fa-download"></i></a>
                                            </div>
                                            @endif
                                        </div>

                                        <div class="about-me-list">
                                            <ul class="list-space">
                                                <li>
                                                    <h4>Appointment</h4>
                                                    <span>{{$data->session_id}}
                                                    </span>
                                                </li>
                                                <li>
                                                    <h4>User</h4>
                                                    @php
                                                    if (empty($data->user)) {
                                                    $img = asset('assets/img/male-avatar.jpg');
                                                    $name = "USER";
                                                    } else {
                                                    if ($data->user->image != NULL) {
                                                    $img = asset('assets/uploads/user/' . $data->user->image);
                                                    $name = $data->user->First_Name . $data->user->Last_Name;
                                                    } else {
                                                    $name = $data->user->First_Name;
                                                    if ($data->user->Gender == 'MALE' || $data->user->Gender == 'M') {
                                                    $img = asset('assets/img/male.png');
                                                    } elseif ($data->user->Gender == 'FEMALE' || $data->user->Gender == 'F') {
                                                    $img = asset('assets/img/female.png');
                                                    } else {
                                                    $img = asset('assets/img/other.png');
                                                    }
                                                    }
                                                    }
                                                    @endphp
                                                    <span>
                                                        <div class=" d-flex align-items-center">
                                                            <div class="img-users call-user">
                                                                <a href="{{route('admin.view-user', ['slug' => $data->user->id])}}"><img src="{{$img }}" alt="img"></a>
                                                            </div>
                                                            <div class="chat-users">
                                                                <div class="user-titles d-flex">
                                                                    <h5>{{$data->user->First_Name }} {{$data->user->Last_Name}} </h5>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </span>
                                                </li>

                                                <li>
                                                    <h4>Status</h4>
                                                    <span><button class="custom-badge status-pink">{{$data->Appointment_Status}}</button>
                                                    </span>
                                                </li>
                                                <li>
                                                    <h4>Date</h4>
                                                    <span>{{date('d M Y', strtotime($data->Appointment_Date)) }}</span>
                                                </li>
                                                <li>
                                                    <h4>Time</h4>
                                                    <span>{{ $data->Appointment_Time}}</span>
                                                </li>
                                                <li>
                                                    <h4>Type</h4>
                                                    <span>{{ $type }}</span>
                                                </li>
                                                <li>
                                                    <h4>Booked Date</h4>
                                                    <span>{{$data->Appointment_Booked_Date }}</span>
                                                </li>

                                                <li>
                                                    <h4>Booked Time</h4>
                                                    <span>{{ $data->Appointment_Booked_Time}}</span>
                                                </li>
                                                <li>
                                                    <h4>Service</h4>
                                                    <span>{{ $data->service->service_name}}</span>
                                                </li>
                                                <li>
                                                    <h4>Fee</h4>
                                                    <span>{{ $data->fee}}</span>
                                                </li>
                                                <li>
                                                    <h4>Context</h4>
                                                    <span>{{ $data->context}}</span>
                                                </li>

                                                @if($data->Appointment_Status=='Completed')
                                                @php

                                                $time=App\Models\PatientCallLog::where('appoinment_id',$data->id)->first();
                                                if($time!=null){
                                                $datetime_1 = $time->joinin_time;
                                                $datetime_2 = $time->joinout_time;

                                                $from_time = strtotime($datetime_1);
                                                $to_time = strtotime($datetime_2);
                                                $diff_minutes = round(abs($from_time - $to_time) / 60,2). " minutes";
                                                }
                                                @endphp
                                                @if($time!=null)
                                                <li>
                                                    <h4>Call Duration</h4>
                                                    <span>{{ $diff_minutes}}</span>
                                                </li>
                                                @endif
                                                @endif
                                                @if($data->package_id)
                                                <li>
                                                    <h4>Package</h4>
                                                    <span><a href="{{route('admin.view-packages', ['slug' => $data->package->slug])}}" target="_blank">{{ $data->package->title}}</a></span>
                                                </li>
                                                @endif
                                            </ul>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            @if(count($data->review)>0)


                            <div class="doctor-personals-grp">
                                <div class="card">
                                    <div class="card-body">
                                        <div class="tab-content-set">
                                            <ul class="nav">
                                                <li>
                                                    <a href="javascript:void(0);" class="active"><span class="set-about-icon me-2">
                                                            <img src="{{asset('assets/img/icons/doctor-dash-02.svg')}}" alt></span>Review</a>
                                                </li>

                                            </ul>
                                        </div>
                                        <div class="personal-list-out">
                                            <div class="row">

                                                @foreach($data->review as $item)
                                                <div class="treat-box mb-2">
                                                    <div class="user-imgs-blk">

                                                        <div class="active-user-detail flex-grow-1">
                                                            @php
                                                            $bal=5 - $item->rate;

                                                            @endphp


                                                            @for($i=0; $i < $item->rate; $i++)
                                                                <i class="fa-solid fa-star m-r-5 status-orange"></i>
                                                                @endfor
                                                                @if($item->rate < 5) @for ($i=0; $i < $bal; $i++) <i class="fa-solid fa-star m-r-5"></i>
                                                                    @endfor
                                                                    @endif
                                                                    <div class="hello-park">
                                                                        <p>{{$item->comment}}</p>
                                                                    </div>
                                                        </div>
                                                    </div>
                                                    <small>{{$item->created_at}}</small>
                                                </div>


                                                @endforeach
                                                <!-- <div class="hello-park">
                                                   
                                                </div> -->
                                            </div>
                                        </div>

                                    </div>
                                </div>
                            </div>
                            @endif
                        </div>
                        <div class="col-lg-6">
                            <div class="doctor-personals-grp">
                                <div class="card">
                                    <div class="card-body">
                                        <div class="tab-content-set row">
                                            <div class="col-md-6">
                                                <ul class="nav">
                                                    <li>
                                                        <a class="active"><span class="set-about-icon me-2">
                                                                <img src="{{asset('assets/img/icons/menu-icon-05.svg')}}" alt></span>Payment Details</a>
                                                    </li>
                                                </ul>
                                            </div>

                                            <div class="col-md-6">
                                                  @if($data->Appointment_Status!='Failed' && $data->invoice_number!=NULL)
                                                <a href="{{route('admin.invoice',['id'=>$data->id])}}" target="_blank" style="float:right;" class="btn btn-info " target="_blank"><i class="fa fa-download"></i></a>
                                           @endif
                                            </div>

                                        </div>

                                        <div class="about-me-list">
                                            @if($data->payment_status=='Unpaid')
                                             <ul class="list-space">
                                                  <li>
                                                    <h4>Payment Status</h4>
                                                    <span>{{ $data->payment_status}}</span>
                                                </li>
                                                <li>
                                                    <h4>Order ID</h4>
                                                    <span>{{ $data->razorpay_order_id}}
                                                        <br><br>
                                                        <a href="{{route('admin.check_payment_status', ['id' => $data->id])}}"><u>Check Payment Status</u></a>
                                                    </span>
                                                </li>
                                             </ul>
                                           
                                            @else
                                            <ul class="list-space">
                                                <li>
                                                    <h4>Payment Method</h4>
                                                    <span>@if($data->wallet_trasaction_id!=NULL && $data->payment_id!=NULL)
                                                        Razropay and Wallet Transaction
                                                        @elseif($data->payment_id!=NULL)
                                                        Razropay
                                                        @elseif($data->wallet_trasaction_id)
                                                        Wallet
                                                        @endif
                                                    </span>
                                                </li>
                                                @if($data->payment_id!=NULL)
                                                @php
                                                $p=App\Models\PaymentDetails::where('id',$data->payment_id)->first();

                                                // Convert the Unix timestamp to a Carbon instance
                                                $paymentDate = Carbon\Carbon::createFromTimestamp($p->payment_date);

                                                // Format the date as needed (e.g., 'Y-m-d H:i:s' for '2024-08-02 14:30:00')
                                                $formattedDate = $paymentDate->format('Y-m-d H:i:s');
                                                @endphp
                                                <li>
                                                    <h4>Payment ID</h4>
                                                    <span>{{$p->payment_id}}</button>
                                                    </span>
                                                </li>
                                                <li>
                                                    <h4>Amount in currency</h4>
                                                    <span>{{$p->amount_in_currency }}</span>
                                                </li>
                                                <li>
                                                    <h4>Total amount in Rupee</h4>
                                                    <span>{{ $p->total_amount_in_rupee}}</span>
                                                </li>
                                                <li>
                                                    <h4>Currency</h4>
                                                    <span>{{ $p->currency }}</span>
                                                </li>
                                                <li>
                                                    <h4>Payment Method</h4>
                                                    <span>{{$p->payment_method }}</span>
                                                </li>

                                                <li>
                                                    <h4>Payment Status</h4>
                                                    <span>{{ $p->payment_status}}</span>
                                                </li>
                                                <li>
                                                    <h4>Payment Date</h4>
                                                    <span>{{ $formattedDate}}</span>
                                                </li>
                                                @endif
                                                @if($data->wallet_trasaction_id!=NULL)
                                                @php
                                                $w=App\Models\UserWalletTransactions::where('id',$data->wallet_trasaction_id)->first();
                                                @endphp
                                                <li>
                                                    <h4>Wallet Amount</h4>
                                                    <span>{{ $w->amount}}</span>
                                                </li>
                                                @endif


                                            </ul>
                                            @endif
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div class="doctor-personals-grp">
                                <div class="card">
                                    <div class="card-body">
                                        <div class="tab-content-set row">
                                            <div class="col-md-6">
                                                <ul class="nav">
                                                    <li>
                                                        <a class="active"><span class="set-about-icon me-2">
                                                                <img src="{{asset('assets/img/icons/doctor-dash-02.svg')}}" alt></span>Consultation Note</a>
                                                    </li>
                                                </ul>
                                            </div>
                                            <div class="col-md-6">

                                                @if($data->consultationNote==null)
                                                <button type="submit" style="float:right;" class="btn btn-success " data-bs-toggle="modal" data-bs-target="#addConsultationModal"><i class="far fa-plus"></i></button>
                                                @else
                                                <a href="{{asset('assets/uploads/consultation/' . $data->consultationNote->attachment)}}" style="float:right;" class="btn btn-info " target="_blank" download="eConsultation_{{$data->user->First_Name}}{{$data->user->Last_Name}}_00{{$data->id}}{{$data->user->id}}"><i class="fa fa-download"></i></a>
                                                <!-- <a href="{{ route('admin.download-consultation-note', ['id' => $data->consultationNote->id]) }}" style="float:right;" class="btn btn-info " target="_blank" download="eConsultation_{{$data->user->First_Name}}{{$data->user->Last_Name}}_00{{$data->id}}{{$data->user->id}}"><i class="fa fa-download"></i></a> -->
                                                <button type="submit" style="float:right;" class="btn btn-success " data-bs-toggle="modal" data-bs-target="#addConsultationModal"><i class="far fa-edit"></i></button>
                                                @endif
                                            </div>
                                        </div>
                                        <div class="personal-list-out">
                                            <div class="row">
                                                <div class="hello-park">
                                                    @if($data->consultationNote)
                                                    {{$data->consultationNote->note}}
                                                    @endif
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div class="doctor-personals-grp">
                                <div class="card">
                                    <div class="card-body">
                                        <div class="tab-content-set row">
                                            <div class="col-md-6">
                                                <ul class="nav">
                                                    <li>
                                                        <a href="javascript:void(0);" class="active"><span class="set-about-icon me-2">
                                                                <img src="{{asset('assets/img/icons/doctor-dash-02.svg')}}" alt></span>Prescription Note </a>
                                                    </li>

                                                </ul>
                                            </div>
                                            <div class="col-md-6">
                                                @if($data->prescription==null)
                                                <button type="submit" style="float:right;" class="btn btn-success " data-bs-toggle="modal" data-bs-target="#addPrescriptionModal"><i class="far fa-plus"></i></button>
                                                @else

                                                <a href="{{asset('assets/uploads/prescription/' . $data->prescription->attachment)}}" style="float:right;" class="btn btn-info " target="_blank" download="ePrescription_{{$data->user->First_Name}}{{$data->user->Last_Name}}_00{{$data->id}}{{$data->user->id}}"><i class="fa fa-download"></i></a>
                                                <button type="submit" style="float:right;" class="btn btn-success " data-bs-toggle="modal" data-bs-target="#addPrescriptionModal"><i class="far fa-edit"></i></button>
                                                @endif
                                            </div>
                                        </div>
                                        <div class="personal-list-out">
                                            <div class="row">
                                                <div class="hello-park">
                                                    @if($data->prescription)
                                                    {{$data->prescription->note}}
                                                    @endif
                                                </div>
                                            </div>
                                        </div>

                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

            </div>
        </div>

        <div id="reshedulemodal" class="modal fade" role="dialog">
            <div class="modal-dialog modal-dialog-centered modal-lg">
                <div class="modal-content">
                    <div class="modal-header">
                        <h3 class="modal-title">Reshedule Appoinment</h3>

                    </div>
                    <div class="modal-body text-center">
                        <form method="post" action="{{ route('admin.reshedule-appoinment') }}">
                            <!-- <form id="reshedule_form" action="{{ route('admin.reshedule-appoinment') }}"> -->
                            @csrf
                            <div class="row">
                                <div class="doctor-table-blk mb-3">
                                    <h5>Select Date and Time</h5>
                                </div>

                                <div class="col-12 col-md-6 col-xl-6">
                                    <div class="form-group local-forms row">

                                        @php

                                        $booking_date = str_replace('-', '/', $data->Appointment_Date);

                                        $booking_date = date("d/m/Y", strtotime($booking_date));
                                        @endphp
                                        <input class="form-control datetimepicker" name="booking_date" value="{{$booking_date}}" type="text" placeholder>
                                        <input type="hidden" name="slot_id">
                                        <input type="hidden" name="slot">
                                        <input type="hidden" name="appoinment_id" value="{{$data->id}}">
                                    </div>
                                    <div class="form-group local-forms row">
                                        <button class="btn btn-info search_slot">Search Slots</button>
                                    </div>
                                </div>

                                <div class="col-sm-6 col-lg-6 col-xl-6 d-flex">
                                    <div class="row text-center" id="slot-div" style="width:100%;">

                                    </div>
                                </div>



                            </div>
                            <!-- <div class="row m-t-20">
                                <div class=" col-12 col-md-12 col-xl-12">
                                    <div class="form-group local-forms">
                                        <label>Specialization</label>
                                        <input class="form-control" required name="tag" type="text">
                                    </div>
                                </div>
                            </div>-->
                            <div class="m-t-20"> <a href="#" class="btn btn-white" data-bs-dismiss="modal">Close</a>
                                <button type="submit" class="btn btn-success ">Submit</button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
        <div id="transferSheduleModal" class="modal fade" role="dialog">
            <div class="modal-dialog modal-dialog-centered modal-lg">
                <div class="modal-content">
                    <div class="modal-header">
                        <h3 class="modal-title">Transfer Appoinment</h3>

                    </div>
                    <div class="modal-body text-center">
                        <form method="post" action="{{ route('admin.reshedule-appoinment') }}">
                            <!-- <form id="reshedule_form" action="{{ route('admin.reshedule-appoinment') }}"> -->
                            @csrf
                            <div class="row">
                                <div class="col-12 col-md-12 col-xl-12">
                                    <div class="row text-center" id="search-div">
                                    </div>
                                </div>
                                <div class="doctor-table-blk mb-3">
                                    <h3>Select Date and Time</h3>
                                </div>


                                <div class="col-12 col-md-6 col-xl-6">
                                    <div class="form-group local-forms row">

                                        @php

                                        $booking_date = str_replace('-', '/', $data->Appointment_Date);

                                        $booking_date = date("d/m/Y", strtotime($booking_date));
                                        @endphp
                                        <input class="form-control datetimepicker" name="booking_date_transfer" value="{{$booking_date}}" type="text" placeholder>
                                        <input type="hidden" name="slot_id_transfer">
                                        <input type="hidden" name="slot_transfer">
                                        <input type="hidden" name="therapist_id">
                                        <input type="hidden" name="appoinment_id" value="{{$data->id}}">
                                    </div>
                                    <div class="form-group local-forms row">
                                        <button class="btn btn-info search_slot">Search Slots</button>
                                    </div>
                                </div>

                                <div class="col-sm-6 col-lg-6 col-xl-6 d-flex">
                                    <div class="row text-center" id="slot-div" style="width:100%;">

                                    </div>
                                </div>



                            </div>
                            <!-- <div class="row m-t-20">
                                <div class=" col-12 col-md-12 col-xl-12">
                                    <div class="form-group local-forms">
                                        <label>Specialization</label>
                                        <input class="form-control" required name="tag" type="text">
                                    </div>
                                </div>
                            </div>-->
                            <div class="m-t-20"> <a href="#" class="btn btn-white" data-bs-dismiss="modal">Close</a>
                                <button type="submit" class="btn btn-success ">Submit</button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
        <div id="delete_patient" class="modal fade delete-modal" role="dialog">
            <div class="modal-dialog modal-dialog-centered">
                <div class="modal-content">
                    <div class="modal-body text-center">
                        <img src="assets/img/sent.png" alt width="50" height="46">
                        <h3>Are you sure want to delete this ?</h3>
                        <div class="m-t-20"> <a href="#" class="btn btn-white" data-bs-dismiss="modal">Close</a>
                            <button type="submit" class="btn btn-danger" id="delete_item">Delete</button>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div id="addConsultationModal" class="modal fade delete-modal" role="dialog">
            <div class="modal-dialog modal-dialog-centered">
                <div class="modal-content">
                    <div class="modal-header">
                        <h4 class="modal-title">Add Consultation Note</h4>

                    </div>
                    <div class="modal-body text-center">

                        <form id="consulation_form" action="{{ route('admin.add-consulation') }}">
                            @csrf
                            <div class="row">
                                <div class="row m-t-20">
                                    <div class=" col-12 col-md-12 col-xl-12">
                                        <div class="form-group local-forms">
                                            <input type="hidden" value="{{$data->id}}" name="appoinment_id">
                                            <input type="hidden" value="{{$data->therapist_id}}" name="therapist_id">
                                            <input type="hidden" value="{{$data->user_id}}" name="user_id">
                                            <label>Note</label>
                                            @if($data->consultationNote==null)
                                            <textarea class="form-control" name="note"></textarea>
                                            @else
                                            <input type="hidden" value="{{$data->consultationNote->id}}" name="id">
                                            <textarea class="form-control" name="note"> {{$data->consultationNote->note}}</textarea>
                                            @endif

                                        </div>
                                    </div>

                                    <div class=" col-12 col-md-12 col-xl-12">
                                        <div class="form-group local-forms">
                                            <label>Attachment</label>
                                            <input type="file" name="attachment" class="form-control">

                                        </div>
                                    </div>
                                </div>

                            </div>

                            <div class="m-t-20"> <a href="#" class="btn btn-white" data-bs-dismiss="modal">Close</a>
                                <button type="submit" class="btn btn-success ">Submit</button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>

        <div id="addPrescriptionModal" class="modal fade delete-modal" role="dialog">
            <div class="modal-dialog modal-dialog-centered">
                <div class="modal-content">
                    <div class="modal-header">
                        <h4 class="modal-title">Add Prescription Note</h4>

                    </div>
                    <div class="modal-body text-center">
                        <!-- <form method="post" action="{{ route('admin.add-prescription') }}"> -->

                        <form id="prescription_form" action="{{ route('admin.add-prescription') }}">
                            @csrf
                            <div class="row">
                                <div class="row m-t-20">
                                    <div class=" col-12 col-md-12 col-xl-12">
                                        <div class="form-group local-forms">
                                            <input type="hidden" value="{{$data->id}}" name="appoinment_id">
                                            <input type="hidden" value="{{$data->therapist_id}}" name="therapist_id">
                                            <input type="hidden" value="{{$data->user_id}}" name="user_id">
                                            <label>Note</label>
                                            @if($data->prescription==null)
                                            <!-- <textarea class="form-control" name="note"></textarea> -->
                                            <input type="file" name="attachment" class="form-control">
                                            @else
                                            <input type="hidden" value="{{$data->prescription->id}}" name="id">
                                            <input type="file" name="attachment" class="form-control">
                                            <!-- <textarea class="form-control" name="note"> {{$data->prescription->note}}</textarea> -->
                                            @endif

                                        </div>
                                    </div>
                                </div>

                            </div>

                            <div class="m-t-20"> <a href="#" class="btn btn-white" data-bs-dismiss="modal">Close</a>
                                <button type="submit" class="btn btn-success ">Submit</button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
    </div>

    <script>
        $(document).on('click', '#delete_item', function(e) {
            var id = "<?php echo $data->id; ?>";
            var url = "{{route('admin.appoinments')}}"
            e.preventDefault();
            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });
            $.ajax({
                url: "{{ route('admin.delete-appoinment') }}",
                method: "GET",
                data: {
                    'id': id
                },
                success: function(result) {
                    $('#delete_patient').modal('hide');

                    if (result == 1) {
                        toastr.success("Appoinment Deleted Successfully.");
                        window.location.href = url;
                    } else {
                        toastr.error("Something went wrong.");
                    }

                }
            });

        });
        $('body').on('click', '.changeStatus', function(e) {
            var id = "<?php echo $data->id; ?>";
            var status = $(this).data('value');
            e.preventDefault();
            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });
            $.ajax({
                url: "{{ route('admin.change-appoinment-status') }}",
                method: "GET",
                data: {
                    'id': id,
                    'status': status
                },
                success: function(result) {

                    if (result == 1) {
                        toastr.success("Status Changed Successfully.");
                        location.reload();
                    } else {
                        toastr.error("Something went wrong.");
                    }



                }
            });

        });

        $(document).on('click', ".search_slot", function(e) {
            e.preventDefault();
            bookingDate = $("input[name=booking_date]").val();
            callmethod = "<?php echo $data->Appointment_Type; ?>";
            service = "<?php echo $data->service_id; ?>";
            therapist = "<?php echo $data->therapist_id; ?>";
            user = "<?php echo $data->user_id; ?>";
            slots(bookingDate, callmethod, service, therapist,user);

        });

        function slots(bookingDate, callmethod, service, therapist,user) {
            $("#js-loader").fadeIn(300);

            $.ajax({
                url: "{{ route('admin.search-slots') }}",
                method: "GET",
                data: {
                    'bookingDate': bookingDate,
                    'therapist': therapist,
                    'service': service,
                    'callmethod': callmethod,
                    'user_id':user
                },
                success: function(result) {
                    $("#js-loader").fadeOut(300);
                    $("input[name=call_type]").val(callmethod);
                    $('#slot-div').html(result);
                    $('#slot-li').addClass('active');
                    $('#slot').addClass('active');
                    $('#consulation').removeClass('active');
                    // booking();
                }
            });

            $(document).on('click', ".slot-btn", function(e) {
                e.preventDefault();
                slot_id = $(this).data('id');
                slot = $(this).data('value');
                $(".slot-btn").removeClass("btn-n-active");
                $(this).addClass("btn-n-active");
                $("input[name=slot_id]").val(slot_id);
                $("input[name=slot]").val(slot);
            });

        }
        $(document).ready(function(e) {

            bookingDate = $("input[name=booking_date]").val();
            callmethod = "<?php echo $data->Appointment_Type; ?>";
            service = "<?php echo $data->service_id; ?>";
            therapist = "<?php echo $data->therapist_id; ?>";
            user = "<?php echo $data->user_id; ?>";
            slots(bookingDate, callmethod, service, therapist,user);
        });
        $('#prescription_form').submit(function(e) {
            e.preventDefault();
            var url = $(this).attr("action");
            let formData = new FormData(this);
            $("#js-loader").fadeIn();
            $.ajax({
                type: 'POST',
                url: url,
                data: formData,
                contentType: false,
                processData: false,
                success: function(result) {
                    $("#js-loader").fadeOut();
                    if (result.status == true) {
                        toastr.success(result.data);
                        location.reload();
                    } else if (result.status == false) {
                        toastr.error(result.data);
                    }
                },
                error: function(err) {
                    // Your Error Message
                    toastr.error(err.data);
                }
            });
        });
        $('#consulation_form').submit(function(e) {
            e.preventDefault();
            var url = $(this).attr("action");
            let formData = new FormData(this);
            $("#js-loader").fadeIn();
            $.ajax({
                type: 'POST',
                url: url,
                data: formData,
                contentType: false,
                processData: false,
                success: function(result) {
                    $("#js-loader").fadeOut();
                    if (result.status == true) {
                        toastr.success(result.data);
                        location.reload();
                    } else if (result.status == false) {
                        toastr.error(result.data);
                    }
                },
                error: function(err) {
                    // Your Error Message
                    toastr.error(err.data);
                }
            });
        });
    </script>
    @endsection