@extends('admin.layout.dashboard-template')
@section('content')
<div class="page-wrapper">
    <div class="content">

        <div class="page-header">
            <div class="row">
                <div class="col-sm-12">
                    <ul class="breadcrumb">
                        <li class="breadcrumb-item active">Roles</li>
                    </ul>
                </div>
            </div>
        </div>

        <div class="row">
            <div class="col-sm-12">
                <div class="card card-table show-entire">
                    <div class="card-body">

                        <div class="page-table-header mb-2">
                            <div class="row align-items-center">
                                <div class="col">
                                    <div class="doctor-table-blk">
                                        <h3>Roles</h3>
                                        <div class="doctor-search-blk">
                                            <div class="add-group">
                                                <a href="javascript:void(0);" data-bs-toggle="modal" data-bs-target="#add_roles" class="btn btn-primary add-pluss ms-2"><img src="{{asset('assets/img/icons/plus.svg')}}" alt></a>

                                            </div>
                                        </div>
                                    </div>
                                </div>

                            </div>
                        </div>

                        <div class="table-responsive">
                            <table class="table border-0 custom-table comman-table mb-0" id="role_table">
                                <thead>
                                    <tr>
                                        <th>
                                            #
                                        </th>
                                        <th>Roles</th>
                                        <th>ACTION</th>
                                    </tr>
                                </thead>
                                <tbody>

                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div id="add_roles" class="modal fade" role="dialog">
        <div class="modal-dialog modal-dialog-centered modal-lg">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Add Role</h5>

                </div>
                <div class="modal-body ">
                    <form id="roles_form" action="{{ route('admin.save-role') }}">
                        @csrf
                        <div class="row m-t-20">
                            <div class=" col-12 col-md-12 col-xl-12">
                                <div class="form-group local-forms">
                                    <label>Role<span class="login-danger">*</span></label>
                                    <input class="form-control" required name="name" type="text">
                                </div>
                            </div>

                            <div class=" col-12 col-md-12 col-xl-12 ">
                                <div class="form-group local-forms row mb-5">
                                    <label>Permissions<span class="login-danger">*</span></label>
                                    @foreach($permission as $value)
                                    <div class="col-4 col-md-4 col-xl-4 mt-sm-2">
                                        <input type="checkbox" name="permission[]" class="form-check-input" value="{{ $value->id }}"> {{ $value->name }}
                                    </div>
                                    @endforeach
                                </div>
                            </div>
                        </div>
                        <div class="m-t-20"> <a href="#" class="btn btn-white" data-bs-dismiss="modal">Close</a>
                            <button type="submit" class="btn btn-success ">ADD</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>

    <div id="edit_role" class="modal fade" role="dialog">
        <div class="modal-dialog modal-dialog-centered modal-lg">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Edit Role</h5>
                </div>
                <div class="modal-body ">
                    <form id="edit_roles_form" action="{{ route('admin.update-role') }}">
                        @csrf
                        <div class="col-12" id="edithtml"></div>
                    </form>
                </div>
            </div>
        </div>
    </div>
    <div id="delete_role" class="modal fade delete-modal" role="dialog">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-body text-center">
                    <img src="{{asset('assets/img/sent.png')}}" alt width="50" height="46">
                    <h3>Are you sure want to delete this ?</h3>
                    <div class="m-t-20"> <a href="#" class="btn btn-white" data-bs-dismiss="modal">Close</a>
                        <button type="submit" class="btn btn-danger" id="delete_item">Delete</button>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <script type="text/javascript">
        $(function() {
            $('#role_table').DataTable({
                processing: true,
                serverSide: true,
                ajax: "{{ route('admin.get-role') }}",
                columns: [{
                    data: 'DT_RowIndex',
                    name: 'DT_RowIndex'
                }, {
                    data: 'tag',
                    name: 'tag'
                }, {
                    data: 'action',
                    name: 'action',
                    orderable: false,
                    searchable: false
                }, ],
                "select": {
                    'style': 'multi',
                    'selector': 'td:first-child' //only checkbox can select row 
                },
            });

        });
        $(document).on('click', '.edit_role', function() {
            $('#edit_role').modal('show');
            var id = $(this).data('id');
            $("#js-loader").fadeIn();
            $.ajax({
                url: "{{ route('admin.edit-role') }}",
                method: "GET",
                data: {
                    'id': id
                },
                success: function(result) {
                    $("#js-loader").fadeOut();
                    $('#edithtml').html(result);
                }
            });
        });


        var deleteID;
        $('body').on('click', '#getDeleteId', function() {
            deleteID = $(this).data('id');
        })
        $(document).on('click', '#delete_item', function(e) {
            var id = deleteID;
            e.preventDefault();
            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token" ]').attr('content')
                }
            });
            $.ajax({
                url: "{{ route('admin.delete-role') }}",
                method: "GET",
                data: {
                    'id': id
                },
                success: function(result) {
                    $('#delete_role').modal('hide');
                    $('.table').DataTable().ajax.reload();
                    if (result == 1) {
                        toastr.success("Data Deleted Successfully.");
                    } else {
                        toastr.error("Something went wrong.");
                    }
                    $('.table').DataTable().ajax.reload();
                }
            });
        });

        $('#roles_form').submit(function(e) {
            e.preventDefault();
            var url = $(this).attr("action");
            let formData = new FormData(this);
            $("#js-loader").fadeIn();
            $.ajax({
                type: 'POST',
                url: url,
                data: formData,
                contentType: false,
                processData: false,
                success: function(data) {
                    $('.table').DataTable().ajax.reload();
                    $("#js-loader").fadeOut();
                    if (data.status == true) {
                        toastr.success(data.msg);
                    } else {
                        toastr.error(data.msg);
                    }
                },
                error: function(err) { // Your Error Message
                    toastr.error(err);
                }
            });
        });



        $('#edit_roles_form').submit(function(e) {
            e.preventDefault();
            var url = $(this).attr("action");
            let formData = new FormData(this);
            $("#js-loader").fadeIn();
            $.ajax({
                type: 'POST',
                url: url,
                data: formData,
                contentType: false,
                processData: false,
                success: function(data) {
                    $('.table').DataTable().ajax.reload();
                    $("#js-loader").fadeOut();
                    if (data.status == true) {
                        toastr.success(data.msg);
                    } else {
                        toastr.error(data.msg);
                    }
                },
                error: function(err) { // Your Error Message
                    toastr.error(err);
                }
            });
        });
    </script>
    @endsection