<?php
function days()
{
    $data = ['Sunday', 'Monday', 'Tuesday', 'Wednesday', 'Thursday', 'Friday', 'Saturday'];
    return $data;
}

function statusColor($status)
{
    if ($status == 'Awaiting') {
        $color = '#ffbc34';
    } else if ($status == 'Confirm') {
        $color = '#009efb';
    } else if ($status == 'Cancel') {
        $color = '#f62d51';
    } else if ($status == 'Completed') {
        $color = '#55ce63';
    } else if ($status == 'Resheduled') {
        $color = '#009efb';
    } else if ($status == 'Rejected') {
        $color = '#6c757d';
    } else if ($status == 'Join') {
        $color = '#facc06';
    } else if ($status == 'Incall') {
        $color = '#22a531';
    } else if ($status == 'Missed') {
        $color = '#c0223e';
    }


    return $color;
}
function slots($startTime, $breakTime, $endTime)
{
    $slots = [];

    $period = new Carbon\CarbonPeriod($startTime, $breakTime, $endTime); // for create use 24 hours format later change format 

    foreach ($period as $item) {
        array_push($slots, $item->format("h:i A"));
    }
    return $slots;
}

function completedPackagesessions($package_id, $therapist_id, $user_id)
{
    $c = App\Models\Appointments::select(Illuminate\Support\Facades\DB::raw('count(*) as total'))
        ->where('therapist_id', $therapist_id)
        ->where('package_id', $package_id)
        ->where('user_id', $user_id)
        ->where('Appointment_Status', 'Completed')
        ->groupBy('package_id')
        ->get();

    return count($c);
}
