<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Coupons;
use Cviebrock\EloquentSluggable\Services\SlugService;
use Illuminate\Database\QueryException;
use Yajra\DataTables\Facades\DataTables;
use Carbon\Carbon;

class CouponController extends Controller
{
    public function index()
    {
        return view('admin.coupons.list');
    }
    public function viewCoupons(Request $request)
    {
        $data = Coupons::where('id', $request->id)->first();
        if ($data->discount_type == '%') {
            $price = $data->discount_rate . $data->discount_type;
        } else {
            $price = $data->discount_type . $data->discount_rate;
        }
        $html = '<div class="card-box profile-header">
<div class="row">
<div class="col-md-12">
<div class="profile-view">
<div class="profile-img-wrap">
<div class="profile-img">
<a href="#"><img class="avatar" src="' . asset('assets/uploads/Couponss/' . $data->image) . '" alt=""></a>
</div>
</div>
<div class="profile-basic">
<div class="row">
<div class="col-md-5">
<div class="profile-info-left">
  <h3 class="user-name m-t-0 mb-0">' . $data->title . '</h3>
                                                    <small class="text-muted">' . $data->promo_code . '</small>
                                                    <div class="staff-id">Expiry Date : ' . date('d l Y', strtotime($data->expiry_date)) . '</div>
                                                    <div class="staff-msg"><a href="javascript:void(0);" class="status-pink">' . $price . '</a></div>
</div>
</div>
<div class="col-md-7">
<small>
' . $data->description . '
</small>
</div>
</div>
</div>
</div>
</div>
</div>
</div>';
        return  response()->json($html);
    }
    public function editCoupon(Request $request)
    {
        $data = Coupons::where('slug', $request->slug)->first();
        return view('admin.coupons.edit', ['data' => $data]);
    }
    public function saveCoupon(Request $request)
    {

        try {
            $request->validate([
                'title' => 'required',
                'promo_code' => 'required',
                'expiry_date' => 'required',
                'discount_type' => 'required',
                'discount_rate' => 'required',
                'start_date' => 'required'
            ]);

            $slug = SlugService::createSlug(Coupons::class, 'slug', $request->title);

            $start_date = str_replace('/', '-', $request->start_date);
            $start_date = date("Y-m-d", strtotime($start_date));

            $expiry_date = str_replace('/', '-', $request->expiry_date);
            $expiry_date = date("Y-m-d", strtotime($expiry_date));

            $booking_date = str_replace('/', '-', $request->bookingDate);
            $booking_date = date("Y-m-d", strtotime($booking_date));
            $Coupons = new Coupons();
            $Coupons->title = $request->title;
            $Coupons->slug = $slug;
            $Coupons->promo_code = $request->promo_code;
            $Coupons->discount_type = $request->discount_type;
            $Coupons->discount_rate = $request->discount_rate;
            $Coupons->start_date = $start_date;
            $Coupons->expiry_date = $expiry_date;
            $Coupons->save();

            if (!$Coupons) {
                return false;
            } else {
                return true;
            }
        } catch (QueryException $e) {
            return $e->getMessage();
        }
    }
    public function updateCoupon(Request $request)
    {
        try {
            $request->validate([
                'title' => 'required',
                'promo_code' => 'required',
                'expiry_date' => 'required',
                'discount_type' => 'required',
                'discount_rate' => 'required',
                'expiry_date' => 'required',
                'start_date' => 'required'
            ]);

            $start_date = str_replace('/', '-', $request->start_date);
            $start_date = date("Y-m-d", strtotime($start_date));

            $expiry_date = str_replace('/', '-', $request->expiry_date);
            $expiry_date = date("Y-m-d", strtotime($expiry_date));


            $data = Coupons::where('id', $request->id)->first();
            if ($request->title != $data->title) {
                $slug = SlugService::createSlug(Coupons::class, 'slug', $request->title);
            } else {
                $slug = $data->slug;
            }

            $params = [
                'title' => $request->title,
                'slug' => $slug,
                'promo_code' => $request->promo_code,
                'discount_type' => $request->discount_type,
                'discount_rate' => $request->discount_rate,
                'start_date' => $start_date,
                'expiry_date' => $expiry_date
            ];

            // print_r($params);
            // die();
            $result = Coupons::where('id', $request->id)
                ->update(
                    $params
                );
            //  die();
            if ($result == 1) {
                return true;
            } else {
                return false;
            }
        } catch (QueryException $e) {
            return $e->getMessage();
        }
    }
    public function deleteCoupons(Request $request)
    {
        $res = Coupons::where('id', $request->id)->delete();
        return $res;
    }

    public function getCoupons(Request $request)
    {
        if ($request->ajax()) {
            $data = Coupons::orderBy('id', 'DESC')->get();
            return Datatables::of($data)
                ->addIndexColumn()
                ->addColumn('action', function ($data) {
                    $actionBtn = '<a href="javascript:void(0);"  class="text-muted" data-id="' . $data->id . '"  id="getViewId" > <span class="badge badge-primary"><i class="far fa-eye"></i></span></a>
                     <a href="' . route('admin.edit-coupons', ['slug' => $data->slug]) . '"   class="text-muted" > <span class="badge badge-success"><i class="far fa-edit"></i></span></a>
                     <a  href="javascript:void(0);" data-id="' . $data->id . '"  id="getDeleteId" class="text-muted" data-bs-toggle="modal" data-bs-target="#delete_Coupons"> <span class="badge badge-danger"><i class="far fa-trash-alt"></i></span></a>';
                    return $actionBtn;
                })
                ->addColumn('title', function ($data) {

                    $html = '<div class="chat-user-group d-flex align-items-center">                    
                        <div class="chat-users chat-user-blk">
                        <div class="user-titles ">
                        <h5> ' . $data->title . '</h5>
                        <p>Coupon Code: ' . $data->promo_code . '</p>
                        </div>
                        </div>
                        </div>';
                    return $html;
                })
                ->addColumn('start_date', function ($data) {
                    return   date('d M Y', strtotime($data->start_date));
                })
                ->addColumn('expiry_date', function ($data) {
                    return   date('d M Y', strtotime($data->expiry_date));
                })
                ->addColumn('discount', function ($data) {
                    if ($data->discount_type == '%') {
                        return   $data->discount_rate . $data->discount_type;
                    } else {
                        return   $data->discount_type . $data->discount_rate;
                    }
                })
                ->addColumn('status', function ($data) {
                    $status = '';
                    $class = '';
                    if ($data->status == 'ACTIVE') {
                        $class = "success";
                        $val = 'BLOCKED';
                    } else {
                        $class = "danger";
                        $val = 'ACTIVE';
                    }
                    return '<a href="javascript:void(0)" data-id="' . $data->id . '" data-value="' . $val . '" id="status"><span class="badge badge-' . $class . '">' . $data->status . '</span></a>';
                })
                ->escapeColumns([])

                ->make(true);
        }
    }
    public function changeCouponsStatus(Request $request)
    {
        $res = Coupons::where('id', $request->id)
            ->update(['status' => $request->status]);
        return $res;
    }
}
