<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Session;
use App\Models\Admin;
use App\Models\User;
use Illuminate\Database\QueryException;
use Validator;

class AuthController extends Controller
{
    public function checkLogin(Request $request)
    {
        try {
            $this->validate($request, [
                'email' => 'required|email',
                'password' => 'required',
            ]);

            if (auth()->guard('admin')->attempt(['email' => $request->input('email'),  'password' => $request->input('password')])) {

                $user = auth()->guard('admin')->user();

                Session::put('user', $user);

                return redirect()->route('admin.dashboard')->with('success', 'You are Logged in sucessfully.');
            } else {
                return back()->with('error', 'Whoops! invalid email and password.');
            }
        } catch (QueryException $e) {
            return response()->json(
                array(
                    'status' => false,
                    'data' => $e->getMessage()
                ),
                200
            );
            // return $e->getMessage();
        }
    }

    public function logout(Request $request)
    {
        auth()->guard('admin')->logout();
        Session::flush();
        Session::put('success', 'You are logout sucessfully');
        return redirect(route('admin.login'));
    }
    public function changePassword(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'password' => 'required|string|min:6',
            'confirm_password' => 'required'
        ]);

        if ($validator->fails()) {
            $errors = $validator->errors();
            return redirect()->back()->withErrors($errors);
        }

        if ($request->password == $request->confirm_password) {
            $res =   Admin::where('id', Session::get('user')->id)
                ->update([
                    'password' => bcrypt($request->password)
                ]);
            if ($res == 1) {
                return response()->json(
                    array(
                        'status' => true,
                        'data' => "Password updated successfully"
                    ),
                    200
                );
            } else {
                return response()->json(
                    array(
                        'status' => false,
                        'data' => "Something went wrong"
                    ),
                    200
                );
            }
        } else {
            return response()->json(
                array(
                    'status' => false,
                    'data' => "Password dose not match."
                ),
                200
            );
        }
    }

    public function verifyAccount($token)
    {

        $verifyUser = User::where('email_verify_token', $token)->first();
        $message = 'Sorry your email cannot be identified.';

        if (!is_null($verifyUser)) {

            if (!$verifyUser->is_email_verified) {
                $res =  User::where('id', $verifyUser->id)
                    ->update([
                        'is_email_verified' => 1
                    ]);

                $message = "Your e-mail is verified.";
            } else {
                $message = "Your e-mail is already verified.";
            }
        }


        return view('verify', ['message' => $message]);
    }
}
