<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('therapists', function (Blueprint $table) {
            $table->increments('id');
            $table->string('employee_id')->unique();
            $table->string('prefix');
            $table->string('full_name');
            $table->string('slug')->unique();
            $table->integer('provider_category_id')->unsigned();
            $table->json('services');
            $table->enum('slot_setting_permission', ['off', 'on'])->default('off');
            $table->integer('experience');
            $table->string('mobile')->unique();
            $table->string('email')->unique();
            $table->string('password');
            $table->date('joining_date')->nullable();
            $table->text('qualification');
            $table->string('designation');
            $table->string('language_known');
            $table->string('address');
            $table->string('city');
            $table->string('state');
            $table->string('country');
            $table->string('postal_code');
            $table->string('biography');
            $table->string('skills')->nullable();
            $table->string('awards')->nullable();
            $table->date('dob');
            $table->text('image');
            $table->enum('gender', ['MALE', 'FEMALE']);
            $table->enum('featured', ['0', '1'])->default('1');
            $table->enum('status', ['ACTIVE', 'BLOCKED'])->default('ACTIVE');
            $table->timestamp('created_at')->useCurrent();
            $table->timestamp('updated_at')->nullable()->useCurrentOnUpdate();
            $table->foreign('provider_category_id')->references('id')->on('provider_categories')->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('therapists');
    }
};
