<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Casts\Attribute;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\HasMany;

class WorkingHours extends Model
{
    use HasFactory;

    protected $fillable = [
        'slot_id', 'day', 'start_time', 'end_time'
    ];
    // protected function slots(): Attribute
    // {
    //     return Attribute::make(
    //         get: fn ($value) => json_decode($value, true),
    //         set: fn ($value) => json_encode($value),
    //     );
    // }

    public function slot(): BelongsTo
    {
        return $this->belongsTo(Slot::class);
    }
    public function service(): BelongsTo
    {
        return $this->belongsTo(Service::class);
    }
    public function slotShedule(): HasMany
    {
        return $this->hasMany(SlotShedule::class, 'slot_id');
    }
}
