<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\HasMany;

class UserWalletTransactions extends Model
{
    use HasFactory;

    public function typeOfWallet(): BelongsTo
    {
        return $this->belongsTo(TypesOfWallet::class, 'wallet_id', 'id');
    }
    public function user(): BelongsTo
    {
        return $this->belongsTo(User::class);
    }
    public function payment()
    {
        return $this->belongsTo(PaymentDetails::class);
    }
}
