<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Cviebrock\EloquentSluggable\Sluggable;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\HasMany;
use PharIo\Manifest\License;
use Laravel\Scout\Searchable;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Notifications\Notifiable;
// use Laravel\Sanctum\HasApiTokens;
use Laravel\Passport\HasApiTokens;

class Therapist extends Authenticatable
{
    use HasApiTokens, HasFactory, Notifiable;
    use Sluggable;

    protected $guard = 'therapist';
    protected $fillable = [
        'full_name',
        'email',
        'password',
    ];
    protected $casts = [
        'services' => 'array',
        'specialization_and_expertise' => 'array'
    ];
    public function sluggable(): array
    {
        return [
            'slug' => [
                'source' => 'full_name'
            ]
        ];
    }

    public function providerCategory(): BelongsTo
    {
        return $this->belongsTo(ProviderCategory::class);
    }
    public function service(): BelongsTo
    {
        return $this->belongsTo(Service::class);
    }
    public function work(): HasMany
    {
        return $this->hasMany(TherapistWorkExperience::class, 'therapist_id');
    }
    public function blog(): HasMany
    {
        return $this->hasMany(Blog::class, 'therapist_id');
    }
    public function podcast(): HasMany
    {
        return $this->hasMany(Podcast::class, 'therapist_id');
    }
    public function academics(): HasMany
    {
        return $this->hasMany(TherapistAcademicsExperience::class, 'therapist_id');
    }
    public function training(): HasMany
    {
        return $this->hasMany(TherapistAdditionalTraining::class, 'therapist_id');
    }
    public function specialization(): BelongsTo
    {
        return $this->belongsTo(Specialization::class);
    }
    public function review(): HasMany
    {
        return $this->hasMany(UserReview::class, 'therapist_id');
    }
    public function license(): HasMany
    {
        return $this->hasMany(Licensing::class, 'therapist_id');
    }

    public function slot()
    {
        return $this->hasOne(Slot::class, 'therapist_id ');
    }
    public function chat(): HasMany
    {
        return $this->hasMany(Chat::class, 'therapist_id');
    }
    public function appoinment(): HasMany
    {
        return $this->hasMany(Appointments::class, 'therapist_id');
    }
    public function leaves(): HasMany
    {
        return $this->hasMany(Leave::class, 'therapist_id');
    }
    public function therapistCommission(): HasMany
    {
        return $this->hasMany(TherapistCommission::class, 'therapist_id');
    }
    public function therapistSettlement(): HasMany
    {
        return $this->hasMany(Settlement::class, 'therapist_id');
    }
    public function assessment(): HasMany
    {
        return $this->hasMany(Assessment::class, 'recommended_therapist');
    }
    public function consultationNote()
    {
        return $this->hasOne(ConsulationNote::class, 'therapist_id');
    }
    public function prescription()
    {
        return $this->hasOne(Prescription::class, 'therapist_id');
    }
}
