<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\HasMany;

class Slot extends Model
{
    use HasFactory;
    public function therapist()
    {
        return $this->belongsTo(Therapist::class);
    }


    public function workingHours(): HasMany
    {
        return $this->hasMany(WorkingHours::class, 'slot_id')->select('id', 'slot_id', 'day', 'start_time', 'end_time');
    }
}
