<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\HasMany;

class ServiceFeeStructure extends Model
{
    use HasFactory;

    protected $casts = [
        'rate' => 'float'
    ];

    public function service(): BelongsTo
    {
        return $this->belongsTo(Service::class);
    }

    public function callMethod(): BelongsTo
    {
        return $this->belongsTo(CallMethods::class);
    }

    public function providerCategory(): BelongsTo
    {
        return $this->belongsTo(ProviderCategory::class);
    }

    public function package(): HasMany
    {
        return $this->hasMany(Package::class, 'service_fee_id');
    }
}
