<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasMany;
use Cviebrock\EloquentSluggable\Sluggable;

class Service extends Model
{
    use HasFactory;
    use Sluggable;
    public function sluggable(): array
    {
        return [
            'slug' => [
                'source' => 'service_name'
            ]
        ];
    }

    public function serviceFeeStructure(): HasMany
    {
        return $this->hasMany(ServiceFeeStructure::class, 'service_id');
    }

    public function appoinment(): HasMany
    {
        return $this->hasMany(Appointments::class, 'service_id');
    }

    public function package(): HasMany
    {
        return $this->hasMany(Package::class, 'service_id');
    }

    public function workingHours(): HasMany
    {
        return $this->hasMany(WorkingHours::class, 'service_id');
    }

    public function therapist(): HasMany
    {
        return $this->hasMany(Therapist::class, 'services');
    }
}
