<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Cviebrock\EloquentSluggable\Sluggable;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\HasMany;

class Package extends Model
{
    use HasFactory;
    use Sluggable;
    public function sluggable(): array
    {
        return [
            'slug' => [
                'source' => 'title'
            ]
        ];
    }
    public function service(): BelongsTo
    {
        return $this->belongsTo(Service::class);
    }

    public function packageFee(): BelongsTo
    {
        return $this->belongsTo(ServiceFeeStructure::class);
    }

    public function appoinment(): HasMany
    {
        return $this->hasMany(Appointments::class, 'package_id');
    }
}
