<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasMany;

class CallMethods extends Model
{
    use HasFactory;

    public function service(): HasMany
    {
        return $this->hasMany(ServiceFeeStructure::class, 'service_id');
    }

    public function slotShedule(): HasMany
    {
        return $this->hasMany(SlotShedule::class, 'call_method_id');
    }

    public function appoinment(): HasMany
    {
        return $this->hasMany(Appointments::class);
    }
}
