<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\HasMany;

class Assessment_questions extends Model
{
    use HasFactory;
    public function assessment(): BelongsTo
    {
        return $this->belongsTo(Assessment::class);
    }

    public function answer(): HasMany
    {
        return $this->hasMany(Assessment_answer::class, 'assessment_question_id')->select('id', 'answer', 'rate');
    }
}
