<?php

namespace App\Http\Controllers\user;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\WalletPoint;
use App\Models\WalletPointCommission;
use App\Models\PaymentDetails;
use App\Models\UserWalletTransactions;
use App\Models\UserWallet;
use App\Models\TypesOfWallet;
use Illuminate\Database\QueryException;
use Carbon\Carbon;
use Database\Seeders\TypeofWalletsSeeder;
use Razorpay\Api\Api;
use Mgcodeur\CurrencyConverter\Facades\CurrencyConverter;

class WalletController extends Controller
{
    public function addWalletAmount(Request $request)
    {

        try {
            $api = new Api(env('RAZOR_KEY'), env('RAZOR_SECRET'));

            $payment = $api->payment->fetch($request->payment_id);
            print_r($payment);
            die();
            $point = WalletPoint::orderBy('id', 'DESC')->first();

            $amount = $payment['amount'] / 100;
            $userpoint = $point->point * $amount;
            $currency = $payment['currency'];
            $method = $payment['method'];
            $date = $payment['created_at'];
            $status = $payment['status'];
            $convertedAmount = round(CurrencyConverter::convert($amount)
                ->from($currency)
                ->to('INR')
                ->get());

            $payment = new PaymentDetails();
            $payment->user_id = auth()->user()->id;
            $payment->payment_id = $request->payment_id;
            $payment->amount_in_currency = $amount;
            $payment->total_amount_in_rupee = $convertedAmount;
            $payment->currency = $currency;
            $payment->payment_method = $method;
            $payment->payment_date = $date;
            $payment->payment_status = $status;
            $payment->save();

            // $userwallet = UserWallet::where('user_id', auth()->user()->id)->first();
            // if ($userwallet == null) {
            //     $userBalance = 0;
            //     $balance = $userBalance + $userpoint;

            //     $userwalletadd = new UserWallet();
            //     $userwalletadd->user_id = auth()->user()->id;
            //     $userwalletadd->balance = $balance;
            //     $userwalletadd->save();
            // } else {
            //     $userBalance = $userwallet->balance;
            //     $balance = $userBalance + $userpoint;

            //     $userwalletadd = UserWallet::where('id', $userwallet->id)->update([
            //         'user_id' => auth()->user()->id,
            //         'balance' => $balance
            //     ]);
            // }

            // $userWalletTransaction = new UserWalletTransactions();
            // $userWalletTransaction->user_id = auth()->user()->id;
            // $userWalletTransaction->wallet_id = 1;
            // $userWalletTransaction->payment_id = $payment->id;
            // $userWalletTransaction->type = 'Credit';
            // $userWalletTransaction->amount = $amount;
            // $userWalletTransaction->point = $userpoint;
            // $userWalletTransaction->current_balance = $balance;
            // $userWalletTransaction->save();




            if ($payment) {
                return response()->json(
                    array(
                        'status' => true,
                        'data' => "Wallet added successfully",
                        'statuscode' => 200
                    ),
                    200
                );
            } else {
                return response()->json(
                    array(
                        'status' => false,
                        'data' => "Something went Wrong",
                        'statuscode' => 301
                    ),
                    200
                );
            }
        } catch (QueryException $e) {
            return response()->json(
                array(
                    'status' => false,
                    'data' => $e->getMessage()
                ),
                200
            );
        }
    }

    public function walletBalance(Request $request)
    {
        try {

            $data = UserWallet::where('user_id', auth()->user()->id)->pluck('balance')->first();
            if ($data == null) {
                $data = 0;
            }



            if ($data) {
                return response()->json(
                    array(
                        'status' => true,
                        'balance' => $data,
                        'statuscode' => 200
                    ),
                    200
                );
            } else {
                return response()->json(
                    array(
                        'status' => true,
                        'balance' => 0,
                        'statuscode' => 200
                    ),
                    200
                );
            }
        } catch (QueryException $e) {
            return response()->json(
                array(
                    'status' => false,
                    'data' => $e->getMessage()
                ),
                200
            );
        }
    }

    public function walletTransactions(Request $request)
    {
        try {
            $data = [];
            $result = UserWalletTransactions::where('user_id', auth()->user()->id)->orderBy('id', 'DESC')->get();

            foreach ($result as $key => $item) {
                $convertedAmount = round(CurrencyConverter::convert($item->amount)
                    ->from('INR')
                    ->to(auth()->user()->currency_code)
                    ->get(), 2);
                $type = TypesOfWallet::where('id', $item->wallet_id)->pluck('name')->first();
                $data[$key]['id'] = $item->id;
                $data[$key]['wallet_type'] = $type;
                $data[$key]['transaction_type'] = $item->type;
                $data[$key]['amount'] = $convertedAmount;
                $data[$key]['currency_symbol'] = auth()->user()->currency_symbol;
                $data[$key]['point'] = $item->point;
                $data[$key]['date'] = date("d M Y  h:m:s", ($item->craeted_at));
            }


            if ($data) {
                return response()->json(
                    array(
                        'status' => true,
                        'data' => $data
                    ),
                    200
                );
            } else {
                return response()->json(
                    array(
                        'status' => false,
                        'data' => 'No Trasaction Done'
                    ),
                    200
                );
            }
        } catch (QueryException $e) {
            return response()->json(
                array(
                    'status' => false,
                    'data' => $e->getMessage()
                ),
                200
            );
        }
    }
}
