<?php

namespace App\Http\Controllers\User;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\User;
use App\Models\Location;
use App\Models\UserWallet;
//use Illuminate\Support\Facades\Auth;
use Illuminate\Http\JsonResponse;
use Illuminate\Database\QueryException;
use Cviebrock\EloquentSluggable\Services\SlugService;
use Illuminate\Support\Facades\Validator;
use Kreait\Firebase\Contract\Auth;
use Kreait\Firebase\Exception\Auth\FailedToVerifyToken;
use App\Models\ReportAnIssue;
use App\Notifications\UserRegistrationNotification;
use App\Models\Admin;
use App\Models\Appointments;
use App\Models\PushNotification;
use Illuminate\Support\Facades\Notification;
use Illuminate\Support\Str;
use Illuminate\Support\Facades\Mail;
use App\Models\Package;
use Illuminate\Support\Facades\DB;
use App\Mail\TherapistRegisterNotificationMail;
use Mgcodeur\CurrencyConverter\Facades\CurrencyConverter;

class UserController extends Controller
{
    public function allCurrency(Request $request)
    {
        $currency = Location::select('id', 'currency', 'currency_code')
            ->groupBy('currency_code')
            ->orderBy('currency_code')
            ->get();

        if ($currency) {

            return response()->json(
                array(
                    'status' => true,
                    'data' => $currency
                ),
                200
            );
        } else {
            return response()->json(
                array(
                    'status' => false,
                    'data' => "Something went Wrong"
                ),
                200
            );
        }
    }
    public function login(Request $request)
    {

        $response = (object) [];
        $token = $request->bearerToken();
        $response->token = $token;

        $auth = app('firebase.auth');
        try {

            $verifiedIdToken = $auth->verifyIdToken($token);
            //echo var_dump($verifiedIdToken);
        } catch (FailedToVerifyToken $e) {

            return response()->json(['status' => False, 'message' => 'The token is invalid: ' . $e->getMessage(), 'statuscode' => 500]);
            // echo 'The token is invalid: ' . $e->getMessage();
        }

        /* check token payload */
        $email = $verifiedIdToken->claims()->get('email');
        $response->payload_email = $email;

        $uid = $verifiedIdToken->claims()->get('sub');
        $response->payload_uid = $uid;

        /* check authenticated user */
        $user = $auth->getUser($uid);
        $response->authenticated_user = $user;
        //  print_r($user);die();
        $pn = str_replace(' ', '', $request->phone_number);
        $code =  str_replace('+', '', $request->phone_number);
        $check_number = $request->code . $pn;
        $check_number2 = $request->code . $request->phone_number;
        $check_number3 = $code . $pn;

        // if ($user->phoneNumber == $check_number || $user->phoneNumber == $check_number2 || $user->phoneNumber == $check_number3) {
        try {

            $user = User::select('id', 'UserId', 'Patient_Identification_Number', 'Phone_Code', 'phone', 'SMS')
                ->where('SMS', $check_number3)
                ->orWhere('SMS', $check_number)
                ->orWhere('phone', $request->phone_number)
                ->first();


            $currency = Location::select('currency_symbol', 'currency_code')->where('country', $request->country)->first();



            if (!empty($user)) {
                if ($user->currency == null) {
                    $r = User::where('id', $user->id)->update([
                        'country' => $request->country,
                        'currency_symbol' => $currency->currency_symbol,
                        'currency_code' => $currency->currency_code
                    ]);
                }
                $token =  $user->createToken('MyApp')->accessToken;
                return response()->json(['access_token' => $token, 'statuscode' => 200, 'status' => True, 'message' => 'Login', 'user' => User::where('id', $user->id)->first()]);
            } else {
                $pn = 'P' . random_int(000000000000000000, 999999999999999999);
                $userid = random_int(400000, 499999);
                $user = new User();
                $user->UserId = $userid;
                $user->Patient_Identification_Number = $pn;
                $user->Phone_Code = $request->code;
                $user->phone = $request->phone_number;
                $user->SMS = $request->code . $request->phone_number;
                $user->country = $request->country;
                $user->currency_symbol = $currency->currency_symbol;
                $user->currency_code = $currency->currency_code;
                $user->save();
                $token =  $user->createToken('MyApp')->accessToken;
                $data = [
                    'user_id' => $user->id
                ];
                $notification = Admin::first();

                #store notification info into notifications table
                $notification->notify(new UserRegistrationNotification($data));
                return response()->json(['access_token' => $token, 'statuscode' => 200, 'status' => True, 'message' => "Register", 'user' => User::where('id', $user->id)->first()]);
            }
        } catch (QueryException $e) {
            return   response()->json(['statuscode' => 500, 'status' => False, 'error' => $e->getMessage()]);
        }
        // } else {
        //     return  response()->json(['statuscode' => 500, 'status' => False, 'messsage' => 'Invalid Phone number']);
        // }
    }

    public function register(Request $request): JsonResponse
    {
        try {
            $request->validate([
                'code' => 'required',
                'phone' => 'required'
            ]);
            $user = User::where('Phone_Code', $request->code)->where('phone', $request->phone)->first();
            $currency = Location::select('currency_symbol', 'currency_code')->where('country', $request->country)->first();

            if ($user) {
                if ($user->currency == null) {
                    $r = User::where('id', $user->id)->update([
                        'country' => $request->country,
                        'currency_symbol' => $currency->currency_symbol,
                        'currency_code' => $currency->currency_code
                    ]);
                }
                $token =  $user->createToken('MyApp')->accessToken;
                return response()->json(['access_token' => $token, 'statuscode' => 200, 'status' => True, 'message' => 'Login', 'user' => $user]);
            } else {

                $pn = 'P' . random_int(000000000000000000, 999999999999999999);


                $user = new User();
                $user->Patient_Identification_Number = $pn;
                $user->Phone_Code = $request->code;
                $user->phone = $request->phone;
                $user->SMS = $request->code . '-' . $request->phone;
                $user->country = $request->country;
                $user->currency_symbol = $currency->currency_symbol;
                $user->currency_code = $currency->currency_code;
                $user->save();

                $token =  $user->createToken('MyApp')->accessToken;
                if ($user) {
                    return response()->json(
                        array(
                            'status' => true,
                            'token' => $token,
                            'user' => User::where('id', $user->id)->first(),
                            'data' => "User Added Successfully"
                        ),
                        200
                    );
                } else {
                    return response()->json(
                        array(
                            'status' => false,
                            'data' => "Something went Wrong"
                        ),
                        200
                    );
                }
            }
        } catch (QueryException $e) {
            return response()->json(
                array(
                    'status' => false,
                    'data' => $e->getMessage()
                ),
                200
            );
        }
    }

    public function updateProfile(Request $request): JsonResponse
    {
        //  $user = Auth::guard('api')->user();

        try {

            $validator = Validator::make($request->all(), [
                'first_name' => 'required',
                'last_name' => 'required',
                // 'email' => 'required|unique:users,Email,' . auth()->user()->id,
                'email' => 'required',
                'gender' => 'required',
                'dob' => 'required'
            ]);

            if ($validator->fails()) {
                return response()->json($validator->errors());
            }

            $name = $request->first_name . ' ' . $request->last_name;
            $slug = SlugService::createSlug(
                User::class,
                'slug',
                $name
            );
            $pn = 'P' . random_int(000000000000000000, 999999999999999999);
            $image = '';
            // ******** Image uploade start ********
            if ($request->hasFile('image')) {
                $rand = rand(100, 999);
                $image = time() . '.' . $request->image->extension();
                $imageOriginalName = $request->image->getClientOriginalName();
                $request->image->move(public_path('assets/uploads/user'), $image);
                $res = User::where('id', auth()->user()->id)
                    ->update([
                        'image' => $image,
                    ]);
            }
            // ******** Image uploade end ********
            $res = User::where('id', auth()->user()->id)
                ->update([
                    'First_Name' => $request->first_name,
                    'Last_Name' => $request->last_name,
                    'slug' => $slug,
                    'Email' => $request->email,
                    'alternative_email' => $request->alternative_email,
                    'alternative_phone' => $request->alternative_phone,
                    'Gender' => $request->gender,
                    'DOB' => date("Y-m-d", strtotime($request->dob))
                ]);


            if ($res) {
                return response()->json(
                    array(
                        'status' => true,
                        'data' => "Profile added Successfully",
                        'statuscode' => 200
                    ),
                    200
                );
            } else {
                return response()->json(
                    array(
                        'status' => false,
                        'data' => "Something went Wrong",
                        'statuscode' => 301
                    ),
                    200
                );
            }
        } catch (QueryException $e) {
            return response()->json(
                array(
                    'status' => false,
                    'data' => $e->getMessage()
                ),
                200
            );
        }
    }

    public function logout(Request $request)
    {
        auth()->user()->token()->revoke();

        return response()->json([
            'status' => true,
            'success' => 'logged out',
            'statuscode' => 200
        ], 200);
    }

    public function profile(Request $request)
    {
        // $data = User::select('id as UserId', 'First_Name', 'Last_Name', 'image', 'Email', 'Phone_Code', 'phone', 'DOB', 'Gender', 'currency_symbol', 'currency_code')->where('id', auth()->user()->id)->first();
        $data = User::where('id', auth()->user()->id)->first();
        $data->balance = UserWallet::where('user_id', auth()->user()->id)->pluck('balance')->first();
        if ($data->balance == null) {
            $data->balance = 0;
        }
        //         $balnce = UserWallet::where('user_id', auth()->user()->id)->pluck('balance')->first();
        //         $data->balance = round(CurrencyConverter::convert($balnce)
        //             ->from('INR')
        //             ->to(auth()->user()->currency_code)
        //             ->get(), 2);
        //  echo "hi";die();
        if ($data->image != NULL) {
            $img = asset('assets/uploads/user/' . $data->image);
        } else {
            if ($data->Gender == 'MALE' || $data->Gender == 'M' || $data->Gender == 'Male') {
                $img = asset('assets/img/male.png');
            } elseif ($data->Gender == 'FEMALE' || $data->Gender == 'F' || $data->Gender == 'Female') {
                $img = asset('assets/img/female.png');
            } else {
                $img = asset('assets/img/other.png');
            }
        }
        if ($data->gst_number == NULL) {
            $data->gst_number = '';
        }
        if ($data->address == NULL) {
            $data->address = '';
        }
        $data->image = $img;
        return response()->json([
            'status' => true,
            'data' => $data,
            'statuscode' => 200
        ], 200);
    }

    public function reportAnIssue(Request $request): JsonResponse
    {

        try {
            $image = '';
            // ******** Image uploade start ********
            if ($request->hasFile('image')) {
                $rand = rand(100, 999);
                $image = time() . '.' . $request->image->extension();
                $imageOriginalName = $request->image->getClientOriginalName();
                $request->image->move(public_path('assets/uploads/reportissue'), $image);
            }

            // ******** Image uploade end ********


            $res = ReportAnIssue::insert([
                'user_id' => auth()->user()->id,
                'issue' => $request->issue,
                'description' => $request->description,
                'image' => $image
            ]);


            if ($res) {
                return response()->json(
                    array(
                        'status' => true,
                        'data' => "Data Submitted Successfully",
                        'statuscode' => 200
                    ),
                    200
                );
            } else {
                return response()->json(
                    array(
                        'status' => false,
                        'data' => "Something went Wrong",
                        'statuscode' => 301
                    ),
                    200
                );
            }
        } catch (QueryException $e) {
            return response()->json(
                array(
                    'status' => false,
                    'data' => $e->getMessage()
                ),
                200
            );
        }
    }

    public function saveToken(Request $request)
    {
        $request->validate([
            'token' => 'required'
        ]);

        $res =  User::where('id', auth()->user()->id)
            ->update([
                'device_token' => $request->token
            ]);

        if ($res) {
            return response()->json(
                array(
                    'status' => true,
                    'data' => "token saved successfully.",
                    'statuscode' => 200
                ),
                200
            );
        } else {
            return response()->json(
                array(
                    'status' => false,
                    'data' => "Something went Wrong",
                    'statuscode' => 301
                ),
                200
            );
        }
    }

    public function verifyEmail(Request $request)
    {

        $token = Str::random(64);
        $res =  User::where('id', auth()->user()->id)
            ->update([
                'email_verify_token' => $token
            ]);


        if ($res) {
            Mail::send('admin.email.emailVerificationEmail', ['token' => $token], function ($message) use ($request) {
                $message->to($request->email);
                $message->subject('Email Verification Mail');
            });
            return response()->json(
                array(
                    'status' => true,
                    'data' => "Email verification link send to your mail id",
                    'statuscode' => 200
                ),
                200
            );
        } else {
            return response()->json(
                array(
                    'status' => false,
                    'data' => "Something went Wrong",
                    'statuscode' => 301
                ),
                200
            );
        }
    }

    public function checkEmailVerfied(Request $request)
    {
        $res =  User::where('id', auth()->user()->id)->pluck('is_email_verified')->first();


        if ($res) {
            return response()->json(
                array(
                    'status' => true,
                    'data' => $res,
                    'statuscode' => 200
                ),
                200
            );
        } else {
            return response()->json(
                array(
                    'status' => false,
                    'data' => 0,
                    'statuscode' => 301
                ),
                200
            );
        }
    }

    public function notification(Request $request)
    {
        $res =  PushNotification::select('title', 'message', 'appoinment_id')->where('user_id', auth()->user()->id)->get();

        if ($res) {
            return response()->json(
                array(
                    'status' => true,
                    'data' => $res,
                    'statuscode' => 200
                ),
                200
            );
        } else {
            return response()->json(
                array(
                    'status' => false,
                    'data' => "Something went Wrong",
                    'statuscode' => 301
                ),
                200
            );
        }
    }

    public function packages(Request $request)
    {

        $array = Package::join('appointments', 'appointments.package_id', '=', 'packages.id')
            ->select('packages.id', 'packages.image', 'packages.title', 'packages.description', 'packages.no_of_sessions')
            ->where('appointments.user_id', auth()->user()->id)
            //   ->where('appointments.Appointment_Status', 'Completed')
            ->groupBy('packages.id')
            ->orderBy('packages.id', 'DESC')->get();


        if (!empty($array)) {
            $data = collect($array->toArray())->map(function ($item) {
                $completed_sessions = count(Appointments::where('user_id', auth()->user()->id)
                    ->where('Appointment_Status', 'Completed')
                    ->where('package_id', $item['id'])
                    ->get());
                $item['completed_sessions'] = $completed_sessions;
                $item['image'] = asset('assets/uploads/package/') . '/' . $item['image'];
                $item['rate'] = ($completed_sessions) / $item['no_of_sessions'];
                $item['description'] = Str::limit((strip_tags($item['description'])), 50, '...');
                return $item;
            });
            return response()->json(
                array(
                    'status' => True,
                    'data' => $data
                ),
                200
            );
        } else {
            return response()->json(
                array(
                    'status' => False,
                    'data' => []
                ),
                200
            );
        }
    }

    public function packageDetails(Request $request)
    {

        $data = Package::select('id', 'image', 'title', 'description', 'no_of_sessions')
            ->where('id', $request->package_id)
            ->orderBy('id', 'DESC')->first();
        $completed_sessions = count(Appointments::where('user_id', auth()->user()->id)
            ->where('Appointment_Status', 'Completed')
            ->where('package_id', $data->id)
            ->get());
        $data->completed_sessions = $completed_sessions;
        $data->image = asset('assets/uploads/package/') . '/' . $data->image;
        $data->remaining_sessions = $data->no_of_sessions - $completed_sessions;
        $data->rate = ($completed_sessions) / $data->no_of_sessions;
        $sessions = Appointments::select('id', 'Appointment_Date', 'Appointment_Time')->where('user_id', auth()->user()->id)->where('package_id', $request->package_id)->get();

        $data->sessions = $sessions->map(
            function ($item) {
                $item->Appointment_Date = date('d  M, l Y', strtotime($item->Appointment_Date));
                return $item;
            }
        );

        if (!empty($data)) {
            return response()->json(
                array(
                    'status' => True,
                    'data' => $data
                ),
                200
            );
        } else {
            return response()->json(
                array(
                    'status' => False,
                    'data' => $data
                ),
                200
            );
        }
    }

    public function changeCurrency(Request $request)
    {

        $currency = Location::select('currency_symbol', 'currency_code')->where('id', $request->id)->first();

        $r = User::where('id', auth()->user()->id)->update([
            'country' => $request->country,
            'currency_symbol' => $currency->currency_symbol,
            'currency_code' => $currency->currency_code
        ]);
        if ($r) {

            return response()->json(
                array(
                    'status' => true,
                    'data' => "Currency changed successfully"
                ),
                200
            );
        } else {
            return response()->json(
                array(
                    'status' => false,
                    'data' => "Something went Wrong"
                ),
                200
            );
        }
    }

    public function updateGstNumber(Request $request)
    {
        $r = User::where('id', auth()->user()->id)->update([
            'gst_number' => $request->gst_number
        ]);
        if ($r) {

            return response()->json(
                array(
                    'status' => true,
                    'data' => "Data updated successfully"
                ),
                200
            );
        } else {
            return response()->json(
                array(
                    'status' => false,
                    'data' => "Something went Wrong"
                ),
                200
            );
        }
    }

    public function updateAddress(Request $request)
    {

        $r = User::where('id', auth()->user()->id)->update([
            'address' => $request->address
        ]);
        if ($r) {

            return response()->json(
                array(
                    'status' => true,
                    'data' => "Data updated successfully"
                ),
                200
            );
        } else {
            return response()->json(
                array(
                    'status' => false,
                    'data' => "Something went Wrong"
                ),
                200
            );
        }
    }
}
