<?php

namespace App\Http\Controllers\User;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Service;
use App\Models\Therapist;
use App\Models\Appointments;
use App\Models\ServiceFeeStructure;
use Illuminate\Support\Str;
use Mgcodeur\CurrencyConverter\Facades\CurrencyConverter;

class ServiceController extends Controller
{
    public function serviceList(Request $request)
    {
        $array = Service::select('id', 'service_name', 'slug', 'description', 'image')->orderBy('created_at', 'DESC')->get();
        $data = collect($array->toArray())->map(function ($item) {
            $item['image'] = asset('assets/uploads/service/') . '/' . $item['image'];
            $item['description'] = Str::limit((strip_tags($item['description'])), 50, '...');
            $item['description'] = preg_replace("/&nbsp;/", '', $item['description']);
            $item['description'] = preg_replace("/\s+/", " ", $item['description']);
            return $item;
        });

        if (!empty($data)) {
            return response()->json(
                array(
                    'status' => True,
                    'data' => $data
                ),
                200
            );
        } else {
            return response()->json(
                array(
                    'status' => False,
                    'data' => $data
                ),
                200
            );
        }
    }
    public function serviceDetails(Request $request)
    {
        $data = Service::where('slug', $request->slug)->first();
        $data->image = asset('assets/uploads/service/') . '/' . $data->image;
        $data->description = strip_tags($data->description);
        $data->description = preg_replace("/&nbsp;/", '', $data->description);
        $data->description = preg_replace("/\s+/", " ", $data->description);

        $service = [
            'service_id' => $data->id,
            'service_name' => $data->service_name,
            'slug' => $data->slug,
            'image' => $data->image,
            'description' => $data->description
        ];
        foreach ($data->serviceFeeStructure as $key => $item) {
            $convertedAmount = round(CurrencyConverter::convert($item->rate)
                ->from('INR')
                ->to(auth()->user()->currency_code)
                ->get(), 2);
            $duration[$key] = [
                'provider_category_id' => $item->providerCategory->id,
                'provider_category' => $item->providerCategory->name,
                'call_method_id' => $item->callMethod->id,
                'call_method' => $item->callMethod->name,
                'duration' => $item->duration,
                'rate' => $convertedAmount,
                'currency' => auth()->user()->currency_symbol,
                'currency_code' => auth()->user()->currency_code
            ];
            $call_methods[$key] = [
                $item->callMethod->name
            ];
        }

        $service['duration'] = $duration;
        $service['communication'] = collect($call_methods)->unique()->values();
        if (!empty($data)) {
            return response()->json(
                array(
                    'status' => True,
                    'data' => $service
                ),
                200
            );
        } else {
            return response()->json(
                array(
                    'status' => False,
                    'data' => $service
                ),
                200
            );
        }
    }

    public function fetchTherapistBasedOnService(Request $request)
    {
        $array = Therapist::select('id', 'full_name', 'designation', 'language_known', 'image')->where('provider_category_id', $request->provider_category_id)->whereJsonContains('services', $request->service_id)->get();

        $data = collect($array->toArray())->map(
            function ($item) {
                $item['image'] = asset('assets/uploads/therapist/') . '/' . $item['image'];
                $item['total_sessions'] = count(Appointments::where('therapist_id', $item['id'])->where('Appointment_Status', 'Completed')->get());
                return $item;
            }
        );


        if (!empty($data)) {
            return response()->json(
                array(
                    'status' => True,
                    'data' => $data
                ),
                200
            );
        } else {
            return response()->json(
                array(
                    'status' => False,
                    'data' => $data
                ),
                200
            );
        }
    }
}
