<?php

namespace App\Http\Controllers\User;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\ThoughtofTheDay;
use App\Models\Banners;
use App\Models\VideoBanner;
use App\Models\Therapist;
use App\Models\Package;
use App\Models\Offer;
use App\Models\Appointments;
use App\Models\ServiceFeeStructure;
use Carbon\Carbon;
use App\Models\Settings;
use Mgcodeur\CurrencyConverter\Facades\CurrencyConverter;

class HomePageController extends Controller
{
    public function thoughts(Request $request)
    {
        $carbon = Carbon::now();
        $day = $carbon->format('l');

        $data = ThoughtofTheDay::select('image')->where('day', $day)->first();

        if (empty($data)) {
            $data = ThoughtofTheDay::select('image')->orderBy('id', 'DESC')->first();
        }
        $data->image = asset('assets/uploads/thoughts/') . '/' . $data->image;

        if (!empty($data)) {
            return response()->json(
                array(
                    'status' => True,
                    'data' => $data
                ),
                200
            );
        } else {
            return response()->json(
                array(
                    'status' => False,
                    'data' => $data
                ),
                200
            );
        }
    }

    public function banners(Request $request)
    {
        $array = Banners::select('image')->orderBy('id', 'DESC')->get();

        $data = collect($array->toArray())->map(function ($item) {
            $item['image'] = asset('assets/uploads/banners/') . '/' . $item['image'];
            return $item;
        });

        if (!empty($data)) {
            return response()->json(
                array(
                    'status' => True,
                    'data' => $data
                ),
                200
            );
        } else {
            return response()->json(
                array(
                    'status' => False,
                    'data' => $data
                ),
                200
            );
        }
    }

    public function videobanners(Request $request)
    {
        $array = VideoBanner::select('image', 'link')->orderBy('id', 'DESC')->get();

        $data = collect($array->toArray())->map(function ($item) {
            $item['image'] = asset('assets/uploads/videobanners/') . '/' . $item['image'];
            return $item;
        });

        if (!empty($data)) {
            return response()->json(
                array(
                    'status' => True,
                    'data' => $data
                ),
                200
            );
        } else {
            return response()->json(
                array(
                    'status' => False,
                    'data' => $data
                ),
                200
            );
        }
    }

    public function featuredTherapist(Request $request)
    {
        $array = Therapist::select('id', 'prefix', 'full_name', 'slug', 'designation', 'language_known', 'image', 'featured')->where('featured', '1')->orderBy('id', 'DESC')->get();

        $data = collect($array->toArray())->map(function ($item) {
            $item['image'] = asset('assets/uploads/therapist/') . '/' . $item['image'];
            return $item;
        });

        if (!empty($data)) {
            return response()->json(
                array(
                    'status' => True,
                    'data' => $data
                ),
                200
            );
        } else {
            return response()->json(
                array(
                    'status' => False,
                    'data' => $data
                ),
                200
            );
        }
    }

    public function packages(Request $request)
    {
        $array = Package::orderBy('id', 'DESC')->get();

        $data = collect($array->toArray())->map(function ($item) {
            $item['image'] = asset('assets/uploads/package/') . '/' . $item['image'];
            return $item;
        });

        if (!empty($data)) {
            return response()->json(
                array(
                    'status' => True,
                    'data' => $data
                ),
                200
            );
        } else {
            return response()->json(
                array(
                    'status' => False,
                    'data' => $data
                ),
                200
            );
        }
    }

    public function packageDetails(Request $request)
    {
        $data = Package::where('id', $request->id)->first();
        $data->makeHidden(['created_at', 'updated_at', 'service_fee_id', 'slug']);
        $call_methods = [];
        $grandtotal = 0;

        $service_ids = json_decode($data->service_fee_id);
        $sfss = ServiceFeeStructure::whereIn('id', $service_ids)->get();
        $method = [];
        foreach ($sfss as $key => $sfs) {
            $convertedAmount = round(CurrencyConverter::convert($sfs->rate)
                ->from('INR')
                ->to(auth()->user()->currency_code)
                ->get(), 2);
            $total = $convertedAmount * $data->no_of_sessions;
            $subtotal = $total * ($data->discount / 100);
            $grandtotal = $total - $subtotal;

            $per_session_total = $convertedAmount;
            $per_session_subtotal = $per_session_total * ($data->discount / 100);
            $per_session_grandtotal = $per_session_total - $per_session_subtotal;

            if ($sfs) {

                $method[$key]['provider_category_id'] = $sfs->provider_category_id;
                $method[$key]['provider_category'] = $sfs->providerCategory->name;
                $method[$key]['communication_method_id'] = $sfs->callMethod->id;
                $method[$key]['communication_method'] = $sfs->callMethod->name;
                $method[$key]['duration'] = $sfs->duration . ' minutes';
                $method[$key]['actual_price'] = $convertedAmount;
                $method[$key]['discount_price_per_session'] = $per_session_grandtotal;
                $method[$key]['total_discount_price'] = $grandtotal;
                $method[$key]['currency'] = auth()->user()->currency_symbol;
                $method[$key]['currency_code'] = auth()->user()->currency_code;
            }
        }
        $data->image = asset('assets/uploads/package/') . '/' . $data->image;
        $data->fee = $method;
        if (!empty($data)) {
            return response()->json(
                array(
                    'status' => True,
                    'data' => $data
                ),
                200
            );
        } else {
            return response()->json(
                array(
                    'status' => False,
                    'data' => $data
                ),
                200
            );
        }
    }

    public function offers(Request $request)
    {
        $array = Offer::select('id', 'image')->where('status', 'ACTIVE')->orderBy('id', 'DESC')->get();

        $data = collect($array->toArray())->map(function ($item) {
            $item['image'] = asset('assets/uploads/offers/') . '/' . $item['image'];
            return $item;
        });

        if (!empty($data)) {
            return response()->json(
                array(
                    'status' => True,
                    'data' => $data
                ),
                200
            );
        } else {
            return response()->json(
                array(
                    'status' => False,
                    'data' => $data
                ),
                200
            );
        }
    }

    public function offerDetails(Request $request)
    {
        $data = Offer::where('id', $request->id)->first();

        $data->image = asset('assets/uploads/offers/') . '/' . $data->image;
        if (!empty($data)) {
            return response()->json(
                array(
                    'status' => True,
                    'data' => $data
                ),
                200
            );
        } else {
            return response()->json(
                array(
                    'status' => False,
                    'data' => $data
                ),
                200
            );
        }
    }

    public function packageBookingFromPackage(Request $request)
    {
        $data = [];
        $call_methods = [];
        $grandtotal = 0;
        $array = Package::select('id', 'service_id', 'service_fee_id', 'title', 'no_of_sessions', 'discount', 'image')->where('id', $request->package_id)->first();

        $data = $array;
        $service_ids = json_decode($array->service_fee_id);
        $sfss = ServiceFeeStructure::whereIn('id', $service_ids)->get();
        foreach ($sfss as $sfs) {
            $convertedAmount = round(CurrencyConverter::convert($sfs->rate)
                ->from('INR')
                ->to(auth()->user()->currency_code)
                ->get(), 2);
            $total = $convertedAmount * $array->no_of_sessions;
            $subtotal = $total * ($array->discount / 100);
            $grandtotal = $total - $subtotal;

            if ($sfs) {
                $data['provider_category_id'] = $sfs->provider_category_id;
                $data['communication_method_id'] = $sfs->callMethod->id;
                $data['communication_method'] = $sfs->callMethod->name;
                $data['actual_price'] = $convertedAmount;
                $data['discount_price'] = $grandtotal;
                $data['currency'] = auth()->user()->currency_symbol;
                $data['currency_code'] = auth()->user()->currency_code;
            }


            $therapistarray = Therapist::select('id', 'full_name', 'designation', 'language_known', 'image')->where('provider_category_id', $request->provider_category_id)->whereJsonContains('services', $request->service_id)->get();

            $data['therapist'] = collect($therapistarray->toArray())->map(
                function ($item) {
                    $item['image'] = asset('assets/uploads/therapist/') . '/' . $item['image'];
                    $item['total_sessions'] = count(Appointments::where('therapist_id', $item['id'])->where('Appointment_Status', 'Completed')->get());
                    return $item;
                }
            );
        }
        if (!empty($data)) {
            return response()->json(
                array(
                    'status' => True,
                    'data' => $data
                ),
                200
            );
        } else {
            return response()->json(
                array(
                    'status' => False,
                    'data' => $data
                ),
                200
            );
        }
    }

    public function privacy(Request $request)
    {
        $data = Settings::pluck('privacy_and_terms')->first();

        if (!empty($data)) {
            return response()->json(
                array(
                    'status' => True,
                    'data' => $data
                ),
                200
            );
        } else {
            return response()->json(
                array(
                    'status' => False,
                    'data' => $data
                ),
                200
            );
        }
    }

    public function terms(Request $request)
    {
        $data = Settings::pluck('terms_and_conditions')->first();

        if (!empty($data)) {
            return response()->json(
                array(
                    'status' => True,
                    'data' => $data
                ),
                200
            );
        } else {
            return response()->json(
                array(
                    'status' => False,
                    'data' => $data
                ),
                200
            );
        }
    }

    public function contacts(Request $request)
    {
        $data = Settings::select('email', 'phone')->first();

        if (!empty($data)) {
            return response()->json(
                array(
                    'status' => True,
                    'data' => $data
                ),
                200
            );
        } else {
            return response()->json(
                array(
                    'status' => False,
                    'data' => $data
                ),
                200
            );
        }
    }



    public function sendWhatsappMessage(Request $request)
    {

        // Validate incoming request
        $validatedData = $request->validate([
            'phone_number' => 'required',
            'message' => 'required',
        ]);

        // Process the data (e.g., save to the database)
        // For now, we'll just return the validated data
        return response()->json([
            'message' => 'Data received successfully',
            'data' => $validatedData
        ], 200);
    }
}
