<?php

namespace App\Http\Controllers\User;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Blog;
use App\Models\Therapist;
use App\Models\Blog_category;
use Illuminate\Support\Str;
use App\Models\Podcast;

class BlogController extends Controller
{
    public function blog(Request $request)
    {

        if ($request->category) {
            $array = Blog::select('id', 'title', 'slug', 'blog_category_id', 'therapist_id', 'author', 'description', 'image', 'tags', 'color', 'created_at')->where('blog_category_id', $request->category)->orderBy('title', 'ASC')->get();
        } else {
            $array = Blog::select('id', 'title', 'slug', 'blog_category_id', 'therapist_id', 'author', 'description', 'image', 'tags', 'color', 'created_at')->orderBy('title', 'ASC')->get();
        }
        $data = $array->map(function ($item) {
            $item->image = asset('assets/uploads/blog/') . '/' . $item->image;
            $item->description = Str::limit((strip_tags($item->description)), 50, '...');
            if ($item->author == 'T') {
                $therapist = therapist::where('id', $item->therapist_id)->first();
                $name = $therapist->full_name;
                $item->author = $name;
                $item->author_image = asset('assets/uploads/therapist/' . $therapist->image);
            } else {
                $item->author = 'Feni';
                $item->author_image = asset('assets/img/fenni.jpg');
            }
            return $item;
        });


        if (!empty($data)) {
            return response()->json(
                array(
                    'status' => True,
                    'data' => $data
                ),
                200
            );
        } else {
            return response()->json(
                array(
                    'status' => False,
                    'data' => $data
                ),
                200
            );
        }
    }
    public function blogDetails(Request $request)
    {
        $data = Blog::select('id', 'title', 'blog_category_id', 'therapist_id', 'author', 'description', 'image', 'tags', 'color', 'created_at')->where('id', $request->id)->first();

        if ($data->author == 'T') {
            $data->author = $data->therapist->full_name;
            $data->author_image = asset('assets/uploads/therapist/' . $data->therapist->image);
        } elseif ($data->author == 'F') {
            $data->author = 'Feni';
            $data->author_image = asset('assets/img/fenni.jpg');
        }

        $data->description = strip_tags($data->description);
        $data->description = preg_replace("/&nbsp;/", '', $data->description);
        $data->description = preg_replace("/\s+/", " ", $data->description);
        $data->image = asset('assets/uploads/blog/') . '/' . $data->image;
        if (!empty($data)) {
            return response()->json(
                array(
                    'status' => True,
                    'data' => $data
                ),
                200
            );
        } else {
            return response()->json(
                array(
                    'status' => False,
                    'data' => $data
                ),
                200
            );
        }
    }
    public function blogCategory(Request $request)
    {
        $data = Blog_category::select('id', 'name', 'slug')->get();

        if (!empty($data)) {
            return response()->json(
                array(
                    'status' => True,
                    'data' => $data
                ),
                200
            );
        } else {
            return response()->json(
                array(
                    'status' => False,
                    'data' => $data
                ),
                200
            );
        }
    }

    public function podcast(Request $request)
    {
        $array = Podcast::select('id', 'title', 'duration', 'sub_title', 'image')->orderBy('id', 'DESC')->get();

        $data = $array->map(function ($item) {
            $item->image = asset('assets/uploads/podcast/') . '/' . $item->image;
            $item->sub_title = Str::limit((strip_tags($item->sub_title)), 50, '...');
            return $item;
        });


        if (!empty($data)) {
            return response()->json(
                array(
                    'status' => True,
                    'data' => $data
                ),
                200
            );
        } else {
            return response()->json(
                array(
                    'status' => False,
                    'data' => $data
                ),
                200
            );
        }
    }
    public function podcastDetails(Request $request)
    {
        $data = Podcast::select('id', 'title', 'therapist_id', 'author', 'audio', 'image', 'tags', 'color')->where('id', $request->id)->first();
        $array = [];
        $array['title'] = $data->title;
        $array['color'] = $data->color;

        if ($data->author == 'T') {
            $array['author'] = $data->therapist->full_name;
            $array['author_image'] = asset('assets/uploads/therapist/' . $data->therapist->image);
            //  $t = Therapist::select('full_name', 'image')->where('id', $data->therapist_id)->first();

            // $array['author'] = $t->full_name;
            // $array['author_image'] = asset('assets/uploads/therapist/' . $t->image);
        } elseif ($data->author == 'F') {
            $array['author'] = 'Feni';
            $array['author_image'] = asset('assets/img/fenni.jpg');
        }

        $array['image'] = asset('assets/uploads/podcast/') . '/' . $data->image;
        $array['audio'] = asset('assets/uploads/podcast/audio/') . '/' . $data->audio;

        if (!empty($array)) {
            return response()->json(
                array(
                    'status' => True,
                    'data' => $array
                ),
                200
            );
        } else {
            return response()->json(
                array(
                    'status' => False,
                    'data' => $array
                ),
                200
            );
        }
    }
}
