<?php

namespace App\Http\Controllers\User;

use App\Http\Controllers\Controller;
use App\Models\Assessment;
use App\Models\User_Assessment;
use App\Models\User_Assessment_Q_and_A;
use App\Models\Assessment_questions;
use App\Models\Assessment_rate_settings;
use App\Models\MoodTracker;
use Illuminate\Http\Request;
use Illuminate\Database\QueryException;

class AssessmentController extends Controller
{
    public function assessments(Request $request)
    {
        $array = Assessment::where('status', 'Active')->orderBy('id', 'DESC')->get();
        $data = [];

        foreach ($array as $key => $item) {
            $data[$key]['id'] = $item->id;
            $data[$key]['title'] = $item->title;
            $data[$key]['color'] = $item->color;
            $data[$key]['image'] = asset('assets/uploads/assessment/' . $item->image);
            $data[$key]['time_duration'] = $item->time_duration;
            $data[$key]['steps'] = count($item->questions);
        }


        if (!empty($data)) {
            return response()->json(
                array(
                    'status' => True,
                    'data' => $data
                ),
                200
            );
        } else {
            return response()->json(
                array(
                    'status' => False,
                    'data' => $data
                ),
                200
            );
        }
    }

    public function assessmentsQandA(Request $request)
    {
        $array = Assessment_questions::where('assessment_id', $request->assessment_id)->orderBy('id', 'ASC')->get();
        $data = [];

        foreach ($array as $key => $item) {
            $data[$key]['id'] = $item->id;
            $data[$key]['question'] = $item->question;
            $data[$key]['answers'] = $item->answer;
        }


        if (!empty($data)) {
            return response()->json(
                array(
                    'status' => True,
                    'data' => $data
                ),
                200
            );
        } else {
            return response()->json(
                array(
                    'status' => False,
                    'data' => $data
                ),
                200
            );
        }
    }
    public function saveAssessmentsQandA(Request $request)
    {

        try {
            $total = 0;
            if ($request->id) {
                $current_rate = User_Assessment::where('id', $request->id)->pluck('total_rate')->first();
                $total = $request->rate + $current_rate;
                $assessment = User_Assessment::where('id', $request->id)
                    ->update([
                        'total_rate' => $total
                    ]);

                if ($assessment != 1) {
                    return response()->json(
                        array(
                            'status' => false,
                            'data' => "Something went Wrong",
                            'statuscode' => 301
                        ),
                        200
                    );
                }
                $assessment_qa = new User_Assessment_Q_and_A();
                $assessment_qa->user_assessment_id = $request->id;
                $assessment_qa->question = $request->question;
                $assessment_qa->answer = $request->answer;
                $assessment_qa->rate = $request->rate;
                $assessment_qa->save();
                $total = $total;
                if ($assessment_qa) {
                    $rate_details = Assessment_rate_settings::where('start_rate', '<=', $total)->where('end_rate', '>=', $total)->first();
                    return response()->json(
                        array(
                            'status' => true,
                            'data' => "Assessment added successfully",
                            'updated_id' => $request->id,
                            'total_score' => $total,
                            'score_details' => $rate_details,
                            'statuscode' => 200
                        ),
                        200
                    );
                } else {
                    return response()->json(
                        array(
                            'status' => false,
                            'data' => "Something went Wrong",
                            'statuscode' => 301
                        ),
                        200
                    );
                }
            } else {
                $total = $request->rate;
                $assessment = new User_Assessment();
                $assessment->user_id = auth()->user()->id;
                $assessment->assessment_id = $request->assessment_id;
                $assessment->total_rate = $total;
                $assessment->save();
                if (!$assessment) {
                    return response()->json(
                        array(
                            'status' => false,
                            'data' => "Something went Wrong",
                            'statuscode' => 301
                        ),
                        200
                    );
                }
                $assessment_qa = new User_Assessment_Q_and_A();
                $assessment_qa->user_assessment_id = $assessment->id;
                $assessment_qa->question = $request->question;
                $assessment_qa->answer = $request->answer;
                $assessment_qa->rate = $request->rate;
                $assessment_qa->save();
                if ($assessment_qa) {
                    $rate_details = Assessment_rate_settings::where('start_rate', '<=', $total)->where('end_rate', '>=', $total)->first();
                    return response()->json(
                        array(
                            'status' => true,
                            'data' => "Assessment added successfully",
                            'updated_id' => $assessment->id,
                            'total_score' => $total,
                            'score_details' => $rate_details,
                            'statuscode' => 200
                        ),
                        200
                    );
                } else {
                    return response()->json(
                        array(
                            'status' => false,
                            'data' => "Something went Wrong",
                            'statuscode' => 301
                        ),
                        200
                    );
                }
            }
        } catch (QueryException $e) {
            return response()->json(
                array(
                    'status' => false,
                    'data' => $e->getMessage()
                ),
                200
            );
        }
    }
    public function saveMoodTracker(Request $request)
    {
        try {
            $res = MoodTracker::where('user_id', auth()->user()->id)->where('date', date("Y-m-d", strtotime(now())))->first();
            if ($res == null) {
                $user = new MoodTracker();
                $user->user_id = auth()->user()->id;
                $user->date = date("Y-m-d", strtotime(now()));
                $user->emotion = $request->emotion;
                $user->description = $request->description;
                $user->save();
            } else {
                $user = MoodTracker::where('id', $res->id)
                    ->update([
                        'emotion' => $request->emotion,
                        'description' => $request->description
                    ]);
            }
            if ($user) {
                return response()->json(
                    array(
                        'status' => true,
                        'data' => "Data added successfully",
                        'statuscode' => 200
                    ),
                    200
                );
            } else {
                return response()->json(
                    array(
                        'status' => false,
                        'data' => "Something went Wrong",
                        'statuscode' => 301
                    ),
                    200
                );
            }
        } catch (QueryException $e) {
            return response()->json(
                array(
                    'status' => false,
                    'data' => $e->getMessage()
                ),
                200
            );
        }
    }

    public function moodListing(Request $request)
    {
        try {
            $data = MoodTracker::select('id', 'date', 'emotion', 'description')->where('user_id', auth()->user()->id)->orderBy('date', 'DESC')->get();

            if ($data) {
                return response()->json(
                    array(
                        'status' => true,
                        'data' => $data,
                        'statuscode' => 200
                    ),
                    200
                );
            } else {
                return response()->json(
                    array(
                        'status' => false,
                        'data' => $data,
                        'statuscode' => 301
                    ),
                    200
                );
            }
        } catch (QueryException $e) {
            return response()->json(
                array(
                    'status' => false,
                    'data' => $e->getMessage()
                ),
                200
            );
        }
    }
    public function getMood(Request $request)
    {
        try {

            $data = MoodTracker::select('id', 'date', 'emotion', 'description')->where('user_id', auth()->user()->id)->where('date', $request->date)->orderBy('date', 'DESC')->first();

            if ($data) {
                return response()->json(
                    array(
                        'status' => true,
                        'data' => $data,
                        'statuscode' => 200
                    ),
                    200
                );
            } else {
                return response()->json(
                    array(
                        'status' => false,
                        'data' => $data,
                        'statuscode' => 301
                    ),
                    200
                );
            }
        } catch (QueryException $e) {
            return response()->json(
                array(
                    'status' => false,
                    'data' => $e->getMessage()
                ),
                200
            );
        }
    }
}
