<?php

namespace App\Http\Controllers\Therapist;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Therapist;
use App\Models\Appointments;
use Illuminate\Support\Facades\Auth;
use App\Models\UserReview;
use App\Models\SlotShedule;
use Carbon\Carbon;
use App\Models\ServiceFeeStructure;
use Illuminate\Database\QueryException;
use App\Models\Prescription;
use App\Models\ConsulationNote;
use Illuminate\Support\Facades\DB;
use App\Models\UserWalletTransactions;
use App\Models\UserWallet;
use App\Models\WalletPoint;
use App\Notifications\AppoinmentNotification;
use App\Models\Admin;
use Illuminate\Support\Facades\Notification;
use App\Models\PushNotification;
use App\Console\Commands\Appointment;
use App\Models\TherapistCommission;
use App\Models\WalletPointCommission;

class AppoinmentController extends Controller
{

    public function upcomingAppoinments(Request $request)
  {

        try {
            $now = Carbon::now();
            $current_time = $now->format('H:i');
            $data = [];
            $key = 0;

            $array = Appointments::where('therapist_id', auth()->user()->id)
                ->where('Appointment_Status', '!=', 'Cancel')
                ->where('Appointment_Status', '!=', 'Missed')
                ->where('Appointment_Status', '!=', 'Completed')
                ->where('Appointment_Status', '!=', 'Failed')
                ->where('Appointment_Date', '=', date('Y-m-d'))
                ->orderBy('Appointment_Date', 'DESC')
                ->orderByRaw("STR_TO_DATE(Appointment_Time, '%h:%i %p') ASC")
                ->get();
            $array2 = Appointments::where('therapist_id', auth()->user()->id)
                ->where('Appointment_Status', '!=', 'Cancel')
                ->where('Appointment_Status', '!=', 'Missed')
                ->where('Appointment_Status', '!=', 'Completed')
                ->where('Appointment_Status', '!=', 'Failed')
                ->where('Appointment_Date', '>', date('Y-m-d'))
                ->orderBy('Appointment_Date', 'DESC')
                ->orderByRaw("STR_TO_DATE(Appointment_Time, '%h:%i %p') ASC")
                ->get();
            if (count($array) > 0) {
                foreach ($array as $item) {
                    // $duration = ServiceFeeStructure::where('service_id', $item->service_id)->where('provider_category_id', $item->therapist->provider_category_id)->where('call_method_id', $item->Appointment_Type)->pluck('duration')->first();
                    $givenDateTime = date("H:i", strtotime($item->Appointment_Time));

                    // $time = $item->Appointment_Date . " " . $givenDateTime . ":00";
                    // $closeTime =  Carbon::parse($time)->addMinutes($duration);
                    if ($item->user->image != NULL) {
                        $img = asset('assets/uploads/user/' . $item->user->image);
                    } else {
                        $img = asset('assets/img/no-image-available.jpg');
                    }
                    if ($item->Appointment_Date == date("Y-m-d")) {

                        if ($current_time > $givenDateTime) {
                            if ($item->Appointment_Status == 'Join' || $item->Appointment_Status == 'No Participants') {
                                $data[$key]['id'] = $item->id;
                                $data[$key]['user_id'] = $item->user->id;
                                $data[$key]['user_name'] = $item->user->First_Name . ' ' . $item->user->Last_Name;
                                $data[$key]['user_image'] = $img;
                                $data[$key]['Appointment_Date'] = $item->Appointment_Date;
                                $data[$key]['start_time'] = $item->Appointment_Time;
                                $data[$key]['end_time'] =  $item->end_time;
                                $data[$key]['Appointment_Status'] = $item->Appointment_Status;
                                $data[$key]['Appointment_Status_color'] = statusColor($item->Appointment_Status);
                                $data[$key]['call_type'] = $item->callMethod->name;
                                $data[$key]['call_type_id'] = $item->callMethod->id;
                                $data[$key]['service'] = $item->service_id;
                                $data[$key]['call_status'] = $item->call_status;
                                $data[$key]['follow_up_date'] = $item->follow_up_date;
                                $data[$key]['fee'] = $item->fee;
                                $key++;
                            } else {
                                $data[$key]['id'] = $item->id;
                                $data[$key]['user_id'] = $item->user->id;
                                $data[$key]['user_name'] = $item->user->First_Name . ' ' . $item->user->Last_Name;
                                $data[$key]['user_image'] = $img;
                                $data[$key]['Appointment_Date'] = $item->Appointment_Date;
                                $data[$key]['start_time'] = $item->Appointment_Time;
                                $data[$key]['end_time'] =  $item->end_time;
                                $data[$key]['Appointment_Status'] = $item->Appointment_Status;
                                $data[$key]['Appointment_Status_color'] = statusColor($item->Appointment_Status);
                                $data[$key]['call_type'] = $item->callMethod->name;
                                $data[$key]['call_type_id'] = $item->callMethod->id;
                                $data[$key]['service'] = $item->service_id;
                                $data[$key]['call_status'] = $item->call_status;
                                $data[$key]['follow_up_date'] = $item->follow_up_date;
                                $data[$key]['fee'] = $item->fee;
                                $key++;
                            }
                        } else {
                            $data[$key]['id'] = $item->id;
                            $data[$key]['user_id'] = $item->user->id;
                            $data[$key]['user_name'] = $item->user->First_Name . ' ' . $item->user->Last_Name;
                            $data[$key]['user_image'] = $img;
                            $data[$key]['Appointment_Date'] = $item->Appointment_Date;
                            $data[$key]['start_time'] = $item->Appointment_Time;
                            $data[$key]['end_time'] =  $item->end_time;
                            $data[$key]['Appointment_Status'] = $item->Appointment_Status;
                            $data[$key]['Appointment_Status_color'] = statusColor($item->Appointment_Status);
                            $data[$key]['call_type'] = $item->callMethod->name;
                            $data[$key]['call_type_id'] = $item->callMethod->id;
                            $data[$key]['service'] = $item->service_id;
                            $data[$key]['call_status'] = $item->call_status;
                            $data[$key]['follow_up_date'] = $item->follow_up_date;
                            $data[$key]['fee'] = $item->fee;
                            $key++;
                        }
                    } else {
                        $data[$key]['id'] = $item->id;
                        $data[$key]['user_id'] = $item->user->id;
                        $data[$key]['user_name'] = $item->user->First_Name . ' ' . $item->user->Last_Name;
                        $data[$key]['user_image'] = $img;
                        $data[$key]['Appointment_Date'] = $item->Appointment_Date;
                        $data[$key]['start_time'] = $item->Appointment_Time;
                        $data[$key]['end_time'] =  $item->end_time;
                        $data[$key]['Appointment_Status'] = $item->Appointment_Status;
                        $data[$key]['Appointment_Status_color'] = statusColor($item->Appointment_Status);
                        $data[$key]['call_type_id'] = $item->callMethod->id;
                        $data[$key]['service'] = $item->service_id;
                        $data[$key]['call_type'] = $item->callMethod->name;
                        $data[$key]['call_status'] = $item->call_status;
                        $data[$key]['follow_up_date'] = $item->follow_up_date;
                        $data[$key]['fee'] = $item->fee;
                        $key++;
                    }
                }
            } 
            if (count($array2) > 0) {
                foreach ($array2 as $item) {
                    // $duration = ServiceFeeStructure::where('service_id', $item->service_id)->where('provider_category_id', $item->therapist->provider_category_id)->where('call_method_id', $item->Appointment_Type)->pluck('duration')->first();
                    $givenDateTime = date("H:i", strtotime($item->Appointment_Time));

                    // $time = $item->Appointment_Date . " " . $givenDateTime . ":00";
                    // $closeTime =  Carbon::parse($time)->addMinutes($duration);
                    if ($item->user->image != NULL) {
                        $img = asset('assets/uploads/user/' . $item->user->image);
                    } else {
                        $img = asset('assets/img/no-image-available.jpg');
                    }
                    if ($item->Appointment_Date == date("Y-m-d")) {

                        if ($current_time > $givenDateTime) {
                            if ($item->Appointment_Status == 'Join' || $item->Appointment_Status == 'No Participants') {
                                $data[$key]['id'] = $item->id;
                                $data[$key]['user_id'] = $item->user->id;
                                $data[$key]['user_name'] = $item->user->First_Name . ' ' . $item->user->Last_Name;
                                $data[$key]['user_image'] = $img;
                                $data[$key]['Appointment_Date'] = $item->Appointment_Date;
                                $data[$key]['start_time'] = $item->Appointment_Time;
                                $data[$key]['end_time'] =  $item->end_time;
                                $data[$key]['Appointment_Status'] = $item->Appointment_Status;
                                $data[$key]['Appointment_Status_color'] = statusColor($item->Appointment_Status);
                                $data[$key]['call_type'] = $item->callMethod->name;
                                $data[$key]['call_type_id'] = $item->callMethod->id;
                                $data[$key]['service'] = $item->service_id;
                                $data[$key]['call_status'] = $item->call_status;
                                $data[$key]['follow_up_date'] = $item->follow_up_date;
                                $data[$key]['fee'] = $item->fee;
                                $key++;
                            } else {
                                $data[$key]['id'] = $item->id;
                                $data[$key]['user_id'] = $item->user->id;
                                $data[$key]['user_name'] = $item->user->First_Name . ' ' . $item->user->Last_Name;
                                $data[$key]['user_image'] = $img;
                                $data[$key]['Appointment_Date'] = $item->Appointment_Date;
                                $data[$key]['start_time'] = $item->Appointment_Time;
                                $data[$key]['end_time'] =  $item->end_time;
                                $data[$key]['Appointment_Status'] = $item->Appointment_Status;
                                $data[$key]['Appointment_Status_color'] = statusColor($item->Appointment_Status);
                                $data[$key]['call_type'] = $item->callMethod->name;
                                $data[$key]['call_type_id'] = $item->callMethod->id;
                                $data[$key]['service'] = $item->service_id;
                                $data[$key]['call_status'] = $item->call_status;
                                $data[$key]['follow_up_date'] = $item->follow_up_date;
                                $data[$key]['fee'] = $item->fee;
                                $key++;
                            }
                        } else {
                            $data[$key]['id'] = $item->id;
                            $data[$key]['user_id'] = $item->user->id;
                            $data[$key]['user_name'] = $item->user->First_Name . ' ' . $item->user->Last_Name;
                            $data[$key]['user_image'] = $img;
                            $data[$key]['Appointment_Date'] = $item->Appointment_Date;
                            $data[$key]['start_time'] = $item->Appointment_Time;
                            $data[$key]['end_time'] =  $item->end_time;
                            $data[$key]['Appointment_Status'] = $item->Appointment_Status;
                            $data[$key]['Appointment_Status_color'] = statusColor($item->Appointment_Status);
                            $data[$key]['call_type'] = $item->callMethod->name;
                            $data[$key]['call_type_id'] = $item->callMethod->id;
                            $data[$key]['service'] = $item->service_id;
                            $data[$key]['call_status'] = $item->call_status;
                            $data[$key]['follow_up_date'] = $item->follow_up_date;
                            $data[$key]['fee'] = $item->fee;
                            $key++;
                        }
                    } else {
                        $data[$key]['id'] = $item->id;
                        $data[$key]['user_id'] = $item->user->id;
                        $data[$key]['user_name'] = $item->user->First_Name . ' ' . $item->user->Last_Name;
                        $data[$key]['user_image'] = $img;
                        $data[$key]['Appointment_Date'] = $item->Appointment_Date;
                        $data[$key]['start_time'] = $item->Appointment_Time;
                        $data[$key]['end_time'] =  $item->end_time;
                        $data[$key]['Appointment_Status'] = $item->Appointment_Status;
                        $data[$key]['Appointment_Status_color'] = statusColor($item->Appointment_Status);
                        $data[$key]['call_type_id'] = $item->callMethod->id;
                        $data[$key]['service'] = $item->service_id;
                        $data[$key]['call_type'] = $item->callMethod->name;
                        $data[$key]['call_status'] = $item->call_status;
                        $data[$key]['follow_up_date'] = $item->follow_up_date;
                        $data[$key]['fee'] = $item->fee;
                        $key++;
                    }
                }
              
            }
            if ($data) {
                return response()->json(
                    array(
                        'status' => true,
                        'data' => $data,
                        'statuscode' => 200
                    ),
                    200
                );
            } else {
                return response()->json(
                    array(
                        'status' => true,
                        'data' => $data,
                        'statuscode' => 200
                    ),
                    200
                );
            }
        } catch (QueryException $e) {
            return response()->json(
                array(
                    'status' => false,
                    'data' => $e->getMessage()
                ),
                200
            );
        }
    }
    
    public function cancelledAppoinments(Request $request)
    {

        try {
            $now = Carbon::now();
            $current_time = $now->format('H:i');
            $data = [];
            $key = 0;
            $array = Appointments::where('therapist_id', auth()->user()->id)->where('Appointment_Status', 'Cancel')->orderBy('Appointment_Date', 'ASC')->orderByRaw("STR_TO_DATE(Appointment_Time, '%h:%i %p') DESC")->get();
            foreach ($array as $item) {
                //   $duration = ServiceFeeStructure::where('service_id', $item->service_id)->where('provider_category_id', $item->therapist->provider_category_id)->where('call_method_id', $item->Appointment_Type)->pluck('duration')->first();
                $givenDateTime = date("H:i", strtotime($item->Appointment_Time));

                //  $time = $item->Appointment_Date . " " . $givenDateTime . ":00";
                //  $closeTime =  Carbon::parse($time)->addMinutes($duration);
                if ($item->user->image != NULL) {
                    $img = asset('assets/uploads/user/' . $item->user->image);
                } else {
                    $img = asset('assets/img/no-image-available.jpg');
                }
                if ($item->Appointment_Date == date("Y-m-d")) {

                    if ($current_time > $givenDateTime) {
                        continue;
                    } else {
                        $data[$key]['id'] = $item->id;
                        $data[$key]['user_id'] = $item->user->id;
                        $data[$key]['user_name'] = $item->user->First_Name . ' ' . $item->user->Last_Name;
                        $data[$key]['user_image'] = $img;
                        $data[$key]['Appointment_Date'] = $item->Appointment_Date;
                        $data[$key]['start_time'] = $item->Appointment_Time;
                        $data[$key]['end_time'] =  $item->end_time;
                        $data[$key]['Appointment_Status'] = $item->Appointment_Status;
                        $data[$key]['Appointment_Status_color'] = statusColor($item->Appointment_Status);
                        $data[$key]['call_type'] = $item->callMethod->name;
                        $data[$key]['call_type_id'] = $item->callMethod->id;
                        $data[$key]['service'] = $item->service_id;
                        $data[$key]['call_status'] = $item->call_status;
                        $data[$key]['follow_up_date'] = $item->follow_up_date;
                        $data[$key]['fee'] = $item->fee;
                        $key++;
                    }
                } else {
                    $data[$key]['id'] = $item->id;
                    $data[$key]['user_id'] = $item->user->id;
                    $data[$key]['user_name'] = $item->user->First_Name . ' ' . $item->user->Last_Name;
                    $data[$key]['user_image'] = $img;
                    $data[$key]['Appointment_Date'] = $item->Appointment_Date;
                    $data[$key]['start_time'] = $item->Appointment_Time;
                    $data[$key]['end_time'] =  $item->end_time;
                    $data[$key]['Appointment_Status'] = $item->Appointment_Status;
                    $data[$key]['Appointment_Status_color'] = statusColor($item->Appointment_Status);
                    $data[$key]['call_type'] = $item->callMethod->name;
                    $data[$key]['call_type_id'] = $item->callMethod->id;
                    $data[$key]['service'] = $item->service_id;
                    $data[$key]['call_status'] = $item->call_status;
                    $data[$key]['follow_up_date'] = $item->follow_up_date;
                    $data[$key]['fee'] = $item->fee;
                    $key++;
                }
            }
            if ($data) {
                return response()->json(
                    array(
                        'status' => true,
                        'data' => $data,
                        'statuscode' => 200
                    ),
                    200
                );
            } else {
                return response()->json(
                    array(
                        'status' => true,
                        'data' => $data,
                        'statuscode' => 200
                    ),
                    200
                );
            }
        } catch (QueryException $e) {
            return response()->json(
                array(
                    'status' => false,
                    'data' => $e->getMessage()
                ),
                200
            );
        }
    }
    public function previousAppoinments(Request $request)
    {

        try {
            $now = Carbon::now();
            $current_time = $now->format('H:i');
            $data = [];
            $key = 0;
            $array = Appointments::where('therapist_id', auth()->user()->id)
                ->where('Appointment_Status', '!=', 'Cancel')
                ->where('Appointment_Status', '!=', 'Join')
                ->where('Appointment_Status', '!=', 'No Participants')
                ->where('Appointment_Status', '!=', 'Failed')
                ->where('Appointment_Date', '<=', date('Y-m-d'))
                ->orderBy('Appointment_Date', 'DESC')
                ->orderByRaw("STR_TO_DATE(Appointment_Time, '%h:%i %p') DESC")
                ->get();
            if (count($array) > 0) {
                foreach ($array as $item) {
                    if ($item->user->image != NULL) {
                        $img = asset('assets/uploads/user/' . $item->user->image);
                    } else {
                        $img = asset('assets/img/no-image-available.jpg');
                    }

                    //  $duration = Slot::where('therapist_id', auth()->user()->id)->pluck('call_duration')->first();
                    $givenDateTime = date("H:i", strtotime($item->Appointment_Time));

                    // $time = $item->Appointment_Date . " " . $givenDateTime . ":00";
                    // $closeTime =  Carbon::parse($time)->addMinutes($duration);

                    if ($item->Appointment_Date == date("Y-m-d")) {

                        if ($current_time < $givenDateTime) {
                            continue;
                        } else {
                            $data[$key]['id'] = $item->id;
                            $data[$key]['user_id'] = $item->user->id;
                            $data[$key]['user_name'] = $item->user->First_Name . ' ' . $item->user->Last_Name;
                            $data[$key]['user_image'] = $img;
                            $data[$key]['Appointment_Date'] = $item->Appointment_Date;
                            $data[$key]['start_time'] = $item->Appointment_Time;
                            $data[$key]['end_time'] =  $item->end_time;
                            $data[$key]['Appointment_Status'] = $item->Appointment_Status;
                            $data[$key]['Appointment_Status_color'] = statusColor($item->Appointment_Status);
                            $data[$key]['call_type'] = $item->callMethod->name;
                            $data[$key]['call_status'] = $item->call_status;
                            $data[$key]['call_type_id'] = $item->callMethod->id;
                            $data[$key]['service'] = $item->service_id;
                            $data[$key]['follow_up_date'] = $item->follow_up_date;
                            $data[$key]['fee'] = $item->fee;
                            $key++;
                        }
                    } else {
                        $data[$key]['id'] = $item->id;
                        $data[$key]['user_id'] = $item->user->id;
                        $data[$key]['user_name'] = $item->user->First_Name . ' ' . $item->user->Last_Name;
                        $data[$key]['user_image'] = $img;
                        $data[$key]['Appointment_Date'] = $item->Appointment_Date;
                        $data[$key]['start_time'] = $item->Appointment_Time;
                        $data[$key]['end_time'] =  $item->end_time;
                        $data[$key]['Appointment_Status'] = $item->Appointment_Status;
                        $data[$key]['Appointment_Status_color'] = statusColor($item->Appointment_Status);
                        $data[$key]['call_type_id'] = $item->callMethod->id;
                        $data[$key]['service'] = $item->service_id;
                        $data[$key]['call_type'] = $item->callMethod->name;
                        $data[$key]['call_status'] = $item->call_status;
                        $data[$key]['follow_up_date'] = $item->follow_up_date;
                        $data[$key]['fee'] = $item->fee;
                        $key++;
                    }
                }
                if ($data) {
                    return response()->json(
                        array(
                            'status' => true,
                            'data' => $data,
                            'statuscode' => 200
                        ),
                        200
                    );
                } else {
                    return response()->json(
                        array(
                            'status' => true,
                            'data' => $data,
                            'statuscode' => 200
                        ),
                        200
                    );
                }
            } else {
                return response()->json(
                    array(
                        'status' => true,
                        'data' => $array,
                        'statuscode' => 200
                    ),
                    200
                );
            }
        } catch (QueryException $e) {
            return response()->json(
                array(
                    'status' => false,
                    'data' => $e->getMessage()
                ),
                200
            );
        }
    }

    public function addPrescription(Request $request)
    {

        try {
            //  print_r($request->all());die();
            $res = Prescription::where('appoinment_id', $request->appoinment_id)->first();
            if ($request->hasFile('attachment')) {
                if ($res != null) {
                    if (file_exists(public_path('assets/uploads/prescription/' . $res->attachment)) && ($res->attachment != null)) {
                        unlink("assets/uploads/prescription/" . $res->attachment);
                    }
                }
                $rand = rand(100, 999);
                $image = time() . '.' . $request->attachment->extension();
                $imageOriginalName = $request->attachment->getClientOriginalName();
                $request->attachment->move(public_path('assets/uploads/prescription'), $image);
            }


            if ($res == null) {
                $review = new Prescription();
                $review->therapist_id = auth()->user()->id;
                $review->user_id = $request->user_id;
                $review->appoinment_id = $request->appoinment_id;
                // $review->note = $request->note;
                $review->attachment = $image;
                $review->save();
            } else {
                $review = Prescription::where('id', $res->id)->update([
                    'therapist_id' => auth()->user()->id,
                    'attachment' => $image
                ]);
            }
            // ******** Image uploade start ********

            // ******** Image uploade end ********

            if ($review) {
                return response()->json(
                    array(
                        'status' => true,
                        'data' => "Prescription added successfully",
                        'statuscode' => 200
                    ),
                    200
                );
            } else {
                return response()->json(
                    array(
                        'status' => false,
                        'data' => "Something went Wrong",
                        'statuscode' => 301
                    ),
                    200
                );
            }
        } catch (QueryException $e) {
            return response()->json(
                array(
                    'status' => false,
                    'data' => $e->getMessage()
                ),
                200
            );
        }
    }

    public function addConsulation(Request $request)
    {
        try {
            $res = ConsulationNote::where('appoinment_id', $request->appoinment_id)->first();
            $image = NULL;
            if ($request->hasFile('attachment')) {
                if (file_exists(public_path('assets/uploads/user/' . $res->attachment)) && ($res->attachment != null)) {
                    unlink("assets/uploads/consultation/" . $res->attachment);
                }
                $rand = rand(100, 999);
                $image = time() . '.' . $request->attachment->extension();
                $imageOriginalName = $request->attachment->getClientOriginalName();
                $request->attachment->move(public_path('assets/uploads/consultation'), $image);
            }
            if ($res == null) {
                $res = new ConsulationNote();
                $res->therapist_id = auth()->user()->id;
                $res->user_id = $request->user_id;
                $res->appoinment_id = $request->appoinment_id;
                $res->note = $request->note;
                $res->attachment = $image;
                $res->save();
            } else {
                $res = ConsulationNote::where('id', $res->id)
                    ->update([
                        'user_id' => $request->user_id,
                        'appoinment_id' => $request->appoinment_id,
                        'note' => $request->note,
                        'attachment' => $image
                    ]);
            }
            $appoinmentStatus = Appointments::where('id', $request->appoinment_id)
                ->update(['Appointment_Status' => 'Completed']);
            $appoinment = Appointments::select('fee', 'therapist_id')->where('id', $request->appoinment_id)->first();

            $commission = TherapistCommission::where('therapist_id', $appoinment->therapist_id)->where('appoinment_id', $request->appoinment_id)->first();


            if ($commission == null) {
                $providercategory = Therapist::where('id', $appoinment->therapist_id)->pluck('provider_category_id')->first();

                $platformFeePercentage = WalletPointCommission::where('provider_category_id', $providercategory)->pluck('commission')->first();
                $amount = $appoinment->fee;
                $platformFee = $amount * ($platformFeePercentage / 100);
                $therapistEarnings = $amount - $platformFee;

                $tc = new TherapistCommission();
                $tc->therapist_id = $appoinment->therapist_id;
                $tc->appoinment_id = $request->appoinment_id;
                $tc->amount = $amount;
                $tc->commission = $platformFeePercentage;
                $tc->platform_fee = $therapistEarnings;
                $tc->therapist_earnings =  $platformFee;
                $tc->save();
            }
            if ($res) {
                return response()->json(
                    array(
                        'status' => true,
                        'data' => "Consulation added successfully",
                        'statuscode' => 200
                    ),
                    200
                );
            } else {
                return response()->json(
                    array(
                        'status' => false,
                        'data' => "Something went Wrong",
                        'statuscode' => 301
                    ),
                    200
                );
            }
        } catch (QueryException $e) {
            return response()->json(
                array(
                    'status' => false,
                    'data' => $e->getMessage()
                ),
                200
            );
        }
    }


    public function packageAppoinments(Request $request)
    {

        try {
            $now = Carbon::now();
            $current_time = $now->format('H:i');
            $data = [];
            $key = 0;
            $array = Appointments::select('user_id', 'package_id', DB::raw('count(*) as total'))
                ->where('therapist_id', auth()->user()->id)
                ->where('package_id', '!=', null)
                ->orderBy('Appointment_Date', 'ASC')
                ->groupBy('package_id')
                ->get();
            if (count($array) > 0) {
                foreach ($array as $key => $item) {
                    if ($item->user->image != NULL) {
                        $img = asset('assets/uploads/user/' . $item->user->image);
                    } else {
                        $img = asset('assets/img/no-image-available.jpg');
                    }
                    $completed_session = completedPackagesessions($item->package_id, auth()->user()->id, $item->user_id);
                    $avg = ($completed_session / $item->package->no_of_sessions) * 100;
                    $data[$key]['user_id'] = $item->user_id;
                    $data[$key]['user_name'] = $item->user->First_Name . ' ' . $item->user->Last_Name;
                    $data[$key]['user_image'] = $img;
                    $data[$key]['package_id'] = $item->package->id;
                    $data[$key]['package_name'] = $item->package->title;
                    $data[$key]['total_sessions'] = $item->package->no_of_sessions;
                    $data[$key]['completed_sessions'] = $completed_session;
                    $data[$key]['percentage_rate'] = $avg;
                }
                if ($data) {
                    return response()->json(
                        array(
                            'status' => true,
                            'data' => $data,
                            'statuscode' => 200
                        ),
                        200
                    );
                } else {
                    return response()->json(
                        array(
                            'status' => false,
                            'data' => $data,
                            'statuscode' => 200
                        ),
                        200
                    );
                }
            } else {
                return response()->json(
                    array(
                        'status' => true,
                        'data' => [],
                        'statuscode' => 200
                    ),
                    200
                );
            }
        } catch (QueryException $e) {
            return response()->json(
                array(
                    'status' => false,
                    'data' => $e->getMessage()
                ),
                200
            );
        }
    }

    public function cancelReason(Request $request)
    {
        $data = Appointments::where('id', $request->appoinment_id)->pluck('cancel_reason')->first();

        if ($data) {
            return response()->json(
                array(
                    'status' => true,
                    'reason' => $data,
                    'statuscode' => 200
                ),
                200
            );
        } else {
            return response()->json(
                array(
                    'status' => false,
                    'reason' => "",
                    'statuscode' => 301
                ),
                200
            );
        }
    }

    public function changeAppoinmentStatus(Request $request)
    {
        $data = [
            'appoinment_id' => $request->appoinment_id
        ];
        $notification = Admin::first();

        #store notification info into notifications table
        $notification->notify(new AppoinmentNotification($data));
        try {
            if ($request->status == 'Cancel') {
                $appoinment = Appointments::select('Appointment_Time', 'Appointment_Date', 'user_id')->where('id', $request->appoinment_id)->first();
                $d = $appoinment->Appointment_Date . ' ' . $appoinment->Appointment_Time;
                $appoinmentTime = date("Y-m-d H:i:s", strtotime($d));
                $checkTime = Carbon::parse($appoinmentTime)->subHours(5);
                $currentDateTime = Carbon::now();

                if ($currentDateTime > $checkTime) {
                    return response()->json(
                        array(
                            'status' => false,
                            'data' => "Cancel time exceed",
                            'statuscode' => 301
                        ),
                        200
                    );
                }
                $res = Appointments::where('id', $request->appoinment_id)
                    ->update([
                        'Appointment_Status' => $request->status,
                        'cancel_reason' => $request->reason
                    ]);


                $point = WalletPoint::orderBy('id', 'DESC')->first();

                $amount = Appointments::where('id', $request->appoinment_id)->pluck('fee')->first();;
                $userpoint = $amount;



                $userwallet = UserWallet::where('user_id', $appoinment->user_id)->first();
                if ($userwallet == null) {
                    $userBalance = 0;
                    $balance = $userBalance + $userpoint;

                    $userwalletadd = new UserWallet();
                    $userwalletadd->user_id = $appoinment->user_id;
                    $userwalletadd->balance = $balance;
                    $userwalletadd->save();
                } else {
                    $userBalance = $userwallet->balance;
                    $balance = $userBalance + $userpoint;

                    $userwalletadd = UserWallet::where('id', $userwallet->id)->update([
                        'user_id' => $appoinment->user_id,
                        'balance' => $balance
                    ]);
                }

                $userWalletTransaction = new UserWalletTransactions();
                $userWalletTransaction->user_id = $appoinment->user_id;
                $userWalletTransaction->wallet_id = 2;
                $userWalletTransaction->type = 'Credit';
                $userWalletTransaction->amount = $amount;
                $userWalletTransaction->point = $userpoint;
                $userWalletTransaction->current_balance = $balance;
                $userWalletTransaction->save();

                if ($userWalletTransaction) {
                    return response()->json(
                        array(
                            'status' => true,
                            'data' => $request->status . " Your appoinment successfully. Refund amount updated to user wallet balance.",
                            'statuscode' => 200
                        ),
                        200
                    );
                } else {
                    return response()->json(
                        array(
                            'status' => false,
                            'data' => "Something went Wrong",
                            'statuscode' => 301
                        ),
                        200
                    );
                }
            } elseif ($request->status == 'Resheduled') {
                $appoinment = Appointments::select('Appointment_Time', 'Appointment_Date')->where('id', $request->appoinment_id)->first();
                $d = $appoinment->Appointment_Date . ' ' . $appoinment->Appointment_Time;
                $appoinmentTime = date("Y-m-d H:i:s", strtotime($d));
                $checkTime = Carbon::parse($appoinmentTime)->subHours(5);
                $currentDateTime = Carbon::now();

                if ($currentDateTime > $checkTime) {
                    return response()->json(
                        array(
                            'status' => false,
                            'data' => "Reshedule time exceed",
                            'statuscode' => 301
                        ),
                        200
                    );
                }
                $res = Appointments::where('id', $request->appoinment_id)
                    ->update([
                        'Appointment_Status' => $request->status,
                        'reshedule_reason' => $request->reason
                    ]);
            } else {
                $res = Appointments::where('id', $request->appoinment_id)
                    ->update([
                        'Appointment_Status' => $request->status
                    ]);
            }

            if ($res) {
                return response()->json(
                    array(
                        'status' => true,
                        'data' => $request->status . " Your appoinment successfully",
                        'statuscode' => 200
                    ),
                    200
                );
            } else {
                return response()->json(
                    array(
                        'status' => false,
                        'data' => "Something went Wrong",
                        'statuscode' => 301
                    ),
                    200
                );
            }
        } catch (QueryException $e) {
            return response()->json(
                array(
                    'status' => false,
                    'data' => $e->getMessage()
                ),
                200
            );
        }
    }

    public function followupdate(Request $request)
    {

        $res = Appointments::where('id', $request->appoinment_id)->update(['follow_up_date' => date("y-m-d", strtotime($request->date))]);
        if ($res) {
            return response()->json(
                array(
                    'status' => true,
                    'data' => " Follow up date addd successfully",
                    'statuscode' => 200
                ),
                200
            );
        } else {
            return response()->json(
                array(
                    'status' => false,
                    'data' => "Something went Wrong",
                    'statuscode' => 301
                ),
                200
            );
        }
    }
    public function downloadConsulation(Request $request)
    {

        $data = Appointments::where('id', $request->appoinment_id)->first();
        $pres = ConsulationNote::where('appoinment_id', $request->appoinment_id)->first();
        if ($pres) {
            $file = public_path('assets/uploads/consultation/' . $pres->attachment);;
        } else {
            $file = NULL;
        }
        if ($pres) {

            return response()->json(
                array(
                    'status' => true,
                    'note' => $pres->note,
                    'link' => $file,
                    'statuscode' => 200
                ),
                200
            );
        } else {

            return response()->json(
                array(
                    'status' => false,
                    'note' => '',
                    'link' => "",
                    'statuscode' => 500
                ),
                500
            );
        }
        // $headers = [
        //     'Content-Type' => 'application/pdf',
        // ];

        // return response()->download($file, 'eConsultation' . $data->user->First_Name . $data->user->Last_Name . ' _00' . $data->id . $data->user->id, $headers);
    }
    public function downloadCousltationattachment(Request $request)
    {

        $data = Appointments::where('id', $request->appoinment_id)->first();
        $pres = ConsulationNote::where('appoinment_id', $request->appoinment_id)->first();
        if ($pres->attachment != null) {
            $file = public_path('assets/uploads/consultation/' . $pres->attachment);
            return response()->download($file, 'eConsultation' . $data->user->First_Name . $data->user->Last_Name . ' _00' . $data->id . $data->user->id);
        } else {
            $file = NULL;
            return response()->json(
                array(
                    'status' => false,
                    'link' => "",
                    'statuscode' => 500
                ),
                500
            );
        }
    }
    public function downloadPrescription(Request $request)
    {

        $data = Appointments::where('id', $request->appoinment_id)->first();
        $pres = Prescription::where('appoinment_id', $request->appoinment_id)->first();
        if ($pres->attachment != null) {
            $file = public_path('assets/uploads/prescription/' . $pres->attachment);
            return response()->download($file, 'ePrescription' . $data->user->First_Name . $data->user->Last_Name . ' _00' . $data->id . $data->user->id);
        } else {
            $file = NULL;
            return response()->json(
                array(
                    'status' => false,
                    'link' => "",
                    'statuscode' => 500
                ),
                500
            );
        }
    }
}
