<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Chat;
use App\Models\User;
use App\Models\Therapist;
use Illuminate\Database\QueryException;

class ChatController extends Controller
{
    public function saveUserChat(Request $request)
    {
        try {
            $msg = $request->message;
            if ($request->hasFile('message')) {
                $rand = rand(100, 999);
                $msg = time() . '.' . $request->message->extension();
                $imageOriginalName = $request->message->getClientOriginalName();
                $request->message->move(public_path('assets/uploads/chat'), $msg);
            }

            $chat = new Chat();
            $chat->user_id = auth()->user()->id;
            $chat->therapist_id = $request->therapist_id;
            $chat->message = $msg;
            $chat->message_type = $request->message_type;
            $chat->sendby = $request->sendby;
            $chat->send_date = now()->format('Y-m-d');
            $chat->save();


            if ($chat) {

                $therapist = Therapist::where('id', $request->therapist_id)->first();
                $data = [
                    "to" => $therapist->device_token,
                    "notification" => [
                        'title' => 'You have new message from ' . auth()->user()->First_Name . ' ' . auth()->user()->Last_Name,
                        'body' => $msg,
                    ],
                    "data" => [
                        "route" => "notification"
                    ]
                ];

                sendpushnotification($data);

                return response()->json(
                    array(
                        'status' => true,
                        'data' => "Data saved  Sucessfully"
                    ),
                    200
                );
            } else {
                return response()->json(
                    array(
                        'status' => false,
                        'data' => "Something went Wrong"
                    ),
                    200
                );
            }
        } catch (QueryException $e) {
            return response()->json(
                array(
                    'status' => false,
                    'data' => $e->getMessage()
                ),
                200
            );
        }
    }

    public function saveTherapistChat(Request $request)
    {
        try {
            $msg = $request->message;
            if ($request->hasFile('message')) {
                $rand = rand(100, 999);
                $msg = time() . '.' . $request->message->extension();
                $imageOriginalName = $request->message->getClientOriginalName();
                $request->message->move(public_path('assets/uploads/chat'), $msg);
            }

            $chat = new Chat();
            $chat->user_id = $request->user_id;
            $chat->therapist_id = auth()->user()->id;
            $chat->message = $msg;
            $chat->message_type = $request->message_type;
            $chat->sendby = $request->sendby;
            $chat->send_date = now()->format('Y-m-d');
            $chat->save();


            if ($chat) {

                $user = User::where('id', $request->user_id)->first();
                $data = [
                    "to" => $user->device_token,
                    "notification" => [
                        'title' => 'You have new message from ' . auth()->user()->full_name,
                        'body' => $msg,
                    ],
                    "data" => [
                        "route" => "notification"
                    ]
                ];
                sendpushnotification($data);

                return response()->json(
                    array(
                        'status' => true,
                        'data' => "Data saved  Sucessfully"
                    ),
                    200
                );
            } else {
                return response()->json(
                    array(
                        'status' => false,
                        'data' => "Something went Wrong"
                    ),
                    200
                );
            }
        } catch (QueryException $e) {
            return response()->json(
                array(
                    'status' => false,
                    'data' => $e->getMessage()
                ),
                200
            );
        }
    }

    public function getTherapistChat(Request $request)
    {
        try {
            $chat = Chat::where('therapist_id', auth()->user()->id)
                ->where('user_id', $request->user_id)
                ->orderBy('id', 'DESC')
                ->get();
            $data = $chat->map(function ($item) {
                if ($item->message_type == 'file') {
                    $item->message = asset('assets/uploads/chat/') . '/' . $item->message;
                }
                return $item;
            });
            if ($chat) {
                return response()->json(
                    array(
                        'status' => true,
                        'data' => $data
                    ),
                    200
                );
            } else {
                return response()->json(
                    array(
                        'status' => false,
                        'data' => "Something went Wrong"
                    ),
                    200
                );
            }
        } catch (QueryException $e) {
            return response()->json(
                array(
                    'status' => false,
                    'data' => $e->getMessage()
                ),
                200
            );
        }
    }


    public function getUserChat(Request $request)
    {
        try {
            $chat = Chat::where('therapist_id', $request->therapist_id)
                ->where('user_id', auth()->user()->id)
                ->orderBy('id', 'DESC')
                ->get();
            $data = $chat->map(function ($item) {
                if ($item->message_type == 'file') {
                    $item->message = asset('assets/uploads/chat/') . '/' . $item->message;
                }
                return $item;
            });
            if ($chat) {
                return response()->json(
                    array(
                        'status' => true,
                        'data' => $data
                    ),
                    200
                );
            } else {
                return response()->json(
                    array(
                        'status' => false,
                        'data' => "Something went Wrong"
                    ),
                    200
                );
            }
        } catch (QueryException $e) {
            return response()->json(
                array(
                    'status' => false,
                    'data' => $e->getMessage()
                ),
                200
            );
        }
    }
}
