<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\WalletPoint;
use App\Models\UserWalletTransactions;
use App\Models\UserWallet;
use App\Models\WalletPointCommission;
use App\Models\Settings;
use App\Models\TypesOfWallet;
use Illuminate\Database\QueryException;
use Yajra\DataTables\Facades\DataTables;

class WalletController extends Controller
{
    public function index(Request $request)
    {
        $data = Settings::first();
        return view('admin.configuration.settings', ['data' => $data]);
    }
    public function saveWalletPoint(Request $request)
    {
        try {
            $walletpoint = new WalletPoint();
            $walletpoint->rupee_amount = $request->rupee;
            $walletpoint->point = $request->point;
            $walletpoint->save();
            // $res = WalletPoint::insert([
            //     'point' => $request->point
            // ]);

            if ($walletpoint) {
                return true;
            } else {
                return false;
            }
        } catch (QueryException $e) {
            return $e->getMessage();
        }
    }

    public function getWalletPoints(Request $request)
    {
        if ($request->ajax()) {
            $data = WalletPoint::orderBy('id', 'DESC')->get();
            return Datatables::of($data)
                ->addIndexColumn()
                ->addColumn('created_at', function ($data) {
                    return date("d M Y", strtotime($data->created_at));
                })
                ->addColumn('rupee', function ($data) {
                    return $data->rupee_amount;
                })
                ->addColumn('point', function ($data) {
                    return $data->point;
                })
                ->escapeColumns([])

                ->make(true);
        }
    }

    public function saveWalletCommission(Request $request)
    {
        try {
            for ($i = 0; $i < count($request->category); $i++) {
                $data = WalletPointCommission::where('provider_category_id', $request->category[$i])->first();
                if ($data == null) {
                    $walletpoint = new WalletPointCommission();
                    $walletpoint->provider_category_id = $request->category[$i];
                    $walletpoint->commission = $request->commission[$i];
                    $walletpoint->save();
                } else {
                    $walletpoint = WalletPointCommission::where('provider_category_id', $request->category[$i])->update([
                        'commission' => $request->commission[$i]
                    ]);
                }
            }
            if ($walletpoint) {
                return true;
            } else {
                return false;
            }
        } catch (QueryException $e) {
            return $e->getMessage();
        }
    }


    public function walletTransactions(Request $request)
    {
        if ($request->ajax()) {
            $data = UserWalletTransactions::where('user_id', $request->slug)->orderBy('id', 'DESC')->get();
            return Datatables::of($data)
                ->addIndexColumn()
                ->addColumn('amount', function ($data) {
                    if ($data->type == 'Credit') {
                        return   '<p style="color:green;">' . $data->amount . '<p>';
                    } elseif ($data->type == 'Debit') {
                        return   '<p style="color:red;">' . $data->amount . '<p>';
                    }
                })
                ->addColumn('point', function ($data) {
                    if ($data->type == 'Credit') {
                        return   '<p style="color:green;">' . $data->point . '<p>';
                    } elseif ($data->type == 'Debit') {
                        return   '<p style="color:red;">' . $data->point . '<p>';
                    }
                })
                ->addColumn('date', function ($data) {
                    if ($data->type == 'Credit') {
                        return   '<p style="color:green;">' . date("d M Y H:m:i", strtotime($data->created_at)) . '<p>';
                    } elseif ($data->type == 'Debit') {
                        return   '<p style="color:red;">' . date("d M Y H:m:i", strtotime($data->created_at)) . '<p>';
                    }
                })
                ->addColumn('wallet_type', function ($data) {
                    if ($data->type == 'Credit') {
                        return   '<p style="color:green;">' . $data->typeOfWallet->name . '<p>';
                    } elseif ($data->type == 'Debit') {
                        return   '<p style="color:red;">' . $data->typeOfWallet->name . '<p>';
                    }
                })
                ->addColumn('transaction_type', function ($data) {
                    if ($data->type == 'Credit') {
                        return   '<p style="color:green;">' . $data->type . '<p>';
                    } elseif ($data->type == 'Debit') {
                        return   '<p style="color:red;">' . $data->type . '<p>';
                    }
                })
                ->addColumn('transaction_type', function ($data) {
                    $html = '';

                    if ($data->type == 'Credit') {

                        $html .= '<a href="javascript:;" class="custom-badge status-green" title="view Payment details" class="text-muted" data-bs-toggle="modal" data-bs-target="#view_payment">' . $data->type . '</a>';
                        if ($data->payment) {
                            $html .= '

    <div id="view_payment" class="modal fade delete-modal" role="dialog">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content">
            <div class="modal-header ">
            <h4>Payment Details</h4>
            </div
                <div class="modal-body">
                   <table class="table">
                   <tr>
                   <th>Payment Id</th>
                   <td>:</td>
                   <td>' . $data->payment->payment_id . '</td>
                   </tr>
                   <tr>
                   <th>Amount in currency</th>
                    <td>:</td>
                   <td>' . $data->payment->amount_in_currency . '</td>
                   </tr>
                   <tr>
                   <th>Amount in rupee</th>
                    <td>:</td>
                   <td>' . $data->payment->total_amount_in_rupee . '</td>
                   </tr>
                   <tr>
                   <th>Payment Currency</th>
                    <td>:</td>
                   <td>' . $data->payment->currency . '</td>
                   </tr>
                   <tr>
                   <th>Payment Method</th>
                    <td>:</td>
                   <td>' . $data->payment->payment_method . '</td>
                   </tr>
                   <tr>
                   <th>Payment Date</th>
                    <td>:</td>
                   <td>' . $data->payment->payment_date . '</td>
                   </tr>
                    <tr>
                   <th>Payment Status</th>
                    <td>:</td>
                   <td>' . $data->payment->payment_status . '</td>
                   </tr>
                  </table> 
                </div>
            </div>
        </div>
    </div>';
                        }
                    } elseif ($data->type == 'Debit') {
                        $html .= '<a href="javascript:;" class="custom-badge status-red">' . $data->type . '</a>';
                    }

                    return $html;
                })
                ->addColumn('balance', function ($data) {
                    if ($data->type == 'Credit') {
                        return   '<p style="color:green;">' . $data->current_balance . '<p>';
                    } elseif ($data->type == 'Debit') {
                        return   '<p style="color:red;">' . $data->current_balance . '<p>';
                    }
                })
                ->escapeColumns([])

                ->make(true);
        }
    }


    public function savePrivacyPolicy(Request $request)
    {
        try {
            $data = Settings::first();
            if ($data == null) {
                $settings = new Settings();
                $settings->privacy_and_terms = $request->privacy_and_terms;
                $settings->save();
            } else {
                $settings = Settings::where('id', $data->id)->update([
                    'privacy_and_terms' => $request->privacy_and_terms
                ]);
            }
            if ($settings) {
                return true;
            } else {
                return false;
            }
        } catch (QueryException $e) {
            return $e->getMessage();
        }
    }

    public function saveTermCondition(Request $request)
    {
        try {
            $data = Settings::first();
            if ($data == null) {
                $settings = new Settings();
                $settings->terms_and_conditions = $request->terms_and_conditions;
                $settings->save();
            } else {
                $settings = Settings::where('id', $data->id)->update([
                    'terms_and_conditions' => $request->terms_and_conditions
                ]);
            }
            if ($settings) {
                return true;
            } else {
                return false;
            }
        } catch (QueryException $e) {
            return $e->getMessage();
        }
    }

    public function saveContact(Request $request)
    {
        try {
            $data = Settings::first();
            if ($data == null) {
                $settings = new Settings();
                $settings->email = $request->email;
                $settings->phone = $request->phone;
                $settings->save();
            } else {
                $settings = Settings::where('id', $data->id)->update([
                    'email' => $request->email,
                    'phone' => $request->phone
                ]);
            }
            if ($settings) {
                return true;
            } else {
                return false;
            }
        } catch (QueryException $e) {
            return $e->getMessage();
        }
    }

    public function addWalletAmount(Request $request)
    {

        try {
            $point = WalletPoint::orderBy('id', 'DESC')->pluck('point')->first();
            $balance = $request->amount;
            $user_id = $request->user_id;
            $amount = $request->amount;
            $userpoint = $point * $request->amount;

            $userwallet = UserWallet::where('user_id', $request->user_id)->first();
            if ($userwallet == null) {
                $userBalance = 0;
                $balance = $userBalance + $userpoint;

                $userwalletadd = new UserWallet();
                $userwalletadd->user_id = $request->user_id;
                $userwalletadd->balance = $balance;
                $userwalletadd->save();
            } else {
                $userBalance = $userwallet->balance;
                $balance = $userBalance + $userpoint;

                $userwalletadd = UserWallet::where('id', $userwallet->id)->update([
                    'user_id' => $request->user_id,
                    'balance' => $balance
                ]);
            }

            $userWalletTransaction = new UserWalletTransactions();
            $userWalletTransaction->user_id = $user_id;
            $userWalletTransaction->wallet_id = 1;
            $userWalletTransaction->type = $request->type;
            $userWalletTransaction->amount = $amount;
            $userWalletTransaction->point = $userpoint;
            $userWalletTransaction->current_balance = $balance;
            $userWalletTransaction->save();




            if ($userWalletTransaction) {
                return response()->json(
                    array(
                        'status' => true,
                        'data' => "Wallet added successfully",
                        'statuscode' => 200
                    ),
                    200
                );
            } else {
                return response()->json(
                    array(
                        'status' => false,
                        'data' => "Something went Wrong",
                        'statuscode' => 301
                    ),
                    200
                );
            }
        } catch (QueryException $e) {
            return response()->json(
                array(
                    'status' => false,
                    'data' => $e->getMessage()
                ),
                200
            );
        }
    }

    public function updateWalletType(Request $request)
    {

        try {
            for ($i = 0; $i < count($request->id); $i++) {
                $res = TypesOfWallet::where('id', $request->id[$i])
                    ->update(['expiry_duration' => $request->expiry_duration[$i]]);
            }
            if ($res) {
                return true;
            } else {
                return false;
            }
        } catch (QueryException $e) {
            return $e->getMessage();
        }
    }
}
