<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Offer;
use Cviebrock\EloquentSluggable\Services\SlugService;
use Illuminate\Database\QueryException;
use Yajra\DataTables\Facades\DataTables;

class OfferController extends Controller
{
    public function index()
    {
        return view('admin.offer.list');
    }
    public function viewOffer(Request $request)
    {
        $data = Offer::where('id', $request->id)->first();
        if ($data->discount_type == '%') {
            $price = $data->discount_rate . $data->discount_type;
        } else {
            $price = $data->discount_type . $data->discount_rate;
        }
        $html = '<div class="card-box profile-header">
<div class="row">
<div class="col-md-12">
<div class="profile-view">
<div class="profile-img-wrap">
<div class="profile-img">
<a href="#"><img class="avatar" src="' . asset('assets/uploads/offers/' . $data->image) . '" alt=""></a>
</div>
</div>
<div class="profile-basic">
<div class="row">
<div class="col-md-5">
<div class="profile-info-left">
  <h3 class="user-name m-t-0 mb-0">' . $data->title . '</h3>
                                                    <small class="text-muted">' . $data->promo_code . '</small>
                                                    <div class="staff-id">Expiry Date : ' . date('d l Y', strtotime($data->expiry_date)) . '</div>
                                                    <div class="staff-msg"><a href="javascript:void(0);" class="status-pink">' . $price . '</a></div>
</div>
</div>
<div class="col-md-7">
<small>
' . $data->description . '
</small>
</div>
</div>
</div>
</div>
</div>
</div>
</div>';
        return  response()->json($html);
    }
    public function editOffer(Request $request)
    {
        $data = Offer::where('slug', $request->slug)->first();
        return view('admin.offer.edit', ['data' => $data]);
    }
    public function saveOffer(Request $request)
    {
        try {
            $request->validate([
                'title' => 'required',
                'promo_code' => 'required',
                'expiry_date' => 'required',
                'discount_type' => 'required',
                'discount_rate' => 'required',
                'expiry_date' => 'required',
                'image' => 'required',
                'note' => 'required'
            ]);

            $image = '';
            // ******** Image uploade start ********
            if ($request->hasFile('image')) {
                $rand = rand(100, 999);
                $image = time() . '.' . $request->image->extension();
                $imageOriginalName = $request->image->getClientOriginalName();
                $request->image->move(public_path('assets/uploads/offers'), $image);
            }

            // ******** Image uploade end ********
            $slug = SlugService::createSlug(Offer::class, 'slug', $request->title);

            $offer = new Offer();
            $offer->title = $request->title;
            $offer->slug = $slug;
            $offer->promo_code = $request->promo_code;
            $offer->discount_type = $request->discount_type;
            $offer->discount_rate = $request->discount_rate;
            $offer->image = $image;
            $offer->expiry_date = date("Y-m-d", strtotime($request->expiry_date));
            $offer->description = $request->note;
            $offer->save();
            if (!$offer) {
                return false;
            } else {
                return true;
            }
        } catch (QueryException $e) {
            return $e->getMessage();
        }
    }
    public function updateOffer(Request $request)
    {
        try {
            $request->validate([
                'title' => 'required',
                'promo_code' => 'required',
                'expiry_date' => 'required',
                'discount_type' => 'required',
                'discount_rate' => 'required',
                'expiry_date' => 'required',
                'note' => 'required'
            ]);

            $image = '';

            $data = Offer::where('id', $request->id)->first();
            if ($request->title != $data->title) {
                $slug = SlugService::createSlug(Offer::class, 'slug', $request->title);
            } else {
                $slug = $data->slug;
            }

            $params = [
                'title' => $request->title,
                'slug' => $slug,
                'promo_code' => $request->promo_code,
                'discount_type' => $request->discount_type,
                'discount_rate' => $request->discount_rate,
                'expiry_date' => date("Y-d-m", strtotime($request->expiry_date)),
                'description' => $request->note
            ];

            // ******** Image uploade start ********
            if ($request->hasFile('image')) {
                $rand = rand(100, 999);
                $image = time() . '.' . $request->image->extension();
                $imageOriginalName = $request->image->getClientOriginalName();
                $request->image->move(public_path('assets/uploads/offers'), $image);
                $result = Offer::where('id', $request->id)
                    ->update(['image' => $image]);
            }

            // ******** Image uploade end ********
            $result = Offer::where('id', $request->id)
                ->update(
                    $params
                );

            if ($result == 1) {
                return true;
            } else {
                return false;
            }
        } catch (QueryException $e) {
            return $e->getMessage();
        }
    }
    public function deleteOffer(Request $request)
    {

        $data = Offer::whereRaw('id = ?', $request->id)->first();

        if ((file_exists(public_path('assets/uploads/offers/' . $data->image))) && ($data->image != NULL)) {
            unlink("assets/uploads/offers/" . $data->image);
        }

        $res = Offer::where('id', $request->id)->delete();
        return $res;
    }

    public function getOffer(Request $request)
    {

        if ($request->ajax()) {
            $data = Offer::orderBy('id', 'DESC')->get();
            return Datatables::of($data)
                ->addIndexColumn()
                ->addColumn('action', function ($data) {
                    $actionBtn = '<a href="javascript:void(0);"  class="text-muted" data-id="' . $data->id . '"  id="getViewId" > <span class="badge badge-primary"><i class="far fa-eye"></i></span></a>
                     <a href="' . route('admin.edit-offer', ['slug' => $data->slug]) . '"   class="text-muted" > <span class="badge badge-success"><i class="far fa-edit"></i></span></a>
                     <a  href="javascript:void(0);" data-id="' . $data->id . '"  id="getDeleteId" class="text-muted" data-bs-toggle="modal" data-bs-target="#delete_offer"> <span class="badge badge-danger"><i class="far fa-trash-alt"></i></span></a>';
                    return $actionBtn;
                })
                ->addColumn('title', function ($data) {
                    // return   $data->title;
                    if ($data->image != NULL) {
                        $img = asset('assets/uploads/offers/' . $data->image);
                    } else {
                        $img = asset('assets/img/no-image-available.jpg');
                    }
                    $html = '<div class="chat-user-group d-flex align-items-center">
                        <div class="img-users call-user">
                        <a href="javascript:void(0);"><img src="' . $img . '" alt="img"></a>
                        </div>
                        <div class="chat-users chat-user-blk">
                        <div class="user-titles ">
                        <h5> ' . $data->title . '</h5>
                        <p>Promo Code: ' . $data->promo_code . '</p>
                        </div>
                        </div>
                        </div>';
                    return $html;
                })
                ->addColumn('expiry_date', function ($data) {
                    return   date('d l Y', strtotime($data->expiry_date));
                })
                ->addColumn('discount', function ($data) {
                    if ($data->discount_type == '%') {
                        return   $data->discount_rate . $data->discount_type;
                    } else {
                        return   $data->discount_type . $data->discount_rate;
                    }
                })
                ->addColumn('status', function ($data) {
                    $status = '';
                    $class = '';
                    if ($data->status == 'ACTIVE') {
                        $class = "success";
                        $val = 'BLOCKED';
                    } else {
                        $class = "danger";
                        $val = 'ACTIVE';
                    }
                    return '<a href="javascript:void(0)" data-id="' . $data->id . '" data-value="' . $val . '" id="status"><span class="badge badge-' . $class . '">' . $data->status . '</span></a>';
                })
                ->escapeColumns([])

                ->make(true);
        }
    }
    public function changeOfferStatus(Request $request)
    {
        $res = Offer::where('id', $request->id)
            ->update(['status' => $request->status]);
        return $res;
    }
}
