<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Blog;
use App\Models\Blog_category;
use App\Models\Therapist;
use Cviebrock\EloquentSluggable\Services\SlugService;
use Illuminate\Database\QueryException;
use Yajra\DataTables\Facades\DataTables;
use Illuminate\Support\Str;

class BlogController extends Controller
{

    // *************** Blog Category ***********************
    public function saveBlogCategory(Request $request)
    {
        try {
            $request->validate([
                'title' => 'required'
            ]);

            $slug = SlugService::createSlug(Blog_category::class, 'slug', $request->title);

            $blogCategory = new Blog_category();
            $blogCategory->name = $request->title;
            $blogCategory->slug = $slug;
            $blogCategory->save();
            if (!$blogCategory) {
                return false;
            } else {
                return true;
            }
        } catch (QueryException $e) {
            return $e->getMessage();
        }
    }
    public function getBlogCategory(Request $request)
    {
        if ($request->ajax()) {
            $data = Blog_category::orderBy('id', 'DESC')->get();
            return Datatables::of($data)
                ->addIndexColumn()
                ->addColumn('action', function ($data) {
                    $actionBtn = '
                     <a href="javascript:void(0);"  class="text-muted" data-id="' . $data->id . '" data-value="' . $data->name . '" id="getEditId" class="text-muted" data-bs-toggle="modal" data-bs-target="#edit_blog_category"> <span class="badge badge-success"><i class="far fa-edit"></i></span></a>
                                            <a  href="javascript:void(0);" data-id="' . $data->id . '"  id="getDeleteId" class="text-muted" data-bs-toggle="modal" data-bs-target="#delete_blog"> <span class="badge badge-danger"><i class="far fa-trash-alt"></i></span></a>';
                    return $actionBtn;
                })
                ->addColumn('title', function ($data) {
                    return   $data->name;
                })

                ->escapeColumns([])

                ->make(true);
        }
    }

    public function deleteBlogCategory(Request $request)
    {
        $res = Blog_category::where('id', $request->id)->delete();
        return $res;
    }

    public function updateBlogCategory(Request $request)
    {
        try {
            $request->validate([
                'title' => 'required'
            ]);

            $data = Blog_category::where('id', $request->id)->first();

            if ($request->title != $data->name) {
                $slug = SlugService::createSlug(Blog_category::class, 'slug', $request->title);
            } else {
                $slug = $data->slug;
            }


            $res = Blog_category::where('id', $request->id)
                ->update([
                    'name' => $request->title,
                    'slug' => $slug
                ]);

            if ($res) {
                return true;
            } else {
                return false;
            }
        } catch (QueryException $e) {
            return $e->getMessage();
        }
    }

    // *************************** Blog Category End *********************

    // *************************** Blog *****************************************

    public function saveBlog(Request $request)
    {
        try {
            $request->validate([
                'title' => 'required',
                'author' => 'required',
                'blog_category' => 'required',
                'tags' => 'required',
                'description' => 'required',
                'image' => 'required',
                'color' => 'required'
            ]);

            $image = '';
            // ******** Image uploade start ********
            if ($request->hasFile('image')) {
                $rand = rand(100, 999);
                $image = time() . '.' . $request->image->extension();
                $imageOriginalName = $request->image->getClientOriginalName();
                $request->image->move(public_path('assets/uploads/blog'), $image);
            }
            // ******** Image uploade end ********

            $slug = SlugService::createSlug(
                Blog_category::class,
                'slug',
                $request->title
            );
            if ($request->author == 'T') {
                $therapist = $request->therapist;
            } else {
                $therapist = null;
            }
            $blog = new Blog();
            $blog->title = $request->title;
            $blog->slug = $slug;
            $blog->blog_category_id = $request->blog_category;
            $blog->author = $request->author;
            $blog->therapist_id = $therapist;
            $blog->description = $request->description;
            $blog->image = $image;
            $blog->tags = $request->tags;
            $blog->color = $request->color;
            $blog->save();

            if (!$blog) {
                return false;
            } else {
                return true;
            }
        } catch (QueryException $e) {
            return $e->getMessage();
        }
    }

    public function updateBlog(Request $request)
    {
        try {
            $request->validate([
                'title' => 'required',
                'author' => 'required',
                'blog_category' => 'required',
                'tags' => 'required',
                'description' => 'required',
                'color' => 'required'
            ]);

            $data = Blog::where('id', $request->id)->first();

            if ($request->title != $data->title) {
                $slug = SlugService::createSlug(Blog::class, 'slug', $request->title);
            } else {
                $slug = $data->slug;
            }
            // ******** Image uploade start ********
            if ($request->hasFile('image')) {
                if ($request->hasFile('image')) {
                    $rand = rand(100, 999);
                    $image = time() . '.' . $request->image->extension();
                    $imageOriginalName = $request->image->getClientOriginalName();
                    $request->image->move(public_path('assets/uploads/blog'), $image);
                }
                $res = Blog::where('id', $request->id)
                    ->update([
                        'image' => $image
                    ]);
            }
            // ******** Image uploade end ********
            if ($request->author == 'T') {
                $therapist = $request->therapist;
            } else {
                $therapist = null;
            }
            $res = Blog::where('id', $request->id)
                ->update([
                    'title' => $request->title,
                    'slug' => $slug,
                    'blog_category_id' => $request->blog_category,
                    'author' => $request->author,
                    'therapist_id' => $therapist,
                    'description' => $request->description,
                    'tags' => $request->tags,
                    'color' => $request->color,
                ]);

            if ($res == 1) {
                return true;
            } else {
                return false;
            }
        } catch (QueryException $e) {
            return $e->getMessage();
        }
    }
    public function getBlog(Request $request)
    {
        if ($request->ajax()) {
            $data = Blog::query()
                ->with(['therapist' => function ($query) {
                    $query->select('id', 'image', 'full_name');
                }])
                ->orderBy('id', 'DESC')->get();
            return Datatables::of($data)
                ->addIndexColumn()
                ->addColumn('action', function ($data) {
                    $actionBtn = '<a href="' . route('admin.view-blog', ['slug' => $data->slug]) . '"  class="text-muted"> <span class="badge badge-primary"><i class="far fa-eye"></i></span></a>
                     <a href="' . route('admin.edit-blog', ['slug' => $data->slug]) . '"   class="text-muted" > <span class="badge badge-success"><i class="far fa-edit"></i></span></a>
                                            <a  href="javascript:void(0);" data-id="' . $data->id . '"  id="getDeleteId" class="text-muted" data-bs-toggle="modal" data-bs-target="#delete_blog"> <span class="badge badge-danger"><i class="far fa-trash-alt"></i></span></a>';
                    return $actionBtn;
                })
                ->addColumn('title', function ($data) {
                    // return   $data->title;
                    if ($data->image != NULL) {
                        $img = asset('assets/uploads/blog/' . $data->image);
                    } else {
                        $img = asset('assets/img/no-image-available.jpg');
                    }
                    $html = '<div class="chat-user-group d-flex align-items-center">
                        <div class="img-users call-user">
                        <a href="' . route('admin.view-blog', ['slug' => $data->slug]) . '"><img src="' . $img . '" alt="img"></a>
                        </div>
                        <div class="chat-users chat-user-blk">
                        <div class="user-titles ">
                        <h5> ' . $data->title . '</h5>
                        <p>' . Str::limit((strip_tags($data->description)), 50, '...') . '</p>
                        </div>
                        </div>
                        </div>';
                    return $html;
                })
                ->addColumn('category', function ($data) {
                    return   $data->blogCategory->name;
                })
                ->addColumn('author', function ($data) {
                    $html = '';
                    if ($data->author == 'F') {
                        $html = '<img width="28" height="28" class="rounded-circle" src="' . asset('assets/img/fenni.jpg') . '" alt="">
<h2>Feni</h2>';
                    } elseif ($data->author == 'T') {
                        $full_name = Therapist::where('id', $data->therapist_id)->pluck('full_name')->first();
                        $image = Therapist::where('id', $data->therapist_id)->pluck('image')->first();
                        if ($image != NULL) {
                            $img = asset('assets/uploads/therapist/' . $image);
                        } else {
                            if ($data->gender == 'MALE') {
                                $img = asset('assets/img/male-avatar.jpg');
                            } else {
                                $img = asset('assets/img/female-avatar.webp');
                            }
                        }
                        $html = '<img width="28" height="28" class="rounded-circle" src="' . $img . '" alt="">
<h2>' . $full_name . '</h2>';
                    }
                    return   $html;
                })
                ->addColumn('status', function ($data) {
                    $status = '';
                    $class = '';
                    if ($data->status == 'ACTIVE') {
                        $class = "success";
                        $val = 'BLOCKED';
                    } else {
                        $class = "danger";
                        $val = 'ACTIVE';
                    }
                    return '<a href="javascript:void(0)" data-id="' . $data->id . '" data-value="' . $val . '" id="status"><span class="badge badge-' . $class . '">' . $data->status . '</span></a>';
                })
                ->escapeColumns([])

                ->make(true);
        }
    }

    public function changeBlogStatus(Request $request)
    {
        $res = Blog::where('id', $request->id)
            ->update(['status' => $request->status]);
        return $res;
    }

    public function deleteBlog(Request $request)
    {
        try {
            $data = Blog::where('id', $request->id)->first();

            if ((file_exists(public_path('assets/uploads/blog/' . $data->image))) && ($data->image != NULL)) {
                unlink("assets/uploads/blog/" . $data->image);
            }

            $res = Blog::where('id', $request->id)->delete();
            return $res;
        } catch (QueryException $e) {
            return $e->getMessage();
        }
    }

    public function editBlog(Request $request)
    {
        $data = Blog::where('slug', $request->slug)->first();
        return view('admin.blog.edit', ['data' => $data]);
    }

    public function viewBlog(Request $request)
    {
        $data = Blog::where('slug', $request->slug)->first();
        return view('admin.blog.view', ['data' => $data]);
    }

    // ************************************* Blog End ************************
}
