<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use App\Models\Appointments;
use App\Models\PushNotification;
use Illuminate\Support\Carbon;

class AppoinmentInMinutes extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'app:appoinment-in-minutes';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Command description';

    /**
     * Execute the console command.
     */
    public function handle()
    {
        $current_time = Carbon::now()->format('H:i:s');
        $start_time = Carbon::now()->format('H:i:s');
        $end_time = Carbon::now()->addMinutes(5)->format('H:i:s');
        $enddate=Carbon::now()->format('Y-m-d');
        $array = Appointments::select('appointments.*', 'users.device_token', 'users.First_Name', 'users.Last_Name')
            ->rightJoin('users', 'users.id', '=', 'appointments.user_id')
             ->whereIn('Appointment_Status',[ 'Confirm','Awaiting' , 'No Participants', 'Awaiting','Join'])
            ->where('Appointment_Date', date('Y-m-d'))
            ->get();

            $statuschange = Appointments::where('end_datetime',$enddate)
        ->whereIn('Appointment_Status',[ 'Awaiting Participant','No Participants' , 'Awaiting', 'Join'])
            ->get();
        foreach ($statuschange as $item) {
            $check = $item->end_time;
            $check =  Carbon::createFromFormat('h:i A', $check)->format('H:i:s');
            if ($check < $start_time) {
                Appointments::where('id', $item->id)
                    ->update(['Appointment_Status' => 'Missed']);
            }
        }



        foreach ($array as $item) {
            $start_time = $item->Appointment_Time;
            $start_time =  Carbon::createFromFormat('h:i A', $start_time)->subMinutes(5)->format('H:i:s');
            $end_time = $item->end_time;
            $end_time =  Carbon::createFromFormat('h:i A', $end_time)->format('H:i:s');
            if ($current_time >= $start_time && $current_time <= $end_time) {
                PushNotification::create([
                    'title' => 'Appoinment Remainder',
                    'message' => "Hello " . $item->First_Name . "  " . $item->Last_Name . " this is a friendly reminder for your appointment with " . $item->therapist->prefix . " " . $item->therapist->full_name . " on " . $item->Appointment_Date . " at " . $item->Appointment_Time . ". See you soon!",
                    'therapist_notification' => "This is a friendly reminder for your appointment with " . $item->First_Name . "  " . $item->Last_Name . " on " . $item->Appointment_Date . " at " . $item->Appointment_Time . ". ",
                    'type' => 'Appointment',
                    'user_id' => $item->user_id,
                    'therapist_id' => $item->therapist_id,
                    'appoinment_id' => $item->id
                ]);
                if ($item->Appointment_Status == 'Confirm') {
                    Appointments::where('id', $item->id)->update([
                        'Appointment_Status' => 'Join'
                    ]);
                } elseif ($item->Appointment_Status == 'Join') {
                    Appointments::where('id', $item->id)->update([
                        'Appointment_Status' => 'No Participants'
                    ]);
                }
                $data = [
                   'token' => $item->device_token,
                    "notification" => [
                        'title' => 'Appoinment Remainder',
                        'body' => "Hello " . $item->First_Name . "  " . $item->Last_Name . " this is a friendly reminder for your appointment with " . $item->therapist->prefix . " " . $item->therapist->full_name . " on " . $item->Appointment_Date . " at " . $item->Appointment_Time . ". See you soon!"
                    ],
                    "data" => [
                        "route" => "notification"
                    ]
                ];
                sendpushnotification($data);
                $data2 = [
                   'token' => $item->therapist->device_token,
                    "notification" => [
                        'title' => 'Appoinment Remainder',
                        'body' => "This is a friendly reminder for your appointment with " . $item->First_Name . "  " . $item->Last_Name . " on " . $item->Appointment_Date . " at " . $item->Appointment_Time . ". ",
                    ],
                    "data" => [
                        "route" => "notification"
                    ]
                ];
                sendpushnotification($data2);
            }
        }

        $array2 = Appointments::select('appointments.*', 'users.device_token', 'users.First_Name', 'users.Last_Name')
            ->rightJoin('users', 'users.id', '=', 'appointments.user_id')
            ->where('Appointment_Status', 'In Progress')
            ->where('Appointment_Date', date('Y-m-d'))
            //   ->whereBetween('end_time', [$start_time, $end_time])
            ->get();

        foreach ($array2 as $item) {
            $check = $item->end_time;
            $check =  Carbon::createFromFormat('h:i A', $check)->format('H:i:s');
            if ($check >= $start_time && $check <= $end_time) {
                PushNotification::create([
                    'title' => 'Appoinment Remainder',
                    'message' => "Hello " . $item->First_Name . " " . $item->Last_Name . " this is a friendly reminder for your appointment with " . $item->therapist->prefix . " " . $item->therapist->full_name . " on " . $item->Appointment_Date . " at " . $item->Appointment_Time . ". See you soon!",
                    'therapist_notification' => "This is a friendly reminder for your appointment with " . $item->First_Name . " " . $item->Last_Name . " on " . $item->Appointment_Date . " at " . $item->Appointment_Time . ". ",
                    'type' => 'Appointment',
                    'user_id' => $item->user_id,
                    'therapist_id' => $item->therapist_id,
                    'appoinment_id' => $item->id
                ]);


                $data2 = [
                   'token' => $item->therapist->device_token,
                    "notification" => [
                        'title' => 'Appoinment Remainder',
                        'body' => "Your Video call with " . $item->First_Name . " " . $item->Last_Name . " on " . $item->Appointment_Date . " at " . $item->Appointment_Time . ".  is about to end",
                    ],
                    "data" => [
                        "route" => "notification"
                    ]
                ];
                sendpushnotification($data2);
            }
        }
    }
}
