<?php

namespace App\Http\Controllers\Therapist;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Therapist;
use App\Models\Appointments;
use Illuminate\Support\Facades\Auth;
use App\Models\UserReview;
use App\Models\SlotShedule;
use Carbon\Carbon;
use App\Models\Prescription;
use App\Models\ServiceFeeStructure;
use Illuminate\Support\Facades\Hash;
use App\Models\ThoughtofTheDay;
use Illuminate\Database\QueryException;
use App\Models\Banners;
use App\Models\Blog;
use App\Models\Blog_category;
use Cviebrock\EloquentSluggable\Services\SlugService;
use Illuminate\Support\Str;

class LoginController extends Controller
{
    private $apiToken;
    // public function __construct()
    // {
    //     $this->apiToken = uniqid(base64_encode(Str::random(40)));
    // }
    public function login(Request $request)
    {

        if (auth()->guard('therapist')->attempt(['email' => $request->input('email'),  'password' => $request->input('password')])) {

            $user = auth()->guard('therapist')->user();

            if ($user->image != NULL) {
                $img = asset('assets/therapist/therapist/' . $user->image);
            } else {
                $img = asset('assets/img/no-image-available.jpg');
            }
            $reviewsum = UserReview::where('therapist_id', $user->id)->avg('rate');

            $data = [
                'id' => $user->id,
                'name' => $user->full_name,
                'mobile_number' => $user->mobile,
                'email' => $user->email,
                'image' => $img,
                'designation' => $user->designation,
                'total_sessions' => count(Appointments::where('therapist_id', $user->id)->get()),
                'completed_sessions' => count(Appointments::where('therapist_id', $user->id)->where('Appointment_Status', 'Completed')->get()),
                'total_clients' => count(Appointments::select('user_id', 'id')->where('therapist_id', $user->id)->orderBy('id', 'DESC')->groupBy('user_id')->get()),
                'total_reviews' => count(UserReview::where('therapist_id', $user->id)->get()),
                'total_review_rate' => round($reviewsum, 0)
            ];
            $accessToken = $user->createToken('MyApp')->accessToken;

            return response(["status" => true, "code" => 200, "message" => "Logged In successfully", "data" => $data, 'access_token' => $accessToken]);
        } else {
            return response()->json([
                'status' => False,
                'message' => 'Unauthorized Access'
            ]);
        }
    }

    public function overview(Request $request)
    {
        $data['total_sessions'] = count(Appointments::where('therapist_id', auth()->user()->id)->get());
        $data['completed_sessions'] = count(Appointments::where('therapist_id', auth()->user()->id)->where('Appointment_Status', 'Completed')->get());
        $data['pending_sessions'] = count(Appointments::where('therapist_id', auth()->user()->id)->where('Appointment_Status', 'Awaiting')->get());
        $data['cancel_sessions'] = count(Appointments::where('therapist_id', auth()->user()->id)->where('Appointment_Status', 'Cancel')->get());

        if (!empty($data)) {
            return response()->json(
                array(
                    'status' => True,
                    'data' => $data
                ),
                200
            );
        } else {
            return response()->json(
                array(
                    'status' => False,
                    'data' => $data
                ),
                200
            );
        }
    }
    public function upcomingAppoinmentsHomePage(Request $request)
    {
        try {
            $now = Carbon::now();
            $current_time = $now->format('H:i');
            $data = [];
            $key = 0;
            $array = Appointments::where('therapist_id', auth()->user()->id)->where('Appointment_Date', '>=', date('Y-m-d'))->orderBy('Appointment_Date', 'ASC')->get();
            foreach ($array as $item) {
                if ($key == 2) {
                    break;
                }

                if ($item->user->image != NULL) {
                    $img = asset('assets/uploads/user/' . $item->user->image);
                } else {
                    $img = asset('assets/img/no-image-available.jpg');
                }
                $duration = ServiceFeeStructure::where('service_id', $item->service_id)->where('provider_category_id', $item->therapist->provider_category_id)->where('call_method_id', $item->Appointment_Type)->pluck('duration')->first();
                $givenDateTime = date("H:i", strtotime($item->Appointment_Time));

                $time = $item->Appointment_Date . " " . $givenDateTime . ":00";
                $closeTime =  Carbon::parse($time)->addMinutes($duration);

                if ($item->Appointment_Date == date("Y-m-d")) {

                    if ($current_time > $givenDateTime) {
                        if ($item->call_status == false) {
                            continue;
                        } else {
                            $data[$key]['id'] = $item->id;
                            $data[$key]['user_id'] = $item->user->id;
                            $data[$key]['user_name'] = $item->user->First_Name . ' ' . $item->user->Last_Name;
                            $data[$key]['user_image'] = $img;
                            $data[$key]['Appointment_Date'] = $item->Appointment_Date;
                            $data[$key]['start_time'] = $item->Appointment_Time;
                            $data[$key]['end_time'] =  $item->end_time;
                            $data[$key]['Appointment_Status'] = $item->Appointment_Status;
                            $data[$key]['Appointment_Status_color'] = statusColor($item->Appointment_Status);
                            $data[$key]['call_type'] = $item->callMethod->name;
                            $data[$key]['call_type_id'] = $item->callMethod->id;
                            $data[$key]['service'] = $item->service_id;
                            $data[$key]['call_status'] = $item->call_status;
                            $data[$key]['follow_up_date'] = $item->follow_up_date;
                            $data[$key]['fee'] = $item->fee;
                            $key++;
                        }
                    } else {
                        $data[$key]['id'] = $item->id;
                        $data[$key]['user_id'] = $item->user->id;
                        $data[$key]['user_name'] = $item->user->First_Name . ' ' . $item->user->Last_Name;
                        $data[$key]['user_image'] = $img;
                        $data[$key]['Appointment_Date'] = $item->Appointment_Date;
                        $data[$key]['start_time'] = $item->Appointment_Time;
                        $data[$key]['end_time'] =  $item->end_time;
                        $data[$key]['Appointment_Status'] = $item->Appointment_Status;
                        $data[$key]['Appointment_Status_color'] = statusColor($item->Appointment_Status);
                        $data[$key]['call_type'] = $item->callMethod->name;
                        $data[$key]['call_type_id'] = $item->callMethod->id;
                        $data[$key]['service'] = $item->service_id;
                        $data[$key]['call_status'] = $item->call_status;
                        $data[$key]['follow_up_date'] = $item->follow_up_date;
                        $data[$key]['fee'] = $item->fee;
                        $key++;
                    }
                } else {
                    $data[$key]['id'] = $item->id;
                    $data[$key]['user_id'] = $item->user->id;
                    $data[$key]['user_name'] = $item->user->First_Name . ' ' . $item->user->Last_Name;
                    $data[$key]['user_image'] = $img;
                    $data[$key]['Appointment_Date'] = $item->Appointment_Date;
                    $data[$key]['start_time'] = $item->Appointment_Time;
                    $data[$key]['end_time'] =  $item->end_time;
                    $data[$key]['Appointment_Status'] = $item->Appointment_Status;
                    $data[$key]['Appointment_Status_color'] = statusColor($item->Appointment_Status);
                    $data[$key]['call_type'] = $item->callMethod->name;
                    $data[$key]['call_type_id'] = $item->callMethod->id;
                    $data[$key]['service'] = $item->service_id;
                    $data[$key]['call_status'] = $item->call_status;
                    $data[$key]['follow_up_date'] = $item->follow_up_date;
                    $data[$key]['fee'] = $item->fee;
                    $key++;
                }
            }
            if ($data) {
                return response()->json(
                    array(
                        'status' => true,
                        'data' => $data,
                        'statuscode' => 200
                    ),
                    200
                );
            } else {
                return response()->json(
                    array(
                        'status' => true,
                        'data' => $data,
                        'statuscode' => 200
                    ),
                    200
                );
            }
        } catch (QueryException $e) {
            return response()->json(
                array(
                    'status' => false,
                    'data' => $e->getMessage()
                ),
                200
            );
        }
    }

    public function thoughts(Request $request)
    {
        $carbon = Carbon::now();
        $day = $carbon->format('l');

        $data = ThoughtofTheDay::select('image')->where('day', $day)->first();

        if (empty($data)) {
            $data = ThoughtofTheDay::select('image')->orderBy('id', 'DESC')->first();
        }
        $data->image = asset('assets/uploads/thoughts/') . '/' . $data->image;

        if (!empty($data)) {
            return response()->json(
                array(
                    'status' => True,
                    'data' => $data
                ),
                200
            );
        } else {
            return response()->json(
                array(
                    'status' => False,
                    'data' => $data
                ),
                200
            );
        }
    }

    public function banners(Request $request)
    {
        $array = Banners::select('image')->orderBy('id', 'DESC')->get();

        $data = collect($array->toArray())->map(function ($item) {
            $item['image'] = asset('assets/uploads/banners/') . '/' . $item['image'];
            return $item;
        });

        if (!empty($data)) {
            return response()->json(
                array(
                    'status' => True,
                    'data' => $data
                ),
                200
            );
        } else {
            return response()->json(
                array(
                    'status' => False,
                    'data' => $data
                ),
                200
            );
        }
    }

    public function reviews(Request $request)
    {
        $data = [];
        $img = '';
        $array = UserReview::where('therapist_id', auth()->user()->id)->orderBy('id', 'DESC')->get();

        if ($array) {
            foreach ($array as $key => $item) {
                if (empty($item->user)) {
                    $img = asset('assets/img/male-avatar.jpg');
                    $name = "USER";
                } else {
                    if ($item->user->image != NULL) {
                        $img = asset('assets/uploads/user/' . $item->user->image);
                    } else {

                        if ($item->user->Gender == 'MALE' || $item->user->Gender == 'M' || $item->user->Gender == 'Male') {
                            $img = asset('assets/img/male.png');
                        } elseif ($item->user->Gender == 'FEMALE' || $item->user->Gender == 'F' || $item->user->Gender == 'Female') {
                            $img = asset('assets/img/female.png');
                        } else {
                            $img = asset('assets/img/other.png');
                        }
                    }

                    $name = $item->user->First_Name . ' ' . $item->user->Last_Name;
                }
                // $data = collect($array)->map(function ($item) {
                $data[$key]['user_name'] =  $name;
                $data[$key]['user_image'] = $img;
                $data[$key]['date'] = $item->created_at;
                $data[$key]['rate'] = $item->rate;
                $data[$key]['comment'] = $item->comment;
            }
        }


        if (!empty($data)) {
            return response()->json(
                array(
                    'status' => True,
                    'data' => $data
                ),
                200
            );
        } else {
            return response()->json(
                array(
                    'status' => True,
                    'data' => $data
                ),
                200
            );
        }
    }

    public function addBlog(Request $request)
    {
        try {

            $image = '';
            // ******** Image uploade start ********
            if ($request->hasFile('image')) {
                $rand = rand(100, 999);
                $image = time() . '.' . $request->image->extension();
                $imageOriginalName = $request->image->getClientOriginalName();
                $request->image->move(public_path('assets/uploads/blog'), $image);
            }
            // ******** Image uploade end ********

            $slug = SlugService::createSlug(
                Blog_category::class,
                'slug',
                $request->title
            );
            if ($request->author == 'T') {
                $therapist = $request->therapist;
            } else {
                $therapist = null;
            }
            $blog = new Blog();
            $blog->title = $request->title;
            $blog->slug = $slug;
            $blog->blog_category_id = $request->blog_category_id;
            $blog->author = 'T';
            $blog->therapist_id = auth()->user()->id;
            $blog->description = $request->description;
            $blog->image = $image;
            $blog->tags = $request->tags;
            $blog->color = '#ffffff';
            $blog->save();

            if ($blog) {
                return response()->json(
                    array(
                        'status' => true,
                        'data' => "Blog added successfully",
                        'statuscode' => 200
                    ),
                    200
                );
            } else {
                return response()->json(
                    array(
                        'status' => false,
                        'data' => "Something went Wrong",
                        'statuscode' => 301
                    ),
                    200
                );
            }
        } catch (QueryException $e) {
            return response()->json(
                array(
                    'status' => false,
                    'data' => $e->getMessage()
                ),
                200
            );
        }
    }

    public function blogCategory(Request $request)
    {
        $data = Blog_category::select('id', 'name')->orderBy('name', 'ASC')->get();


        if (!empty($data)) {
            return response()->json(
                array(
                    'status' => True,
                    'data' => $data
                ),
                200
            );
        } else {
            return response()->json(
                array(
                    'status' => False,
                    'data' => $data
                ),
                200
            );
        }
    }

    public function blog(Request $request)
    {

        if ($request->category) {
            $array = Blog::select('id', 'title', 'slug', 'blog_category_id', 'therapist_id', 'author', 'description', 'image', 'tags', 'color', 'created_at')->where('blog_category_id', $request->category)->orderBy('title', 'ASC')->get();
        } else {
            $array = Blog::select('id', 'title', 'slug', 'blog_category_id', 'therapist_id', 'author', 'description', 'image', 'tags', 'color', 'created_at')->orderBy('title', 'ASC')->get();
        }

        $data = $array->map(function ($item) {

            $item->image = asset('assets/uploads/blog/') . '/' . $item->image;
            $item->description = Str::limit((strip_tags($item->description)), 50, '...');
            if ($item->author == 'T') {
                $name = Therapist::where('id', $item->therapist_id)->pluck('full_name')->first();
                $image = Therapist::where('id', $item->therapist_id)->pluck('image')->first();
                $item->author = $name;
                $item->author_image = asset('assets/uploads/therapist/' . $image);
            } else {
                $item->author = 'Feni';
                $item->author_image = asset('assets/img/fenni.jpg');
            }

            return $item;
        });


        if (!empty($data)) {
            return response()->json(
                array(
                    'status' => True,
                    'data' => $data
                ),
                200
            );
        } else {
            return response()->json(
                array(
                    'status' => False,
                    'data' => $data
                ),
                200
            );
        }
    }

    public function logout(Request $request)
    {

        auth()->user()->token()->revoke();

        return response()->json([
            'status' => true,
            'success' => 'logged out',
            'statuscode' => 200
        ], 200);
    }








    public function reviewDetails(Request $request)
    {
        $data = [];
        $img = '';
        $array = UserReview::where('therapist_id', auth()->user()->id)->orderBy('rate', 'DESC')->get();
        if (count($array) > 0) {
            $reviewsum = UserReview::where('therapist_id', auth()->user()->id)->avg('rate');
            $data['total_reviews'] = count($array);
            $data['total_review_rate'] = round($reviewsum, 0);
            $data['ratings'] = count(UserReview::where('therapist_id', auth()->user()->id)->whereNotNull('rate')->orderBy('id', 'DESC')->get());
            $data['reviews'] = count(UserReview::where('therapist_id', auth()->user()->id)->whereNotNull('comment')->orderBy('id', 'DESC')->get());

            $review_rate_graph = [];

            for ($i = 1; $i <= 5; $i++) {
                $rates = count(UserReview::where('therapist_id', auth()->user()->id)->where('rate', $i)->get());
                $star = round(($rates / count($array)) * 100, 0);
                $review_rate_graph[$i] = $star . '%';
            }

            $data['review_rate_graph'] = $review_rate_graph;
            if ($array) {
                foreach ($array as $key => $item) {
                    if (empty($item->user)) {
                        $img = asset('assets/img/male-avatar.jpg');
                        $name = "USER";
                    } else {
                        if ($item->user->image != NULL) {
                            $img = asset('assets/uploads/user/' . $item->user->image);
                        } else {

                            if ($item->user->Gender == 'MALE' || $item->user->Gender == 'M' || $item->user->Gender == 'Male') {
                                $img = asset('assets/img/male.png');
                            } elseif ($item->user->Gender == 'FEMALE' || $item->user->Gender == 'F' || $item->user->Gender == 'Female') {
                                $img = asset('assets/img/female.png');
                            } else {
                                $img = asset('assets/img/other.png');
                            }
                        }

                        $name = $item->user->First_Name . ' ' . $item->user->Last_Name;
                    }
                    // $data = collect($array)->map(function ($item) {
                    $data['top_reviews'][$key]['user_name'] =  $name;
                    $data['top_reviews'][$key]['user_image'] = $img;
                    $data['top_reviews'][$key]['date'] = $item->created_at;
                    $data['top_reviews'][$key]['rate'] = $item->rate;
                    $data['top_reviews'][$key]['comment'] = $item->comment;
                }
            }

            if (!empty($data)) {
                return response()->json(
                    array(
                        'status' => True,
                        'data' => $data
                    ),
                    200
                );
            } else {
                return response()->json(
                    array(
                        'status' => False,
                        'data' => $data
                    ),
                    200
                );
            }
        } else {
            return response()->json(
                array(
                    'status' => true,
                    'data' => []
                ),
                200
            );
        }
    }
}
